/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.DevNullValuesWriter;
import io.trino.parquet.writer.valuewriter.RunLengthBitPackingHybridValuesWriter;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;

public interface ColumnDescriptorValuesWriter {
    public void writeInteger(int var1);

    public void writeRepeatInteger(int var1, int var2);

    public long getBufferedSize();

    public long getAllocatedSize();

    public BytesInput getBytes();

    public Encoding getEncoding();

    public void reset();

    public static ColumnDescriptorValuesWriter newRepetitionLevelWriter(ColumnDescriptor path, int pageSizeThreshold) {
        return ColumnDescriptorValuesWriter.newColumnDescriptorValuesWriter(path.getMaxRepetitionLevel(), pageSizeThreshold);
    }

    public static ColumnDescriptorValuesWriter newDefinitionLevelWriter(ColumnDescriptor path, int pageSizeThreshold) {
        return ColumnDescriptorValuesWriter.newColumnDescriptorValuesWriter(path.getMaxDefinitionLevel(), pageSizeThreshold);
    }

    private static ColumnDescriptorValuesWriter newColumnDescriptorValuesWriter(int maxLevel, int pageSizeThreshold) {
        if (maxLevel == 0) {
            return new DevNullValuesWriter();
        }
        return new RunLengthBitPackingHybridValuesWriter(BytesUtils.getWidthFromMaxInt((int)maxLevel), pageSizeThreshold);
    }
}

