/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DateType;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class DateValueWriter
extends PrimitiveValueWriter {
    public DateValueWriter(ValuesWriter valuesWriter, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
    }

    @Override
    public void write(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (mayHaveNull && block.isNull(position)) continue;
            int value = DateType.DATE.getInt(block, position);
            valuesWriter.writeInteger(value);
            statistics.updateStats(value);
        }
    }
}

