/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.BloomFilterValuesWriter;
import io.trino.parquet.writer.valuewriter.DictionaryFallbackValuesWriter;
import java.util.Optional;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TrinoValuesWriterFactory {
    private static final int INITIAL_SLAB_SIZE = 64;
    private final int maxPageSize;
    private final int maxDictionaryPageSize;

    public TrinoValuesWriterFactory(int maxPageSize, int maxDictionaryPageSize) {
        this.maxPageSize = maxPageSize;
        this.maxDictionaryPageSize = maxDictionaryPageSize;
    }

    public ValuesWriter newValuesWriter(ColumnDescriptor descriptor, Optional<BloomFilter> bloomFilter) {
        return switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
            default -> throw new MatchException(null, null);
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> new BooleanPlainValuesWriter();
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> this.getFixedLenByteArrayValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.BINARY -> this.getBinaryValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.INT32 -> this.getInt32ValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.INT64 -> this.getInt64ValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.INT96 -> this.getInt96ValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> this.getDoubleValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.FLOAT -> this.getFloatValuesWriter(descriptor, bloomFilter);
        };
    }

    private ValuesWriter getFixedLenByteArrayValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        return BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new FixedLenByteArrayPlainValuesWriter(path.getPrimitiveType().getTypeLength(), 64, this.maxPageSize, (ByteBufferAllocator)new HeapByteBufferAllocator()), bloomFilter);
    }

    private ValuesWriter getBinaryValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(64, this.maxPageSize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        return BloomFilterValuesWriter.createBloomFilterValuesWriter(this.dictWriterWithFallBack(path, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), (ValuesWriter)fallbackWriter), bloomFilter);
    }

    private ValuesWriter getInt32ValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(64, this.maxPageSize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        return BloomFilterValuesWriter.createBloomFilterValuesWriter(this.dictWriterWithFallBack(path, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), (ValuesWriter)fallbackWriter), bloomFilter);
    }

    private ValuesWriter getInt64ValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(64, this.maxPageSize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        return BloomFilterValuesWriter.createBloomFilterValuesWriter(this.dictWriterWithFallBack(path, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), (ValuesWriter)fallbackWriter), bloomFilter);
    }

    private ValuesWriter getInt96ValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        FixedLenByteArrayPlainValuesWriter fallbackWriter = new FixedLenByteArrayPlainValuesWriter(12, 64, this.maxPageSize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        return BloomFilterValuesWriter.createBloomFilterValuesWriter(this.dictWriterWithFallBack(path, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), (ValuesWriter)fallbackWriter), bloomFilter);
    }

    private ValuesWriter getDoubleValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(64, this.maxPageSize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        return BloomFilterValuesWriter.createBloomFilterValuesWriter(this.dictWriterWithFallBack(path, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), (ValuesWriter)fallbackWriter), bloomFilter);
    }

    private ValuesWriter getFloatValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        PlainValuesWriter fallbackWriter = new PlainValuesWriter(64, this.maxPageSize, (ByteBufferAllocator)new HeapByteBufferAllocator());
        return BloomFilterValuesWriter.createBloomFilterValuesWriter(this.dictWriterWithFallBack(path, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), (ValuesWriter)fallbackWriter), bloomFilter);
    }

    private static Encoding getEncodingForDataPage() {
        return Encoding.PLAIN_DICTIONARY;
    }

    private static Encoding getEncodingForDictionaryPage() {
        return Encoding.PLAIN_DICTIONARY;
    }

    private DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path, Encoding dictPageEncoding, Encoding dataPageEncoding) {
        return switch (path.getPrimitiveType().getPrimitiveTypeName()) {
            default -> throw new MatchException(null, null);
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            case PrimitiveType.PrimitiveTypeName.BINARY -> new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(this.maxDictionaryPageSize, dataPageEncoding, dictPageEncoding, (ByteBufferAllocator)new HeapByteBufferAllocator());
            case PrimitiveType.PrimitiveTypeName.INT32 -> new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(this.maxDictionaryPageSize, dataPageEncoding, dictPageEncoding, (ByteBufferAllocator)new HeapByteBufferAllocator());
            case PrimitiveType.PrimitiveTypeName.INT64 -> new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(this.maxDictionaryPageSize, dataPageEncoding, dictPageEncoding, (ByteBufferAllocator)new HeapByteBufferAllocator());
            case PrimitiveType.PrimitiveTypeName.INT96 -> new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.maxDictionaryPageSize, 12, dataPageEncoding, dictPageEncoding, (ByteBufferAllocator)new HeapByteBufferAllocator());
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(this.maxDictionaryPageSize, dataPageEncoding, dictPageEncoding, (ByteBufferAllocator)new HeapByteBufferAllocator());
            case PrimitiveType.PrimitiveTypeName.FLOAT -> new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(this.maxDictionaryPageSize, dataPageEncoding, dictPageEncoding, (ByteBufferAllocator)new HeapByteBufferAllocator());
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(this.maxDictionaryPageSize, path.getPrimitiveType().getTypeLength(), dataPageEncoding, dictPageEncoding, (ByteBufferAllocator)new HeapByteBufferAllocator());
        };
    }

    private ValuesWriter dictWriterWithFallBack(ColumnDescriptor path, Encoding dictPageEncoding, Encoding dataPageEncoding, ValuesWriter writerToFallBackTo) {
        return new DictionaryFallbackValuesWriter(this.dictionaryWriter(path, dictPageEncoding, dataPageEncoding), writerToFallBackTo);
    }
}

