/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.ArrayConstructor;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BindExpression;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Cube;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.ExcludedPattern;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainOption;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.GroupingElement;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LabelDereference;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.PatternAlternation;
import io.trino.sql.tree.PatternConcatenation;
import io.trino.sql.tree.PatternPermutation;
import io.trino.sql.tree.PatternVariable;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.QuantifiedPattern;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Rollup;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SetOperation;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.TableElement;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.TransactionMode;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.WindowDefinition;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import io.trino.sql.tree.With;
import io.trino.sql.tree.WithQuery;

public abstract class DefaultTraversalVisitor<C>
extends AstVisitor<Void, C> {
    @Override
    protected Void visitExtract(Extract node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitCast(Cast node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitArithmeticBinary(ArithmeticBinaryExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitBetweenPredicate(BetweenPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getMin(), context);
        this.process(node.getMax(), context);
        return null;
    }

    @Override
    protected Void visitCoalesceExpression(CoalesceExpression node, C context) {
        for (Expression operand : node.getOperands()) {
            this.process(operand, context);
        }
        return null;
    }

    @Override
    protected Void visitAtTimeZone(AtTimeZone node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getTimeZone(), context);
        return null;
    }

    @Override
    protected Void visitArrayConstructor(ArrayConstructor node, C context) {
        for (Expression expression : node.getValues()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitSubscriptExpression(SubscriptExpression node, C context) {
        this.process(node.getBase(), context);
        this.process(node.getIndex(), context);
        return null;
    }

    @Override
    protected Void visitComparisonExpression(ComparisonExpression node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        return null;
    }

    @Override
    protected Void visitTrim(Trim node, C context) {
        this.process(node.getTrimSource(), context);
        node.getTrimCharacter().ifPresent(trimChar -> this.process((Node)trimChar, context));
        return null;
    }

    @Override
    protected Void visitFormat(Format node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        return null;
    }

    @Override
    protected Void visitQuery(Query node, C context) {
        if (node.getWith().isPresent()) {
            this.process(node.getWith().get(), context);
        }
        this.process(node.getQueryBody(), context);
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getOffset().isPresent()) {
            this.process(node.getOffset().get(), context);
        }
        if (node.getLimit().isPresent()) {
            this.process(node.getLimit().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitWith(With node, C context) {
        for (WithQuery query : node.getQueries()) {
            this.process(query, context);
        }
        return null;
    }

    @Override
    protected Void visitWithQuery(WithQuery node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitSelect(Select node, C context) {
        for (SelectItem item : node.getSelectItems()) {
            this.process(item, context);
        }
        return null;
    }

    @Override
    protected Void visitSingleColumn(SingleColumn node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitAllColumns(AllColumns node, C context) {
        node.getTarget().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitWhenClause(WhenClause node, C context) {
        this.process(node.getOperand(), context);
        this.process(node.getResult(), context);
        return null;
    }

    @Override
    protected Void visitInPredicate(InPredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getValueList(), context);
        return null;
    }

    @Override
    protected Void visitFunctionCall(FunctionCall node, C context) {
        for (Expression argument : node.getArguments()) {
            this.process(argument, context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getWindow().isPresent()) {
            this.process((Node)((Object)node.getWindow().get()), context);
        }
        if (node.getFilter().isPresent()) {
            this.process(node.getFilter().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitWindowOperation(WindowOperation node, C context) {
        this.process(node.getName(), context);
        this.process((Node)((Object)node.getWindow()), context);
        return null;
    }

    @Override
    protected Void visitGroupingOperation(GroupingOperation node, C context) {
        for (Expression columnArgument : node.getGroupingColumns()) {
            this.process(columnArgument, context);
        }
        return null;
    }

    @Override
    protected Void visitDereferenceExpression(DereferenceExpression node, C context) {
        this.process(node.getBase(), context);
        return null;
    }

    @Override
    protected Void visitWindowReference(WindowReference node, C context) {
        this.process(node.getName(), context);
        return null;
    }

    @Override
    public Void visitWindowSpecification(WindowSpecification node, C context) {
        if (node.getExistingWindowName().isPresent()) {
            this.process(node.getExistingWindowName().get(), context);
        }
        for (Expression expression : node.getPartitionBy()) {
            this.process(expression, context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getFrame().isPresent()) {
            this.process(node.getFrame().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitWindowDefinition(WindowDefinition node, C context) {
        this.process(node.getWindow());
        return null;
    }

    @Override
    public Void visitWindowFrame(WindowFrame node, C context) {
        this.process(node.getStart(), context);
        if (node.getEnd().isPresent()) {
            this.process(node.getEnd().get(), context);
        }
        for (MeasureDefinition measureDefinition : node.getMeasures()) {
            this.process(measureDefinition, context);
        }
        for (VariableDefinition variableDefinition : node.getVariableDefinitions()) {
            this.process(variableDefinition, context);
        }
        return null;
    }

    @Override
    protected Void visitMeasureDefinition(MeasureDefinition node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    protected Void visitVariableDefinition(VariableDefinition node, C context) {
        this.process(node.getExpression(), context);
        return null;
    }

    @Override
    public Void visitFrameBound(FrameBound node, C context) {
        if (node.getValue().isPresent()) {
            this.process(node.getValue().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitOffset(Offset node, C context) {
        this.process(node.getRowCount());
        return null;
    }

    @Override
    protected Void visitLimit(Limit node, C context) {
        this.process(node.getRowCount());
        return null;
    }

    @Override
    protected Void visitFetchFirst(FetchFirst node, C context) {
        node.getRowCount().ifPresent(this::process);
        return null;
    }

    @Override
    protected Void visitSimpleCaseExpression(SimpleCaseExpression node, C context) {
        this.process(node.getOperand(), context);
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitInListExpression(InListExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        return null;
    }

    @Override
    protected Void visitNullIfExpression(NullIfExpression node, C context) {
        this.process(node.getFirst(), context);
        this.process(node.getSecond(), context);
        return null;
    }

    @Override
    protected Void visitIfExpression(IfExpression node, C context) {
        this.process(node.getCondition(), context);
        this.process(node.getTrueValue(), context);
        if (node.getFalseValue().isPresent()) {
            this.process(node.getFalseValue().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitTryExpression(TryExpression node, C context) {
        this.process(node.getInnerExpression(), context);
        return null;
    }

    @Override
    protected Void visitBindExpression(BindExpression node, C context) {
        for (Expression value : node.getValues()) {
            this.process(value, context);
        }
        this.process(node.getFunction(), context);
        return null;
    }

    @Override
    protected Void visitArithmeticUnary(ArithmeticUnaryExpression node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitNotExpression(NotExpression node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitSearchedCaseExpression(SearchedCaseExpression node, C context) {
        for (WhenClause clause : node.getWhenClauses()) {
            this.process(clause, context);
        }
        node.getDefaultValue().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitLikePredicate(LikePredicate node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getPattern(), context);
        node.getEscape().ifPresent(value -> this.process((Node)value, context));
        return null;
    }

    @Override
    protected Void visitIsNotNullPredicate(IsNotNullPredicate node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitIsNullPredicate(IsNullPredicate node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitLogicalExpression(LogicalExpression node, C context) {
        for (Node node2 : node.getTerms()) {
            this.process(node2, context);
        }
        return null;
    }

    @Override
    protected Void visitSubqueryExpression(SubqueryExpression node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitOrderBy(OrderBy node, C context) {
        for (SortItem sortItem : node.getSortItems()) {
            this.process(sortItem, context);
        }
        return null;
    }

    @Override
    protected Void visitSortItem(SortItem node, C context) {
        this.process(node.getSortKey(), context);
        return null;
    }

    @Override
    protected Void visitQuerySpecification(QuerySpecification node, C context) {
        this.process(node.getSelect(), context);
        if (node.getFrom().isPresent()) {
            this.process(node.getFrom().get(), context);
        }
        if (node.getWhere().isPresent()) {
            this.process(node.getWhere().get(), context);
        }
        if (node.getGroupBy().isPresent()) {
            this.process(node.getGroupBy().get(), context);
        }
        if (node.getHaving().isPresent()) {
            this.process(node.getHaving().get(), context);
        }
        for (WindowDefinition windowDefinition : node.getWindows()) {
            this.process(windowDefinition, context);
        }
        if (node.getOrderBy().isPresent()) {
            this.process(node.getOrderBy().get(), context);
        }
        if (node.getOffset().isPresent()) {
            this.process(node.getOffset().get(), context);
        }
        if (node.getLimit().isPresent()) {
            this.process(node.getLimit().get(), context);
        }
        return null;
    }

    @Override
    protected Void visitSetOperation(SetOperation node, C context) {
        for (Relation relation : node.getRelations()) {
            this.process(relation, context);
        }
        return null;
    }

    @Override
    protected Void visitValues(Values node, C context) {
        for (Expression row : node.getRows()) {
            this.process(row, context);
        }
        return null;
    }

    @Override
    protected Void visitRow(Row node, C context) {
        for (Expression expression : node.getItems()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitTableSubquery(TableSubquery node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitAliasedRelation(AliasedRelation node, C context) {
        this.process(node.getRelation(), context);
        return null;
    }

    @Override
    protected Void visitSampledRelation(SampledRelation node, C context) {
        this.process(node.getRelation(), context);
        this.process(node.getSamplePercentage(), context);
        return null;
    }

    @Override
    protected Void visitJoin(Join node, C context) {
        this.process(node.getLeft(), context);
        this.process(node.getRight(), context);
        node.getCriteria().filter(criteria -> criteria instanceof JoinOn).ifPresent(criteria -> this.process(((JoinOn)criteria).getExpression(), context));
        return null;
    }

    @Override
    protected Void visitUnnest(Unnest node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitGroupBy(GroupBy node, C context) {
        for (GroupingElement groupingElement : node.getGroupingElements()) {
            this.process(groupingElement, context);
        }
        return null;
    }

    @Override
    protected Void visitCube(Cube node, C context) {
        return null;
    }

    @Override
    protected Void visitRollup(Rollup node, C context) {
        return null;
    }

    @Override
    protected Void visitSimpleGroupBy(SimpleGroupBy node, C context) {
        for (Expression expression : node.getExpressions()) {
            this.process(expression, context);
        }
        return null;
    }

    @Override
    protected Void visitGroupingSets(GroupingSets node, C context) {
        return null;
    }

    @Override
    protected Void visitInsert(Insert node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitRefreshMaterializedView(RefreshMaterializedView node, C context) {
        return null;
    }

    @Override
    protected Void visitDelete(Delete node, C context) {
        this.process(node.getTable(), context);
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected Void visitUpdate(Update node, C context) {
        this.process(node.getTable(), context);
        node.getAssignments().forEach(value -> this.process((Node)value, context));
        node.getWhere().ifPresent(where -> this.process((Node)where, context));
        return null;
    }

    @Override
    protected Void visitUpdateAssignment(UpdateAssignment node, C context) {
        this.process(node.getName(), context);
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitMerge(Merge node, C context) {
        this.process(node.getTable(), context);
        node.getTargetAlias().ifPresent(target -> this.process((Node)target, context));
        this.process(node.getRelation(), context);
        this.process(node.getExpression(), context);
        node.getMergeCases().forEach(mergeCase -> this.process((Node)mergeCase, context));
        return null;
    }

    @Override
    protected Void visitMergeInsert(MergeInsert node, C context) {
        node.getExpression().ifPresent(expression -> this.process((Node)expression, context));
        node.getColumns().forEach(column -> this.process((Node)column, context));
        node.getValues().forEach(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected Void visitMergeUpdate(MergeUpdate node, C context) {
        node.getExpression().ifPresent(expression -> this.process((Node)expression, context));
        node.getAssignments().forEach(assignment -> {
            this.process(assignment.getTarget(), context);
            this.process(assignment.getValue(), context);
        });
        return null;
    }

    @Override
    protected Void visitMergeDelete(MergeDelete node, C context) {
        node.getExpression().ifPresent(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected Void visitCreateTableAsSelect(CreateTableAsSelect node, C context) {
        this.process(node.getQuery(), context);
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitProperty(Property node, C context) {
        this.process(node.getName(), context);
        if (!node.isSetToDefault()) {
            this.process(node.getNonDefaultValue(), context);
        }
        return null;
    }

    @Override
    protected Void visitAnalyze(Analyze node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitCreateView(CreateView node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitSetSession(SetSession node, C context) {
        this.process(node.getValue(), context);
        return null;
    }

    @Override
    protected Void visitAddColumn(AddColumn node, C context) {
        this.process(node.getColumn(), context);
        return null;
    }

    @Override
    protected Void visitCreateSchema(CreateSchema node, C context) {
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitCreateTable(CreateTable node, C context) {
        for (TableElement tableElement : node.getElements()) {
            this.process(tableElement, context);
        }
        for (Property property : node.getProperties()) {
            this.process(property, context);
        }
        return null;
    }

    @Override
    protected Void visitStartTransaction(StartTransaction node, C context) {
        for (TransactionMode transactionMode : node.getTransactionModes()) {
            this.process(transactionMode, context);
        }
        return null;
    }

    @Override
    protected Void visitExplain(Explain node, C context) {
        this.process(node.getStatement(), context);
        for (ExplainOption option : node.getOptions()) {
            this.process(option, context);
        }
        return null;
    }

    @Override
    protected Void visitExplainAnalyze(ExplainAnalyze node, C context) {
        this.process(node.getStatement(), context);
        return null;
    }

    @Override
    protected Void visitShowStats(ShowStats node, C context) {
        this.process(node.getRelation(), context);
        return null;
    }

    @Override
    protected Void visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, C context) {
        this.process(node.getValue(), context);
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected Void visitExists(ExistsPredicate node, C context) {
        this.process(node.getSubquery(), context);
        return null;
    }

    @Override
    protected Void visitLateral(Lateral node, C context) {
        this.process(node.getQuery(), context);
        return null;
    }

    @Override
    protected Void visitLambdaExpression(LambdaExpression node, C context) {
        this.process(node.getBody(), context);
        return null;
    }

    @Override
    protected Void visitExcludedPattern(ExcludedPattern node, C context) {
        this.process(node.getPattern(), context);
        return null;
    }

    @Override
    protected Void visitPatternAlternation(PatternAlternation node, C context) {
        for (RowPattern rowPattern : node.getPatterns()) {
            this.process(rowPattern, context);
        }
        return null;
    }

    @Override
    protected Void visitPatternConcatenation(PatternConcatenation node, C context) {
        for (RowPattern rowPattern : node.getPatterns()) {
            this.process(rowPattern, context);
        }
        return null;
    }

    @Override
    protected Void visitPatternPermutation(PatternPermutation node, C context) {
        for (RowPattern rowPattern : node.getPatterns()) {
            this.process(rowPattern, context);
        }
        return null;
    }

    @Override
    protected Void visitPatternVariable(PatternVariable node, C context) {
        this.process(node.getName(), context);
        return null;
    }

    @Override
    protected Void visitQuantifiedPattern(QuantifiedPattern node, C context) {
        this.process(node.getPattern(), context);
        return null;
    }

    @Override
    protected Void visitLabelDereference(LabelDereference node, C context) {
        node.getReference().ifPresent(reference -> this.process((Node)reference, context));
        return null;
    }

    @Override
    protected Void visitJsonExists(JsonExists node, C context) {
        this.process(node.getJsonPathInvocation(), context);
        return null;
    }

    @Override
    protected Void visitJsonValue(JsonValue node, C context) {
        this.process(node.getJsonPathInvocation(), context);
        node.getEmptyDefault().ifPresent(expression -> this.process((Node)expression, context));
        node.getErrorDefault().ifPresent(expression -> this.process((Node)expression, context));
        return null;
    }

    @Override
    protected Void visitJsonQuery(JsonQuery node, C context) {
        this.process(node.getJsonPathInvocation(), context);
        return null;
    }

    @Override
    protected Void visitJsonPathInvocation(JsonPathInvocation node, C context) {
        this.process(node.getInputExpression(), context);
        for (JsonPathParameter parameter : node.getPathParameters()) {
            this.process(parameter.getParameter(), context);
        }
        return null;
    }

    @Override
    protected Void visitJsonObject(JsonObject node, C context) {
        for (JsonObjectMember member : node.getMembers()) {
            this.process(member, context);
        }
        return null;
    }

    @Override
    protected Void visitJsonArray(JsonArray node, C context) {
        for (JsonArrayElement element : node.getElements()) {
            this.process(element, context);
        }
        return null;
    }
}

