/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.sql.ExpressionFormatter;
import io.trino.sql.RowPatternFormatter;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.CallArgument;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.DescriptorArgument;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainFormat;
import io.trino.sql.tree.ExplainOption;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.GrantorSpecification;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinCriteria;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JoinUsing;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryPeriod;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowCreate;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableArgument;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.TableFunctionArgument;
import io.trino.sql.tree.TableFunctionInvocation;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.sql.tree.TransactionMode;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.WithQuery;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SqlFormatter {
    private static final String INDENT = "   ";

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder).process(root, 0);
        return builder.toString();
    }

    static String formatName(QualifiedName name) {
        return name.getOriginalParts().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining("."));
    }

    private static void appendAliasColumns(StringBuilder builder, List<Identifier> columns) {
        if (columns != null && !columns.isEmpty()) {
            String formattedColumns = columns.stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", "));
            builder.append(" (").append(formattedColumns).append(')');
        }
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;

        public Formatter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            this.builder.append(ExpressionFormatter.formatExpression(node));
            return null;
        }

        @Override
        protected Void visitRowPattern(RowPattern node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitRowPattern should only be called at root");
            this.builder.append(RowPatternFormatter.formatPattern(node));
            return null;
        }

        @Override
        protected Void visitUnnest(Unnest node, Integer indent) {
            this.builder.append("UNNEST(").append(node.getExpressions().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", "))).append(")");
            if (node.isWithOrdinality()) {
                this.builder.append(" WITH ORDINALITY");
            }
            return null;
        }

        @Override
        protected Void visitLateral(Lateral node, Integer indent) {
            this.append(indent, "LATERAL (");
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ")");
            return null;
        }

        @Override
        protected Void visitTableFunctionInvocation(TableFunctionInvocation node, Integer indent) {
            this.append(indent, "TABLE(");
            this.appendTableFunctionInvocation(node, indent + 1);
            this.builder.append(")");
            return null;
        }

        private void appendTableFunctionInvocation(TableFunctionInvocation node, Integer indent) {
            this.builder.append(SqlFormatter.formatName(node.getName())).append("(\n");
            this.appendTableFunctionArguments(node.getArguments(), indent + 1);
            if (!node.getCopartitioning().isEmpty()) {
                this.builder.append("\n");
                this.append(indent + 1, "COPARTITION ");
                this.builder.append(node.getCopartitioning().stream().map(tableList -> tableList.stream().map(SqlFormatter::formatName).collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(", ")));
            }
            this.builder.append(")");
        }

        private void appendTableFunctionArguments(List<TableFunctionArgument> arguments, int indent) {
            for (int i = 0; i < arguments.size(); ++i) {
                TableFunctionArgument argument = arguments.get(i);
                if (argument.getName().isPresent()) {
                    this.append(indent, ExpressionFormatter.formatExpression(argument.getName().get()));
                    this.builder.append(" => ");
                } else {
                    this.append(indent, "");
                }
                Node value = argument.getValue();
                if (value instanceof Expression) {
                    this.builder.append(ExpressionFormatter.formatExpression((Expression)value));
                } else {
                    this.process(value, indent + 1);
                }
                if (i >= arguments.size() - 1) continue;
                this.builder.append(",\n");
            }
        }

        @Override
        protected Void visitTableArgument(TableArgument node, Integer indent) {
            Relation relation = node.getTable();
            Relation unaliased = relation instanceof AliasedRelation ? ((AliasedRelation)relation).getRelation() : relation;
            this.builder.append("TABLE(");
            this.process(unaliased, indent);
            this.builder.append(")");
            if (relation instanceof AliasedRelation) {
                AliasedRelation aliasedRelation = (AliasedRelation)relation;
                this.builder.append(" AS ").append(ExpressionFormatter.formatExpression(aliasedRelation.getAlias()));
                SqlFormatter.appendAliasColumns(this.builder, aliasedRelation.getColumnNames());
            }
            if (node.getPartitionBy().isPresent()) {
                this.builder.append("\n");
                this.append(indent, "PARTITION BY ").append(node.getPartitionBy().get().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", ")));
            }
            if (node.isPruneWhenEmpty()) {
                this.builder.append("\n");
                this.append(indent, "PRUNE WHEN EMPTY");
            } else {
                this.builder.append("\n");
                this.append(indent, "KEEP WHEN EMPTY");
            }
            node.getOrderBy().ifPresent(orderBy -> {
                this.builder.append("\n");
                this.append(indent, ExpressionFormatter.formatOrderBy(orderBy));
            });
            return null;
        }

        @Override
        protected Void visitDescriptorArgument(DescriptorArgument node, Integer indent) {
            if (node.getDescriptor().isPresent()) {
                this.builder.append(node.getDescriptor().get().getFields().stream().map(field -> {
                    String formattedField = ExpressionFormatter.formatExpression(field.getName());
                    if (field.getType().isPresent()) {
                        formattedField = formattedField + " " + ExpressionFormatter.formatExpression(field.getType().get());
                    }
                    return formattedField;
                }).collect(Collectors.joining(", ", "DESCRIPTOR(", ")")));
            } else {
                this.builder.append("CAST (NULL AS DESCRIPTOR)");
            }
            return null;
        }

        @Override
        protected Void visitPrepare(Prepare node, Integer indent) {
            this.append(indent, "PREPARE ");
            this.builder.append(node.getName());
            this.builder.append(" FROM");
            this.builder.append("\n");
            this.process(node.getStatement(), indent + 1);
            return null;
        }

        @Override
        protected Void visitDeallocate(Deallocate node, Integer indent) {
            this.append(indent, "DEALLOCATE PREPARE ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExecute(Execute node, Integer indent) {
            this.append(indent, "EXECUTE ");
            this.builder.append(node.getName());
            List<Expression> parameters = node.getParameters();
            if (!parameters.isEmpty()) {
                this.builder.append(" USING ");
                Joiner.on((String)", ").appendTo(this.builder, parameters);
            }
            return null;
        }

        @Override
        protected Void visitDescribeOutput(DescribeOutput node, Integer indent) {
            this.append(indent, "DESCRIBE OUTPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitDescribeInput(DescribeInput node, Integer indent) {
            this.append(indent, "DESCRIBE INPUT ");
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            node.getWith().ifPresent(with -> {
                this.append(indent, "WITH");
                if (with.isRecursive()) {
                    this.builder.append(" RECURSIVE");
                }
                this.builder.append("\n  ");
                Iterator<WithQuery> queries = with.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = queries.next();
                    this.append(indent, ExpressionFormatter.formatExpression(query.getName()));
                    query.getColumnNames().ifPresent(columnNames -> SqlFormatter.appendAliasColumns(this.builder, columnNames));
                    this.builder.append(" AS ");
                    this.process(new TableSubquery(query.getQuery()), indent);
                    this.builder.append('\n');
                    if (!queries.hasNext()) continue;
                    this.builder.append(", ");
                }
            });
            this.processRelation(node.getQueryBody(), indent);
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent));
            node.getOffset().ifPresent(offset -> this.process((Node)offset, indent));
            node.getLimit().ifPresent(limit -> this.process((Node)limit, indent));
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            node.getFrom().ifPresent(from -> {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process((Node)from, indent);
            });
            this.builder.append('\n');
            node.getWhere().ifPresent(where -> this.append(indent, "WHERE " + ExpressionFormatter.formatExpression(where)).append('\n'));
            node.getGroupBy().ifPresent(groupBy -> this.append(indent, "GROUP BY " + (groupBy.isDistinct() ? " DISTINCT " : "") + ExpressionFormatter.formatGroupBy(groupBy.getGroupingElements())).append('\n'));
            node.getHaving().ifPresent(having -> this.append(indent, "HAVING " + ExpressionFormatter.formatExpression(having)).append('\n'));
            if (!node.getWindows().isEmpty()) {
                this.append(indent, "WINDOW");
                this.formatDefinitionList((List)node.getWindows().stream().map(definition -> ExpressionFormatter.formatExpression(definition.getName()) + " AS " + ExpressionFormatter.formatWindowSpecification(definition.getWindow())).collect(ImmutableList.toImmutableList()), indent + 1);
            }
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent));
            node.getOffset().ifPresent(offset -> this.process((Node)offset, indent));
            node.getLimit().ifPresent(limit -> this.process((Node)limit, indent));
            return null;
        }

        @Override
        protected Void visitOrderBy(OrderBy node, Integer indent) {
            this.append(indent, ExpressionFormatter.formatOrderBy(node)).append('\n');
            return null;
        }

        @Override
        protected Void visitOffset(Offset node, Integer indent) {
            this.append(indent, "OFFSET ").append(ExpressionFormatter.formatExpression(node.getRowCount())).append(" ROWS\n");
            return null;
        }

        @Override
        protected Void visitFetchFirst(FetchFirst node, Integer indent) {
            this.append(indent, "FETCH FIRST " + node.getRowCount().map(count -> ExpressionFormatter.formatExpression(count) + " ROWS ").orElse("ROW ")).append(node.isWithTies() ? "WITH TIES" : "ONLY").append('\n');
            return null;
        }

        @Override
        protected Void visitLimit(Limit node, Integer indent) {
            this.append(indent, "LIMIT ").append(ExpressionFormatter.formatExpression(node.getRowCount())).append('\n');
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatExpression(node.getExpression()));
            node.getAlias().ifPresent(alias -> this.builder.append(' ').append(ExpressionFormatter.formatExpression(alias)));
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer indent) {
            node.getTarget().ifPresent(value -> this.builder.append(ExpressionFormatter.formatExpression(value)).append("."));
            this.builder.append("*");
            if (!node.getAliases().isEmpty()) {
                this.builder.append(" AS (").append(Joiner.on((String)", ").join((Iterable)node.getAliases().stream().map(ExpressionFormatter::formatExpression).collect(ImmutableList.toImmutableList()))).append(")");
            }
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(SqlFormatter.formatName(node.getName()));
            node.getQueryPeriod().ifPresent(queryPeriod -> this.builder.append(" " + queryPeriod));
            return null;
        }

        @Override
        protected Void visitQueryPeriod(QueryPeriod node, Integer indent) {
            this.builder.append("FOR " + node.getRangeType().name() + " AS OF " + ExpressionFormatter.formatExpression(node.getEnd().get()));
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            String type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON ").append(ExpressionFormatter.formatExpression(on.getExpression()));
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + criteria);
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.processRelationSuffix(node.getRelation(), indent);
            this.builder.append(' ').append(ExpressionFormatter.formatExpression(node.getAlias()));
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitPatternRecognitionRelation(PatternRecognitionRelation node, Integer indent) {
            this.processRelationSuffix(node.getInput(), indent);
            this.builder.append(" MATCH_RECOGNIZE (\n");
            if (!node.getPartitionBy().isEmpty()) {
                this.append(indent + 1, "PARTITION BY ").append(node.getPartitionBy().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", "))).append("\n");
            }
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent + 1));
            if (!node.getMeasures().isEmpty()) {
                this.append(indent + 1, "MEASURES");
                this.formatDefinitionList((List)node.getMeasures().stream().map(measure -> ExpressionFormatter.formatExpression(measure.getExpression()) + " AS " + ExpressionFormatter.formatExpression(measure.getName())).collect(ImmutableList.toImmutableList()), indent + 2);
            }
            node.getRowsPerMatch().ifPresent(rowsPerMatch -> {
                String rowsPerMatchDescription;
                switch (rowsPerMatch) {
                    case ONE: {
                        rowsPerMatchDescription = "ONE ROW PER MATCH";
                        break;
                    }
                    case ALL_SHOW_EMPTY: {
                        rowsPerMatchDescription = "ALL ROWS PER MATCH SHOW EMPTY MATCHES";
                        break;
                    }
                    case ALL_OMIT_EMPTY: {
                        rowsPerMatchDescription = "ALL ROWS PER MATCH OMIT EMPTY MATCHES";
                        break;
                    }
                    case ALL_WITH_UNMATCHED: {
                        rowsPerMatchDescription = "ALL ROWS PER MATCH WITH UNMATCHED ROWS";
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unexpected rowsPerMatch: " + (Object)((Object)node.getRowsPerMatch().get()));
                    }
                }
                this.append(indent + 1, rowsPerMatchDescription).append("\n");
            });
            node.getAfterMatchSkipTo().ifPresent(afterMatchSkipTo -> {
                String skipTo = ExpressionFormatter.formatSkipTo(afterMatchSkipTo);
                this.append(indent + 1, skipTo).append("\n");
            });
            node.getPatternSearchMode().ifPresent(patternSearchMode -> this.append(indent + 1, patternSearchMode.getMode().name()).append("\n"));
            this.append(indent + 1, "PATTERN (").append(RowPatternFormatter.formatPattern(node.getPattern())).append(")\n");
            if (!node.getSubsets().isEmpty()) {
                this.append(indent + 1, "SUBSET");
                this.formatDefinitionList((List)node.getSubsets().stream().map(subset -> ExpressionFormatter.formatExpression(subset.getName()) + " = " + subset.getIdentifiers().stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", ", "(", ")"))).collect(ImmutableList.toImmutableList()), indent + 2);
            }
            this.append(indent + 1, "DEFINE");
            this.formatDefinitionList((List)node.getVariableDefinitions().stream().map(variable -> ExpressionFormatter.formatExpression(variable.getName()) + " AS " + ExpressionFormatter.formatExpression(variable.getExpression())).collect(ImmutableList.toImmutableList()), indent + 2);
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitSampledRelation(SampledRelation node, Integer indent) {
            this.processRelationSuffix(node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append((Object)node.getType()).append(" (").append(node.getSamplePercentage()).append(')');
            return null;
        }

        private void processRelationSuffix(Relation relation, Integer indent) {
            if (relation instanceof AliasedRelation || relation instanceof SampledRelation || relation instanceof PatternRecognitionRelation) {
                this.builder.append("( ");
                this.process(relation, indent + 1);
                this.append(indent, ")");
            } else {
                this.process(relation, indent);
            }
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(ExpressionFormatter.formatExpression(row));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitExcept(Except node, Integer indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            if (!node.isDistinct()) {
                this.builder.append("ALL ");
            }
            this.processRelation(node.getRight(), indent);
            return null;
        }

        @Override
        protected Void visitIntersect(Intersect node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                if (node.isDistinct()) continue;
                this.builder.append("ALL ");
            }
            return null;
        }

        @Override
        protected Void visitMerge(Merge node, Integer indent) {
            this.builder.append("MERGE INTO ").append(node.getTargetTable().getName());
            node.getTargetAlias().ifPresent(value -> this.builder.append(' ').append(value));
            this.builder.append("\n");
            this.append(indent + 1, "USING ");
            this.processRelation(node.getSource(), indent + 2);
            this.builder.append("\n");
            this.append(indent + 1, "ON ");
            this.builder.append(ExpressionFormatter.formatExpression(node.getPredicate()));
            for (MergeCase mergeCase : node.getMergeCases()) {
                this.builder.append("\n");
                this.process(mergeCase, indent);
            }
            return null;
        }

        @Override
        protected Void visitMergeInsert(MergeInsert node, Integer indent) {
            this.appendMergeCaseWhen(false, node.getExpression());
            this.append(indent + 1, "THEN INSERT ");
            if (!node.getColumns().isEmpty()) {
                this.builder.append("(");
                Joiner.on((String)", ").appendTo(this.builder, node.getColumns());
                this.builder.append(")");
            }
            this.builder.append("VALUES (");
            Joiner.on((String)", ").appendTo(this.builder, Iterables.transform(node.getValues(), ExpressionFormatter::formatExpression));
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitMergeUpdate(MergeUpdate node, Integer indent) {
            this.appendMergeCaseWhen(true, node.getExpression());
            this.append(indent + 1, "THEN UPDATE SET");
            boolean first = true;
            for (MergeUpdate.Assignment assignment : node.getAssignments()) {
                this.builder.append("\n");
                this.append(indent + 1, first ? "  " : ", ");
                this.builder.append(assignment.getTarget()).append(" = ").append(ExpressionFormatter.formatExpression(assignment.getValue()));
                first = false;
            }
            return null;
        }

        @Override
        protected Void visitMergeDelete(MergeDelete node, Integer indent) {
            this.appendMergeCaseWhen(true, node.getExpression());
            this.append(indent + 1, "THEN DELETE");
            return null;
        }

        private void appendMergeCaseWhen(boolean matched, Optional<Expression> expression) {
            this.builder.append(matched ? "WHEN MATCHED" : "WHEN NOT MATCHED");
            expression.ifPresent(value -> this.builder.append(" AND ").append(ExpressionFormatter.formatExpression(value)));
            this.builder.append("\n");
        }

        @Override
        protected Void visitCreateView(CreateView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(SqlFormatter.formatName(node.getName()));
            node.getComment().ifPresent(comment -> this.builder.append(" COMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            node.getSecurity().ifPresent(security -> this.builder.append(" SECURITY ").append(security));
            this.builder.append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitRenameView(RenameView node, Integer indent) {
            this.builder.append("ALTER VIEW ").append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitRenameMaterializedView(RenameMaterializedView node, Integer indent) {
            this.builder.append("ALTER MATERIALIZED VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitSetViewAuthorization(SetViewAuthorization node, Integer indent) {
            this.builder.append("ALTER VIEW ").append(SqlFormatter.formatName(node.getSource())).append(" SET AUTHORIZATION ").append(Formatter.formatPrincipal(node.getPrincipal()));
            return null;
        }

        @Override
        protected Void visitCreateMaterializedView(CreateMaterializedView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("MATERIALIZED VIEW ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            node.getComment().ifPresent(comment -> this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitRefreshMaterializedView(RefreshMaterializedView node, Integer indent) {
            this.builder.append("REFRESH MATERIALIZED VIEW ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitDropMaterializedView(DropMaterializedView node, Integer indent) {
            this.builder.append("DROP MATERIALIZED VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitDropView(DropView node, Integer indent) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName());
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            ArrayList<String> options = new ArrayList<String>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    options.add("TYPE " + (Object)((Object)((ExplainType)option).getType()));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    options.add("FORMAT " + (Object)((Object)((ExplainFormat)option).getType()));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + option);
            }
            if (!options.isEmpty()) {
                this.builder.append("(");
                Joiner.on((String)", ").appendTo(this.builder, options);
                this.builder.append(")");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitExplainAnalyze(ExplainAnalyze node, Integer indent) {
            this.builder.append("EXPLAIN ANALYZE");
            if (node.isVerbose()) {
                this.builder.append(" VERBOSE");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowCatalogs(ShowCatalogs node, Integer indent) {
            this.builder.append("SHOW CATALOGS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSchemas(ShowSchemas node, Integer indent) {
            this.builder.append("SHOW SCHEMAS");
            node.getCatalog().ifPresent(catalog -> this.builder.append(" FROM ").append(node.getCatalog().get()));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowTables(ShowTables node, Integer indent) {
            this.builder.append("SHOW TABLES");
            node.getSchema().ifPresent(value -> this.builder.append(" FROM ").append(SqlFormatter.formatName(value)));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowCreate(ShowCreate node, Integer indent) {
            if (node.getType() == ShowCreate.Type.TABLE) {
                this.builder.append("SHOW CREATE TABLE ").append(SqlFormatter.formatName(node.getName()));
            } else if (node.getType() == ShowCreate.Type.VIEW) {
                this.builder.append("SHOW CREATE VIEW ").append(SqlFormatter.formatName(node.getName()));
            } else if (node.getType() == ShowCreate.Type.MATERIALIZED_VIEW) {
                this.builder.append("SHOW CREATE MATERIALIZED VIEW ").append(SqlFormatter.formatName(node.getName()));
            }
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer indent) {
            this.builder.append("SHOW COLUMNS FROM ").append(SqlFormatter.formatName(node.getTable()));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowStats(ShowStats node, Integer indent) {
            this.builder.append("SHOW STATS FOR ");
            this.process(node.getRelation(), 0);
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer indent) {
            this.builder.append("SHOW FUNCTIONS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSession(ShowSession node, Integer indent) {
            this.builder.append("SHOW SESSION");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer indent) {
            this.builder.append("DELETE FROM ").append(SqlFormatter.formatName(node.getTable().getName()));
            node.getWhere().ifPresent(where -> this.builder.append(" WHERE ").append(ExpressionFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitCreateSchema(CreateSchema node, Integer indent) {
            this.builder.append("CREATE SCHEMA ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSchemaName()));
            node.getPrincipal().ifPresent(principal -> this.builder.append("\nAUTHORIZATION ").append(Formatter.formatPrincipal(principal)));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitDropSchema(DropSchema node, Integer indent) {
            this.builder.append("DROP SCHEMA ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSchemaName())).append(" ").append(node.isCascade() ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        protected Void visitRenameSchema(RenameSchema node, Integer indent) {
            this.builder.append("ALTER SCHEMA ").append(SqlFormatter.formatName(node.getSource())).append(" RENAME TO ").append(ExpressionFormatter.formatExpression(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitSetSchemaAuthorization(SetSchemaAuthorization node, Integer indent) {
            this.builder.append("ALTER SCHEMA ").append(SqlFormatter.formatName(node.getSource())).append(" SET AUTHORIZATION ").append(Formatter.formatPrincipal(node.getPrincipal()));
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            node.getColumnAliases().ifPresent(columnAliases -> {
                String columnList = columnAliases.stream().map(ExpressionFormatter::formatExpression).collect(Collectors.joining(", "));
                this.builder.append(String.format("( %s )", columnList));
            });
            node.getComment().ifPresent(comment -> this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            if (!node.isWithData()) {
                this.builder.append(" WITH NO DATA");
            }
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            String tableName = SqlFormatter.formatName(node.getName());
            this.builder.append(tableName).append(" (\n");
            String elementIndent = Formatter.indentString(indent + 1);
            String columnList = node.getElements().stream().map(element -> {
                if (element instanceof ColumnDefinition) {
                    ColumnDefinition column = (ColumnDefinition)element;
                    return elementIndent + this.formatColumnDefinition(column);
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    StringBuilder builder = new StringBuilder(elementIndent);
                    builder.append("LIKE ").append(SqlFormatter.formatName(likeClause.getTableName()));
                    likeClause.getPropertiesOption().ifPresent(propertiesOption -> builder.append(" ").append(propertiesOption.name()).append(" PROPERTIES"));
                    return builder.toString();
                }
                throw new UnsupportedOperationException("unknown table element: " + element);
            }).collect(Collectors.joining(",\n"));
            this.builder.append(columnList);
            this.builder.append("\n").append(")");
            node.getComment().ifPresent(comment -> this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        private String formatPropertiesMultiLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            String propertyList = properties.stream().map(element -> SqlFormatter.INDENT + ExpressionFormatter.formatExpression(element.getName()) + " = " + (element.isSetToDefault() ? "DEFAULT" : ExpressionFormatter.formatExpression(element.getNonDefaultValue()))).collect(Collectors.joining(",\n"));
            return "\nWITH (\n" + propertyList + "\n)";
        }

        private String formatPropertiesSingleLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            return " WITH ( " + this.joinProperties(properties) + " )";
        }

        private String formatColumnDefinition(ColumnDefinition column) {
            StringBuilder builder = new StringBuilder().append(ExpressionFormatter.formatExpression(column.getName())).append(" ").append(column.getType());
            if (!column.isNullable()) {
                builder.append(" NOT NULL");
            }
            column.getComment().ifPresent(comment -> builder.append(" COMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            builder.append(this.formatPropertiesSingleLine(column.getProperties()));
            return builder.toString();
        }

        private static String formatGrantor(GrantorSpecification grantor) {
            GrantorSpecification.Type type = grantor.getType();
            switch (type) {
                case CURRENT_ROLE: 
                case CURRENT_USER: {
                    return type.name();
                }
                case PRINCIPAL: {
                    return Formatter.formatPrincipal(grantor.getPrincipal().get());
                }
            }
            throw new IllegalArgumentException("Unsupported principal type: " + (Object)((Object)type));
        }

        private static String formatPrincipal(PrincipalSpecification principal) {
            PrincipalSpecification.Type type = principal.getType();
            switch (type) {
                case UNSPECIFIED: {
                    return principal.getName().toString();
                }
                case USER: 
                case ROLE: {
                    return String.format("%s %s", type.name(), principal.getName());
                }
            }
            throw new IllegalArgumentException("Unsupported principal type: " + (Object)((Object)type));
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer indent) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTableName()));
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getSource()).append(" RENAME TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitSetProperties(SetProperties node, Integer context) {
            SetProperties.Type type = node.getType();
            this.builder.append("ALTER ");
            switch (type) {
                case TABLE: {
                    this.builder.append("TABLE ");
                    break;
                }
                case MATERIALIZED_VIEW: {
                    this.builder.append("MATERIALIZED VIEW ");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported SetProperties.Type: " + (Object)((Object)type));
                }
            }
            this.builder.append(SqlFormatter.formatName(node.getName())).append(" SET PROPERTIES ").append(this.joinProperties(node.getProperties()));
            return null;
        }

        private String joinProperties(List<Property> properties) {
            return properties.stream().map(element -> ExpressionFormatter.formatExpression(element.getName()) + " = " + (element.isSetToDefault() ? "DEFAULT" : ExpressionFormatter.formatExpression(element.getNonDefaultValue()))).collect(Collectors.joining(", "));
        }

        @Override
        protected Void visitComment(Comment node, Integer context) {
            String comment = node.getComment().map(ExpressionFormatter::formatStringLiteral).orElse("NULL");
            switch (node.getType()) {
                case TABLE: {
                    this.builder.append("COMMENT ON TABLE ").append(node.getName()).append(" IS ").append(comment);
                    break;
                }
                case VIEW: {
                    this.builder.append("COMMENT ON VIEW ").append(node.getName()).append(" IS ").append(comment);
                    break;
                }
                case COLUMN: {
                    this.builder.append("COMMENT ON COLUMN ").append(node.getName()).append(" IS ").append(comment);
                }
            }
            return null;
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getTable()).append(" RENAME COLUMN ");
            if (node.isColumnExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getSource()).append(" TO ").append(node.getTarget());
            return null;
        }

        @Override
        protected Void visitDropColumn(DropColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTable())).append(" DROP COLUMN ");
            if (node.isColumnExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(ExpressionFormatter.formatExpression(node.getColumn()));
            return null;
        }

        @Override
        protected Void visitTableExecute(TableExecute node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            this.builder.append(SqlFormatter.formatName(node.getTable().getName()));
            this.builder.append(" EXECUTE ");
            this.builder.append(ExpressionFormatter.formatExpression(node.getProcedureName()));
            if (!node.getArguments().isEmpty()) {
                this.builder.append("(");
                this.formatCallArguments(indent, node.getArguments());
                this.builder.append(")");
            }
            node.getWhere().ifPresent(where -> this.builder.append("\n").append(Formatter.indentString(indent)).append("WHERE ").append(ExpressionFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitAnalyze(Analyze node, Integer indent) {
            this.builder.append("ANALYZE ").append(SqlFormatter.formatName(node.getTableName()));
            this.builder.append(this.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitAddColumn(AddColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.getName()).append(" ADD COLUMN ");
            if (node.isColumnNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(this.formatColumnDefinition(node.getColumn()));
            return null;
        }

        @Override
        protected Void visitSetTableAuthorization(SetTableAuthorization node, Integer indent) {
            this.builder.append("ALTER TABLE ").append(SqlFormatter.formatName(node.getSource())).append(" SET AUTHORIZATION ").append(Formatter.formatPrincipal(node.getPrincipal()));
            return null;
        }

        @Override
        protected Void visitInsert(Insert node, Integer indent) {
            this.builder.append("INSERT INTO ").append(SqlFormatter.formatName(node.getTarget()));
            node.getColumns().ifPresent(columns -> this.builder.append(" (").append(Joiner.on((String)", ").join((Iterable)columns)).append(")"));
            this.builder.append("\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitUpdate(Update node, Integer indent) {
            this.builder.append("UPDATE ").append(node.getTable().getName()).append(" SET");
            int setCounter = node.getAssignments().size() - 1;
            for (UpdateAssignment assignment : node.getAssignments()) {
                this.builder.append("\n").append(Formatter.indentString(indent + 1)).append(assignment.getName().getValue()).append(" = ").append(ExpressionFormatter.formatExpression(assignment.getValue()));
                if (setCounter > 0) {
                    this.builder.append(",");
                }
                --setCounter;
            }
            node.getWhere().ifPresent(where -> this.builder.append("\n").append(Formatter.indentString(indent)).append("WHERE ").append(ExpressionFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitTruncateTable(TruncateTable node, Integer indent) {
            this.builder.append("TRUNCATE TABLE ");
            this.builder.append(SqlFormatter.formatName(node.getTableName()));
            return null;
        }

        @Override
        public Void visitSetSession(SetSession node, Integer indent) {
            this.builder.append("SET SESSION ").append(SqlFormatter.formatName(node.getName())).append(" = ").append(ExpressionFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        public Void visitResetSession(ResetSession node, Integer indent) {
            this.builder.append("RESET SESSION ").append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitCallArgument(CallArgument node, Integer indent) {
            node.getName().ifPresent(name -> this.builder.append(name).append(" => "));
            this.builder.append(ExpressionFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        protected Void visitCall(Call node, Integer indent) {
            this.builder.append("CALL ").append(node.getName()).append("(");
            this.formatCallArguments(indent, node.getArguments());
            this.builder.append(")");
            return null;
        }

        private void formatCallArguments(Integer indent, List<CallArgument> arguments) {
            Iterator<CallArgument> iterator = arguments.iterator();
            while (iterator.hasNext()) {
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
        }

        @Override
        protected Void visitRow(Row node, Integer indent) {
            this.builder.append("ROW(");
            boolean firstItem = true;
            for (Expression item : node.getItems()) {
                if (!firstItem) {
                    this.builder.append(", ");
                }
                this.process(item, indent);
                firstItem = false;
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitStartTransaction(StartTransaction node, Integer indent) {
            this.builder.append("START TRANSACTION");
            Iterator<TransactionMode> iterator = node.getTransactionModes().iterator();
            while (iterator.hasNext()) {
                this.builder.append(" ");
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
            return null;
        }

        @Override
        protected Void visitIsolationLevel(Isolation node, Integer indent) {
            this.builder.append("ISOLATION LEVEL ").append(node.getLevel().getText());
            return null;
        }

        @Override
        protected Void visitTransactionAccessMode(TransactionAccessMode node, Integer indent) {
            this.builder.append(node.isReadOnly() ? "READ ONLY" : "READ WRITE");
            return null;
        }

        @Override
        protected Void visitCommit(Commit node, Integer indent) {
            this.builder.append("COMMIT");
            return null;
        }

        @Override
        protected Void visitRollback(Rollback node, Integer indent) {
            this.builder.append("ROLLBACK");
            return null;
        }

        @Override
        protected Void visitCreateRole(CreateRole node, Integer indent) {
            this.builder.append("CREATE ROLE ").append(node.getName());
            node.getGrantor().ifPresent(grantor -> this.builder.append(" WITH ADMIN ").append(Formatter.formatGrantor(grantor)));
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(catalog));
            return null;
        }

        @Override
        protected Void visitDropRole(DropRole node, Integer indent) {
            this.builder.append("DROP ROLE ").append(node.getName());
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(catalog));
            return null;
        }

        @Override
        protected Void visitGrantRoles(GrantRoles node, Integer indent) {
            this.builder.append("GRANT ");
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" TO ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            if (node.isAdminOption()) {
                this.builder.append(" WITH ADMIN OPTION");
            }
            node.getGrantor().ifPresent(grantor -> this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(grantor)));
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(catalog));
            return null;
        }

        @Override
        protected Void visitRevokeRoles(RevokeRoles node, Integer indent) {
            this.builder.append("REVOKE ");
            if (node.isAdminOption()) {
                this.builder.append("ADMIN OPTION FOR ");
            }
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" FROM ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            node.getGrantor().ifPresent(grantor -> this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(grantor)));
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(catalog));
            return null;
        }

        @Override
        protected Void visitSetRole(SetRole node, Integer indent) {
            this.builder.append("SET ROLE ");
            SetRole.Type type = node.getType();
            switch (type) {
                case ALL: 
                case NONE: {
                    this.builder.append((Object)type);
                    break;
                }
                case ROLE: {
                    this.builder.append(node.getRole().get());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
                }
            }
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(catalog));
            return null;
        }

        @Override
        public Void visitGrant(Grant node, Integer indent) {
            this.builder.append("GRANT ");
            this.builder.append(node.getPrivileges().map(privileges -> String.join((CharSequence)", ", privileges)).orElse("ALL PRIVILEGES"));
            this.builder.append(" ON ");
            node.getType().ifPresent(type -> this.builder.append(type).append(' '));
            this.builder.append(SqlFormatter.formatName(node.getName())).append(" TO ").append(Formatter.formatPrincipal(node.getGrantee()));
            if (node.isWithGrantOption()) {
                this.builder.append(" WITH GRANT OPTION");
            }
            return null;
        }

        @Override
        public Void visitDeny(Deny node, Integer indent) {
            this.builder.append("DENY ");
            if (node.getPrivileges().isPresent()) {
                this.builder.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)node.getPrivileges().get()));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ");
            if (node.getType().isPresent()) {
                this.builder.append((Object)node.getType().get());
                this.builder.append(" ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName())).append(" TO ").append(Formatter.formatPrincipal(node.getGrantee()));
            return null;
        }

        @Override
        public Void visitRevoke(Revoke node, Integer indent) {
            this.builder.append("REVOKE ");
            if (node.isGrantOptionFor()) {
                this.builder.append("GRANT OPTION FOR ");
            }
            this.builder.append(node.getPrivileges().map(privileges -> String.join((CharSequence)", ", privileges)).orElse("ALL PRIVILEGES"));
            this.builder.append(" ON ");
            node.getType().ifPresent(type -> this.builder.append(type).append(' '));
            this.builder.append(node.getName()).append(" FROM ").append(Formatter.formatPrincipal(node.getGrantee()));
            return null;
        }

        @Override
        public Void visitShowGrants(ShowGrants node, Integer indent) {
            this.builder.append("SHOW GRANTS ");
            node.getTableName().ifPresent(tableName -> {
                this.builder.append("ON ");
                if (node.getTable()) {
                    this.builder.append("TABLE ");
                }
                this.builder.append(tableName);
            });
            return null;
        }

        @Override
        protected Void visitShowRoles(ShowRoles node, Integer indent) {
            this.builder.append("SHOW ");
            if (node.isCurrent()) {
                this.builder.append("CURRENT ");
            }
            this.builder.append("ROLES");
            node.getCatalog().ifPresent(catalog -> this.builder.append(" FROM ").append(catalog));
            return null;
        }

        @Override
        protected Void visitShowRoleGrants(ShowRoleGrants node, Integer indent) {
            this.builder.append("SHOW ROLE GRANTS");
            node.getCatalog().ifPresent(catalog -> this.builder.append(" FROM ").append(catalog));
            return null;
        }

        @Override
        public Void visitSetPath(SetPath node, Integer indent) {
            this.builder.append("SET PATH ");
            this.builder.append(Joiner.on((String)", ").join(node.getPathSpecification().getPath()));
            return null;
        }

        @Override
        public Void visitSetTimeZone(SetTimeZone node, Integer indent) {
            this.builder.append("SET TIME ZONE ");
            this.builder.append(node.getTimeZone().map(ExpressionFormatter::formatExpression).orElse("LOCAL"));
            return null;
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                this.builder.append("TABLE ").append(((Table)relation).getName()).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private StringBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return Strings.repeat((String)SqlFormatter.INDENT, (int)indent);
        }

        private void formatDefinitionList(List<String> elements, int indent) {
            if (elements.size() == 1) {
                this.builder.append(" ").append((String)Iterables.getOnlyElement(elements)).append("\n");
            } else {
                this.builder.append("\n");
                for (int i = 0; i < elements.size() - 1; ++i) {
                    this.append(indent, elements.get(i)).append(",\n");
                }
                this.append(indent, elements.get(elements.size() - 1)).append("\n");
            }
        }
    }
}

