/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath;

import io.trino.jsonpath.JsonPathBaseListener;
import io.trino.jsonpath.JsonPathLexer;
import io.trino.jsonpath.JsonPathParser;
import io.trino.sql.jsonpath.PathTreeBuilder;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.parser.ParsingException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class PathParser {
    private final BaseErrorListener errorListener;

    public PathParser(Location startLocation) {
        Objects.requireNonNull(startLocation, "startLocation is null");
        final int pathStartLine = startLocation.line;
        final int pathStartColumn = startLocation.column;
        this.errorListener = new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
                int lineInQuery = pathStartLine - 1 + line;
                int columnInQuery = line == 1 ? pathStartColumn + 1 + charPositionInLine : charPositionInLine + 1;
                throw new ParsingException(message, e, lineInQuery, columnInQuery);
            }
        };
    }

    public PathNode parseJsonPath(String path) {
        try {
            JsonPathParser.PathContext tree;
            JsonPathLexer lexer = new JsonPathLexer((CharStream)CharStreams.fromString((String)path));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            JsonPathParser parser = new JsonPathParser((TokenStream)tokenStream);
            parser.addParseListener(new PostProcessor(Arrays.asList(parser.getRuleNames()), parser));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)this.errorListener);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)this.errorListener);
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                tree = parser.path();
            }
            catch (ParseCancellationException ex) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                tree = parser.path();
            }
            return (PathNode)new PathTreeBuilder().visit((ParseTree)tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("stack overflow while parsing JSON path");
        }
    }

    public static class Location {
        private final int line;
        private final int column;

        public Location(int line, int column) {
            if (line < 1) {
                throw new IllegalArgumentException("line must be at least 1");
            }
            if (column < 0) {
                throw new IllegalArgumentException("column must be at least 0");
            }
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private static class PostProcessor
    extends JsonPathBaseListener {
        private final List<String> ruleNames;
        private final JsonPathParser parser;

        public PostProcessor(List<String> ruleNames, JsonPathParser parser) {
            this.ruleNames = ruleNames;
            this.parser = parser;
        }

        @Override
        public void exitNonReserved(JsonPathParser.NonReservedContext context) {
            if (!(context.getChild(0) instanceof TerminalNode)) {
                int rule = ((ParserRuleContext)context.getChild(0)).getRuleIndex();
                throw new AssertionError((Object)("nonReserved can only contain tokens. Found nested rule: " + this.ruleNames.get(rule)));
            }
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            CommonToken newToken = new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 51, token.getChannel(), token.getStartIndex(), token.getStopIndex());
            context.getParent().addChild(this.parser.createTerminalNode(context.getParent(), (Token)newToken));
        }
    }
}

