/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import io.trino.sql.SqlFormatter;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.Statement;
import java.util.function.Function;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.assertj.core.api.ThrowableTypeAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.intellij.lang.annotations.Language;

public class ParserAssert
extends RecursiveComparisonAssert<ParserAssert> {
    private static final StandardRepresentation NODE_REPRESENTATION = new StandardRepresentation(){

        public String toStringOf(Object object) {
            if (object instanceof Statement || object instanceof Expression || object instanceof RowPattern) {
                return SqlFormatter.formatSql((Node)((Node)object));
            }
            return super.toStringOf(object);
        }
    };

    public static AssertProvider<ParserAssert> type(String sql) {
        return ParserAssert.createAssertion(arg_0 -> ((SqlParser)new SqlParser()).createType(arg_0), sql);
    }

    public static AssertProvider<ParserAssert> expression(@Language(value="SQL") String sql) {
        return ParserAssert.createAssertion(ParserAssert::createExpression, sql);
    }

    public static AssertProvider<ParserAssert> statement(@Language(value="SQL") String sql) {
        return ParserAssert.createAssertion(ParserAssert::createStatement, sql);
    }

    public static AssertProvider<ParserAssert> rowPattern(String sql) {
        return ParserAssert.createAssertion(arg_0 -> ((SqlParser)new SqlParser()).createRowPattern(arg_0), sql);
    }

    private static Expression createExpression(String expression) {
        return new SqlParser().createExpression(expression, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL));
    }

    private static Statement createStatement(String statement) {
        return new SqlParser().createStatement(statement, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL));
    }

    public static ThrowableAssertAlternative<ParsingException> assertExpressionIsInvalid(@Language(value="SQL") String sql) {
        return ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(ParsingException.class).as("expression: %s", new Object[]{sql})).isThrownBy(() -> ParserAssert.createExpression(sql));
    }

    public static ThrowableAssertAlternative<ParsingException> assertStatementIsInvalid(@Language(value="SQL") String sql) {
        return ((ThrowableTypeAssert)Assertions.assertThatExceptionOfType(ParsingException.class).as("statement: %s", new Object[]{sql})).isThrownBy(() -> ParserAssert.createStatement(sql));
    }

    private ParserAssert(Node actual, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        super((Object)actual, recursiveComparisonConfiguration);
    }

    public ParserAssert ignoringLocation() {
        return (ParserAssert)this.ignoringFieldsMatchingRegexes(new String[]{"(.*\\.)?location"});
    }

    private static <T extends Node> AssertProvider<ParserAssert> createAssertion(Function<String, T> parser, String sql) {
        return () -> (ParserAssert)((ParserAssert)new ParserAssert((Node)parser.apply(sql), ParserAssert.newRecursiveComparisonConfig()).withRepresentation((Representation)NODE_REPRESENTATION)).satisfies(parsed -> ((ParserAssert)((ParserAssert)((Object)((Object)((Object)new ParserAssert((Node)parser.apply(SqlFormatter.formatSql((Node)((Node)parsed))), ParserAssert.newRecursiveComparisonConfig()).describedAs("Validate SQL->AST->SQL roundtrip", new Object[0]))))).withRepresentation((Representation)NODE_REPRESENTATION)).ignoringLocation().isEqualTo(parser.apply(sql)));
    }

    private static RecursiveComparisonConfiguration newRecursiveComparisonConfig() {
        RecursiveComparisonConfiguration config = new RecursiveComparisonConfiguration();
        config.ignoreAllOverriddenEquals();
        config.strictTypeChecking(true);
        return config;
    }
}

