/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.trino.sql.QueryUtil;
import io.trino.sql.SqlFormatter;
import io.trino.sql.parser.ParserAssert;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.parser.TreeNodes;
import io.trino.sql.testing.TreeAssertions;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.AllRows;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.AnchorPattern;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.CallArgument;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Cube;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.Descriptor;
import io.trino.sql.tree.DescriptorField;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.EmptyPattern;
import io.trino.sql.tree.EmptyTableTreatment;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainFormat;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantOnType;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.GrantorSpecification;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OneOrMoreQuantifier;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.PathElement;
import io.trino.sql.tree.PathSpecification;
import io.trino.sql.tree.PatternAlternation;
import io.trino.sql.tree.PatternConcatenation;
import io.trino.sql.tree.PatternQuantifier;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.PatternVariable;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.ProcessingMode;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.QuantifiedPattern;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.QueryPeriod;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.Rollup;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SetColumnType;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.TableFunctionArgument;
import io.trino.sql.tree.TableFunctionDescriptorArgument;
import io.trino.sql.tree.TableFunctionInvocation;
import io.trino.sql.tree.TableFunctionTableArgument;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.TimeLiteral;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowDefinition;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import io.trino.sql.tree.With;
import io.trino.sql.tree.WithQuery;
import io.trino.sql.tree.ZeroOrMoreQuantifier;
import io.trino.sql.tree.ZeroOrOneQuantifier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSqlParser {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void testPosition() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("position('a' in 'b')")))).isEqualTo(new FunctionCall(TreeNodes.location(1, 1), QualifiedName.of((String)"strpos"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 17), "b"), (Object)new StringLiteral(TreeNodes.location(1, 10), "a"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("position('a' in ('b'))")))).isEqualTo(new FunctionCall(TreeNodes.location(1, 1), QualifiedName.of((String)"strpos"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 18), "b"), (Object)new StringLiteral(TreeNodes.location(1, 10), "a"))));
    }

    @Test
    public void testPossibleExponentialBacktracking() {
        TestSqlParser.createExpression("(((((((((((((((((((((((((((true)))))))))))))))))))))))))))");
    }

    @Test
    @Timeout(value=2L, unit=TimeUnit.SECONDS)
    public void testPotentialUnboundedLookahead() {
        TestSqlParser.createExpression("(\n      1 * -1 +\n      1 * -2 +\n      1 * -3 +\n      1 * -4 +\n      1 * -5 +\n      1 * -6 +\n      1 * -7 +\n      1 * -8 +\n      1 * -9 +\n      1 * -10 +\n      1 * -11 +\n      1 * -12 \n)\n");
    }

    @Test
    public void testQualifiedName() {
        Assertions.assertThat((String)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).toString()).isEqualTo("a.b.c.d");
        Assertions.assertThat((String)QualifiedName.of((String)"A", (String[])new String[]{"b", "C", "d"}).toString()).isEqualTo("a.b.c.d");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"b", (String[])new String[]{"c", "d"})));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"})));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"a", (String[])new String[]{"c", "d"})));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"z", (String[])new String[]{"a", "b", "c", "d"})));
        Assertions.assertThat((Object)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"})).isEqualTo((Object)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}));
    }

    @Test
    public void testGenericLiteral() {
        TestSqlParser.assertGenericLiteral("VARCHAR");
        TestSqlParser.assertGenericLiteral("BIGINT");
        TestSqlParser.assertGenericLiteral("DOUBLE");
        TestSqlParser.assertGenericLiteral("BOOLEAN");
        TestSqlParser.assertGenericLiteral("DATE");
        TestSqlParser.assertGenericLiteral("foo");
    }

    private static void assertGenericLiteral(String type) {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(type + " 'abc'")))).isEqualTo(new GenericLiteral(new NodeLocation(1, 1), type, "abc"));
    }

    @Test
    public void testBinaryLiteral() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("x' '")))).isEqualTo(new BinaryLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("x''")))).isEqualTo(new BinaryLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("X'abcdef1234567890ABCDEF'")))).isEqualTo(new BinaryLiteral(location, "abcdef1234567890ABCDEF"));
        TestSqlParser.assertInvalidExpression("X 'a b'", "Spaces are not allowed.*");
        TestSqlParser.assertInvalidExpression("X'a b c'", "Binary literal must contain an even number of digits.*");
        TestSqlParser.assertInvalidExpression("X'a z'", "Binary literal can only contain hexadecimal digits.*");
    }

    @Test
    public void testLiterals() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("TIME 'abc'")))).isEqualTo(new TimeLiteral(location, "abc"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("TIMESTAMP 'abc'")))).isEqualTo(new TimestampLiteral(location, "abc"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '33' day")))).isEqualTo(new IntervalLiteral(location, "33", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '33' day to second")))).isEqualTo(new IntervalLiteral(location, "33", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.of(IntervalLiteral.IntervalField.SECOND)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("CHAR 'abc'")))).isEqualTo(new CharLiteral(location, "abc"));
    }

    @Test
    public void testNumbers() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("9223372036854775807")))).isEqualTo(new LongLiteral(location, "9223372036854775807"));
        TestSqlParser.assertInvalidExpression("9223372036854775808", "Invalid numeric literal: 9223372036854775808");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-9223372036854775808")))).isEqualTo(new LongLiteral(location, "-9223372036854775808"));
        TestSqlParser.assertInvalidExpression("-9223372036854775809", "Invalid numeric literal: -9223372036854775809");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1E5")))).isEqualTo(new DoubleLiteral(location, "1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1E-5")))).isEqualTo(new DoubleLiteral(location, "1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".1E5")))).isEqualTo(new DoubleLiteral(location, ".1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".1E-5")))).isEqualTo(new DoubleLiteral(location, ".1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1.1E5")))).isEqualTo(new DoubleLiteral(location, "1.1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1.1E-5")))).isEqualTo(new DoubleLiteral(location, "1.1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1E5")))).isEqualTo(new DoubleLiteral(location, "-1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1E-5")))).isEqualTo(new DoubleLiteral(location, "-1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-.1E5")))).isEqualTo(new DoubleLiteral(location, "-.1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-.1E-5")))).isEqualTo(new DoubleLiteral(location, "-.1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1.1E5")))).isEqualTo(new DoubleLiteral(location, "-1.1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1.1E-5")))).isEqualTo(new DoubleLiteral(location, "-1.1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".1")))).isEqualTo(new DecimalLiteral(location, ".1"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1.2")))).isEqualTo(new DecimalLiteral(location, "1.2"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1.2")))).isEqualTo(new DecimalLiteral(location, "-1.2"));
    }

    @Test
    public void testArray() {
        TestSqlParser.assertExpression("ARRAY []", (Expression)new Array((List)ImmutableList.of()));
        TestSqlParser.assertExpression("ARRAY [1, 2]", (Expression)new Array((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"))));
        TestSqlParser.assertExpression("ARRAY [1e0, 2.5e0]", (Expression)new Array((List)ImmutableList.of((Object)new DoubleLiteral("1.0"), (Object)new DoubleLiteral("2.5"))));
        TestSqlParser.assertExpression("ARRAY ['hi']", (Expression)new Array((List)ImmutableList.of((Object)new StringLiteral("hi"))));
        TestSqlParser.assertExpression("ARRAY ['hi', 'hello']", (Expression)new Array((List)ImmutableList.of((Object)new StringLiteral("hi"), (Object)new StringLiteral("hello"))));
    }

    @Test
    public void testArraySubscript() {
        TestSqlParser.assertExpression("ARRAY [1, 2][1]", (Expression)new SubscriptExpression((Expression)new Array((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"))), (Expression)new LongLiteral("1")));
        TestSqlParser.assertExpression("CASE WHEN TRUE THEN ARRAY[1,2] END[1]", (Expression)new SubscriptExpression((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new BooleanLiteral("true"), (Expression)new Array((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"))))), Optional.empty()), (Expression)new LongLiteral("1")));
    }

    @Test
    public void testRowSubscript() {
        TestSqlParser.assertExpression("ROW (1, 'a', true)[1]", (Expression)new SubscriptExpression((Expression)new Row((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("a"), (Object)new BooleanLiteral("true"))), (Expression)new LongLiteral("1")));
    }

    @Test
    public void testAllColumns() {
        TestSqlParser.assertStatement("SELECT * FROM t", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.empty(), (List)ImmutableList.of()))), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT r.* FROM t", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.of(new Identifier("r")), (List)ImmutableList.of()))), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT ROW (1, 'a', true).*", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.of(new Row((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("a"), (Object)new BooleanLiteral("true")))), (List)ImmutableList.of())))));
        TestSqlParser.assertStatement("SELECT ROW (1, 'a', true).* AS (f1, f2, f3)", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.of(new Row((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("a"), (Object)new BooleanLiteral("true")))), (List)ImmutableList.of((Object)new Identifier("f1"), (Object)new Identifier("f2"), (Object)new Identifier("f3")))))));
    }

    @Test
    public void testDouble() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123E7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.E7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.0E7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123E+7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123E-7")))).isEqualTo(new DoubleLiteral(location, "123E-7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.456E7")))).isEqualTo(new DoubleLiteral(location, "123.456E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.456E+7")))).isEqualTo(new DoubleLiteral(location, "123.456E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.456E-7")))).isEqualTo(new DoubleLiteral(location, "123.456E-7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".4E42")))).isEqualTo(new DoubleLiteral(location, ".4E42"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".4E+42")))).isEqualTo(new DoubleLiteral(location, ".4E42"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".4E-42")))).isEqualTo(new DoubleLiteral(location, ".4E-42"));
    }

    @Test
    public void testArithmeticUnary() {
        TestSqlParser.assertExpression("9", (Expression)new LongLiteral("9"));
        TestSqlParser.assertExpression("+9", (Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")));
        TestSqlParser.assertExpression("+ 9", (Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")));
        TestSqlParser.assertExpression("++9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9"))));
        TestSqlParser.assertExpression("+ +9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9"))));
        TestSqlParser.assertExpression("+ + 9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9"))));
        TestSqlParser.assertExpression("+++9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")))));
        TestSqlParser.assertExpression("+ + +9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")))));
        TestSqlParser.assertExpression("+ + + 9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")))));
        TestSqlParser.assertExpression("-9", (Expression)new LongLiteral("-9"));
        TestSqlParser.assertExpression("- 9", (Expression)new LongLiteral("-9"));
        TestSqlParser.assertExpression("- + 9", (Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9"))));
        TestSqlParser.assertExpression("-+9", (Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9"))));
        TestSqlParser.assertExpression("+ - + 9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")))));
        TestSqlParser.assertExpression("+-+9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")))));
        TestSqlParser.assertExpression("- -9", (Expression)ArithmeticUnaryExpression.negative((Expression)new LongLiteral("-9")));
        TestSqlParser.assertExpression("- - 9", (Expression)ArithmeticUnaryExpression.negative((Expression)new LongLiteral("-9")));
        TestSqlParser.assertExpression("- + - + 9", (Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9"))))));
        TestSqlParser.assertExpression("-+-+9", (Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9"))))));
        TestSqlParser.assertExpression("+ - + - + 9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")))))));
        TestSqlParser.assertExpression("+-+-+9", (Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.positive((Expression)new LongLiteral("9")))))));
        TestSqlParser.assertExpression("- - -9", (Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.negative((Expression)new LongLiteral("-9"))));
        TestSqlParser.assertExpression("- - - 9", (Expression)ArithmeticUnaryExpression.negative((Expression)ArithmeticUnaryExpression.negative((Expression)new LongLiteral("-9"))));
    }

    @Test
    public void testCoalesce() {
        TestSqlParser.assertInvalidExpression("coalesce()", "The 'coalesce' function must have at least two arguments");
        TestSqlParser.assertInvalidExpression("coalesce(5)", "The 'coalesce' function must have at least two arguments");
        TestSqlParser.assertInvalidExpression("coalesce(1, 2) filter (where true)", "FILTER not valid for 'coalesce' function");
        TestSqlParser.assertInvalidExpression("coalesce(1, 2) OVER ()", "OVER clause not valid for 'coalesce' function");
        TestSqlParser.assertExpression("coalesce(13, 42)", (Expression)new CoalesceExpression((Expression)new LongLiteral("13"), (Expression)new LongLiteral("42"), new Expression[0]));
        TestSqlParser.assertExpression("coalesce(6, 7, 8)", (Expression)new CoalesceExpression((Expression)new LongLiteral("6"), (Expression)new LongLiteral("7"), new Expression[]{new LongLiteral("8")}));
        TestSqlParser.assertExpression("coalesce(13, null)", (Expression)new CoalesceExpression((Expression)new LongLiteral("13"), (Expression)new NullLiteral(), new Expression[0]));
        TestSqlParser.assertExpression("coalesce(null, 13)", (Expression)new CoalesceExpression((Expression)new NullLiteral(), (Expression)new LongLiteral("13"), new Expression[0]));
        TestSqlParser.assertExpression("coalesce(null, null)", (Expression)new CoalesceExpression((Expression)new NullLiteral(), (Expression)new NullLiteral(), new Expression[0]));
    }

    @Test
    public void testIf() {
        TestSqlParser.assertExpression("if(true, 1, 0)", (Expression)new IfExpression((Expression)new BooleanLiteral("true"), (Expression)new LongLiteral("1"), (Expression)new LongLiteral("0")));
        TestSqlParser.assertExpression("if(true, 3, null)", (Expression)new IfExpression((Expression)new BooleanLiteral("true"), (Expression)new LongLiteral("3"), (Expression)new NullLiteral()));
        TestSqlParser.assertExpression("if(false, null, 4)", (Expression)new IfExpression((Expression)new BooleanLiteral("false"), (Expression)new NullLiteral(), (Expression)new LongLiteral("4")));
        TestSqlParser.assertExpression("if(false, null, null)", (Expression)new IfExpression((Expression)new BooleanLiteral("false"), (Expression)new NullLiteral(), (Expression)new NullLiteral()));
        TestSqlParser.assertExpression("if(true, 3)", (Expression)new IfExpression((Expression)new BooleanLiteral("true"), (Expression)new LongLiteral("3"), null));
        TestSqlParser.assertInvalidExpression("IF(true)", "Invalid number of arguments for 'if' function");
        TestSqlParser.assertInvalidExpression("IF(true, 1, 0) FILTER (WHERE true)", "FILTER not valid for 'if' function");
        TestSqlParser.assertInvalidExpression("IF(true, 1, 0) OVER()", "OVER clause not valid for 'if' function");
    }

    @Test
    public void testNullIf() {
        TestSqlParser.assertExpression("nullif(42, 87)", (Expression)new NullIfExpression((Expression)new LongLiteral("42"), (Expression)new LongLiteral("87")));
        TestSqlParser.assertExpression("nullif(42, null)", (Expression)new NullIfExpression((Expression)new LongLiteral("42"), (Expression)new NullLiteral()));
        TestSqlParser.assertExpression("nullif(null, null)", (Expression)new NullIfExpression((Expression)new NullLiteral(), (Expression)new NullLiteral()));
        TestSqlParser.assertInvalidExpression("nullif(1)", "Invalid number of arguments for 'nullif' function");
        TestSqlParser.assertInvalidExpression("nullif(1, 2, 3)", "Invalid number of arguments for 'nullif' function");
        TestSqlParser.assertInvalidExpression("nullif(42, 87) filter (where true)", "FILTER not valid for 'nullif' function");
        TestSqlParser.assertInvalidExpression("nullif(42, 87) OVER ()", "OVER clause not valid for 'nullif' function");
    }

    @Test
    public void testDoubleInQuery() {
        TestSqlParser.assertStatement("SELECT 123.456E7 FROM DUAL", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new DoubleLiteral("123.456E7")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"DUAL"))));
    }

    @Test
    public void testIntersect() {
        TestSqlParser.assertStatement("SELECT 123 INTERSECT DISTINCT SELECT 123 INTERSECT ALL SELECT 123", (Statement)QueryUtil.query((QueryBody)new Intersect((List)ImmutableList.of((Object)new Intersect((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true), (Object)TestSqlParser.createSelect123()), false)));
    }

    @Test
    public void testUnion() {
        TestSqlParser.assertStatement("SELECT 123 UNION DISTINCT SELECT 123 UNION ALL SELECT 123", (Statement)QueryUtil.query((QueryBody)new Union((List)ImmutableList.of((Object)new Union((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true), (Object)TestSqlParser.createSelect123()), false)));
    }

    private static QuerySpecification createSelect123() {
        return new QuerySpecification(QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("123")}), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Test
    public void testReservedWordIdentifier() {
        TestSqlParser.assertStatement("SELECT id FROM public.orders", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"id")}), (Relation)new Table(QualifiedName.of((String)"public", (String[])new String[]{"orders"}))));
        TestSqlParser.assertStatement("SELECT id FROM \"public\".\"order\"", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"id")}), (Relation)new Table(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("public", true), (Object)new Identifier("order", true))))));
        TestSqlParser.assertStatement("SELECT id FROM \"public\".\"order\"\"2\"", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"id")}), (Relation)new Table(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("public", true), (Object)new Identifier("order\"2", true))))));
    }

    @Test
    public void testBetween() {
        TestSqlParser.assertExpression("1 BETWEEN 2 AND 3", (Expression)new BetweenPredicate((Expression)new LongLiteral("1"), (Expression)new LongLiteral("2"), (Expression)new LongLiteral("3")));
        TestSqlParser.assertExpression("1 NOT BETWEEN 2 AND 3", (Expression)new NotExpression((Expression)new BetweenPredicate((Expression)new LongLiteral("1"), (Expression)new LongLiteral("2"), (Expression)new LongLiteral("3"))));
    }

    @Test
    public void testSelectWithLimit() {
        TestSqlParser.assertStatement("SELECT * FROM table1 LIMIT 2", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new LongLiteral("2")))));
        TestSqlParser.assertStatement("SELECT * FROM table1 LIMIT ALL", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new AllRows()))));
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new LongLiteral("1"), new StringLiteral("1")}), QueryUtil.row((Expression[])new Expression[]{new LongLiteral("2"), new StringLiteral("2")})}));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) LIMIT ALL", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new AllRows()))));
    }

    @Test
    public void testValues() {
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new StringLiteral("a"), new LongLiteral("1"), new DoubleLiteral("2.2")}), QueryUtil.row((Expression[])new Expression[]{new StringLiteral("b"), new LongLiteral("2"), new DoubleLiteral("3.3")})}));
        TestSqlParser.assertStatement("VALUES ('a', 1, 2.2e0), ('b', 2, 3.3e0)", (Statement)valuesQuery);
        TestSqlParser.assertStatement("SELECT * FROM (VALUES ('a', 1, 2.2e0), ('b', 2, 3.3e0))", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery)));
    }

    @Test
    public void testRowPattern() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("(A B)* | CC+? DD?? E | (F | G)")))).isEqualTo(new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternConcatenation(TreeNodes.location(1, 2), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 2), new Identifier(TreeNodes.location(1, 2), "A", false)), (Object)new PatternVariable(TreeNodes.location(1, 4), new Identifier(TreeNodes.location(1, 4), "B", false)))), (PatternQuantifier)new ZeroOrMoreQuantifier(TreeNodes.location(1, 6), true)), (Object)new PatternConcatenation(TreeNodes.location(1, 10), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(1, 10), (List)ImmutableList.of((Object)new QuantifiedPattern(TreeNodes.location(1, 10), (RowPattern)new PatternVariable(TreeNodes.location(1, 10), new Identifier(TreeNodes.location(1, 10), "CC", false)), (PatternQuantifier)new OneOrMoreQuantifier(TreeNodes.location(1, 12), false)), (Object)new QuantifiedPattern(TreeNodes.location(1, 15), (RowPattern)new PatternVariable(TreeNodes.location(1, 15), new Identifier(TreeNodes.location(1, 15), "DD", false)), (PatternQuantifier)new ZeroOrOneQuantifier(TreeNodes.location(1, 17), false)))), (Object)new PatternVariable(TreeNodes.location(1, 20), new Identifier(TreeNodes.location(1, 20), "E", false)))))), (Object)new PatternAlternation(TreeNodes.location(1, 25), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 25), new Identifier(TreeNodes.location(1, 25), "F", false)), (Object)new PatternVariable(TreeNodes.location(1, 29), new Identifier(TreeNodes.location(1, 29), "G", false)))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A | B | C D E F")))).isEqualTo(new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (Object)new PatternVariable(TreeNodes.location(1, 5), new Identifier(TreeNodes.location(1, 5), "B", false)))), (Object)new PatternConcatenation(TreeNodes.location(1, 9), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(1, 9), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(1, 9), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 9), new Identifier(TreeNodes.location(1, 9), "C", false)), (Object)new PatternVariable(TreeNodes.location(1, 11), new Identifier(TreeNodes.location(1, 11), "D", false)))), (Object)new PatternVariable(TreeNodes.location(1, 13), new Identifier(TreeNodes.location(1, 13), "E", false)))), (Object)new PatternVariable(TreeNodes.location(1, 15), new Identifier(TreeNodes.location(1, 15), "F", false)))))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createRowPattern("A!")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:2: mismatched input '!'.*");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createRowPattern("A**")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:3: mismatched input '*'.*");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A??")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new ZeroOrOneQuantifier(TreeNodes.location(1, 2), false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("^$")))).isEqualTo(new PatternConcatenation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new AnchorPattern(TreeNodes.location(1, 1), AnchorPattern.Type.PARTITION_START), (Object)new AnchorPattern(TreeNodes.location(1, 2), AnchorPattern.Type.PARTITION_END))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("()")))).isEqualTo(new EmptyPattern(TreeNodes.location(1, 1)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{3}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")), Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{3,}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")), Optional.empty())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{,3}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.empty(), Optional.of(new LongLiteral(TreeNodes.location(1, 4), "3")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{3,4}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")), Optional.of(new LongLiteral(TreeNodes.location(1, 5), "4")))));
    }

    @Test
    public void testPrecedenceAndAssociativity() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 AND 2 AND 3 AND 4")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LongLiteral(TreeNodes.location(1, 7), "2"), (Object)new LongLiteral(TreeNodes.location(1, 13), "3"), (Object)new LongLiteral(TreeNodes.location(1, 19), "4"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 OR 2 OR 3 OR 4")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LongLiteral(TreeNodes.location(1, 6), "2"), (Object)new LongLiteral(TreeNodes.location(1, 11), "3"), (Object)new LongLiteral(TreeNodes.location(1, 16), "4"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 AND 2 AND 3 OR 4 AND 5 AND 6 OR 7 AND 8 AND 9")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LongLiteral(TreeNodes.location(1, 7), "2"), (Object)new LongLiteral(TreeNodes.location(1, 13), "3"))), (Object)new LogicalExpression(TreeNodes.location(1, 18), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 18), "4"), (Object)new LongLiteral(TreeNodes.location(1, 24), "5"), (Object)new LongLiteral(TreeNodes.location(1, 30), "6"))), (Object)new LogicalExpression(TreeNodes.location(1, 35), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 35), "7"), (Object)new LongLiteral(TreeNodes.location(1, 41), "8"), (Object)new LongLiteral(TreeNodes.location(1, 47), "9"))))));
        TestSqlParser.assertExpression("1 AND 2 OR 3", (Expression)LogicalExpression.or((Expression)LogicalExpression.and((Expression)new LongLiteral("1"), (Expression)new LongLiteral("2")), (Expression)new LongLiteral("3")));
        TestSqlParser.assertExpression("1 OR 2 AND 3", (Expression)LogicalExpression.or((Expression)new LongLiteral("1"), (Expression)LogicalExpression.and((Expression)new LongLiteral("2"), (Expression)new LongLiteral("3"))));
        TestSqlParser.assertExpression("NOT 1 AND 2", (Expression)LogicalExpression.and((Expression)new NotExpression((Expression)new LongLiteral("1")), (Expression)new LongLiteral("2")));
        TestSqlParser.assertExpression("NOT 1 OR 2", (Expression)LogicalExpression.or((Expression)new NotExpression((Expression)new LongLiteral("1")), (Expression)new LongLiteral("2")));
        TestSqlParser.assertExpression("-1 + 2", (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral("-1"), (Expression)new LongLiteral("2")));
        TestSqlParser.assertExpression("1 - 2 - 3", (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new LongLiteral("1"), (Expression)new LongLiteral("2")), (Expression)new LongLiteral("3")));
        TestSqlParser.assertExpression("1 / 2 / 3", (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral("1"), (Expression)new LongLiteral("2")), (Expression)new LongLiteral("3")));
        TestSqlParser.assertExpression("1 + 2 * 3", (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral("1"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new LongLiteral("2"), (Expression)new LongLiteral("3"))));
    }

    @Test
    public void testInterval() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' YEAR")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.YEAR, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123-3' YEAR TO MONTH")))).isEqualTo(new IntervalLiteral(location, "123-3", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.YEAR, Optional.of(IntervalLiteral.IntervalField.MONTH)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' MONTH")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.MONTH, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' DAY")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123 23:58:53.456' DAY TO SECOND")))).isEqualTo(new IntervalLiteral(location, "123 23:58:53.456", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.of(IntervalLiteral.IntervalField.SECOND)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' HOUR")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '23:59' HOUR TO MINUTE")))).isEqualTo(new IntervalLiteral(location, "23:59", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.MINUTE)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' MINUTE")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.MINUTE, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' SECOND")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.SECOND, Optional.empty()));
    }

    @Test
    public void testDecimal() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '12.34'")))).isEqualTo(new DecimalLiteral(location, "12.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '12.'")))).isEqualTo(new DecimalLiteral(location, "12."));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '12'")))).isEqualTo(new DecimalLiteral(location, "12"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '.34'")))).isEqualTo(new DecimalLiteral(location, ".34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '+12.34'")))).isEqualTo(new DecimalLiteral(location, "+12.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '+12'")))).isEqualTo(new DecimalLiteral(location, "+12"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '-12.34'")))).isEqualTo(new DecimalLiteral(location, "-12.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '-12'")))).isEqualTo(new DecimalLiteral(location, "-12"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '+.34'")))).isEqualTo(new DecimalLiteral(location, "+.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '-.34'")))).isEqualTo(new DecimalLiteral(location, "-.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.")))).isEqualTo(new DecimalLiteral(location, "123."));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.0")))).isEqualTo(new DecimalLiteral(location, "123.0"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".5")))).isEqualTo(new DecimalLiteral(location, ".5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.5")))).isEqualTo(new DecimalLiteral(location, "123.5"));
        TestSqlParser.assertInvalidDecimalExpression("123.", "Unexpected decimal literal: 123.");
        TestSqlParser.assertInvalidDecimalExpression("123.0", "Unexpected decimal literal: 123.0");
        TestSqlParser.assertInvalidDecimalExpression(".5", "Unexpected decimal literal: .5");
        TestSqlParser.assertInvalidDecimalExpression("123.5", "Unexpected decimal literal: 123.5");
    }

    private static void assertInvalidDecimalExpression(String sql, String message) {
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression(sql, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.REJECT))).isInstanceOfSatisfying(ParsingException.class, e -> Assertions.assertThat((String)e.getErrorMessage()).isEqualTo(message));
    }

    @Test
    public void testTime() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("TIME '03:04:05'")))).isEqualTo(new TimeLiteral(location, "03:04:05"));
    }

    @Test
    public void testCurrentTimestamp() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("CURRENT_TIMESTAMP")))).isEqualTo(new CurrentTime(location, CurrentTime.Function.TIMESTAMP));
    }

    @Test
    public void testTrim() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(BOTH FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.BOTH, (Expression)new StringLiteral(TreeNodes.location(1, 16), " abc "), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(LEADING FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.LEADING, (Expression)new StringLiteral(TreeNodes.location(1, 19), " abc "), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(TRAILING FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.TRAILING, (Expression)new StringLiteral(TreeNodes.location(1, 20), " abc "), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(BOTH ' ' FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.BOTH, (Expression)new StringLiteral(TreeNodes.location(1, 20), " abc "), Optional.of(new StringLiteral(TreeNodes.location(1, 11), " "))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(LEADING ' ' FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.LEADING, (Expression)new StringLiteral(TreeNodes.location(1, 23), " abc "), Optional.of(new StringLiteral(TreeNodes.location(1, 14), " "))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(TRAILING ' ' FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.TRAILING, (Expression)new StringLiteral(TreeNodes.location(1, 24), " abc "), Optional.of(new StringLiteral(TreeNodes.location(1, 15), " "))));
        TestSqlParser.assertInvalidExpression("trim(FROM ' abc ')", "The 'trim' function must have specification, char or both arguments when it takes FROM");
    }

    @Test
    public void testFormat() {
        TestSqlParser.assertExpression("format('%s', 'abc')", (Expression)new Format((List)ImmutableList.of((Object)new StringLiteral("%s"), (Object)new StringLiteral("abc"))));
        TestSqlParser.assertExpression("format('%d %s', 123, 'x')", (Expression)new Format((List)ImmutableList.of((Object)new StringLiteral("%d %s"), (Object)new LongLiteral("123"), (Object)new StringLiteral("x"))));
        TestSqlParser.assertInvalidExpression("format()", "The 'format' function must have at least two arguments");
        TestSqlParser.assertInvalidExpression("format('%s')", "The 'format' function must have at least two arguments");
    }

    @Test
    public void testCase() {
        TestSqlParser.assertExpression("CASE 1 IS NULL WHEN true THEN 2 ELSE 3 END", (Expression)new SimpleCaseExpression((Expression)new IsNullPredicate((Expression)new LongLiteral("1")), (List)ImmutableList.of((Object)new WhenClause((Expression)new BooleanLiteral("true"), (Expression)new LongLiteral("2"))), Optional.of(new LongLiteral("3"))));
    }

    @Test
    public void testSearchedCase() {
        TestSqlParser.assertExpression("CASE WHEN a > 3 THEN 23 WHEN b = a THEN 33 END", (Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("a"), (Expression)new LongLiteral("3")), (Expression)new LongLiteral("23")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Identifier("b"), (Expression)new Identifier("a")), (Expression)new LongLiteral("33"))), Optional.empty()));
    }

    @Test
    public void testSetSession() {
        TestSqlParser.assertStatement("SET SESSION foo = 'bar'", (Statement)new SetSession(QualifiedName.of((String)"foo"), (Expression)new StringLiteral("bar")));
        TestSqlParser.assertStatement("SET SESSION foo.bar = 'baz'", (Statement)new SetSession(QualifiedName.of((String)"foo", (String[])new String[]{"bar"}), (Expression)new StringLiteral("baz")));
        TestSqlParser.assertStatement("SET SESSION foo.bar.boo = 'baz'", (Statement)new SetSession(QualifiedName.of((String)"foo", (String[])new String[]{"bar", "boo"}), (Expression)new StringLiteral("baz")));
        TestSqlParser.assertStatement("SET SESSION foo.bar = 'ban' || 'ana'", (Statement)new SetSession(QualifiedName.of((String)"foo", (String[])new String[]{"bar"}), (Expression)new FunctionCall(QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral("ban"), (Object)new StringLiteral("ana")))));
    }

    @Test
    public void testResetSession() {
        TestSqlParser.assertStatement("RESET SESSION foo.bar", (Statement)new ResetSession(QualifiedName.of((String)"foo", (String[])new String[]{"bar"})));
        TestSqlParser.assertStatement("RESET SESSION foo", (Statement)new ResetSession(QualifiedName.of((String)"foo")));
    }

    @Test
    public void testSessionIdentifiers() {
        TestSqlParser.assertStatement("SET SESSION \"foo-bar\".baz = 'x'", (Statement)new SetSession(QualifiedName.of((String)"foo-bar", (String[])new String[]{"baz"}), (Expression)new StringLiteral("x")));
        ParserAssert.assertStatementIsInvalid("SET SESSION foo-bar.name = 'value'").withMessage("line 1:16: mismatched input '-'. Expecting: '.', '='");
        TestSqlParser.assertStatement("RESET SESSION \"foo-bar\".baz", (Statement)new ResetSession(QualifiedName.of((String)"foo-bar", (String[])new String[]{"baz"})));
        ParserAssert.assertStatementIsInvalid("RESET SESSION foo-bar.name").withMessage("line 1:18: mismatched input '-'. Expecting: '.', <EOF>");
    }

    @Test
    public void testShowSession() {
        TestSqlParser.assertStatement("SHOW SESSION", (Statement)new ShowSession(Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW SESSION LIKE '%'", (Statement)new ShowSession(Optional.of("%"), Optional.empty()));
        TestSqlParser.assertStatement("SHOW SESSION LIKE '%' ESCAPE '$'", (Statement)new ShowSession(Optional.of("%"), Optional.of("$")));
    }

    @Test
    public void testShowCatalogs() {
        TestSqlParser.assertStatement("SHOW CATALOGS", (Statement)new ShowCatalogs(Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW CATALOGS LIKE '%'", (Statement)new ShowCatalogs(Optional.of("%"), Optional.empty()));
        TestSqlParser.assertStatement("SHOW CATALOGS LIKE '%$_%' ESCAPE '$'", (Statement)new ShowCatalogs(Optional.of("%$_%"), Optional.of("$")));
    }

    @Test
    public void testShowSchemas() {
        TestSqlParser.assertStatement("SHOW SCHEMAS", (Statement)new ShowSchemas(Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW SCHEMAS FROM foo", (Statement)new ShowSchemas(Optional.of(QueryUtil.identifier((String)"foo")), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW SCHEMAS IN foo LIKE '%'", (Statement)new ShowSchemas(Optional.of(QueryUtil.identifier((String)"foo")), Optional.of("%"), Optional.empty()));
        TestSqlParser.assertStatement("SHOW SCHEMAS IN foo LIKE '%$_%' ESCAPE '$'", (Statement)new ShowSchemas(Optional.of(QueryUtil.identifier((String)"foo")), Optional.of("%$_%"), Optional.of("$")));
    }

    @Test
    public void testShowTables() {
        TestSqlParser.assertStatement("SHOW TABLES", (Statement)new ShowTables(Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW TABLES FROM a", (Statement)new ShowTables(Optional.of(QualifiedName.of((String)"a")), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW TABLES FROM \"awesome schema\"", (Statement)new ShowTables(Optional.of(QualifiedName.of((String)"awesome schema")), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW TABLES IN a LIKE '%$_%' ESCAPE '$'", (Statement)new ShowTables(Optional.of(QualifiedName.of((String)"a")), Optional.of("%$_%"), Optional.of("$")));
    }

    @Test
    public void testShowColumns() {
        TestSqlParser.assertStatement("SHOW COLUMNS FROM a", (Statement)new ShowColumns(QualifiedName.of((String)"a"), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW COLUMNS FROM a.b", (Statement)new ShowColumns(QualifiedName.of((String)"a", (String[])new String[]{"b"}), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW COLUMNS FROM \"awesome table\"", (Statement)new ShowColumns(QualifiedName.of((String)"awesome table"), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW COLUMNS FROM \"awesome schema\".\"awesome table\"", (Statement)new ShowColumns(QualifiedName.of((String)"awesome schema", (String[])new String[]{"awesome table"}), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW COLUMNS FROM a.b LIKE '%$_%' ESCAPE '$'", (Statement)new ShowColumns(QualifiedName.of((String)"a", (String[])new String[]{"b"}), Optional.of("%$_%"), Optional.of("$")));
        ParserAssert.assertStatementIsInvalid("SHOW COLUMNS FROM a.b LIKE null").withMessage("line 1:28: mismatched input 'null'. Expecting: <string>");
        ParserAssert.assertStatementIsInvalid("SHOW COLUMNS FROM a.b LIKE 'a' ESCAPE null'").withMessage("line 1:39: mismatched input 'null'. Expecting: <string>");
    }

    @Test
    public void testShowFunctions() {
        TestSqlParser.assertStatement("SHOW FUNCTIONS", (Statement)new ShowFunctions(Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW FUNCTIONS LIKE '%'", (Statement)new ShowFunctions(Optional.of("%"), Optional.empty()));
        TestSqlParser.assertStatement("SHOW FUNCTIONS LIKE '%' ESCAPE '$'", (Statement)new ShowFunctions(Optional.of("%"), Optional.of("$")));
    }

    @Test
    public void testSubstringBuiltInFunction() {
        String givenString = "ABCDEF";
        TestSqlParser.assertStatement(String.format("SELECT substring('%s' FROM 2)", givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substr"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2")}))})));
        TestSqlParser.assertStatement(String.format("SELECT substring('%s' FROM 2 FOR 3)", givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substr"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2"), new LongLiteral("3")}))})));
    }

    @Test
    public void testSubstringRegisteredFunction() {
        String givenString = "ABCDEF";
        TestSqlParser.assertStatement(String.format("SELECT substring('%s', 2)", givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substring"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2")}))})));
        TestSqlParser.assertStatement(String.format("SELECT substring('%s', 2, 3)", givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substring"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2"), new LongLiteral("3")}))})));
    }

    @Test
    public void testSelectWithRowType() {
        TestSqlParser.assertStatement("SELECT col1.f1, col2, col3.f1.f2.f3 FROM table1", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new DereferenceExpression((Expression)new Identifier("col1"), QueryUtil.identifier((String)"f1")), new Identifier("col2"), new DereferenceExpression((Expression)new DereferenceExpression((Expression)new DereferenceExpression((Expression)new Identifier("col3"), QueryUtil.identifier((String)"f1")), QueryUtil.identifier((String)"f2")), QueryUtil.identifier((String)"f3"))}), (Relation)new Table(QualifiedName.of((String)"table1"))));
        TestSqlParser.assertStatement("SELECT col1.f1[0], col2, col3[2].f2.f3, col4[4] FROM table1", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new SubscriptExpression((Expression)new DereferenceExpression((Expression)new Identifier("col1"), QueryUtil.identifier((String)"f1")), (Expression)new LongLiteral("0")), new Identifier("col2"), new DereferenceExpression((Expression)new DereferenceExpression((Expression)new SubscriptExpression((Expression)new Identifier("col3"), (Expression)new LongLiteral("2")), QueryUtil.identifier((String)"f2")), QueryUtil.identifier((String)"f3")), new SubscriptExpression((Expression)new Identifier("col4"), (Expression)new LongLiteral("4"))}), (Relation)new Table(QualifiedName.of((String)"table1"))));
        TestSqlParser.assertStatement("SELECT CAST(ROW(11, 12) AS ROW(COL0 INTEGER, COL1 INTEGER)).col0", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new DereferenceExpression((Expression)new Cast((Expression)new Row((List)Lists.newArrayList((Object[])new Expression[]{new LongLiteral("11"), new LongLiteral("12")})), (DataType)TreeNodes.rowType(TreeNodes.location(1, 26), TreeNodes.field(TreeNodes.location(1, 30), "COL0", TreeNodes.simpleType(TreeNodes.location(1, 35), "INTEGER")), TreeNodes.field(TreeNodes.location(1, 44), "COL1", TreeNodes.simpleType(TreeNodes.location(1, 49), "INTEGER")))), QueryUtil.identifier((String)"col0"))})));
    }

    @Test
    public void testSelectWithOrderBy() {
        TestSqlParser.assertStatement("SELECT * FROM table1 ORDER BY a", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"a")})));
    }

    @Test
    public void testSelectWithOffset() {
        TestSqlParser.assertStatement("SELECT * FROM table1 OFFSET 2 ROWS", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 OFFSET 2", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new LongLiteral("1"), new StringLiteral("1")}), QueryUtil.row((Expression[])new Expression[]{new LongLiteral("2"), new StringLiteral("2")})}));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) OFFSET 2 ROWS", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) OFFSET 2", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
    }

    @Test
    public void testSelectWithFetch() {
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH FIRST 2 ROWS ONLY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new LongLiteral("2")))));
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH NEXT ROW ONLY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty()))));
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new LongLiteral("1"), new StringLiteral("1")}), QueryUtil.row((Expression[])new Expression[]{new LongLiteral("2"), new StringLiteral("2")})}));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) FETCH FIRST ROW ONLY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty()))));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) FETCH FIRST ROW WITH TIES", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty(), true))));
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH FIRST 2 ROWS WITH TIES", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new LongLiteral("2"), true))));
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH NEXT ROW WITH TIES", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty(), true))));
    }

    @Test
    public void testSelectWithGroupBy() {
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY a", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier("a")))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY a, b", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier("a"))), (Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier("b")))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY ()", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of())))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY GROUPING SETS (a)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new GroupingSets((List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a"))))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT a, b, GROUPING(a, b) FROM table1 GROUP BY GROUPING SETS ((a), (b))", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{DereferenceExpression.from((QualifiedName)QualifiedName.of((String)"a")), DereferenceExpression.from((QualifiedName)QualifiedName.of((String)"b")), new GroupingOperation(Optional.empty(), (List)ImmutableList.of((Object)QualifiedName.of((String)"a"), (Object)QualifiedName.of((String)"b")))}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new GroupingSets((List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a")), (Object)ImmutableList.of((Object)new Identifier("b"))))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY ALL GROUPING SETS ((a, b), (a), ()), CUBE (c), ROLLUP (d)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new GroupingSets((List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a"), (Object)new Identifier("b")), (Object)ImmutableList.of((Object)new Identifier("a")), (Object)ImmutableList.of())), (Object)new Cube((List)ImmutableList.of((Object)new Identifier("c"))), (Object)new Rollup((List)ImmutableList.of((Object)new Identifier("d")))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY DISTINCT GROUPING SETS ((a, b), (a), ()), CUBE (c), ROLLUP (d)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(true, (List)ImmutableList.of((Object)new GroupingSets((List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a"), (Object)new Identifier("b")), (Object)ImmutableList.of((Object)new Identifier("a")), (Object)ImmutableList.of())), (Object)new Cube((List)ImmutableList.of((Object)new Identifier("c"))), (Object)new Rollup((List)ImmutableList.of((Object)new Identifier("d")))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testCreateSchema() {
        TestSqlParser.assertStatement("CREATE SCHEMA test", (Statement)new CreateSchema(QualifiedName.of((String)"test"), false, (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE SCHEMA IF NOT EXISTS test", (Statement)new CreateSchema(QualifiedName.of((String)"test"), true, (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE SCHEMA test WITH (a = 'apple', b = 123)", (Statement)new CreateSchema(QualifiedName.of((String)"test"), false, (List)ImmutableList.of((Object)new Property(new Identifier("a"), (Expression)new StringLiteral("apple")), (Object)new Property(new Identifier("b"), (Expression)new LongLiteral("123")))));
        TestSqlParser.assertStatement("CREATE SCHEMA \"some name that contains space\"", (Statement)new CreateSchema(QualifiedName.of((String)"some name that contains space"), false, (List)ImmutableList.of()));
    }

    @Test
    public void testDropSchema() {
        TestSqlParser.assertStatement("DROP SCHEMA test", (Statement)new DropSchema(QualifiedName.of((String)"test"), false, false));
        TestSqlParser.assertStatement("DROP SCHEMA test CASCADE", (Statement)new DropSchema(QualifiedName.of((String)"test"), false, true));
        TestSqlParser.assertStatement("DROP SCHEMA IF EXISTS test", (Statement)new DropSchema(QualifiedName.of((String)"test"), true, false));
        TestSqlParser.assertStatement("DROP SCHEMA IF EXISTS test RESTRICT", (Statement)new DropSchema(QualifiedName.of((String)"test"), true, false));
        TestSqlParser.assertStatement("DROP SCHEMA \"some schema that contains space\"", (Statement)new DropSchema(QualifiedName.of((String)"some schema that contains space"), false, false));
    }

    @Test
    public void testRenameSchema() {
        TestSqlParser.assertStatement("ALTER SCHEMA foo RENAME TO bar", (Statement)new RenameSchema(QualifiedName.of((String)"foo"), QueryUtil.identifier((String)"bar")));
        TestSqlParser.assertStatement("ALTER SCHEMA foo.bar RENAME TO baz", (Statement)new RenameSchema(QualifiedName.of((String)"foo", (String[])new String[]{"bar"}), QueryUtil.identifier((String)"baz")));
        TestSqlParser.assertStatement("ALTER SCHEMA \"awesome schema\".\"awesome table\" RENAME TO \"even more awesome table\"", (Statement)new RenameSchema(QualifiedName.of((String)"awesome schema", (String[])new String[]{"awesome table"}), QueryUtil.quotedIdentifier((String)"even more awesome table")));
    }

    @Test
    public void testUnicodeString() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&''")))).isEqualTo(new StringLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'' UESCAPE ')'")))).isEqualTo(new StringLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801'")))).isEqualTo(new StringLiteral(location, "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'\u6d4b\u8bd5ABC\\6d4B\\8Bd5'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\u6d4b\u8bd5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5ABC\\6d4B\\8Bd5'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\u6d4b\u8bd5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5ABC\\\\'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\\"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5ABC###8Bd5' UESCAPE '#'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC#\u8bd5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5''A''B''C##''''#8Bd5' UESCAPE '#'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5'A'B'C#''\u8bd5"));
        TestSqlParser.assertInvalidExpression("U&  '\u6d4b\u8bd5ABC\\\\'", ".*mismatched input.*");
        TestSqlParser.assertInvalidExpression("u&'\u6d4b\u8bd5ABC\\'", "Incomplete escape sequence: ");
        TestSqlParser.assertInvalidExpression("u&'\u6d4b\u8bd5ABC\\+'", "Incomplete escape sequence: ");
        TestSqlParser.assertInvalidExpression("U&'hello\\6dB\\8Bd5'", "Incomplete escape sequence: 6dB.*");
        TestSqlParser.assertInvalidExpression("U&'hello\\6D4B\\8Bd'", "Incomplete escape sequence: 8Bd");
        TestSqlParser.assertInvalidExpression("U&'hello\\K6B\\8Bd5'", "Invalid hexadecimal digit: K");
        TestSqlParser.assertInvalidExpression("U&'hello\\+FFFFFD\\8Bd5'", "Invalid escaped character: FFFFFD");
        TestSqlParser.assertInvalidExpression("U&'hello\\DBFF'", "Invalid escaped character: DBFF\\. Escaped character is a surrogate\\. Use '\\\\\\+123456' instead\\.");
        TestSqlParser.assertInvalidExpression("U&'hello\\+00DBFF'", "Invalid escaped character: 00DBFF\\. Escaped character is a surrogate\\. Use '\\\\\\+123456' instead\\.");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '%%'", "Invalid Unicode escape character: %%");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '\udbff'", "Invalid Unicode escape character: \udbff");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '\n'", "Invalid Unicode escape character: \n");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE ''''", "Invalid Unicode escape character: '");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE ' '", "Invalid Unicode escape character:  ");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE ''", "Empty Unicode escape character");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '1'", "Invalid Unicode escape character: 1");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '+'", "Invalid Unicode escape character: \\+");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'hello!6d4B!8Bd5!+10FFFFworld!7F16!7801' UESCAPE '!'")))).isEqualTo(new StringLiteral(location, "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'\u6d4b\u8bd5ABC!6d4B!8Bd5' UESCAPE '!'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\u6d4b\u8bd5"));
        TestSqlParser.assertExpression("U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' UESCAPE '!'", (Expression)new StringLiteral("hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801"));
    }

    @Test
    public void testCreateTable() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo (a VARCHAR, b BIGINT COMMENT 'hello world', c IPADDRESS)")))).isEqualTo(new CreateTable(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), (List)ImmutableList.of((Object)TreeNodes.columnDefinition(TreeNodes.location(1, 19), "a", TreeNodes.simpleType(TreeNodes.location(1, 21), "VARCHAR")), (Object)TreeNodes.columnDefinition(TreeNodes.location(1, 30), "b", TreeNodes.simpleType(TreeNodes.location(1, 32), "BIGINT"), true, "hello world"), (Object)TreeNodes.columnDefinition(TreeNodes.location(1, 62), "c", TreeNodes.simpleType(TreeNodes.location(1, 64), "IPADDRESS"))), false, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c TIMESTAMP)")))).isEqualTo(new CreateTable(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 28), "bar"), (List)ImmutableList.of((Object)TreeNodes.columnDefinition(TreeNodes.location(1, 33), "c", (DataType)TreeNodes.dateTimeType(TreeNodes.location(1, 35), DateTimeDataType.Type.TIMESTAMP, false), true)), true, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR WITH (nullable = true, compression = 'LZ4'))")))).describedAs("CREATE TABLE with column properties", new Object[0]))).isEqualTo(new CreateTable(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 28), "bar"), (List)ImmutableList.of((Object)TreeNodes.columnDefinition(TreeNodes.location(1, 33), "c", TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, (List<Property>)ImmutableList.of((Object)TreeNodes.property(TreeNodes.location(1, 49), "nullable", (Expression)new BooleanLiteral(TreeNodes.location(1, 60), "true")), (Object)TreeNodes.property(TreeNodes.location(1, 66), "compression", (Expression)new StringLiteral(TreeNodes.location(1, 80), "LZ4"))))), true, (List)ImmutableList.of(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE IF NOT EXISTS bar (LIKE like_table)", (Statement)new CreateTable(QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.empty())), true, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table)")))).ignoringLocation().isEqualTo(new CreateTable(QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.empty())), true, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table, d BIGINT)")))).ignoringLocation().isEqualTo(new CreateTable(QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 63), "BIGINT"), true, Collections.emptyList(), Optional.empty())), true, (List)ImmutableList.of(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE IF NOT EXISTS bar (LIKE like_table INCLUDING PROPERTIES)", (Statement)new CreateTable(QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.of(LikeClause.PropertiesOption.INCLUDING))), true, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table EXCLUDING PROPERTIES)")))).ignoringLocation().isEqualTo(new CreateTable(QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.of(LikeClause.PropertiesOption.EXCLUDING))), true, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table EXCLUDING PROPERTIES) COMMENT 'test'")))).ignoringLocation().isEqualTo(new CreateTable(QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.of(LikeClause.PropertiesOption.EXCLUDING))), true, (List)ImmutableList.of(), Optional.of("test")));
    }

    @Test
    public void testCreateTableWithNotNull() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo (a VARCHAR NOT NULL COMMENT 'column a', b BIGINT COMMENT 'hello world', c IPADDRESS, d INTEGER NOT NULL)")))).ignoringLocation().isEqualTo(new CreateTable(QualifiedName.of((String)"foo"), (List)ImmutableList.of((Object)new ColumnDefinition(QueryUtil.identifier((String)"a"), TreeNodes.simpleType(TreeNodes.location(1, 20), "VARCHAR"), false, Collections.emptyList(), Optional.of("column a")), (Object)new ColumnDefinition(QueryUtil.identifier((String)"b"), TreeNodes.simpleType(TreeNodes.location(1, 59), "BIGINT"), true, Collections.emptyList(), Optional.of("hello world")), (Object)new ColumnDefinition(QueryUtil.identifier((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 91), "IPADDRESS"), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QueryUtil.identifier((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 104), "INTEGER"), false, Collections.emptyList(), Optional.empty())), false, (List)ImmutableList.of(), Optional.empty()));
    }

    @Test
    public void testCreateTableAsSelect() {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
        Query querySelectColumn = QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("a")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
        Query querySelectColumns = QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("a"), new Identifier("b")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
        QualifiedName table = QualifiedName.of((String)"foo");
        TestSqlParser.assertStatement("CREATE TABLE foo AS SELECT * FROM t", (Statement)new CreateTableAsSelect(table, query, false, (List)ImmutableList.of(), true, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x) AS SELECT a FROM t", (Statement)new CreateTableAsSelect(table, querySelectColumn, false, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier("x"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x,y) AS SELECT a,b FROM t", (Statement)new CreateTableAsSelect(table, querySelectColumns, false, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE IF NOT EXISTS foo AS SELECT * FROM t", (Statement)new CreateTableAsSelect(table, query, true, (List)ImmutableList.of(), true, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE IF NOT EXISTS foo(x) AS SELECT a FROM t", (Statement)new CreateTableAsSelect(table, querySelectColumn, true, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier("x"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE IF NOT EXISTS foo(x,y) AS SELECT a,b FROM t", (Statement)new CreateTableAsSelect(table, querySelectColumns, true, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo AS SELECT * FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, query, false, (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x) AS SELECT a FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, querySelectColumn, false, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier("x"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x,y) AS SELECT a,b FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, querySelectColumns, false, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y"))), Optional.empty()));
        ImmutableList properties = ImmutableList.of((Object)new Property(new Identifier("string"), (Expression)new StringLiteral("bar")), (Object)new Property(new Identifier("long"), (Expression)new LongLiteral("42")), (Object)new Property(new Identifier("computed"), (Expression)new FunctionCall(QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral("ban"), (Object)new StringLiteral("ana")))), (Object)new Property(new Identifier("a"), (Expression)new Array((List)ImmutableList.of((Object)new StringLiteral("v1"), (Object)new StringLiteral("v2")))));
        TestSqlParser.assertStatement("CREATE TABLE foo WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT * FROM t", (Statement)new CreateTableAsSelect(table, query, false, (List)properties, true, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x) WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT a FROM t", (Statement)new CreateTableAsSelect(table, querySelectColumn, false, (List)properties, true, Optional.of(ImmutableList.of((Object)new Identifier("x"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x,y) WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT a,b FROM t", (Statement)new CreateTableAsSelect(table, querySelectColumns, false, (List)properties, true, Optional.of(ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT * FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, query, false, (List)properties, false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x) WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT a FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, querySelectColumn, false, (List)properties, false, Optional.of(ImmutableList.of((Object)new Identifier("x"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo(x,y) WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT a,b FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, querySelectColumns, false, (List)properties, false, Optional.of(ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y"))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE foo COMMENT 'test'WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT * FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, query, false, (List)properties, false, Optional.empty(), Optional.of("test")));
        TestSqlParser.assertStatement("CREATE TABLE foo(x) COMMENT 'test'WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT a FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, querySelectColumn, false, (List)properties, false, Optional.of(ImmutableList.of((Object)new Identifier("x"))), Optional.of("test")));
        TestSqlParser.assertStatement("CREATE TABLE foo(x,y) COMMENT 'test'WITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] ) AS SELECT a,b FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, querySelectColumns, false, (List)properties, false, Optional.of(ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y"))), Optional.of("test")));
        TestSqlParser.assertStatement("CREATE TABLE foo(x,y) COMMENT 'test'WITH ( \"string\" = 'bar', \"long\" = 42, computed = 'ban' || 'ana', a = ARRAY[ 'v1', 'v2' ] ) AS SELECT a,b FROM t WITH NO DATA", (Statement)new CreateTableAsSelect(table, querySelectColumns, false, (List)properties, false, Optional.of(ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y"))), Optional.of("test")));
    }

    @Test
    public void testCreateTableAsWith() {
        String queryParenthesizedWith = "CREATE TABLE foo AS ( WITH t(x) AS (VALUES 1) TABLE t ) WITH NO DATA";
        String queryUnparenthesizedWith = "CREATE TABLE foo AS WITH t(x) AS (VALUES 1) TABLE t WITH NO DATA";
        String queryParenthesizedWithHasAlias = "CREATE TABLE foo(a) AS ( WITH t(x) AS (VALUES 1) TABLE t ) WITH NO DATA";
        String queryUnparenthesizedWithHasAlias = "CREATE TABLE foo(a) AS WITH t(x) AS (VALUES 1) TABLE t WITH NO DATA";
        QualifiedName table = QualifiedName.of((String)"foo");
        Query query = new Query(Optional.of(new With(false, (List)ImmutableList.of((Object)new WithQuery(QueryUtil.identifier((String)"t"), QueryUtil.query((QueryBody)new Values((List)ImmutableList.of((Object)new LongLiteral("1")))), Optional.of(ImmutableList.of((Object)QueryUtil.identifier((String)"x"))))))), (QueryBody)new Table(QualifiedName.of((String)"t")), Optional.empty(), Optional.empty(), Optional.empty());
        TestSqlParser.assertStatement(queryParenthesizedWith, (Statement)new CreateTableAsSelect(table, query, false, (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement(queryUnparenthesizedWith, (Statement)new CreateTableAsSelect(table, query, false, (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement(queryParenthesizedWithHasAlias, (Statement)new CreateTableAsSelect(table, query, false, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier("a"))), Optional.empty()));
        TestSqlParser.assertStatement(queryUnparenthesizedWithHasAlias, (Statement)new CreateTableAsSelect(table, query, false, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier("a"))), Optional.empty()));
    }

    @Test
    public void testDropTable() {
        TestSqlParser.assertStatement("DROP TABLE a", (Statement)new DropTable(QualifiedName.of((String)"a"), false));
        TestSqlParser.assertStatement("DROP TABLE a.b", (Statement)new DropTable(QualifiedName.of((String)"a", (String[])new String[]{"b"}), false));
        TestSqlParser.assertStatement("DROP TABLE a.b.c", (Statement)new DropTable(QualifiedName.of((String)"a", (String[])new String[]{"b", "c"}), false));
        TestSqlParser.assertStatement("DROP TABLE a.\"b/y\".c", (Statement)new DropTable(QualifiedName.of((String)"a", (String[])new String[]{"b/y", "c"}), false));
        TestSqlParser.assertStatement("DROP TABLE IF EXISTS a", (Statement)new DropTable(QualifiedName.of((String)"a"), true));
        TestSqlParser.assertStatement("DROP TABLE IF EXISTS a.b", (Statement)new DropTable(QualifiedName.of((String)"a", (String[])new String[]{"b"}), true));
        TestSqlParser.assertStatement("DROP TABLE IF EXISTS a.b.c", (Statement)new DropTable(QualifiedName.of((String)"a", (String[])new String[]{"b", "c"}), true));
        TestSqlParser.assertStatement("DROP TABLE IF EXISTS a.\"b/y\".c", (Statement)new DropTable(QualifiedName.of((String)"a", (String[])new String[]{"b/y", "c"}), true));
    }

    @Test
    public void testTruncateTable() throws Exception {
        TestSqlParser.assertStatement("TRUNCATE TABLE a", (Statement)new TruncateTable(QualifiedName.of((String)"a")));
        TestSqlParser.assertStatement("TRUNCATE TABLE a.b", (Statement)new TruncateTable(QualifiedName.of((String)"a", (String[])new String[]{"b"})));
        TestSqlParser.assertStatement("TRUNCATE TABLE a.b.c", (Statement)new TruncateTable(QualifiedName.of((String)"a", (String[])new String[]{"b", "c"})));
    }

    @Test
    public void testDropView() {
        TestSqlParser.assertStatement("DROP VIEW a", (Statement)new DropView(QualifiedName.of((String)"a"), false));
        TestSqlParser.assertStatement("DROP VIEW a.b", (Statement)new DropView(QualifiedName.of((String)"a", (String[])new String[]{"b"}), false));
        TestSqlParser.assertStatement("DROP VIEW a.b.c", (Statement)new DropView(QualifiedName.of((String)"a", (String[])new String[]{"b", "c"}), false));
        TestSqlParser.assertStatement("DROP VIEW IF EXISTS a", (Statement)new DropView(QualifiedName.of((String)"a"), true));
        TestSqlParser.assertStatement("DROP VIEW IF EXISTS a.b", (Statement)new DropView(QualifiedName.of((String)"a", (String[])new String[]{"b"}), true));
        TestSqlParser.assertStatement("DROP VIEW IF EXISTS a.b.c", (Statement)new DropView(QualifiedName.of((String)"a", (String[])new String[]{"b", "c"}), true));
    }

    @Test
    public void testInsertInto() {
        Table table = new Table(QualifiedName.of((String)"a", (String[])new String[]{"b/c", "d"}));
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
        TestSqlParser.assertStatement("INSERT INTO a.\"b/c\".d SELECT * FROM t", (Statement)new Insert(table, Optional.empty(), query));
        TestSqlParser.assertStatement("INSERT INTO a.\"b/c\".d (c1, c2) SELECT * FROM t", (Statement)new Insert(table, Optional.of(ImmutableList.of((Object)QueryUtil.identifier((String)"c1"), (Object)QueryUtil.identifier((String)"c2"))), query));
    }

    @Test
    public void testDelete() {
        TestSqlParser.assertStatement("DELETE FROM t", (Statement)new Delete(QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")), Optional.empty()));
        TestSqlParser.assertStatement("DELETE FROM \"awesome table\"", (Statement)new Delete(QueryUtil.table((QualifiedName)QualifiedName.of((String)"awesome table")), Optional.empty()));
        TestSqlParser.assertStatement("DELETE FROM t WHERE a = b", (Statement)new Delete(QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Identifier("a"), (Expression)new Identifier("b")))));
    }

    @Test
    public void testMerge() {
        NodeLocation location = new NodeLocation(1, 1);
        TestSqlParser.assertStatement("MERGE INTO inventory AS i   USING changes AS c   ON i.part = c.part WHEN MATCHED AND c.action = 'mod'   THEN UPDATE SET     qty = qty + c.qty   , ts = CURRENT_TIMESTAMP WHEN MATCHED AND c.action = 'del'   THEN DELETE WHEN NOT MATCHED AND c.action = 'new'   THEN INSERT (part, qty) VALUES (c.part, c.qty)", (Statement)new Merge(location, (Relation)new AliasedRelation(location, (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"inventory")), new Identifier("i"), null), QueryUtil.aliased((Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"changes")), (String)"c"), QueryUtil.equal((Expression)QueryUtil.nameReference((String)"i", (String[])new String[]{"part"}), (Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"part"})), (List)ImmutableList.of((Object)new MergeUpdate(Optional.of(QueryUtil.equal((Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"action"}), (Expression)new StringLiteral("mod"))), (List)ImmutableList.of((Object)new MergeUpdate.Assignment(new Identifier("qty"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, QueryUtil.nameReference((String)"qty", (String[])new String[0]), QueryUtil.nameReference((String)"c", (String[])new String[]{"qty"}))), (Object)new MergeUpdate.Assignment(new Identifier("ts"), (Expression)new CurrentTime(CurrentTime.Function.TIMESTAMP)))), (Object)new MergeDelete(Optional.of(QueryUtil.equal((Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"action"}), (Expression)new StringLiteral("del")))), (Object)new MergeInsert(Optional.of(QueryUtil.equal((Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"action"}), (Expression)new StringLiteral("new"))), (List)ImmutableList.of((Object)new Identifier("part"), (Object)new Identifier("qty")), (List)ImmutableList.of((Object)QueryUtil.nameReference((String)"c", (String[])new String[]{"part"}), (Object)QueryUtil.nameReference((String)"c", (String[])new String[]{"qty"}))))));
    }

    @Test
    public void testRenameTable() {
        TestSqlParser.assertStatement("ALTER TABLE a RENAME TO b", (Statement)new RenameTable(QualifiedName.of((String)"a"), QualifiedName.of((String)"b"), false));
        TestSqlParser.assertStatement("ALTER TABLE IF EXISTS a RENAME TO b", (Statement)new RenameTable(QualifiedName.of((String)"a"), QualifiedName.of((String)"b"), true));
    }

    @Test
    public void testSetTableProperties() {
        TestSqlParser.assertStatement("ALTER TABLE a SET PROPERTIES foo='bar'", (Statement)new SetProperties(SetProperties.Type.TABLE, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new StringLiteral("bar")))));
        TestSqlParser.assertStatement("ALTER TABLE a SET PROPERTIES foo=true", (Statement)new SetProperties(SetProperties.Type.TABLE, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new BooleanLiteral("true")))));
        TestSqlParser.assertStatement("ALTER TABLE a SET PROPERTIES foo=123", (Statement)new SetProperties(SetProperties.Type.TABLE, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new LongLiteral("123")))));
        TestSqlParser.assertStatement("ALTER TABLE a SET PROPERTIES foo=123, bar=456", (Statement)new SetProperties(SetProperties.Type.TABLE, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new LongLiteral("123")), (Object)new Property(new Identifier("bar"), (Expression)new LongLiteral("456")))));
        TestSqlParser.assertStatement("ALTER TABLE a SET PROPERTIES \" s p a c e \"='bar'", (Statement)new SetProperties(SetProperties.Type.TABLE, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier(" s p a c e "), (Expression)new StringLiteral("bar")))));
        TestSqlParser.assertStatement("ALTER TABLE a SET PROPERTIES foo=123, bar=DEFAULT", (Statement)new SetProperties(SetProperties.Type.TABLE, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new LongLiteral("123")), (Object)new Property(new Identifier("bar")))));
        ParserAssert.assertStatementIsInvalid("ALTER TABLE a SET PROPERTIES").withMessage("line 1:29: mismatched input '<EOF>'. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER TABLE a SET PROPERTIES ()").withMessage("line 1:30: mismatched input '('. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER TABLE a SET PROPERTIES (foo='bar')").withMessage("line 1:30: mismatched input '('. Expecting: <identifier>");
    }

    @Test
    public void testCommentTable() {
        TestSqlParser.assertStatement("COMMENT ON TABLE a IS 'test'", (Statement)new Comment(Comment.Type.TABLE, QualifiedName.of((String)"a"), Optional.of("test")));
        TestSqlParser.assertStatement("COMMENT ON TABLE a IS ''", (Statement)new Comment(Comment.Type.TABLE, QualifiedName.of((String)"a"), Optional.of("")));
        TestSqlParser.assertStatement("COMMENT ON TABLE a IS NULL", (Statement)new Comment(Comment.Type.TABLE, QualifiedName.of((String)"a"), Optional.empty()));
    }

    @Test
    public void testCommentView() {
        TestSqlParser.assertStatement("COMMENT ON VIEW a IS 'test'", (Statement)new Comment(Comment.Type.VIEW, QualifiedName.of((String)"a"), Optional.of("test")));
        TestSqlParser.assertStatement("COMMENT ON VIEW a IS ''", (Statement)new Comment(Comment.Type.VIEW, QualifiedName.of((String)"a"), Optional.of("")));
        TestSqlParser.assertStatement("COMMENT ON VIEW a IS NULL", (Statement)new Comment(Comment.Type.VIEW, QualifiedName.of((String)"a"), Optional.empty()));
    }

    @Test
    public void testCommentColumn() {
        TestSqlParser.assertStatement("COMMENT ON COLUMN a.b IS 'test'", (Statement)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"a", (String[])new String[]{"b"}), Optional.of("test")));
        TestSqlParser.assertStatement("COMMENT ON COLUMN a.b IS ''", (Statement)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"a", (String[])new String[]{"b"}), Optional.of("")));
        TestSqlParser.assertStatement("COMMENT ON COLUMN a.b IS NULL", (Statement)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"a", (String[])new String[]{"b"}), Optional.empty()));
        TestSqlParser.assertStatement("COMMENT ON COLUMN a IS 'test'", (Statement)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"a"), Optional.of("test")));
        TestSqlParser.assertStatement("COMMENT ON COLUMN a.b.c IS 'test'", (Statement)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"a", (String[])new String[]{"b", "c"}), Optional.of("test")));
        TestSqlParser.assertStatement("COMMENT ON COLUMN a.b.c.d IS 'test'", (Statement)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}), Optional.of("test")));
    }

    @Test
    public void testRenameColumn() {
        TestSqlParser.assertStatement("ALTER TABLE foo.t RENAME COLUMN a TO b", (Statement)new RenameColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"b"), false, false));
        TestSqlParser.assertStatement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN a TO b", (Statement)new RenameColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"b"), true, false));
        TestSqlParser.assertStatement("ALTER TABLE foo.t RENAME COLUMN IF EXISTS a TO b", (Statement)new RenameColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"b"), false, true));
        TestSqlParser.assertStatement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN IF EXISTS a TO b", (Statement)new RenameColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"a"), QueryUtil.identifier((String)"b"), true, true));
    }

    @Test
    public void testRenameView() {
        TestSqlParser.assertStatement("ALTER VIEW a RENAME TO b", (Statement)new RenameView(QualifiedName.of((String)"a"), QualifiedName.of((String)"b")));
    }

    @Test
    public void testAlterViewSetAuthorization() {
        TestSqlParser.assertStatement("ALTER VIEW foo.bar.baz SET AUTHORIZATION qux", (Statement)new SetViewAuthorization(QualifiedName.of((String)"foo", (String[])new String[]{"bar", "baz"}), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("qux"))));
        TestSqlParser.assertStatement("ALTER VIEW foo.bar.baz SET AUTHORIZATION USER qux", (Statement)new SetViewAuthorization(QualifiedName.of((String)"foo", (String[])new String[]{"bar", "baz"}), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("qux"))));
        TestSqlParser.assertStatement("ALTER VIEW foo.bar.baz SET AUTHORIZATION ROLE qux", (Statement)new SetViewAuthorization(QualifiedName.of((String)"foo", (String[])new String[]{"bar", "baz"}), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("qux"))));
    }

    @Test
    public void testTableExecute() {
        Table table = new Table(QualifiedName.of((String)"foo"));
        Identifier procedure = new Identifier("bar");
        TestSqlParser.assertStatement("ALTER TABLE foo EXECUTE bar", (Statement)new TableExecute(TreeNodes.location(1, 1), table, procedure, (List)ImmutableList.of(), Optional.empty()));
        TestSqlParser.assertStatement("ALTER TABLE foo EXECUTE bar(bah => 1, wuh => 'clap') WHERE age > 17", (Statement)new TableExecute(TreeNodes.location(1, 1), table, procedure, (List)ImmutableList.of((Object)new CallArgument(QueryUtil.identifier((String)"bah"), (Expression)new LongLiteral("1")), (Object)new CallArgument(QueryUtil.identifier((String)"wuh"), (Expression)new StringLiteral("clap"))), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("age"), (Expression)new LongLiteral("17")))));
        TestSqlParser.assertStatement("ALTER TABLE foo EXECUTE bar(1, 'clap') WHERE age > 17", (Statement)new TableExecute(TreeNodes.location(1, 1), table, procedure, (List)ImmutableList.of((Object)new CallArgument((Expression)new LongLiteral("1")), (Object)new CallArgument((Expression)new StringLiteral("clap"))), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("age"), (Expression)new LongLiteral("17")))));
    }

    @Test
    public void testAnalyze() {
        QualifiedName table = QualifiedName.of((String)"foo");
        TestSqlParser.assertStatement("ANALYZE foo", (Statement)new Analyze(table, (List)ImmutableList.of()));
        TestSqlParser.assertStatement("ANALYZE foo WITH ( \"string\" = 'bar', \"long\" = 42, computed = concat('ban', 'ana'), a = ARRAY[ 'v1', 'v2' ] )", (Statement)new Analyze(table, (List)ImmutableList.of((Object)new Property(new Identifier("string"), (Expression)new StringLiteral("bar")), (Object)new Property(new Identifier("long"), (Expression)new LongLiteral("42")), (Object)new Property(new Identifier("computed"), (Expression)new FunctionCall(QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral("ban"), (Object)new StringLiteral("ana")))), (Object)new Property(new Identifier("a"), (Expression)new Array((List)ImmutableList.of((Object)new StringLiteral("v1"), (Object)new StringLiteral("v2")))))));
        TestSqlParser.assertStatement("EXPLAIN ANALYZE foo", (Statement)new Explain((Statement)new Analyze(table, (List)ImmutableList.of()), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("EXPLAIN ANALYZE ANALYZE foo", (Statement)new ExplainAnalyze((Statement)new Analyze(table, (List)ImmutableList.of()), false));
    }

    @Test
    public void testAddColumn() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN c bigint")))).ignoringLocation().isEqualTo(new AddColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QueryUtil.identifier((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 31), "bigint"), true, Collections.emptyList(), Optional.empty()), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QueryUtil.identifier((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QueryUtil.identifier((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN IF NOT EXISTS d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QueryUtil.identifier((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN IF NOT EXISTS d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QueryUtil.identifier((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), true, true));
    }

    @Test
    public void testDropColumn() {
        TestSqlParser.assertStatement("ALTER TABLE foo.t DROP COLUMN c", (Statement)new DropColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"c"), false, false));
        TestSqlParser.assertStatement("ALTER TABLE \"t x\" DROP COLUMN \"c d\"", (Statement)new DropColumn(QualifiedName.of((String)"t x"), QueryUtil.quotedIdentifier((String)"c d"), false, false));
        TestSqlParser.assertStatement("ALTER TABLE IF EXISTS foo.t DROP COLUMN c", (Statement)new DropColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"c"), true, false));
        TestSqlParser.assertStatement("ALTER TABLE foo.t DROP COLUMN IF EXISTS c", (Statement)new DropColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"c"), false, true));
        TestSqlParser.assertStatement("ALTER TABLE IF EXISTS foo.t DROP COLUMN IF EXISTS c", (Statement)new DropColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), QueryUtil.identifier((String)"c"), true, true));
    }

    @Test
    public void testAlterColumnSetDataType() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ALTER COLUMN a SET DATA TYPE bigint")))).isEqualTo(new SetColumnType(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), new Identifier(TreeNodes.location(1, 32), "a", false), TreeNodes.simpleType(TreeNodes.location(1, 48), "bigint"), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ALTER COLUMN b SET DATA TYPE double")))).isEqualTo(new SetColumnType(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), new Identifier(TreeNodes.location(1, 42), "b", false), TreeNodes.simpleType(TreeNodes.location(1, 58), "double"), true));
    }

    @Test
    public void testAlterTableSetAuthorization() {
        TestSqlParser.assertStatement("ALTER TABLE foo.bar.baz SET AUTHORIZATION qux", (Statement)new SetTableAuthorization(QualifiedName.of((String)"foo", (String[])new String[]{"bar", "baz"}), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("qux"))));
        TestSqlParser.assertStatement("ALTER TABLE foo.bar.baz SET AUTHORIZATION USER qux", (Statement)new SetTableAuthorization(QualifiedName.of((String)"foo", (String[])new String[]{"bar", "baz"}), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("qux"))));
        TestSqlParser.assertStatement("ALTER TABLE foo.bar.baz SET AUTHORIZATION ROLE qux", (Statement)new SetTableAuthorization(QualifiedName.of((String)"foo", (String[])new String[]{"bar", "baz"}), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("qux"))));
    }

    @Test
    public void testCreateView() {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
        TestSqlParser.assertStatement("CREATE VIEW a AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE OR REPLACE VIEW a AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, true, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE VIEW a SECURITY DEFINER AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, false, Optional.empty(), Optional.of(CreateView.Security.DEFINER)));
        TestSqlParser.assertStatement("CREATE VIEW a SECURITY INVOKER AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, false, Optional.empty(), Optional.of(CreateView.Security.INVOKER)));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT 'comment' SECURITY DEFINER AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, false, Optional.of("comment"), Optional.of(CreateView.Security.DEFINER)));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT '' SECURITY INVOKER AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, false, Optional.of(""), Optional.of(CreateView.Security.INVOKER)));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT 'comment' AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, false, Optional.of("comment"), Optional.empty()));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT '' AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"a"), query, false, Optional.of(""), Optional.empty()));
        TestSqlParser.assertStatement("CREATE VIEW bar.foo AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"bar", (String[])new String[]{"foo"}), query, false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE VIEW \"awesome view\" AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"awesome view"), query, false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE VIEW \"awesome schema\".\"awesome view\" AS SELECT * FROM t", (Statement)new CreateView(QualifiedName.of((String)"awesome schema", (String[])new String[]{"awesome view"}), query, false, Optional.empty(), Optional.empty()));
    }

    @Test
    public void testGrant() {
        TestSqlParser.assertStatement("GRANT INSERT, DELETE ON t TO u", (Statement)new Grant(Optional.of(ImmutableList.of((Object)"INSERT", (Object)"DELETE")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("u")), false));
        TestSqlParser.assertStatement("GRANT UPDATE ON t TO u", (Statement)new Grant(Optional.of(ImmutableList.of((Object)"UPDATE")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("u")), false));
        TestSqlParser.assertStatement("GRANT SELECT ON t TO ROLE PUBLIC WITH GRANT OPTION", (Statement)new Grant(Optional.of(ImmutableList.of((Object)"SELECT")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("PUBLIC")), true));
        TestSqlParser.assertStatement("GRANT ALL PRIVILEGES ON TABLE t TO USER u", (Statement)new Grant(Optional.empty(), Optional.of(GrantOnType.TABLE), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("u")), false));
        TestSqlParser.assertStatement("GRANT DELETE ON \"t\" TO ROLE \"public\" WITH GRANT OPTION", (Statement)new Grant(Optional.of(ImmutableList.of((Object)"DELETE")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("public")), true));
        TestSqlParser.assertStatement("GRANT SELECT ON SCHEMA s TO USER u", (Statement)new Grant(Optional.of(ImmutableList.of((Object)"SELECT")), Optional.of(GrantOnType.SCHEMA), QualifiedName.of((String)"s"), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("u")), false));
    }

    @Test
    public void testDeny() {
        TestSqlParser.assertStatement("DENY INSERT, DELETE ON t TO u", (Statement)new Deny(Optional.of(ImmutableList.of((Object)"INSERT", (Object)"DELETE")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("u"))));
        TestSqlParser.assertStatement("DENY UPDATE ON t TO u", (Statement)new Deny(Optional.of(ImmutableList.of((Object)"UPDATE")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("u"))));
        TestSqlParser.assertStatement("DENY ALL PRIVILEGES ON TABLE t TO USER u", (Statement)new Deny(Optional.empty(), Optional.of(GrantOnType.TABLE), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("u"))));
        TestSqlParser.assertStatement("DENY SELECT ON SCHEMA s TO USER u", (Statement)new Deny(Optional.of(ImmutableList.of((Object)"SELECT")), Optional.of(GrantOnType.SCHEMA), QualifiedName.of((String)"s"), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("u"))));
    }

    @Test
    public void testRevoke() {
        TestSqlParser.assertStatement("REVOKE INSERT, DELETE ON t FROM u", (Statement)new Revoke(false, Optional.of(ImmutableList.of((Object)"INSERT", (Object)"DELETE")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("u"))));
        TestSqlParser.assertStatement("REVOKE UPDATE ON t FROM u", (Statement)new Revoke(false, Optional.of(ImmutableList.of((Object)"UPDATE")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("u"))));
        TestSqlParser.assertStatement("REVOKE GRANT OPTION FOR SELECT ON t FROM ROLE PUBLIC", (Statement)new Revoke(true, Optional.of(ImmutableList.of((Object)"SELECT")), Optional.empty(), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("PUBLIC"))));
        TestSqlParser.assertStatement("REVOKE ALL PRIVILEGES ON TABLE t FROM USER u", (Statement)new Revoke(false, Optional.empty(), Optional.of(GrantOnType.TABLE), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("u"))));
        TestSqlParser.assertStatement("REVOKE DELETE ON TABLE \"t\" FROM \"u\"", (Statement)new Revoke(false, Optional.of(ImmutableList.of((Object)"DELETE")), Optional.of(GrantOnType.TABLE), QualifiedName.of((String)"t"), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("u"))));
        TestSqlParser.assertStatement("REVOKE SELECT ON SCHEMA s FROM USER u", (Statement)new Revoke(false, Optional.of(ImmutableList.of((Object)"SELECT")), Optional.of(GrantOnType.SCHEMA), QualifiedName.of((String)"s"), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("u"))));
    }

    @Test
    public void testShowGrants() {
        TestSqlParser.assertStatement("SHOW GRANTS ON TABLE t", (Statement)new ShowGrants(true, Optional.of(QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SHOW GRANTS ON t", (Statement)new ShowGrants(false, Optional.of(QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SHOW GRANTS", (Statement)new ShowGrants(false, Optional.empty()));
    }

    @Test
    public void testShowRoles() {
        TestSqlParser.assertStatement("SHOW ROLES", (Statement)new ShowRoles(Optional.empty(), false));
        TestSqlParser.assertStatement("SHOW ROLES FROM foo", (Statement)new ShowRoles(Optional.of(new Identifier("foo")), false));
        TestSqlParser.assertStatement("SHOW ROLES IN foo", (Statement)new ShowRoles(Optional.of(new Identifier("foo")), false));
        TestSqlParser.assertStatement("SHOW CURRENT ROLES", (Statement)new ShowRoles(Optional.empty(), true));
        TestSqlParser.assertStatement("SHOW CURRENT ROLES FROM foo", (Statement)new ShowRoles(Optional.of(new Identifier("foo")), true));
        TestSqlParser.assertStatement("SHOW CURRENT ROLES IN foo", (Statement)new ShowRoles(Optional.of(new Identifier("foo")), true));
    }

    @Test
    public void testShowRoleGrants() {
        TestSqlParser.assertStatement("SHOW ROLE GRANTS", (Statement)new ShowRoleGrants(Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SHOW ROLE GRANTS FROM catalog", (Statement)new ShowRoleGrants(Optional.of(new Identifier("catalog"))));
    }

    @Test
    public void testSetPath() {
        TestSqlParser.assertStatement("SET PATH iLikeToEat.apples, andBananas", (Statement)new SetPath(new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.of(new Identifier("iLikeToEat")), new Identifier("apples")), (Object)new PathElement(Optional.empty(), new Identifier("andBananas"))))));
        TestSqlParser.assertStatement("SET PATH \"schemas,with\".\"grammar.in\", \"their!names\"", (Statement)new SetPath(new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.of(new Identifier("schemas,with")), new Identifier("grammar.in")), (Object)new PathElement(Optional.empty(), new Identifier("their!names"))))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSqlParser.assertStatement("SET PATH one.too.many, qualifiers", (Statement)new SetPath(new PathSpecification(Optional.empty(), (List)ImmutableList.of((Object)new PathElement(Optional.empty(), new Identifier("dummyValue"))))))).isInstanceOf(ParsingException.class)).hasMessage("line 1:17: mismatched input '.'. Expecting: ',', <EOF>");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SET PATH ", new ParsingOptions())).isInstanceOf(ParsingException.class)).hasMessage("line 1:10: mismatched input '<EOF>'. Expecting: <identifier>");
    }

    @Test
    public void testSetTimeZone() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE LOCAL")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE 'America/Los_Angeles'")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new StringLiteral(TreeNodes.location(1, 15), "America/Los_Angeles"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE concat_ws('/', 'America', 'Los_Angeles')")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new FunctionCall(TreeNodes.location(1, 15), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 15), "concat_ws", false))), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 25), "/"), (Object)new StringLiteral(TreeNodes.location(1, 30), "America"), (Object)new StringLiteral(TreeNodes.location(1, 41), "Los_Angeles"))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE '-08:00'")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new StringLiteral(TreeNodes.location(1, 15), "-08:00"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE INTERVAL '10' HOUR")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new IntervalLiteral(TreeNodes.location(1, 15), "10", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE INTERVAL -'08:00' HOUR TO MINUTE")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new IntervalLiteral(TreeNodes.location(1, 15), "08:00", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.MINUTE)))));
    }

    @Test
    public void testWith() {
        TestSqlParser.assertStatement("WITH a (t, u) AS (SELECT * FROM x), b AS (SELECT * FROM y) TABLE z", (Statement)new Query(Optional.of(new With(false, (List)ImmutableList.of((Object)new WithQuery(QueryUtil.identifier((String)"a"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"x"))), Optional.of(ImmutableList.of((Object)QueryUtil.identifier((String)"t"), (Object)QueryUtil.identifier((String)"u")))), (Object)new WithQuery(QueryUtil.identifier((String)"b"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"y"))), Optional.empty())))), (QueryBody)new Table(QualifiedName.of((String)"z")), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("WITH RECURSIVE a AS (SELECT * FROM x) TABLE y", (Statement)new Query(Optional.of(new With(true, (List)ImmutableList.of((Object)new WithQuery(QueryUtil.identifier((String)"a"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"x"))), Optional.empty())))), (QueryBody)new Table(QualifiedName.of((String)"y")), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testImplicitJoin() {
        TestSqlParser.assertStatement("SELECT * FROM a, b", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.IMPLICIT, (Relation)new Table(QualifiedName.of((String)"a")), (Relation)new Table(QualifiedName.of((String)"b")), Optional.empty())));
    }

    @Test
    public void testExplain() {
        TestSqlParser.assertStatement("EXPLAIN SELECT * FROM t", (Statement)new Explain((Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("EXPLAIN (TYPE LOGICAL) SELECT * FROM t", (Statement)new Explain((Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), (List)ImmutableList.of((Object)new ExplainType(ExplainType.Type.LOGICAL))));
        TestSqlParser.assertStatement("EXPLAIN (TYPE LOGICAL, FORMAT TEXT) SELECT * FROM t", (Statement)new Explain((Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), (List)ImmutableList.of((Object)new ExplainType(ExplainType.Type.LOGICAL), (Object)new ExplainFormat(ExplainFormat.Type.TEXT))));
        ParserAssert.assertStatementIsInvalid("EXPLAIN VERBOSE SELECT * FROM t").withMessageStartingWith("line 1:9: mismatched input 'VERBOSE'. Expecting: '(', 'ALTER', 'ANALYZE', 'CALL',");
        ParserAssert.assertStatementIsInvalid("EXPLAIN VERBOSE (type LOGICAL) SELECT * FROM t").withMessageStartingWith("line 1:9: mismatched input 'VERBOSE'. Expecting: '(', 'ALTER', 'ANALYZE', 'CALL',");
    }

    @Test
    public void testExplainAnalyze() {
        TestSqlParser.assertStatement("EXPLAIN ANALYZE SELECT * FROM t", (Statement)new ExplainAnalyze((Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), false));
        TestSqlParser.assertStatement("EXPLAIN ANALYZE VERBOSE SELECT * FROM t", (Statement)new ExplainAnalyze((Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), true));
        ParserAssert.assertStatementIsInvalid("EXPLAIN ANALYZE (type DISTRIBUTED) SELECT * FROM t").withMessage("line 1:18: mismatched input 'type'. Expecting: '(', 'SELECT', 'TABLE', 'VALUES'");
        ParserAssert.assertStatementIsInvalid("EXPLAIN ANALYZE VERBOSE (type DISTRIBUTED) SELECT * FROM t").withMessage("line 1:26: mismatched input 'type'. Expecting: '(', 'SELECT', 'TABLE', 'VALUES'");
    }

    @Test
    public void testJoinPrecedence() {
        TestSqlParser.assertStatement("SELECT * FROM a CROSS JOIN b LEFT JOIN c ON true", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.LEFT, (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"a")), (Relation)new Table(QualifiedName.of((String)"b")), Optional.empty()), (Relation)new Table(QualifiedName.of((String)"c")), Optional.of(new JoinOn((Expression)BooleanLiteral.TRUE_LITERAL)))));
        TestSqlParser.assertStatement("SELECT * FROM a CROSS JOIN b NATURAL JOIN c CROSS JOIN d NATURAL JOIN e", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.INNER, (Relation)new Join(Join.Type.CROSS, (Relation)new Join(Join.Type.INNER, (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"a")), (Relation)new Table(QualifiedName.of((String)"b")), Optional.empty()), (Relation)new Table(QualifiedName.of((String)"c")), Optional.of(new NaturalJoin())), (Relation)new Table(QualifiedName.of((String)"d")), Optional.empty()), (Relation)new Table(QualifiedName.of((String)"e")), Optional.of(new NaturalJoin()))));
    }

    @Test
    public void testUnnest() {
        TestSqlParser.assertStatement("SELECT * FROM t CROSS JOIN UNNEST(a)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new Unnest((List)ImmutableList.of((Object)new Identifier("a")), false), Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t CROSS JOIN UNNEST(a, b) WITH ORDINALITY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new Unnest((List)ImmutableList.of((Object)new Identifier("a"), (Object)new Identifier("b")), true), Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t FULL JOIN UNNEST(a) AS tmp (c) ON true", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.FULL, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new AliasedRelation((Relation)new Unnest((List)ImmutableList.of((Object)new Identifier("a")), false), new Identifier("tmp"), (List)ImmutableList.of((Object)new Identifier("c"))), Optional.of(new JoinOn((Expression)BooleanLiteral.TRUE_LITERAL)))));
    }

    @Test
    public void testLateral() {
        Lateral lateralRelation = new Lateral(QueryUtil.query((QueryBody)new Values((List)ImmutableList.of((Object)new LongLiteral("1")))));
        TestSqlParser.assertStatement("SELECT * FROM t, LATERAL (VALUES 1) a(x)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.IMPLICIT, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new AliasedRelation((Relation)lateralRelation, QueryUtil.identifier((String)"a"), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"))), Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t CROSS JOIN LATERAL (VALUES 1) ", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)lateralRelation, Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t FULL JOIN LATERAL (VALUES 1) ON true", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.FULL, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)lateralRelation, Optional.of(new JoinOn((Expression)BooleanLiteral.TRUE_LITERAL)))));
    }

    @Test
    public void testStartTransaction() {
        TestSqlParser.assertStatement("START TRANSACTION", (Statement)new StartTransaction((List)ImmutableList.of()));
        TestSqlParser.assertStatement("START TRANSACTION ISOLATION LEVEL READ UNCOMMITTED", (Statement)new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.READ_UNCOMMITTED))));
        TestSqlParser.assertStatement("START TRANSACTION ISOLATION LEVEL READ COMMITTED", (Statement)new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.READ_COMMITTED))));
        TestSqlParser.assertStatement("START TRANSACTION ISOLATION LEVEL REPEATABLE READ", (Statement)new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.REPEATABLE_READ))));
        TestSqlParser.assertStatement("START TRANSACTION ISOLATION LEVEL SERIALIZABLE", (Statement)new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.SERIALIZABLE))));
        TestSqlParser.assertStatement("START TRANSACTION READ ONLY", (Statement)new StartTransaction((List)ImmutableList.of((Object)new TransactionAccessMode(true))));
        TestSqlParser.assertStatement("START TRANSACTION READ WRITE", (Statement)new StartTransaction((List)ImmutableList.of((Object)new TransactionAccessMode(false))));
        TestSqlParser.assertStatement("START TRANSACTION ISOLATION LEVEL READ COMMITTED, READ ONLY", (Statement)new StartTransaction((List)ImmutableList.of((Object)new Isolation(Isolation.Level.READ_COMMITTED), (Object)new TransactionAccessMode(true))));
        TestSqlParser.assertStatement("START TRANSACTION READ ONLY, ISOLATION LEVEL READ COMMITTED", (Statement)new StartTransaction((List)ImmutableList.of((Object)new TransactionAccessMode(true), (Object)new Isolation(Isolation.Level.READ_COMMITTED))));
        TestSqlParser.assertStatement("START TRANSACTION READ WRITE, ISOLATION LEVEL SERIALIZABLE", (Statement)new StartTransaction((List)ImmutableList.of((Object)new TransactionAccessMode(false), (Object)new Isolation(Isolation.Level.SERIALIZABLE))));
    }

    @Test
    public void testCommit() {
        TestSqlParser.assertStatement("COMMIT", (Statement)new Commit());
        TestSqlParser.assertStatement("COMMIT WORK", (Statement)new Commit());
    }

    @Test
    public void testRollback() {
        TestSqlParser.assertStatement("ROLLBACK", (Statement)new Rollback());
        TestSqlParser.assertStatement("ROLLBACK WORK", (Statement)new Rollback());
    }

    @Test
    public void testAtTimeZone() {
        TestSqlParser.assertStatement("SELECT timestamp '2012-10-31 01:00 UTC' AT TIME ZONE 'America/Los_Angeles'", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new AtTimeZone((Expression)new TimestampLiteral("2012-10-31 01:00 UTC"), (Expression)new StringLiteral("America/Los_Angeles"))})));
    }

    @Test
    public void testLambda() {
        TestSqlParser.assertExpression("() -> x", (Expression)new LambdaExpression((List)ImmutableList.of(), (Expression)new Identifier("x")));
        TestSqlParser.assertExpression("x -> sin(x)", (Expression)new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x"))), (Expression)new FunctionCall(QualifiedName.of((String)"sin"), (List)ImmutableList.of((Object)new Identifier("x")))));
        TestSqlParser.assertExpression("(x, y) -> mod(x, y)", (Expression)new LambdaExpression((List)ImmutableList.of((Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"x")), (Object)new LambdaArgumentDeclaration(QueryUtil.identifier((String)"y"))), (Expression)new FunctionCall(QualifiedName.of((String)"mod"), (List)ImmutableList.of((Object)new Identifier("x"), (Object)new Identifier("y")))));
    }

    @Test
    public void testNonReserved() {
        TestSqlParser.assertStatement("SELECT zone FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("zone")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT INCLUDING, EXCLUDING, PROPERTIES FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("INCLUDING"), new Identifier("EXCLUDING"), new Identifier("PROPERTIES")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT ALL, SOME, ANY FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("ALL"), new Identifier("SOME"), new Identifier("ANY")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("stats")))).isEqualTo(new Identifier(location, "stats", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfd")))).isEqualTo(new Identifier(location, "nfd", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfc")))).isEqualTo(new Identifier(location, "nfc", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfkd")))).isEqualTo(new Identifier(location, "nfkd", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfkc")))).isEqualTo(new Identifier(location, "nfkc", false));
    }

    @Test
    public void testBinaryLiteralToHex() {
        Assertions.assertThat((String)new BinaryLiteral("ab 01").toHexString()).isEqualTo("AB01");
    }

    @Test
    public void testCall() {
        TestSqlParser.assertStatement("CALL foo()", (Statement)new Call(QualifiedName.of((String)"foo"), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CALL foo(123, a => 1, b => 'go', 456)", (Statement)new Call(QualifiedName.of((String)"foo"), (List)ImmutableList.of((Object)new CallArgument((Expression)new LongLiteral("123")), (Object)new CallArgument(QueryUtil.identifier((String)"a"), (Expression)new LongLiteral("1")), (Object)new CallArgument(QueryUtil.identifier((String)"b"), (Expression)new StringLiteral("go")), (Object)new CallArgument((Expression)new LongLiteral("456")))));
    }

    @Test
    public void testPrepare() {
        TestSqlParser.assertStatement("PREPARE myquery FROM select * from foo", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")))));
    }

    @Test
    public void testPrepareDropView() {
        TestSqlParser.assertStatement("PREPARE statement1 FROM DROP VIEW IF EXISTS \"catalog-test\".\"test\".\"foo\"", (Statement)new Prepare(QueryUtil.identifier((String)"statement1"), (Statement)new DropView(QualifiedName.of((String)"catalog-test", (String[])new String[]{"test", "foo"}), true)));
        ParserAssert.assertStatementIsInvalid("PREPARE statement1 FROM DROP VIEW IF EXISTS catalog-test.test.foo").withMessage("line 1:52: mismatched input '-'. Expecting: '.', <EOF>");
    }

    @Test
    public void testPrepareWithParameters() {
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT * FROM foo LIMIT ?", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new Parameter(0))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo LIMIT ?", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new Parameter(2))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ? FROM foo FETCH FIRST ? ROWS ONLY", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new Parameter(1))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo FETCH NEXT ? ROWS WITH TIES", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new Parameter(2), true)))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo OFFSET ? ROWS", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new Parameter(2))), Optional.empty())));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ? FROM foo OFFSET ? ROWS LIMIT ?", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new Parameter(1))), Optional.of(new Limit((Expression)new Parameter(2))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ? FROM foo OFFSET ? ROWS FETCH FIRST ? ROWS WITH TIES", (Statement)new Prepare(QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new Parameter(1))), Optional.of(new FetchFirst((Expression)new Parameter(2), true)))));
    }

    @Test
    public void testDeallocatePrepare() {
        TestSqlParser.assertStatement("DEALLOCATE PREPARE myquery", (Statement)new Deallocate(QueryUtil.identifier((String)"myquery")));
    }

    @Test
    public void testExecute() {
        TestSqlParser.assertStatement("EXECUTE myquery", (Statement)new Execute(QueryUtil.identifier((String)"myquery"), Collections.emptyList()));
    }

    @Test
    public void testExecuteWithUsing() {
        TestSqlParser.assertStatement("EXECUTE myquery USING 1, 'abc', ARRAY ['hello']", (Statement)new Execute(QueryUtil.identifier((String)"myquery"), (List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("abc"), (Object)new Array((List)ImmutableList.of((Object)new StringLiteral("hello"))))));
    }

    @Test
    public void testExists() {
        TestSqlParser.assertStatement("SELECT EXISTS(SELECT 1)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")})))})));
        TestSqlParser.assertStatement("SELECT EXISTS(SELECT 1) = EXISTS(SELECT 2)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")}))), (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("2")}))))})));
        TestSqlParser.assertStatement("SELECT NOT EXISTS(SELECT 1) = EXISTS(SELECT 2)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")}))), (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("2")})))))})));
        TestSqlParser.assertStatement("SELECT (NOT EXISTS(SELECT 1)) = EXISTS(SELECT 2)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new NotExpression((Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")})))), (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("2")}))))})));
    }

    private static ExistsPredicate exists(Query query) {
        return new ExistsPredicate((Expression)new SubqueryExpression(query));
    }

    @Test
    public void testShowStats() {
        String[] tableNames;
        for (String fullName : tableNames = new String[]{"t", "s.t", "c.s.t"}) {
            QualifiedName qualifiedName = TestSqlParser.makeQualifiedName(fullName);
            TestSqlParser.assertStatement(String.format("SHOW STATS FOR %s", qualifiedName), (Statement)new ShowStats((Relation)new Table(qualifiedName)));
        }
    }

    @Test
    public void testShowStatsForQuery() {
        String[] tableNames;
        for (String fullName : tableNames = new String[]{"t", "s.t", "c.s.t"}) {
            QualifiedName qualifiedName = TestSqlParser.makeQualifiedName(fullName);
            TestSqlParser.assertStatement(String.format("SHOW STATS FOR (SELECT * FROM %s)", qualifiedName), (Statement)TestSqlParser.createShowStats(qualifiedName, (List<SelectItem>)ImmutableList.of((Object)new AllColumns()), Optional.empty()));
            TestSqlParser.assertStatement(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE field > 0)", qualifiedName), (Statement)TestSqlParser.createShowStats(qualifiedName, (List<SelectItem>)ImmutableList.of((Object)new AllColumns()), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("field"), (Expression)new LongLiteral("0")))));
            TestSqlParser.assertStatement(String.format("SHOW STATS FOR (SELECT * FROM %s WHERE field > 0 or field < 0)", qualifiedName), (Statement)TestSqlParser.createShowStats(qualifiedName, (List<SelectItem>)ImmutableList.of((Object)new AllColumns()), Optional.of(LogicalExpression.or((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("field"), (Expression)new LongLiteral("0")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Identifier("field"), (Expression)new LongLiteral("0"))))));
        }
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW STATS FOR (SELECT * FROM t LIMIT 10)")))).isEqualTo(new ShowStats(Optional.of(TreeNodes.location(1, 1)), (Relation)new TableSubquery(new Query(TreeNodes.location(1, 17), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 17), new Select(TreeNodes.location(1, 17), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 24), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 31), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.of(new Limit(TreeNodes.location(1, 33), (Expression)new LongLiteral(TreeNodes.location(1, 39), "10")))), Optional.empty(), Optional.empty(), Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW STATS FOR (SELECT * FROM t ORDER BY field LIMIT 10)")))).isEqualTo(new ShowStats(Optional.of(TreeNodes.location(1, 1)), (Relation)new TableSubquery(new Query(TreeNodes.location(1, 17), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 17), new Select(TreeNodes.location(1, 17), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 24), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 31), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.of(new OrderBy(TreeNodes.location(1, 33), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 42), (Expression)new Identifier(TreeNodes.location(1, 42), "field", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.empty(), Optional.of(new Limit(TreeNodes.location(1, 48), (Expression)new LongLiteral(TreeNodes.location(1, 54), "10")))), Optional.empty(), Optional.empty(), Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW STATS FOR (\n   WITH t AS (SELECT 1 )\n   SELECT * FROM t)")))).isEqualTo(new ShowStats(Optional.of(TreeNodes.location(1, 1)), (Relation)new TableSubquery(new Query(TreeNodes.location(2, 4), Optional.of(new With(TreeNodes.location(2, 4), false, (List)ImmutableList.of((Object)new WithQuery(TreeNodes.location(2, 9), new Identifier(TreeNodes.location(2, 9), "t", false), new Query(TreeNodes.location(2, 15), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(2, 15), new Select(TreeNodes.location(2, 15), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(2, 22), (Expression)new LongLiteral(TreeNodes.location(2, 22), "1"), Optional.empty()))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty())))), (QueryBody)new QuerySpecification(TreeNodes.location(3, 4), new Select(TreeNodes.location(3, 4), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(3, 11), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(3, 18), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(3, 18), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()))));
    }

    private static ShowStats createShowStats(QualifiedName name, List<SelectItem> selects, Optional<Expression> where) {
        return new ShowStats((Relation)new TableSubquery(QueryUtil.simpleQuery((Select)new Select(false, selects), (Relation)new Table(name), where, Optional.empty())));
    }

    @Test
    public void testDescribeOutput() {
        TestSqlParser.assertStatement("DESCRIBE OUTPUT myquery", (Statement)new DescribeOutput(QueryUtil.identifier((String)"myquery")));
    }

    @Test
    public void testDescribeInput() {
        TestSqlParser.assertStatement("DESCRIBE INPUT myquery", (Statement)new DescribeInput(QueryUtil.identifier((String)"myquery")));
    }

    @Test
    public void testAggregationFilter() {
        TestSqlParser.assertStatement("SELECT SUM(x) FILTER (WHERE x > 4)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(Optional.empty(), QualifiedName.of((String)"SUM"), Optional.empty(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("x"), (Expression)new LongLiteral("4"))), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier("x")))})));
    }

    @Test
    public void testQuantifiedComparison() {
        TestSqlParser.assertExpression("col1 < ANY (SELECT col2 FROM table1)", (Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.LESS_THAN, QuantifiedComparisonExpression.Quantifier.ANY, (Expression)QueryUtil.identifier((String)"col1"), (Expression)new SubqueryExpression(QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new SingleColumn((Expression)QueryUtil.identifier((String)"col2"))}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"table1"))))));
        TestSqlParser.assertExpression("col1 = ALL (VALUES ROW(1), ROW(2))", (Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, (Expression)QueryUtil.identifier((String)"col1"), (Expression)new SubqueryExpression(QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new LongLiteral("1")}), QueryUtil.row((Expression[])new Expression[]{new LongLiteral("2")})})))));
        TestSqlParser.assertExpression("col1 >= SOME (SELECT 10)", (Expression)new QuantifiedComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, QuantifiedComparisonExpression.Quantifier.SOME, (Expression)QueryUtil.identifier((String)"col1"), (Expression)new SubqueryExpression(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("10")})))));
    }

    @Test
    public void testAggregationWithOrderBy() {
        TestSqlParser.assertExpression("array_agg(x ORDER BY x DESC)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"array_agg"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)QueryUtil.identifier((String)"x"), SortItem.Ordering.DESCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"))));
        TestSqlParser.assertStatement("SELECT array_agg(x ORDER BY t.y) FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(Optional.empty(), QualifiedName.of((String)"array_agg"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new DereferenceExpression((Expression)new Identifier("t"), QueryUtil.identifier((String)"y")), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier("x")))}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
    }

    @Test
    public void testCreateRole() {
        TestSqlParser.assertStatement("CREATE ROLE role", (Statement)new CreateRole(new Identifier("role"), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE role1 WITH ADMIN admin", (Statement)new CreateRole(new Identifier("role1"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE \"role\" WITH ADMIN \"admin\"", (Statement)new CreateRole(new Identifier("role"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE \"ro le\" WITH ADMIN \"ad min\"", (Statement)new CreateRole(new Identifier("ro le"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("ad min"))))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE \"!@#$%^&*'\" WITH ADMIN \"\u0430\u0434\"\"\u043c\u0456\u043d\"", (Statement)new CreateRole(new Identifier("!@#$%^&*'"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("\u0430\u0434\"\u043c\u0456\u043d"))))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE role2 WITH ADMIN USER admin1", (Statement)new CreateRole(new Identifier("role2"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("admin1"))))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE role2 WITH ADMIN ROLE role1", (Statement)new CreateRole(new Identifier("role2"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role1"))))), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE role2 WITH ADMIN CURRENT_USER", (Statement)new CreateRole(new Identifier("role2"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.CURRENT_USER, Optional.empty())), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE role2 WITH ADMIN CURRENT_ROLE", (Statement)new CreateRole(new Identifier("role2"), Optional.of(new GrantorSpecification(GrantorSpecification.Type.CURRENT_ROLE, Optional.empty())), Optional.empty()));
        TestSqlParser.assertStatement("CREATE ROLE role IN my_catalog", (Statement)new CreateRole(new Identifier("role"), Optional.empty(), Optional.of(new Identifier("my_catalog"))));
    }

    @Test
    public void testDropRole() {
        TestSqlParser.assertStatement("DROP ROLE role", (Statement)new DropRole(new Identifier("role"), Optional.empty()));
        TestSqlParser.assertStatement("DROP ROLE \"role\"", (Statement)new DropRole(new Identifier("role"), Optional.empty()));
        TestSqlParser.assertStatement("DROP ROLE \"ro le\"", (Statement)new DropRole(new Identifier("ro le"), Optional.empty()));
        TestSqlParser.assertStatement("DROP ROLE \"!@#$%^&*'\u0430\u0434\"\"\u043c\u0456\u043d\"", (Statement)new DropRole(new Identifier("!@#$%^&*'\u0430\u0434\"\u043c\u0456\u043d"), Optional.empty()));
        TestSqlParser.assertStatement("DROP ROLE role IN my_catalog", (Statement)new DropRole(new Identifier("role"), Optional.of(new Identifier("my_catalog"))));
    }

    @Test
    public void testGrantRoles() {
        TestSqlParser.assertStatement("GRANT role1 TO user1", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1"))), false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("GRANT role1, role2, role3 TO user1, USER user2, ROLE role4 WITH ADMIN OPTION", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1"), (Object)new Identifier("role2"), (Object)new Identifier("role3")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1")), (Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("user2")), (Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role4"))), true, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("GRANT role1 TO user1 WITH ADMIN OPTION GRANTED BY admin", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1"))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("GRANT role1 TO USER user1 WITH ADMIN OPTION GRANTED BY USER admin", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("user1"))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("GRANT role1 TO ROLE role2 WITH ADMIN OPTION GRANTED BY ROLE admin", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role2"))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("GRANT role1 TO ROLE role2 GRANTED BY ROLE admin", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role2"))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("GRANT \"role1\" TO ROLE \"role2\" GRANTED BY ROLE \"admin\"", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role2"))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("GRANT role1 TO user1 IN my_catalog", (Statement)new GrantRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1"))), false, Optional.empty(), Optional.of(new Identifier("my_catalog"))));
    }

    @Test
    public void testRevokeRoles() {
        TestSqlParser.assertStatement("REVOKE role1 FROM user1", (Statement)new RevokeRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1"))), false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("REVOKE ADMIN OPTION FOR role1, role2, role3 FROM user1, USER user2, ROLE role4", (Statement)new RevokeRoles((Set)ImmutableSet.of((Object)new Identifier("role1"), (Object)new Identifier("role2"), (Object)new Identifier("role3")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1")), (Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("user2")), (Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role4"))), true, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("REVOKE ADMIN OPTION FOR role1 FROM user1 GRANTED BY admin", (Statement)new RevokeRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1"))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("REVOKE ADMIN OPTION FOR role1 FROM USER user1 GRANTED BY USER admin", (Statement)new RevokeRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("user1"))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("REVOKE role1 FROM ROLE role2 GRANTED BY ROLE admin", (Statement)new RevokeRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role2"))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("REVOKE \"role1\" FROM ROLE \"role2\" GRANTED BY ROLE \"admin\"", (Statement)new RevokeRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("role2"))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier("admin"))))), Optional.empty()));
        TestSqlParser.assertStatement("REVOKE role1 FROM user1 IN my_catalog", (Statement)new RevokeRoles((Set)ImmutableSet.of((Object)new Identifier("role1")), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier("user1"))), false, Optional.empty(), Optional.of(new Identifier("my_catalog"))));
    }

    @Test
    public void testSetRole() {
        TestSqlParser.assertStatement("SET ROLE ALL", (Statement)new SetRole(SetRole.Type.ALL, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SET ROLE NONE", (Statement)new SetRole(SetRole.Type.NONE, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SET ROLE role", (Statement)new SetRole(SetRole.Type.ROLE, Optional.of(new Identifier("role")), Optional.empty()));
        TestSqlParser.assertStatement("SET ROLE \"role\"", (Statement)new SetRole(SetRole.Type.ROLE, Optional.of(new Identifier("role")), Optional.empty()));
        TestSqlParser.assertStatement("SET ROLE role IN my_catalog", (Statement)new SetRole(SetRole.Type.ROLE, Optional.of(new Identifier("role")), Optional.of(new Identifier("my_catalog"))));
    }

    @Test
    public void testCreateMaterializedView() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE MATERIALIZED VIEW a AS SELECT * FROM t")))).isEqualTo(new CreateMaterializedView(Optional.of(new NodeLocation(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 26), "a", false))), new Query(new NodeLocation(1, 31), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 31), new Select(new NodeLocation(1, 31), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 38), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 45), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 45), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), false, false, Optional.empty(), (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE MATERIALIZED VIEW catalog.schema.matview COMMENT 'A simple materialized view' AS SELECT * FROM catalog2.schema2.tab")))).isEqualTo(new CreateMaterializedView(Optional.of(new NodeLocation(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 37), "catalog", false), (Object)new Identifier(new NodeLocation(1, 45), "schema", false), (Object)new Identifier(new NodeLocation(1, 52), "matview", false))), new Query(new NodeLocation(1, 100), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 100), new Select(new NodeLocation(1, 100), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 107), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 114), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 114), "catalog2", false), (Object)new Identifier(new NodeLocation(1, 123), "schema2", false), (Object)new Identifier(new NodeLocation(1, 131), "tab", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), true, false, Optional.empty(), (List)ImmutableList.of(), Optional.of("A simple materialized view")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE MATERIALIZED VIEW a GRACE PERIOD INTERVAL '2' DAY AS SELECT * FROM t")))).isEqualTo(new CreateMaterializedView(Optional.of(new NodeLocation(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 26), "a", false))), new Query(new NodeLocation(1, 61), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 61), new Select(new NodeLocation(1, 61), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 68), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 75), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 75), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), false, false, Optional.of(new IntervalLiteral(new NodeLocation(1, 41), "2", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty())), (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE MATERIALIZED VIEW catalog.schema.matview COMMENT 'A simple materialized view'WITH (partitioned_by = ARRAY ['dateint']) AS SELECT * FROM catalog2.schema2.tab")))).isEqualTo(new CreateMaterializedView(Optional.of(new NodeLocation(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 37), "catalog", false), (Object)new Identifier(new NodeLocation(1, 45), "schema", false), (Object)new Identifier(new NodeLocation(1, 52), "matview", false))), new Query(new NodeLocation(1, 141), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 141), new Select(new NodeLocation(1, 141), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 148), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 155), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 155), "catalog2", false), (Object)new Identifier(new NodeLocation(1, 164), "schema2", false), (Object)new Identifier(new NodeLocation(1, 172), "tab", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), true, false, Optional.empty(), (List)ImmutableList.of((Object)new Property(new NodeLocation(1, 102), new Identifier(new NodeLocation(1, 102), "partitioned_by", false), (Expression)new Array(new NodeLocation(1, 119), (List)ImmutableList.of((Object)new StringLiteral(new NodeLocation(1, 126), "dateint"))))), Optional.of("A simple materialized view")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE MATERIALIZED VIEW catalog.schema.matview COMMENT 'A partitioned materialized view' WITH (partitioned_by = ARRAY ['dateint']) AS WITH a (t, u) AS (SELECT * FROM x), b AS (SELECT * FROM a) TABLE b")))).isEqualTo(new CreateMaterializedView(Optional.of(new NodeLocation(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 37), "catalog", false), (Object)new Identifier(new NodeLocation(1, 45), "schema", false), (Object)new Identifier(new NodeLocation(1, 52), "matview", false))), new Query(new NodeLocation(1, 147), Optional.of(new With(new NodeLocation(1, 147), false, (List)ImmutableList.of((Object)new WithQuery(new NodeLocation(1, 152), new Identifier(new NodeLocation(1, 152), "a", false), new Query(new NodeLocation(1, 165), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 165), new Select(new NodeLocation(1, 165), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 172), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 179), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 179), "x", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), Optional.of(ImmutableList.of((Object)new Identifier(new NodeLocation(1, 155), "t", false), (Object)new Identifier(new NodeLocation(1, 158), "u", false)))), (Object)new WithQuery(new NodeLocation(1, 183), new Identifier(new NodeLocation(1, 183), "b", false), new Query(new NodeLocation(1, 189), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 189), new Select(new NodeLocation(1, 189), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 196), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 203), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 203), "a", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty())))), (QueryBody)new Table(new NodeLocation(1, 206), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 212), "b", false)))), Optional.empty(), Optional.empty(), Optional.empty()), true, false, Optional.empty(), (List)ImmutableList.of((Object)new Property(new NodeLocation(1, 108), new Identifier(new NodeLocation(1, 108), "partitioned_by", false), (Expression)new Array(new NodeLocation(1, 125), (List)ImmutableList.of((Object)new StringLiteral(new NodeLocation(1, 132), "dateint"))))), Optional.of("A partitioned materialized view")));
    }

    @Test
    public void testRefreshMaterializedView() {
        TestSqlParser.assertStatement("REFRESH MATERIALIZED VIEW test", (Statement)new RefreshMaterializedView(Optional.empty(), new Table(QualifiedName.of((String)"test"))));
        TestSqlParser.assertStatement("REFRESH MATERIALIZED VIEW \"some name that contains space\"", (Statement)new RefreshMaterializedView(Optional.empty(), new Table(QualifiedName.of((String)"some name that contains space"))));
    }

    @Test
    public void testDropMaterializedView() {
        TestSqlParser.assertStatement("DROP MATERIALIZED VIEW a", (Statement)new DropMaterializedView(QualifiedName.of((String)"a"), false));
        TestSqlParser.assertStatement("DROP MATERIALIZED VIEW a.b", (Statement)new DropMaterializedView(QualifiedName.of((String)"a", (String[])new String[]{"b"}), false));
        TestSqlParser.assertStatement("DROP MATERIALIZED VIEW a.b.c", (Statement)new DropMaterializedView(QualifiedName.of((String)"a", (String[])new String[]{"b", "c"}), false));
        TestSqlParser.assertStatement("DROP MATERIALIZED VIEW IF EXISTS a", (Statement)new DropMaterializedView(QualifiedName.of((String)"a"), true));
        TestSqlParser.assertStatement("DROP MATERIALIZED VIEW IF EXISTS a.b", (Statement)new DropMaterializedView(QualifiedName.of((String)"a", (String[])new String[]{"b"}), true));
        TestSqlParser.assertStatement("DROP MATERIALIZED VIEW IF EXISTS a.b.c", (Statement)new DropMaterializedView(QualifiedName.of((String)"a", (String[])new String[]{"b", "c"}), true));
    }

    @Test
    public void testRenameMaterializedView() {
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW a RENAME TO b", (Statement)new RenameMaterializedView(QualifiedName.of((String)"a"), QualifiedName.of((String)"b"), false));
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW IF EXISTS a RENAME TO b", (Statement)new RenameMaterializedView(QualifiedName.of((String)"a"), QualifiedName.of((String)"b"), true));
    }

    @Test
    public void testSetMaterializedViewProperties() {
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo='bar'", (Statement)new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new StringLiteral("bar")))));
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=true", (Statement)new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new BooleanLiteral("true")))));
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=123", (Statement)new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new LongLiteral("123")))));
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=123, bar=456", (Statement)new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new LongLiteral("123")), (Object)new Property(new Identifier("bar"), (Expression)new LongLiteral("456")))));
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW a SET PROPERTIES \" s p a c e \"='bar'", (Statement)new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier(" s p a c e "), (Expression)new StringLiteral("bar")))));
        TestSqlParser.assertStatement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=123, bar=DEFAULT", (Statement)new SetProperties(SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((String)"a"), (List)ImmutableList.of((Object)new Property(new Identifier("foo"), (Expression)new LongLiteral("123")), (Object)new Property(new Identifier("bar")))));
        ParserAssert.assertStatementIsInvalid("ALTER MATERIALIZED VIEW a SET PROPERTIES").withMessage("line 1:41: mismatched input '<EOF>'. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER MATERIALIZED VIEW a SET PROPERTIES ()").withMessage("line 1:42: mismatched input '('. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER MATERIALIZED VIEW a SET PROPERTIES (foo='bar')").withMessage("line 1:42: mismatched input '('. Expecting: <identifier>");
    }

    @Test
    public void testNullTreatment() {
        TestSqlParser.assertExpression("lead(x, 1) ignore nulls over()", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"lead"), Optional.of(new WindowSpecification(Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty())), Optional.empty(), Optional.empty(), false, Optional.of(FunctionCall.NullTreatment.IGNORE), Optional.empty(), (List)ImmutableList.of((Object)new Identifier("x"), (Object)new LongLiteral("1"))));
        TestSqlParser.assertExpression("lead(x, 1) respect nulls over()", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"lead"), Optional.of(new WindowSpecification(Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty())), Optional.empty(), Optional.empty(), false, Optional.of(FunctionCall.NullTreatment.RESPECT), Optional.empty(), (List)ImmutableList.of((Object)new Identifier("x"), (Object)new LongLiteral("1"))));
    }

    @Test
    public void testProcessingMode() {
        TestSqlParser.assertExpression("RUNNING LAST(x, 1)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"LAST"), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.of(new ProcessingMode(Optional.empty(), ProcessingMode.Mode.RUNNING)), (List)ImmutableList.of((Object)new Identifier("x"), (Object)new LongLiteral("1"))));
        TestSqlParser.assertExpression("FINAL FIRST(x, 1)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"FIRST"), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.of(new ProcessingMode(Optional.empty(), ProcessingMode.Mode.FINAL)), (List)ImmutableList.of((Object)new Identifier("x"), (Object)new LongLiteral("1"))));
    }

    @Test
    public void testWindowSpecification() {
        TestSqlParser.assertExpression("rank() OVER someWindow", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"rank"), Optional.of(new WindowReference(new Identifier("someWindow"))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertExpression("rank() OVER (someWindow PARTITION BY x ORDER BY y ROWS CURRENT ROW)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"rank"), Optional.of(new WindowSpecification(Optional.of(new Identifier("someWindow")), (List)ImmutableList.of((Object)new Identifier("x")), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("y"), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.of(new WindowFrame(WindowFrame.Type.ROWS, new FrameBound(FrameBound.Type.CURRENT_ROW), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of())))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertExpression("rank() OVER (PARTITION BY x ORDER BY y ROWS CURRENT ROW)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"rank"), Optional.of(new WindowSpecification(Optional.empty(), (List)ImmutableList.of((Object)new Identifier("x")), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("y"), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.of(new WindowFrame(WindowFrame.Type.ROWS, new FrameBound(FrameBound.Type.CURRENT_ROW), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of())))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
    }

    @Test
    public void testWindowClause() {
        TestSqlParser.assertStatement("SELECT * FROM T WINDOW someWindow AS (PARTITION BY a), otherWindow AS (someWindow ORDER BY b)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(TestSqlParser.makeQualifiedName("T")), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new WindowDefinition(new Identifier("someWindow"), new WindowSpecification(Optional.empty(), (List)ImmutableList.of((Object)new Identifier("a")), Optional.empty(), Optional.empty())), (Object)new WindowDefinition(new Identifier("otherWindow"), new WindowSpecification(Optional.of(new Identifier("someWindow")), (List)ImmutableList.of(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("b"), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.empty()))), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testWindowFrameWithPatternRecognition() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("rank() OVER (                           PARTITION BY x                            ORDER BY y                            MEASURES                                MATCH_NUMBER() AS match_no,                                LAST(A.z) AS last_z                            ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                            AFTER MATCH SKIP TO NEXT ROW                            SEEK                            PATTERN (A B C)                            SUBSET U = (A, B)                            DEFINE                                B AS false,                                C AS CLASSIFIER(U) = 'B'                          )")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "rank", false))), Optional.of(new WindowSpecification(TreeNodes.location(1, 41), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 54), "x", false)), Optional.of(new OrderBy(TreeNodes.location(1, 83), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 92), (Expression)new Identifier(TreeNodes.location(1, 92), "y", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.of(new WindowFrame(TreeNodes.location(1, 121), WindowFrame.Type.ROWS, new FrameBound(TreeNodes.location(1, 280), FrameBound.Type.CURRENT_ROW), Optional.of(new FrameBound(TreeNodes.location(1, 296), FrameBound.Type.FOLLOWING, (Expression)new LongLiteral(TreeNodes.location(1, 296), "5"))), (List)ImmutableList.of((Object)new MeasureDefinition(TreeNodes.location(1, 161), (Expression)new FunctionCall(TreeNodes.location(1, 161), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 161), "MATCH_NUMBER", false))), (List)ImmutableList.of()), new Identifier(TreeNodes.location(1, 179), "match_no", false)), (Object)new MeasureDefinition(TreeNodes.location(1, 220), (Expression)new FunctionCall(TreeNodes.location(1, 220), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 220), "LAST", false))), (List)ImmutableList.of((Object)new DereferenceExpression(TreeNodes.location(1, 225), (Expression)new Identifier(TreeNodes.location(1, 225), "A", false), new Identifier(TreeNodes.location(1, 227), "z", false)))), new Identifier(TreeNodes.location(1, 233), "last_z", false))), Optional.of(SkipTo.skipToNextRow((NodeLocation)TreeNodes.location(1, 347))), Optional.of(new PatternSearchMode(TreeNodes.location(1, 391), PatternSearchMode.Mode.SEEK)), Optional.of(new PatternConcatenation(TreeNodes.location(1, 432), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(1, 432), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 432), new Identifier(TreeNodes.location(1, 432), "A", false)), (Object)new PatternVariable(TreeNodes.location(1, 434), new Identifier(TreeNodes.location(1, 434), "B", false)))), (Object)new PatternVariable(TreeNodes.location(1, 436), new Identifier(TreeNodes.location(1, 436), "C", false))))), (List)ImmutableList.of((Object)new SubsetDefinition(TreeNodes.location(1, 473), new Identifier(TreeNodes.location(1, 473), "U", false), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 478), "A", false), (Object)new Identifier(TreeNodes.location(1, 481), "B", false)))), (List)ImmutableList.of((Object)new VariableDefinition(TreeNodes.location(1, 549), new Identifier(TreeNodes.location(1, 549), "B", false), (Expression)new BooleanLiteral(TreeNodes.location(1, 554), "false")), (Object)new VariableDefinition(TreeNodes.location(1, 592), new Identifier(TreeNodes.location(1, 592), "C", false), (Expression)new ComparisonExpression(TreeNodes.location(1, 611), ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCall(TreeNodes.location(1, 597), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 597), "CLASSIFIER", false))), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 608), "U", false))), (Expression)new StringLiteral(TreeNodes.location(1, 613), "B")))))))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
    }

    @Test
    public void testMeasureOverWindow() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("last_z OVER (                           MEASURES z AS last_z                            ROWS CURRENT ROW                            PATTERN (A)                            DEFINE a AS true                          )")))).isEqualTo(new WindowOperation(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "last_z", false), (Window)new WindowSpecification(TreeNodes.location(1, 41), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.of(new WindowFrame(TreeNodes.location(1, 41), WindowFrame.Type.ROWS, new FrameBound(TreeNodes.location(1, 94), FrameBound.Type.CURRENT_ROW), Optional.empty(), (List)ImmutableList.of((Object)new MeasureDefinition(TreeNodes.location(1, 50), (Expression)new Identifier(TreeNodes.location(1, 50), "z", false), new Identifier(TreeNodes.location(1, 55), "last_z", false))), Optional.empty(), Optional.empty(), Optional.of(new PatternVariable(TreeNodes.location(1, 142), new Identifier(TreeNodes.location(1, 142), "A", false))), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new VariableDefinition(TreeNodes.location(1, 179), new Identifier(TreeNodes.location(1, 179), "a", false), (Expression)new BooleanLiteral(TreeNodes.location(1, 184), "true"))))))));
    }

    @Test
    public void testAllRowsReference() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SELECT 1 + A.*", new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.REJECT))).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:13: mismatched input '.'.*");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT A.*")))).ignoringLocation().isEqualTo(QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns((Expression)new Identifier("A"), (List)ImmutableList.of())))));
    }

    @Test
    public void testUpdate() {
        TestSqlParser.assertStatement("UPDATE foo_table\n    SET bar = 23, baz = 3.1415E0, bletch = 'barf'\nWHERE (nothing = 'fun')", (Statement)new Update(new NodeLocation(1, 1), QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo_table")), (List)ImmutableList.of((Object)new UpdateAssignment(new Identifier("bar"), (Expression)new LongLiteral("23")), (Object)new UpdateAssignment(new Identifier("baz"), (Expression)new DoubleLiteral("3.1415")), (Object)new UpdateAssignment(new Identifier("bletch"), (Expression)new StringLiteral("barf"))), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Identifier("nothing"), (Expression)new StringLiteral("fun")))));
    }

    @Test
    public void testWherelessUpdate() {
        TestSqlParser.assertStatement("UPDATE foo_table\n    SET bar = 23", (Statement)new Update(new NodeLocation(1, 1), QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo_table")), (List)ImmutableList.of((Object)new UpdateAssignment(new Identifier("bar"), (Expression)new LongLiteral("23"))), Optional.empty()));
    }

    @Test
    public void testQueryPeriod() {
        TimestampLiteral rangeValue = new TimestampLiteral(TreeNodes.location(1, 37), "2021-03-01 00:00:01");
        QueryPeriod queryPeriod = new QueryPeriod(TreeNodes.location(1, 17), QueryPeriod.RangeType.TIMESTAMP, (Expression)rangeValue);
        Table table = new Table(TreeNodes.location(1, 15), TreeNodes.qualifiedName(TreeNodes.location(1, 15), "t"), queryPeriod);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM t FOR TIMESTAMP AS OF TIMESTAMP '2021-03-01 00:00:01'")))).isEqualTo(new Query(TreeNodes.location(1, 1), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(table), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
        rangeValue = new StringLiteral(TreeNodes.location(1, 35), "version1");
        queryPeriod = new QueryPeriod(new NodeLocation(1, 17), QueryPeriod.RangeType.VERSION, (Expression)rangeValue);
        table = new Table(TreeNodes.location(1, 15), TreeNodes.qualifiedName(TreeNodes.location(1, 15), "t"), queryPeriod);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM t FOR VERSION AS OF 'version1'")))).isEqualTo(new Query(TreeNodes.location(1, 1), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(table), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testListagg() {
        TestSqlParser.assertExpression("LISTAGG(x) WITHIN GROUP (ORDER BY x)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"LISTAGG"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"), (Object)new StringLiteral(""), (Object)new BooleanLiteral("true"), (Object)new StringLiteral("..."), (Object)new BooleanLiteral("false"))));
        TestSqlParser.assertExpression("LISTAGG( DISTINCT x) WITHIN GROUP (ORDER BY x)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"LISTAGG"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), true, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"), (Object)new StringLiteral(""), (Object)new BooleanLiteral("true"), (Object)new StringLiteral("..."), (Object)new BooleanLiteral("false"))));
        TestSqlParser.assertExpression("LISTAGG(x, ',') WITHIN GROUP (ORDER BY y)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"LISTAGG"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("y", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"), (Object)new StringLiteral(","), (Object)new BooleanLiteral("true"), (Object)new StringLiteral("..."), (Object)new BooleanLiteral("false"))));
        TestSqlParser.assertExpression("LISTAGG(x, ',' ON OVERFLOW ERROR) WITHIN GROUP (ORDER BY x)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"LISTAGG"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"), (Object)new StringLiteral(","), (Object)new BooleanLiteral("true"), (Object)new StringLiteral("..."), (Object)new BooleanLiteral("false"))));
        TestSqlParser.assertExpression("LISTAGG(x, ',' ON OVERFLOW TRUNCATE WITH COUNT) WITHIN GROUP (ORDER BY x)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"LISTAGG"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"), (Object)new StringLiteral(","), (Object)new BooleanLiteral("false"), (Object)new StringLiteral("..."), (Object)new BooleanLiteral("true"))));
        TestSqlParser.assertExpression("LISTAGG(x, ',' ON OVERFLOW TRUNCATE 'HIDDEN' WITHOUT COUNT) WITHIN GROUP (ORDER BY x)", (Expression)new FunctionCall(Optional.empty(), QualifiedName.of((String)"LISTAGG"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"), (Object)new StringLiteral(","), (Object)new BooleanLiteral("false"), (Object)new StringLiteral("HIDDEN"), (Object)new BooleanLiteral("false"))));
    }

    @Test
    public void testTableFunctionInvocation() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => 1))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new LongLiteral(TreeNodes.location(1, 39), "1"))), (List)ImmutableList.of())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(                                               arg1 => TABLE(orders) AS ord(a, b, c)                                                                     PARTITION BY a                                                                     PRUNE WHEN EMPTY                                                                     ORDER BY b ASC NULLS LAST,                                                arg2 => CAST(NULL AS DESCRIPTOR),                                                arg3 => DESCRIPTOR(x integer, y varchar),                                                arg4 => 5,                                                'not-named argument'                                                COPARTITION (ord, nation)))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 77), Optional.of(new Identifier(TreeNodes.location(1, 77), "arg1", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(1, 85), (Relation)new AliasedRelation(TreeNodes.location(1, 85), (Relation)new Table(TreeNodes.location(1, 85), TreeNodes.qualifiedName(TreeNodes.location(1, 91), "orders")), new Identifier(TreeNodes.location(1, 102), "ord", false), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 106), "a", false), (Object)new Identifier(TreeNodes.location(1, 109), "b", false), (Object)new Identifier(TreeNodes.location(1, 112), "c", false))), Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 196), "a", false))), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 360), (Expression)new Identifier(TreeNodes.location(1, 360), "b", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)))), Optional.of(new EmptyTableTreatment(TreeNodes.location(1, 266), EmptyTableTreatment.Treatment.PRUNE)))), (Object)new TableFunctionArgument(TreeNodes.location(1, 425), Optional.of(new Identifier(TreeNodes.location(1, 425), "arg2", false)), (Node)TableFunctionDescriptorArgument.nullDescriptorArgument((NodeLocation)TreeNodes.location(1, 433))), (Object)new TableFunctionArgument(TreeNodes.location(1, 506), Optional.of(new Identifier(TreeNodes.location(1, 506), "arg3", false)), (Node)TableFunctionDescriptorArgument.descriptorArgument((NodeLocation)TreeNodes.location(1, 514), (Descriptor)new Descriptor(TreeNodes.location(1, 514), (List)ImmutableList.of((Object)new DescriptorField(TreeNodes.location(1, 525), new Identifier(TreeNodes.location(1, 525), "x", false), Optional.of(new GenericDataType(TreeNodes.location(1, 527), new Identifier(TreeNodes.location(1, 527), "integer", false), (List)ImmutableList.of()))), (Object)new DescriptorField(TreeNodes.location(1, 536), new Identifier(TreeNodes.location(1, 536), "y", false), Optional.of(new GenericDataType(TreeNodes.location(1, 538), new Identifier(TreeNodes.location(1, 538), "varchar", false), (List)ImmutableList.of()))))))), (Object)new TableFunctionArgument(TreeNodes.location(1, 595), Optional.of(new Identifier(TreeNodes.location(1, 595), "arg4", false)), (Node)new LongLiteral(TreeNodes.location(1, 603), "5")), (Object)new TableFunctionArgument(TreeNodes.location(1, 653), Optional.empty(), (Node)new StringLiteral(TreeNodes.location(1, 653), "not-named argument"))), (List)ImmutableList.of((Object)ImmutableList.of((Object)TreeNodes.qualifiedName(TreeNodes.location(1, 734), "ord"), (Object)TreeNodes.qualifiedName(TreeNodes.location(1, 739), "nation"))))));
    }

    @Test
    public void testTableFunctionTableArgumentAliasing() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => TABLE(orders)))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(1, 39), (Relation)new Table(TreeNodes.location(1, 39), TreeNodes.qualifiedName(TreeNodes.location(1, 45), "orders")), Optional.empty(), Optional.empty(), Optional.empty()))), (List)ImmutableList.of())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => TABLE(orders) AS ord))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(1, 39), (Relation)new AliasedRelation(TreeNodes.location(1, 39), (Relation)new Table(TreeNodes.location(1, 39), TreeNodes.qualifiedName(TreeNodes.location(1, 45), "orders")), new Identifier(TreeNodes.location(1, 56), "ord", false), null), Optional.empty(), Optional.empty(), Optional.empty()))), (List)ImmutableList.of())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => TABLE(orders) AS ord(a, b, c)))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(1, 39), (Relation)new AliasedRelation(TreeNodes.location(1, 39), (Relation)new Table(TreeNodes.location(1, 39), TreeNodes.qualifiedName(TreeNodes.location(1, 45), "orders")), new Identifier(TreeNodes.location(1, 56), "ord", false), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 60), "a", false), (Object)new Identifier(TreeNodes.location(1, 63), "b", false), (Object)new Identifier(TreeNodes.location(1, 66), "c", false))), Optional.empty(), Optional.empty(), Optional.empty()))), (List)ImmutableList.of())));
    }

    @Test
    public void testCopartitionInTableArgumentAlias() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SELECT * FROM TABLE(some_ptf( input => TABLE(orders) copartition(a, b, c)))", new ParsingOptions())).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:54: The word \"COPARTITION\" is ambiguous in this context. To alias an argument, precede the alias with \"AS\". To specify co-partitioning, change the argument order so that the last argument cannot be aliased.");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(                    input => TABLE(SELECT * FROM orders copartition(a, b, c))))")))).isInstanceOf(Query.class);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf( input => TABLE(orders) \"COPARTITION\"(a, b, c)))")))).isInstanceOf(Query.class);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf( input => TABLE(orders) AS copartition(a, b, c)))")))).isInstanceOf(Query.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SELECT * FROM TABLE(some_ptf( input1 => TABLE(customers) PARTITION BY nationkey, input2 => TABLE(nation) PARTITION BY nationkey, input3 => TABLE(lineitem) COPARTITION(customers, nation))) ", new ParsingOptions())).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:156: The word \"COPARTITION\" is ambiguous in this context. To alias an argument, precede the alias with \"AS\". To specify co-partitioning, change the argument order so that the last argument cannot be aliased.");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf( input1 => TABLE(customers) PARTITION BY nationkey, input3 => TABLE(lineitem), input2 => TABLE(nation) PARTITION BY nationkey COPARTITION(customers, nation))) ")))).isInstanceOf(Query.class);
    }

    private static Query selectAllFrom(Relation relation) {
        return new Query(TreeNodes.location(1, 1), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(relation), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public void testJsonExists() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_EXISTS(json_column, 'lax $[5]')")))).isEqualTo(new JsonExists(Optional.of(TreeNodes.location(1, 1)), new JsonPathInvocation(Optional.of(TreeNodes.location(1, 13)), (Expression)new Identifier(TreeNodes.location(1, 13), "json_column", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 26), "lax $[5]"), (List)ImmutableList.of()), JsonExists.ErrorBehavior.FALSE));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_EXISTS(                               json_column FORMAT JSON ENCODING UTF8,                                'lax $[start_parameter TO end_parameter.ceiling()]'                                    PASSING                                            start_column AS start_parameter,                                            end_column FORMAT JSON ENCODING UTF16 AS end_parameter                                UNKNOWN ON ERROR)")))).isEqualTo(new JsonExists(Optional.of(TreeNodes.location(1, 1)), new JsonPathInvocation(Optional.of(TreeNodes.location(1, 44)), (Expression)new Identifier(TreeNodes.location(1, 44), "json_column", false), JsonPathParameter.JsonFormat.UTF8, new StringLiteral(TreeNodes.location(1, 114), "lax $[start_parameter TO end_parameter.ceiling()]"), (List)ImmutableList.of((Object)new JsonPathParameter(Optional.of(TreeNodes.location(1, 252)), new Identifier(TreeNodes.location(1, 268), "start_parameter", false), (Expression)new Identifier(TreeNodes.location(1, 252), "start_column", false), Optional.empty()), (Object)new JsonPathParameter(Optional.of(TreeNodes.location(1, 328)), new Identifier(TreeNodes.location(1, 369), "end_parameter", false), (Expression)new Identifier(TreeNodes.location(1, 328), "end_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)))), JsonExists.ErrorBehavior.UNKNOWN));
    }

    @Test
    public void testJsonValue() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_VALUE(json_column, 'lax $[5]')")))).isEqualTo(new JsonValue(Optional.of(TreeNodes.location(1, 1)), new JsonPathInvocation(Optional.of(TreeNodes.location(1, 12)), (Expression)new Identifier(TreeNodes.location(1, 12), "json_column", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 25), "lax $[5]"), (List)ImmutableList.of()), Optional.empty(), JsonValue.EmptyOrErrorBehavior.NULL, Optional.empty(), JsonValue.EmptyOrErrorBehavior.NULL, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_VALUE(                               json_column FORMAT JSON ENCODING UTF8,                                'lax $[start_parameter TO end_parameter.ceiling()]'                                    PASSING                                            start_column AS start_parameter,                                            end_column FORMAT JSON ENCODING UTF16 AS end_parameter                                RETURNING double                                DEFAULT 5e0 ON EMPTY                                ERROR ON ERROR)")))).isEqualTo(new JsonValue(Optional.of(TreeNodes.location(1, 1)), new JsonPathInvocation(Optional.of(TreeNodes.location(1, 43)), (Expression)new Identifier(TreeNodes.location(1, 43), "json_column", false), JsonPathParameter.JsonFormat.UTF8, new StringLiteral(TreeNodes.location(1, 113), "lax $[start_parameter TO end_parameter.ceiling()]"), (List)ImmutableList.of((Object)new JsonPathParameter(Optional.of(TreeNodes.location(1, 251)), new Identifier(TreeNodes.location(1, 267), "start_parameter", false), (Expression)new Identifier(TreeNodes.location(1, 251), "start_column", false), Optional.empty()), (Object)new JsonPathParameter(Optional.of(TreeNodes.location(1, 327)), new Identifier(TreeNodes.location(1, 368), "end_parameter", false), (Expression)new Identifier(TreeNodes.location(1, 327), "end_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)))), Optional.of(new GenericDataType(TreeNodes.location(1, 423), new Identifier(TreeNodes.location(1, 423), "double", false), (List)ImmutableList.of())), JsonValue.EmptyOrErrorBehavior.DEFAULT, Optional.of(new DoubleLiteral(TreeNodes.location(1, 469), "5e0")), JsonValue.EmptyOrErrorBehavior.ERROR, Optional.empty()));
    }

    @Test
    public void testJsonQuery() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_QUERY(json_column, 'lax $[5]')")))).isEqualTo(new JsonQuery(Optional.of(TreeNodes.location(1, 1)), new JsonPathInvocation(Optional.of(TreeNodes.location(1, 12)), (Expression)new Identifier(TreeNodes.location(1, 12), "json_column", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 25), "lax $[5]"), (List)ImmutableList.of()), Optional.empty(), Optional.empty(), JsonQuery.ArrayWrapperBehavior.WITHOUT, Optional.empty(), JsonQuery.EmptyOrErrorBehavior.NULL, JsonQuery.EmptyOrErrorBehavior.NULL));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_QUERY(                               json_column FORMAT JSON ENCODING UTF8,                                'lax $[start_parameter TO end_parameter.ceiling()]'                                    PASSING                                            start_column AS start_parameter,                                            end_column FORMAT JSON ENCODING UTF16 AS end_parameter                                RETURNING varchar FORMAT JSON ENCODING UTF32                                WITH ARRAY WRAPPER                                OMIT QUOTES                                EMPTY ARRAY ON EMPTY                                ERROR ON ERROR)")))).isEqualTo(new JsonQuery(Optional.of(TreeNodes.location(1, 1)), new JsonPathInvocation(Optional.of(TreeNodes.location(1, 43)), (Expression)new Identifier(TreeNodes.location(1, 43), "json_column", false), JsonPathParameter.JsonFormat.UTF8, new StringLiteral(TreeNodes.location(1, 113), "lax $[start_parameter TO end_parameter.ceiling()]"), (List)ImmutableList.of((Object)new JsonPathParameter(Optional.of(TreeNodes.location(1, 251)), new Identifier(TreeNodes.location(1, 267), "start_parameter", false), (Expression)new Identifier(TreeNodes.location(1, 251), "start_column", false), Optional.empty()), (Object)new JsonPathParameter(Optional.of(TreeNodes.location(1, 327)), new Identifier(TreeNodes.location(1, 368), "end_parameter", false), (Expression)new Identifier(TreeNodes.location(1, 327), "end_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)))), Optional.of(new GenericDataType(TreeNodes.location(1, 423), new Identifier(TreeNodes.location(1, 423), "varchar", false), (List)ImmutableList.of())), Optional.of(JsonPathParameter.JsonFormat.UTF32), JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL, Optional.of(JsonQuery.QuotesBehavior.OMIT), JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY, JsonQuery.EmptyOrErrorBehavior.ERROR));
    }

    @Test
    public void testJsonObject() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_OBJECT()")))).isEqualTo(new JsonObject(Optional.of(TreeNodes.location(1, 1)), (List)ImmutableList.of(), true, false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_OBJECT(key_column : value_column)")))).isEqualTo(new JsonObject(Optional.of(TreeNodes.location(1, 1)), (List)ImmutableList.of((Object)new JsonObjectMember(TreeNodes.location(1, 13), (Expression)new Identifier(TreeNodes.location(1, 13), "key_column", false), (Expression)new Identifier(TreeNodes.location(1, 26), "value_column", false), Optional.empty())), true, false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_OBJECT(                                key_column_1 VALUE value_column FORMAT JSON ENCODING UTF16,                                KEY 'key_literal' VALUE 5,                                key_column_2 : null                                ABSENT ON NULL                                WITH UNIQUE KEYS                                RETURNING varbinary FORMAT JSON ENCODING UTF32                               )")))).isEqualTo(new JsonObject(Optional.of(TreeNodes.location(1, 1)), (List)ImmutableList.of((Object)new JsonObjectMember(TreeNodes.location(1, 45), (Expression)new Identifier(TreeNodes.location(1, 45), "key_column_1", false), (Expression)new Identifier(TreeNodes.location(1, 64), "value_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)), (Object)new JsonObjectMember(TreeNodes.location(1, 136), (Expression)new StringLiteral(TreeNodes.location(1, 140), "key_literal"), (Expression)new LongLiteral(TreeNodes.location(1, 160), "5"), Optional.empty()), (Object)new JsonObjectMember(TreeNodes.location(1, 194), (Expression)new Identifier(TreeNodes.location(1, 194), "key_column_2", false), (Expression)new NullLiteral(TreeNodes.location(1, 209)), Optional.empty())), false, true, Optional.of(new GenericDataType(TreeNodes.location(1, 349), new Identifier(TreeNodes.location(1, 349), "varbinary", false), (List)ImmutableList.of())), Optional.of(JsonPathParameter.JsonFormat.UTF32)));
    }

    @Test
    public void testJsonArray() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_ARRAY()")))).isEqualTo(new JsonArray(Optional.of(TreeNodes.location(1, 1)), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_ARRAY(value_column)")))).isEqualTo(new JsonArray(Optional.of(TreeNodes.location(1, 1)), (List)ImmutableList.of((Object)new JsonArrayElement(TreeNodes.location(1, 12), (Expression)new Identifier(TreeNodes.location(1, 12), "value_column", false), Optional.empty())), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_ARRAY(value_column FORMAT JSON ENCODING UTF16,                                5,                                null                                NULL ON NULL                                RETURNING varbinary FORMAT JSON ENCODING UTF32                               )")))).isEqualTo(new JsonArray(Optional.of(TreeNodes.location(1, 1)), (List)ImmutableList.of((Object)new JsonArrayElement(TreeNodes.location(1, 12), (Expression)new Identifier(TreeNodes.location(1, 12), "value_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)), (Object)new JsonArrayElement(TreeNodes.location(1, 84), (Expression)new LongLiteral(TreeNodes.location(1, 84), "5"), Optional.empty()), (Object)new JsonArrayElement(TreeNodes.location(1, 118), (Expression)new NullLiteral(TreeNodes.location(1, 118)), Optional.empty())), true, Optional.of(new GenericDataType(TreeNodes.location(1, 208), new Identifier(TreeNodes.location(1, 208), "varbinary", false), (List)ImmutableList.of())), Optional.of(JsonPathParameter.JsonFormat.UTF32)));
    }

    private static QualifiedName makeQualifiedName(String tableName) {
        List parts = (List)Splitter.on((char)'.').splitToList((CharSequence)tableName).stream().map(Identifier::new).collect(ImmutableList.toImmutableList());
        return QualifiedName.of((Iterable)parts);
    }

    @Deprecated
    private static void assertStatement(@Language(value="SQL") String query, Statement expected) {
        TestSqlParser.assertParsed(query, (Node)expected, (Node)SQL_PARSER.createStatement(query, new ParsingOptions()));
        TreeAssertions.assertFormattedSql((SqlParser)SQL_PARSER, (Node)expected);
    }

    @Deprecated
    private static void assertExpression(@Language(value="SQL") String expression, Expression expected) {
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(expected, "expected is null");
        TestSqlParser.assertParsed(expression, (Node)expected, (Node)SQL_PARSER.createExpression(expression, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL)));
    }

    private static void assertParsed(String input, Node expected, Node parsed) {
        if (!parsed.equals((Object)expected)) {
            org.junit.jupiter.api.Assertions.fail((String)String.format("expected\n\n%s\n\nto parse as\n\n%s\n\nbut was\n\n%s\n", TestSqlParser.indent(input), TestSqlParser.indent(SqlFormatter.formatSql((Node)expected)), TestSqlParser.indent(SqlFormatter.formatSql((Node)parsed))));
        }
    }

    private static void assertInvalidExpression(String expression, String expectedErrorMessageRegex) {
        ParserAssert.assertExpressionIsInvalid(expression).withMessageMatching("line \\d+:\\d+: " + expectedErrorMessageRegex);
    }

    private static String indent(String value) {
        String indent = "    ";
        return indent + value.trim().replaceAll("\n", "\n" + indent);
    }

    private static Expression createExpression(String expression) {
        return SQL_PARSER.createExpression(expression, new ParsingOptions());
    }
}

