/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import io.trino.sql.ExpressionFormatter;
import io.trino.sql.parser.ParserAssert;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.IntervalLiteral;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionFormatter {
    @Test
    public void testIntervalLiteral() {
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR), "INTERVAL '2' HOUR");
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR), "INTERVAL -'2' HOUR");
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.SECOND)), "INTERVAL '2' HOUR TO SECOND");
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.SECOND)), "INTERVAL -'2' HOUR TO SECOND");
    }

    private void assertFormattedExpression(Expression expression, String expected) {
        ((AbstractStringAssert)Assertions.assertThat((String)ExpressionFormatter.formatExpression((Expression)expression)).as("formatted expression", new Object[0])).isEqualTo(expected);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(expected)))).ignoringLocation().isEqualTo(expression);
    }
}

