/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import io.trino.sql.SqlFormatter;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSqlFormatter {
    @Test
    public void testIdentifiers() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("exists", false))).isEqualTo("\"exists\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("exists", true))).isEqualTo("\"exists\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"exists\"", true))).isEqualTo("\"\"\"exists\"\"\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("analyze", false))).isEqualTo("analyze");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("analyze", true))).isEqualTo("\"analyze\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"analyze\"", true))).isEqualTo("\"\"\"analyze\"\"\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("account", false))).isEqualTo("account");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("account", true))).isEqualTo("\"account\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"account\"", true))).isEqualTo("\"\"\"account\"\"\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("1", true))).isEqualTo("\"1\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"1\"", true))).isEqualTo("\"\"\"1\"\"\"");
    }

    @Test
    public void testCreateTable() {
        BiFunction<String, String, CreateTable> createTable = (tableName, columnName) -> {
            NodeLocation location = new NodeLocation(1, 1);
            Identifier type = new Identifier(location, "VARCHAR", false);
            return new CreateTable(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(tableName, false))), (List)ImmutableList.of((Object)new ColumnDefinition(new Identifier(columnName, false), (DataType)new GenericDataType(location, type, (List)ImmutableList.of()), true, (List)ImmutableList.of(), Optional.empty())), false, (List)ImmutableList.of(), Optional.empty());
        };
        String createTableSql = "CREATE TABLE %s (\n   %s VARCHAR\n)";
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)((Node)createTable.apply("table_name", "column_name")))).isEqualTo(String.format(createTableSql, "table_name", "column_name"));
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)((Node)createTable.apply("exists", "exists")))).isEqualTo(String.format(createTableSql, "\"exists\"", "\"exists\""));
    }
}

