/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.parser.StatementSplitter;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatementSplitter {
    @Test
    public void testSplitterIncomplete() {
        StatementSplitter splitter = new StatementSplitter(" select * FROM foo  ");
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"select * FROM foo", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterEmptyInput() {
        StatementSplitter splitter = new StatementSplitter("");
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterEmptyStatements() {
        StatementSplitter splitter = new StatementSplitter(";;;");
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterSingle() {
        StatementSplitter splitter = new StatementSplitter("select * from foo;");
        Assertions.assertEquals(TestStatementSplitter.statements("select * from foo", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterMultiple() {
        StatementSplitter splitter = new StatementSplitter(" select * from  foo ; select * from t; select * from ");
        Assertions.assertEquals(TestStatementSplitter.statements("select * from  foo", ";", "select * from t", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"select * from", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterMultipleWithEmpty() {
        StatementSplitter splitter = new StatementSplitter("; select * from  foo ; select * from t;;;select * from ");
        Assertions.assertEquals(TestStatementSplitter.statements("select * from  foo", ";", "select * from t", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"select * from", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterCustomDelimiters() {
        String sql = "// select * from  foo // select * from t;//select * from ";
        StatementSplitter splitter = new StatementSplitter(sql, (Set)ImmutableSet.of((Object)";", (Object)"//"));
        Assertions.assertEquals(TestStatementSplitter.statements("select * from  foo", "//", "select * from t", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"select * from", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterErrorBeforeComplete() {
        StatementSplitter splitter = new StatementSplitter(" select * from z# oops ; select ");
        Assertions.assertEquals(TestStatementSplitter.statements("select * from z# oops", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"select", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterErrorAfterComplete() {
        StatementSplitter splitter = new StatementSplitter("select * from foo; select z# oops ");
        Assertions.assertEquals(TestStatementSplitter.statements("select * from foo", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"select z# oops", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithQuotedString() {
        String sql = "select 'foo bar' x from dual";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)sql, (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithIncompleteQuotedString() {
        String sql = "select 'foo', 'bar";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)sql, (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithEscapedSingleQuote() {
        String sql = "select 'hello''world' from dual";
        StatementSplitter splitter = new StatementSplitter(sql + ";");
        Assertions.assertEquals(TestStatementSplitter.statements(sql, ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithQuotedIdentifier() {
        String sql = "select \"0\"\"bar\" from dual";
        StatementSplitter splitter = new StatementSplitter(sql + ";");
        Assertions.assertEquals(TestStatementSplitter.statements(sql, ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithBackquote() {
        String sql = "select  ` f``o o ` from dual";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)sql, (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithDigitIdentifier() {
        String sql = "select   1x  from dual";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)sql, (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithSingleLineComment() {
        StatementSplitter splitter = new StatementSplitter("--empty\n;-- start\nselect * -- junk\n-- hi\nfrom foo; -- done");
        Assertions.assertEquals(TestStatementSplitter.statements("--empty", ";", "-- start\nselect * -- junk\n-- hi\nfrom foo", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"-- done", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithMultiLineComment() {
        StatementSplitter splitter = new StatementSplitter("/* empty */;/* start */ select * /* middle */ from foo; /* end */");
        Assertions.assertEquals(TestStatementSplitter.statements("/* empty */", ";", "/* start */ select * /* middle */ from foo", ";"), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)"/* end */", (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithSingleLineCommentPartial() {
        String sql = "-- start\nselect * -- junk\n-- hi\nfrom foo -- done";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)sql, (Object)splitter.getPartialStatement());
    }

    @Test
    public void testSplitterWithMultiLineCommentPartial() {
        String sql = "/* start */ select * /* middle */ from foo /* end */";
        StatementSplitter splitter = new StatementSplitter(sql);
        Assertions.assertEquals((Object)ImmutableList.of(), (Object)splitter.getCompleteStatements());
        Assertions.assertEquals((Object)sql, (Object)splitter.getPartialStatement());
    }

    @Test
    public void testIsEmptyStatement() {
        Assertions.assertTrue((boolean)StatementSplitter.isEmptyStatement((String)""));
        Assertions.assertTrue((boolean)StatementSplitter.isEmptyStatement((String)" "));
        Assertions.assertTrue((boolean)StatementSplitter.isEmptyStatement((String)"\t\n "));
        Assertions.assertTrue((boolean)StatementSplitter.isEmptyStatement((String)"--foo\n  --what"));
        Assertions.assertTrue((boolean)StatementSplitter.isEmptyStatement((String)"/* oops */"));
        Assertions.assertFalse((boolean)StatementSplitter.isEmptyStatement((String)"x"));
        Assertions.assertFalse((boolean)StatementSplitter.isEmptyStatement((String)"select"));
        Assertions.assertFalse((boolean)StatementSplitter.isEmptyStatement((String)"123"));
        Assertions.assertFalse((boolean)StatementSplitter.isEmptyStatement((String)"z#oops"));
    }

    @Test
    public void testSqueezeStatement() {
        String sql = "select   *  from\n foo\n  order by x ; ";
        Assertions.assertEquals((Object)"select * from foo order by x ;", (Object)StatementSplitter.squeezeStatement((String)sql));
    }

    @Test
    public void testSqueezeStatementWithIncompleteQuotedString() {
        String sql = "select   *  from\n foo\n  where x = 'oops";
        Assertions.assertEquals((Object)"select * from foo where x = 'oops", (Object)StatementSplitter.squeezeStatement((String)sql));
    }

    @Test
    public void testSqueezeStatementWithBackquote() {
        String sql = "select  `  f``o  o`` `   from dual";
        Assertions.assertEquals((Object)"select `  f``o  o`` ` from dual", (Object)StatementSplitter.squeezeStatement((String)sql));
    }

    @Test
    public void testSqueezeStatementAlternateDelimiter() {
        String sql = "select   *  from\n foo\n  order by x // ";
        Assertions.assertEquals((Object)"select * from foo order by x //", (Object)StatementSplitter.squeezeStatement((String)sql));
    }

    @Test
    public void testSqueezeStatementError() {
        String sql = "select   *  from z#oops";
        Assertions.assertEquals((Object)"select * from z#oops", (Object)StatementSplitter.squeezeStatement((String)sql));
    }

    private static List<StatementSplitter.Statement> statements(String ... args) {
        Preconditions.checkArgument((args.length % 2 == 0 ? 1 : 0) != 0, (Object)"arguments not paired");
        ImmutableList.Builder list = ImmutableList.builder();
        for (int i = 0; i < args.length; i += 2) {
            list.add((Object)new StatementSplitter.Statement(args[i], args[i + 1]));
        }
        return list.build();
    }
}

