/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Cast
extends Expression {
    private final Expression expression;
    private final DataType type;
    private final boolean safe;
    private final boolean typeOnly;

    public Cast(Expression expression, DataType type) {
        this(Optional.empty(), expression, type, false, false);
    }

    public Cast(Expression expression, DataType type, boolean safe) {
        this(Optional.empty(), expression, type, safe, false);
    }

    public Cast(Expression expression, DataType type, boolean safe, boolean typeOnly) {
        this(Optional.empty(), expression, type, safe, typeOnly);
    }

    public Cast(NodeLocation location, Expression expression, DataType type) {
        this(Optional.of(location), expression, type, false, false);
    }

    public Cast(NodeLocation location, Expression expression, DataType type, boolean safe) {
        this(Optional.of(location), expression, type, safe, false);
    }

    private Cast(Optional<NodeLocation> location, Expression expression, DataType type, boolean safe, boolean typeOnly) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        this.expression = expression;
        this.type = type;
        this.safe = safe;
        this.typeOnly = typeOnly;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public boolean isTypeOnly() {
        return this.typeOnly;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.expression, (Object)this.type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cast cast = (Cast)o;
        return this.safe == cast.safe && this.typeOnly == cast.typeOnly && this.expression.equals(cast.expression) && this.type.equals(cast.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.safe, this.typeOnly);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Cast.sameClass(this, other)) {
            return false;
        }
        Cast otherCast = (Cast)other;
        return this.safe == otherCast.safe && this.typeOnly == otherCast.typeOnly;
    }
}

