/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WindowOperation
extends Expression {
    private final Identifier name;
    private final Window window;

    public WindowOperation(Identifier name, Window window) {
        this(Optional.empty(), name, window);
    }

    public WindowOperation(NodeLocation location, Identifier name, Window window) {
        this(Optional.of(location), name, window);
    }

    private WindowOperation(Optional<NodeLocation> location, Identifier name, Window window) {
        super(location);
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(window, "window is null");
        Preconditions.checkArgument((window instanceof WindowReference || window instanceof WindowSpecification ? 1 : 0) != 0, (String)"unexpected window: %s", (Object)window.getClass().getSimpleName());
        this.name = name;
        this.window = window;
    }

    public Identifier getName() {
        return this.name;
    }

    public Window getWindow() {
        return this.window;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowOperation(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.name, (Object)((Node)((Object)this.window)));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowOperation o = (WindowOperation)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.window, o.window);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.window);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return WindowOperation.sameClass(this, other);
    }
}

