/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;

public final class AssignmentStatement
extends ControlStatement {
    private final Identifier target;
    private final Expression value;

    public AssignmentStatement(NodeLocation location, Identifier target, Expression value) {
        super(location);
        this.target = Objects.requireNonNull(target, "target is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public Identifier getTarget() {
        return this.target;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAssignmentStatement(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AssignmentStatement)) return false;
        AssignmentStatement other = (AssignmentStatement)obj;
        if (!Objects.equals(this.target, other.target)) return false;
        if (!Objects.equals(this.value, other.value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.target, this.value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("target", (Object)this.target).add("value", (Object)this.value).toString();
    }
}

