/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.GrantObject;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Deny
extends Statement {
    private final Optional<List<String>> privileges;
    private final GrantObject grantObject;
    private final PrincipalSpecification grantee;

    public Deny(Optional<List<String>> privileges, GrantObject grantObject, PrincipalSpecification grantee) {
        this(Optional.empty(), privileges, grantObject, grantee);
    }

    public Deny(NodeLocation location, Optional<List<String>> privileges, GrantObject grantObject, PrincipalSpecification grantee) {
        this(Optional.of(location), privileges, grantObject, grantee);
    }

    private Deny(Optional<NodeLocation> location, Optional<List<String>> privileges, GrantObject grantObject, PrincipalSpecification grantee) {
        super(location);
        Objects.requireNonNull(privileges, "privileges is null");
        this.privileges = privileges.map(ImmutableList::copyOf);
        this.grantObject = Objects.requireNonNull(grantObject, "grantScope is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    public Optional<List<String>> getPrivileges() {
        return this.privileges;
    }

    public GrantObject getGrantObject() {
        return this.grantObject;
    }

    public PrincipalSpecification getGrantee() {
        return this.grantee;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDeny(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.privileges, this.grantObject, this.grantee);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Deny o = (Deny)obj;
        return Objects.equals(this.privileges, o.privileges) && Objects.equals(this.grantObject, o.grantObject) && Objects.equals(this.grantee, o.grantee);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("privileges", this.privileges).add("grantScope", (Object)this.grantObject).add("grantee", (Object)this.grantee).toString();
    }
}

