/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import io.trino.sql.ExpressionFormatter;
import io.trino.sql.parser.ParserAssert;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.StringLiteral;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionFormatter {
    @Test
    public void testIdentifier() {
        this.assertFormattedExpression((Expression)new Identifier("abc"), "abc");
        this.assertFormattedExpression((Expression)new Identifier("with a space"), "\"with a space\"");
        this.assertFormattedExpression((Expression)new Identifier("with \" quote, $ dollar and ' apostrophe"), "\"with \"\" quote, $ dollar and ' apostrophe\"");
    }

    @Test
    public void testStringLiteral() {
        this.assertFormattedExpression((Expression)new StringLiteral("test"), "'test'");
        this.assertFormattedExpression((Expression)new StringLiteral("\u653b\u6bbb\u6a5f\u52d5\u968a"), "'\u653b\u6bbb\u6a5f\u52d5\u968a'");
        this.assertFormattedExpression((Expression)new StringLiteral("\ud83d\ude02"), "'\ud83d\ude02'");
    }

    @Test
    public void testCharLiteral() {
        this.assertFormattedExpression((Expression)new GenericLiteral("CHAR", "test"), "CHAR 'test'");
        this.assertFormattedExpression((Expression)new GenericLiteral("CHAR", "\u653b\u6bbb\u6a5f\u52d5\u968a"), "CHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'");
        this.assertFormattedExpression((Expression)new GenericLiteral("CHAR", "\ud83d\ude02"), "CHAR '\ud83d\ude02'");
    }

    @Test
    public void testGenericLiteral() {
        this.assertFormattedExpression((Expression)new GenericLiteral("VARCHAR", "test"), "VARCHAR 'test'");
        this.assertFormattedExpression((Expression)new GenericLiteral("VARCHAR", "\u653b\u6bbb\u6a5f\u52d5\u968a"), "VARCHAR '\u653b\u6bbb\u6a5f\u52d5\u968a'");
        this.assertFormattedExpression((Expression)new GenericLiteral("VARCHAR", "\ud83d\ude02"), "VARCHAR '\ud83d\ude02'");
    }

    @Test
    public void testIntervalLiteral() {
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR), "INTERVAL '2' HOUR");
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR), "INTERVAL -'2' HOUR");
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.SECOND)), "INTERVAL '2' HOUR TO SECOND");
        this.assertFormattedExpression((Expression)new IntervalLiteral("2", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.SECOND)), "INTERVAL -'2' HOUR TO SECOND");
    }

    private void assertFormattedExpression(Expression expression, String expected) {
        ((AbstractStringAssert)Assertions.assertThat((String)ExpressionFormatter.formatExpression((Expression)expression)).as("formatted expression", new Object[0])).isEqualTo(expected);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(expected)))).ignoringLocation().isEqualTo(expression);
    }
}

