/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableList;
import io.trino.sql.QueryUtil;
import io.trino.sql.SqlFormatter;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.ExecuteImmediate;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.StringLiteral;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSqlFormatter {
    @Test
    public void testShowCatalogs() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowCatalogs(Optional.empty(), Optional.empty()))).isEqualTo("SHOW CATALOGS");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowCatalogs(Optional.of("%"), Optional.empty()))).isEqualTo("SHOW CATALOGS LIKE '%'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowCatalogs(Optional.of("%$_%"), Optional.of("$")))).isEqualTo("SHOW CATALOGS LIKE '%$_%' ESCAPE '$'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowCatalogs(Optional.of("%\u6a5f\u52d5\u968a"), Optional.of("\ud83d\ude02")))).isEqualTo("SHOW CATALOGS LIKE '%\u6a5f\u52d5\u968a' ESCAPE '\ud83d\ude02'");
    }

    @Test
    public void testShowSchemas() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSchemas(Optional.empty(), Optional.empty(), Optional.empty()))).isEqualTo("SHOW SCHEMAS");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSchemas(Optional.empty(), Optional.of("%"), Optional.empty()))).isEqualTo("SHOW SCHEMAS LIKE '%'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSchemas(Optional.empty(), Optional.of("%$_%"), Optional.of("$")))).isEqualTo("SHOW SCHEMAS LIKE '%$_%' ESCAPE '$'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSchemas(Optional.empty(), Optional.of("%\u6a5f\u52d5\u968a"), Optional.of("\ud83d\ude02")))).isEqualTo("SHOW SCHEMAS LIKE '%\u6a5f\u52d5\u968a' ESCAPE '\ud83d\ude02'");
    }

    @Test
    public void testShowTables() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowTables(Optional.empty(), Optional.empty(), Optional.empty()))).isEqualTo("SHOW TABLES");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowTables(Optional.empty(), Optional.of("%"), Optional.empty()))).isEqualTo("SHOW TABLES LIKE '%'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowTables(Optional.empty(), Optional.of("%$_%"), Optional.of("$")))).isEqualTo("SHOW TABLES LIKE '%$_%' ESCAPE '$'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowTables(Optional.empty(), Optional.of("%\u6a5f\u52d5\u968a"), Optional.of("\ud83d\ude02")))).isEqualTo("SHOW TABLES LIKE '%\u6a5f\u52d5\u968a' ESCAPE '\ud83d\ude02'");
    }

    @Test
    public void testShowColumns() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowColumns(QualifiedName.of((String)"a"), Optional.empty(), Optional.empty()))).isEqualTo("SHOW COLUMNS FROM a");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowColumns(QualifiedName.of((String)"a"), Optional.of("%"), Optional.empty()))).isEqualTo("SHOW COLUMNS FROM a LIKE '%'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowColumns(QualifiedName.of((String)"a"), Optional.of("%$_%"), Optional.of("$")))).isEqualTo("SHOW COLUMNS FROM a LIKE '%$_%' ESCAPE '$'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowColumns(QualifiedName.of((String)"a"), Optional.of("%\u6a5f\u52d5\u968a"), Optional.of("\ud83d\ude02")))).isEqualTo("SHOW COLUMNS FROM a LIKE '%\u6a5f\u52d5\u968a' ESCAPE '\ud83d\ude02'");
    }

    @Test
    public void testShowFunctions() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowFunctions(Optional.empty(), Optional.empty(), Optional.empty()))).isEqualTo("SHOW FUNCTIONS");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowFunctions(Optional.empty(), Optional.of("%"), Optional.empty()))).isEqualTo("SHOW FUNCTIONS LIKE '%'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowFunctions(Optional.empty(), Optional.of("%$_%"), Optional.of("$")))).isEqualTo("SHOW FUNCTIONS LIKE '%$_%' ESCAPE '$'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowFunctions(Optional.empty(), Optional.of("%\u6a5f\u52d5\u968a"), Optional.of("\ud83d\ude02")))).isEqualTo("SHOW FUNCTIONS LIKE '%\u6a5f\u52d5\u968a' ESCAPE '\ud83d\ude02'");
    }

    @Test
    public void testShowSession() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSession(Optional.empty(), Optional.empty()))).isEqualTo("SHOW SESSION");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSession(Optional.of("%"), Optional.empty()))).isEqualTo("SHOW SESSION LIKE '%'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSession(Optional.of("%$_%"), Optional.of("$")))).isEqualTo("SHOW SESSION LIKE '%$_%' ESCAPE '$'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ShowSession(Optional.of("%\u6a5f\u52d5\u968a"), Optional.of("\ud83d\ude02")))).isEqualTo("SHOW SESSION LIKE '%\u6a5f\u52d5\u968a' ESCAPE '\ud83d\ude02'");
    }

    @Test
    public void testIdentifiers() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("exists", false))).isEqualTo("\"exists\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("exists", true))).isEqualTo("\"exists\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"exists\"", true))).isEqualTo("\"\"\"exists\"\"\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("analyze", false))).isEqualTo("analyze");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("analyze", true))).isEqualTo("\"analyze\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"analyze\"", true))).isEqualTo("\"\"\"analyze\"\"\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("account", false))).isEqualTo("account");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("account", true))).isEqualTo("\"account\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"account\"", true))).isEqualTo("\"\"\"account\"\"\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("1", true))).isEqualTo("\"1\"");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Identifier("\"1\"", true))).isEqualTo("\"\"\"1\"\"\"");
    }

    @Test
    public void testCreateCatalog() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateCatalog(new Identifier("test"), false, new Identifier("conn"), (List)ImmutableList.of(), Optional.empty(), Optional.empty()))).isEqualTo("CREATE CATALOG test USING conn");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateCatalog(new Identifier("test"), false, new Identifier("conn"), (List)ImmutableList.of(), Optional.empty(), Optional.of("test comment")))).isEqualTo("CREATE CATALOG test USING conn\nCOMMENT 'test comment'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateCatalog(new Identifier("test"), false, new Identifier("conn"), (List)ImmutableList.of(), Optional.empty(), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")))).isEqualTo("CREATE CATALOG test USING conn\nCOMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a'");
    }

    @Test
    public void testCreateTable() {
        BiFunction<String, String, CreateTable> createTable = (tableName, columnName) -> {
            NodeLocation location = new NodeLocation(1, 1);
            Identifier type = new Identifier(location, "VARCHAR", false);
            return new CreateTable(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(tableName, false))), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)columnName), (DataType)new GenericDataType(location, type, (List)ImmutableList.of()), true, (List)ImmutableList.of(), Optional.empty())), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty());
        };
        String createTableSql = "CREATE TABLE %s (\n   %s VARCHAR\n)";
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)((Node)createTable.apply("table_name", "column_name")))).isEqualTo(createTableSql.formatted("table_name", "column_name"));
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)((Node)createTable.apply("exists", "exists")))).isEqualTo(createTableSql.formatted("\"exists\"", "\"exists\""));
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateTable(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("test", false))), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"col"), (DataType)new GenericDataType(new NodeLocation(1, 1), new Identifier("VARCHAR", false), (List)ImmutableList.of()), true, (List)ImmutableList.of(), Optional.empty())), SaveMode.FAIL, (List)ImmutableList.of(), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")))).isEqualTo("CREATE TABLE test (\n   col VARCHAR\n)\nCOMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateTable(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("test", false))), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"col"), (DataType)new GenericDataType(new NodeLocation(1, 1), new Identifier("VARCHAR", false), (List)ImmutableList.of()), true, (List)ImmutableList.of(), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a"))), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty()))).isEqualTo("CREATE TABLE test (\n   col VARCHAR COMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a'\n)");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateTable(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("test", false))), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"col"), (DataType)new GenericDataType(Optional.empty(), new Identifier("VARCHAR"), (List)ImmutableList.of()), false, (List)ImmutableList.of((Object)new Property(new Identifier("abc"), (Expression)new StringLiteral("test")), (Object)new Property(new Identifier("xyz"))), Optional.empty())), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty()))).isEqualTo("CREATE TABLE test (\n   col VARCHAR NOT NULL WITH (abc = 'test', xyz = DEFAULT)\n)");
    }

    @Test
    public void testCreateTableAsSelect() {
        BiFunction<String, String, CreateTableAsSelect> createTableAsSelect = (tableName, columnName) -> {
            Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
            return new CreateTableAsSelect(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(tableName, false))), query, SaveMode.FAIL, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier(columnName, false))), Optional.empty());
        };
        String createTableSql = "CREATE TABLE %s( %s ) AS SELECT *\nFROM\n  t\n";
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)((Node)createTableAsSelect.apply("table_name", "column_name")))).isEqualTo(createTableSql.formatted("table_name", "column_name"));
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)((Node)createTableAsSelect.apply("exists", "exists")))).isEqualTo(createTableSql.formatted("\"exists\"", "\"exists\""));
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateTableAsSelect(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("test", false))), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), SaveMode.FAIL, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier("col", false))), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")))).isEqualTo("CREATE TABLE test( col )\nCOMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a' AS SELECT *\nFROM\n  t\n");
    }

    @Test
    public void testCreateView() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateView(new NodeLocation(1, 1), QualifiedName.of((String)"test"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()))).isEqualTo("CREATE VIEW test AS\nSELECT *\nFROM\n  t\n");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateView(new NodeLocation(1, 1), QualifiedName.of((String)"test"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), false, Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a"), Optional.empty(), (List)ImmutableList.of()))).isEqualTo("CREATE VIEW test COMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a' AS\nSELECT *\nFROM\n  t\n");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateView(new NodeLocation(1, 1), QualifiedName.of((String)"test"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Property(new Identifier("property_1"), (Expression)new StringLiteral("property_value")), (Object)new Property(new Identifier("property_2"), (Expression)new StringLiteral("another_value")))))).isEqualTo("CREATE VIEW test\nWITH (\n   property_1 = 'property_value',\n   property_2 = 'another_value'\n) AS\nSELECT *\nFROM\n  t\n");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateView(new NodeLocation(1, 1), QualifiedName.of((String)"test"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), false, Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a"), Optional.of(CreateView.Security.DEFINER), (List)ImmutableList.of((Object)new Property(new Identifier("property"), (Expression)new StringLiteral("property_value")))))).isEqualTo("CREATE VIEW test COMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a' SECURITY DEFINER\nWITH (\n   property = 'property_value'\n) AS\nSELECT *\nFROM\n  t\n");
    }

    @Test
    public void testCreateMaterializedView() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test_base"))), false, false, Optional.empty(), (List)ImmutableList.of(), Optional.empty()))).isEqualTo("CREATE MATERIALIZED VIEW test_mv AS\nSELECT *\nFROM\n  test_base\n");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new CreateMaterializedView(Optional.empty(), QualifiedName.of((String)"test_mv"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"test_base"))), false, false, Optional.empty(), (List)ImmutableList.of(), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")))).isEqualTo("CREATE MATERIALIZED VIEW test_mv\nCOMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a' AS\nSELECT *\nFROM\n  test_base\n");
    }

    @Test
    public void testAddColumn() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new AddColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"c"), (DataType)new GenericDataType(new NodeLocation(1, 1), new Identifier("VARCHAR", false), (List)ImmutableList.of()), true, Collections.emptyList(), Optional.empty()), false, false))).isEqualTo("ALTER TABLE foo.t ADD COLUMN c VARCHAR");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new AddColumn(QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"c"), (DataType)new GenericDataType(new NodeLocation(1, 1), new Identifier("VARCHAR", false), (List)ImmutableList.of()), true, Collections.emptyList(), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")), false, false))).isEqualTo("ALTER TABLE foo.t ADD COLUMN c VARCHAR COMMENT '\u653b\u6bbb\u6a5f\u52d5\u968a'");
    }

    @Test
    public void testCommentOnTable() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Comment(Comment.Type.TABLE, QualifiedName.of((String)"a"), Optional.of("test")))).isEqualTo("COMMENT ON TABLE a IS 'test'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Comment(Comment.Type.TABLE, QualifiedName.of((String)"a"), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")))).isEqualTo("COMMENT ON TABLE a IS '\u653b\u6bbb\u6a5f\u52d5\u968a'");
    }

    @Test
    public void testCommentOnView() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Comment(Comment.Type.VIEW, QualifiedName.of((String)"a"), Optional.of("test")))).isEqualTo("COMMENT ON VIEW a IS 'test'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Comment(Comment.Type.VIEW, QualifiedName.of((String)"a"), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")))).isEqualTo("COMMENT ON VIEW a IS '\u653b\u6bbb\u6a5f\u52d5\u968a'");
    }

    @Test
    public void testCommentOnColumn() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"test", (String[])new String[]{"a"}), Optional.of("test")))).isEqualTo("COMMENT ON COLUMN test.a IS 'test'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new Comment(Comment.Type.COLUMN, QualifiedName.of((String)"test", (String[])new String[]{"a"}), Optional.of("\u653b\u6bbb\u6a5f\u52d5\u968a")))).isEqualTo("COMMENT ON COLUMN test.a IS '\u653b\u6bbb\u6a5f\u52d5\u968a'");
    }

    @Test
    public void testExecuteImmediate() {
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ExecuteImmediate(new NodeLocation(1, 1), new StringLiteral(new NodeLocation(1, 19), "SELECT * FROM foo WHERE col1 = ? AND col2 = ?"), (List)ImmutableList.of((Object)new LongLiteral("42"), (Object)new StringLiteral("bar"))))).isEqualTo("EXECUTE IMMEDIATE\n'SELECT * FROM foo WHERE col1 = ? AND col2 = ?'\nUSING 42, 'bar'");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ExecuteImmediate(new NodeLocation(1, 1), new StringLiteral(new NodeLocation(1, 19), "SELECT * FROM foo WHERE col1 = 'bar'"), (List)ImmutableList.of()))).isEqualTo("EXECUTE IMMEDIATE\n'SELECT * FROM foo WHERE col1 = ''bar'''");
        Assertions.assertThat((String)SqlFormatter.formatSql((Node)new ExecuteImmediate(new NodeLocation(1, 1), new StringLiteral(new NodeLocation(1, 19), "SELECT * FROM foo WHERE col1 = '\u653b\u6bbb\u6a5f\u52d5\u968a'"), (List)ImmutableList.of()))).isEqualTo("EXECUTE IMMEDIATE\n'SELECT * FROM foo WHERE col1 = ''\u653b\u6bbb\u6a5f\u52d5\u968a'''");
    }
}

