/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath;

import com.google.common.collect.ImmutableList;
import io.trino.sql.jsonpath.PathParser;
import io.trino.sql.jsonpath.tree.AbsMethod;
import io.trino.sql.jsonpath.tree.ArithmeticBinary;
import io.trino.sql.jsonpath.tree.ArithmeticUnary;
import io.trino.sql.jsonpath.tree.ArrayAccessor;
import io.trino.sql.jsonpath.tree.CeilingMethod;
import io.trino.sql.jsonpath.tree.ComparisonPredicate;
import io.trino.sql.jsonpath.tree.ConjunctionPredicate;
import io.trino.sql.jsonpath.tree.ContextVariable;
import io.trino.sql.jsonpath.tree.DatetimeMethod;
import io.trino.sql.jsonpath.tree.DescendantMemberAccessor;
import io.trino.sql.jsonpath.tree.DisjunctionPredicate;
import io.trino.sql.jsonpath.tree.DoubleMethod;
import io.trino.sql.jsonpath.tree.ExistsPredicate;
import io.trino.sql.jsonpath.tree.Filter;
import io.trino.sql.jsonpath.tree.FloorMethod;
import io.trino.sql.jsonpath.tree.IsUnknownPredicate;
import io.trino.sql.jsonpath.tree.JsonNullLiteral;
import io.trino.sql.jsonpath.tree.JsonPath;
import io.trino.sql.jsonpath.tree.KeyValueMethod;
import io.trino.sql.jsonpath.tree.LastIndexVariable;
import io.trino.sql.jsonpath.tree.LikeRegexPredicate;
import io.trino.sql.jsonpath.tree.MemberAccessor;
import io.trino.sql.jsonpath.tree.NamedVariable;
import io.trino.sql.jsonpath.tree.NegationPredicate;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.jsonpath.tree.Predicate;
import io.trino.sql.jsonpath.tree.PredicateCurrentItemVariable;
import io.trino.sql.jsonpath.tree.SizeMethod;
import io.trino.sql.jsonpath.tree.SqlValueLiteral;
import io.trino.sql.jsonpath.tree.StartsWithPredicate;
import io.trino.sql.jsonpath.tree.TypeMethod;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.RecursiveComparisonAssert;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.junit.jupiter.api.Test;

public class TestPathParser {
    private static final PathParser PATH_PARSER = PathParser.withRelativeErrorLocation((PathParser.Location)new PathParser.Location(1, 0));
    private static final RecursiveComparisonConfiguration COMPARISON_CONFIGURATION = RecursiveComparisonConfiguration.builder().withStrictTypeChecking(true).build();

    @Test
    public void testPathMode() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax null"))).isEqualTo((Object)new JsonPath(true, (PathNode)JsonNullLiteral.JSON_NULL));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("strict null"))).isEqualTo((Object)new JsonPath(false, (PathNode)JsonNullLiteral.JSON_NULL));
    }

    @Test
    public void testNumericLiteral() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax 1"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new LongLiteral("1"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax -2"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new LongLiteral("-2"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax 1.2e3"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new DoubleLiteral("1.2e3"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax -1.2e3"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new DoubleLiteral("-1.2e3"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax 1.0"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new DecimalLiteral("1.0"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax -.5"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new DecimalLiteral("-.5"))));
    }

    @Test
    public void testStringLiteral() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax \"aBcD\""))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new StringLiteral("aBcD"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax \"x     x\""))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new StringLiteral("x     x"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax \"x\"\"x\""))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new StringLiteral("x\"x"))));
    }

    @Test
    public void testBooleanLiteral() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax true"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new BooleanLiteral("true"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax false"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SqlValueLiteral((Literal)new BooleanLiteral("false"))));
    }

    @Test
    public void testVariable() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ContextVariable()));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $Some_Name"))).isEqualTo((Object)new JsonPath(true, (PathNode)new NamedVariable("Some_Name")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax last"))).isEqualTo((Object)new JsonPath(true, (PathNode)new LastIndexVariable()));
    }

    @Test
    public void testMethod() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.abs()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new AbsMethod((PathNode)new ContextVariable())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.ceiling()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new CeilingMethod((PathNode)new ContextVariable())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.datetime()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new DatetimeMethod((PathNode)new ContextVariable(), Optional.empty())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.datetime(\"some datetime template\")"))).isEqualTo((Object)new JsonPath(true, (PathNode)new DatetimeMethod((PathNode)new ContextVariable(), Optional.of("some datetime template"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.double()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new DoubleMethod((PathNode)new ContextVariable())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.floor()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new FloorMethod((PathNode)new ContextVariable())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.keyvalue()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new KeyValueMethod((PathNode)new ContextVariable())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.size()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new SizeMethod((PathNode)new ContextVariable())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.type()"))).isEqualTo((Object)new JsonPath(true, (PathNode)new TypeMethod((PathNode)new ContextVariable())));
    }

    @Test
    public void testArithmeticBinary() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ + 2"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.ADD, (PathNode)new ContextVariable(), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ - 2"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.SUBTRACT, (PathNode)new ContextVariable(), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ * 2"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.MULTIPLY, (PathNode)new ContextVariable(), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ / 2"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.DIVIDE, (PathNode)new ContextVariable(), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ % 2"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.MODULUS, (PathNode)new ContextVariable(), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2")))));
    }

    @Test
    public void testArithmeticUnary() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax -$"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticUnary(ArithmeticUnary.Sign.MINUS, (PathNode)new ContextVariable())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax +$"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticUnary(ArithmeticUnary.Sign.PLUS, (PathNode)new ContextVariable())));
    }

    @Test
    public void testArrayAccessor() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $[*]"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArrayAccessor((PathNode)new ContextVariable(), (List)ImmutableList.of())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $[5]"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArrayAccessor((PathNode)new ContextVariable(), (List)ImmutableList.of((Object)new ArrayAccessor.Subscript((PathNode)new SqlValueLiteral((Literal)new LongLiteral("5")))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $[5 to 10]"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArrayAccessor((PathNode)new ContextVariable(), (List)ImmutableList.of((Object)new ArrayAccessor.Subscript((PathNode)new SqlValueLiteral((Literal)new LongLiteral("5")), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("10")))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $[3 to 5, 2, 0 to 1]"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArrayAccessor((PathNode)new ContextVariable(), (List)ImmutableList.of((Object)new ArrayAccessor.Subscript((PathNode)new SqlValueLiteral((Literal)new LongLiteral("3")), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("5"))), (Object)new ArrayAccessor.Subscript((PathNode)new SqlValueLiteral((Literal)new LongLiteral("2"))), (Object)new ArrayAccessor.Subscript((PathNode)new SqlValueLiteral((Literal)new LongLiteral("0")), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("1")))))));
    }

    @Test
    public void testMemberAccessor() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.*"))).isEqualTo((Object)new JsonPath(true, (PathNode)new MemberAccessor((PathNode)new ContextVariable(), Optional.empty())));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.Key_Identifier"))).isEqualTo((Object)new JsonPath(true, (PathNode)new MemberAccessor((PathNode)new ContextVariable(), Optional.of("Key_Identifier"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.\"Key Name\""))).isEqualTo((Object)new JsonPath(true, (PathNode)new MemberAccessor((PathNode)new ContextVariable(), Optional.of("Key Name"))));
    }

    @Test
    public void testDescendantMemberAccessor() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $..Key_Identifier"))).isEqualTo((Object)new JsonPath(true, (PathNode)new DescendantMemberAccessor((PathNode)new ContextVariable(), "Key_Identifier")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $..\"Key Name\""))).isEqualTo((Object)new JsonPath(true, (PathNode)new DescendantMemberAccessor((PathNode)new ContextVariable(), "Key Name")));
    }

    @Test
    public void testPrecedenceAndGrouping() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax 1 + 2 + 3"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.ADD, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.ADD, (PathNode)new SqlValueLiteral((Literal)new LongLiteral("1")), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2"))), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("3")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax 1 * 2 + 3"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.ADD, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.MULTIPLY, (PathNode)new SqlValueLiteral((Literal)new LongLiteral("1")), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2"))), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("3")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax 1 + 2 * 3"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.ADD, (PathNode)new SqlValueLiteral((Literal)new LongLiteral("1")), (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.MULTIPLY, (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2")), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("3"))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax (1 + 2) * 3"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.MULTIPLY, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.ADD, (PathNode)new SqlValueLiteral((Literal)new LongLiteral("1")), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("2"))), (PathNode)new SqlValueLiteral((Literal)new LongLiteral("3")))));
    }

    @Test
    public void testFilter() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists($))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ExistsPredicate((PathNode)new ContextVariable()))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($x == $y)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ComparisonPredicate(ComparisonPredicate.Operator.EQUAL, (PathNode)new NamedVariable("x"), (PathNode)new NamedVariable("y")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($x <> $y)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ComparisonPredicate(ComparisonPredicate.Operator.NOT_EQUAL, (PathNode)new NamedVariable("x"), (PathNode)new NamedVariable("y")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($x != $y)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ComparisonPredicate(ComparisonPredicate.Operator.NOT_EQUAL, (PathNode)new NamedVariable("x"), (PathNode)new NamedVariable("y")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($x < $y)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ComparisonPredicate(ComparisonPredicate.Operator.LESS_THAN, (PathNode)new NamedVariable("x"), (PathNode)new NamedVariable("y")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($x > $y)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ComparisonPredicate(ComparisonPredicate.Operator.GREATER_THAN, (PathNode)new NamedVariable("x"), (PathNode)new NamedVariable("y")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($x <= $y)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ComparisonPredicate(ComparisonPredicate.Operator.LESS_THAN_OR_EQUAL, (PathNode)new NamedVariable("x"), (PathNode)new NamedVariable("y")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($x >= $y)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ComparisonPredicate(ComparisonPredicate.Operator.GREATER_THAN_OR_EQUAL, (PathNode)new NamedVariable("x"), (PathNode)new NamedVariable("y")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($ like_regex \"something*\")"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new LikeRegexPredicate((PathNode)new ContextVariable(), "something*", Optional.empty()))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($ like_regex \"something*\" flag \"some_flag\")"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new LikeRegexPredicate((PathNode)new ContextVariable(), "something*", Optional.of("some_flag")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($ starts with $some_variable)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new StartsWithPredicate((PathNode)new ContextVariable(), (PathNode)new NamedVariable("some_variable")))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ($ starts with \"some_text\")"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new StartsWithPredicate((PathNode)new ContextVariable(), (PathNode)new SqlValueLiteral((Literal)new StringLiteral("some_text"))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? ((exists($)) is unknown)"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new IsUnknownPredicate((Predicate)new ExistsPredicate((PathNode)new ContextVariable())))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (! exists($))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new NegationPredicate((Predicate)new ExistsPredicate((PathNode)new ContextVariable())))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists($x) && exists($y))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ConjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("x")), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("y"))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists($x) || exists($y))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new DisjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("x")), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("y"))))));
    }

    @Test
    public void testPrecedenceAndGroupingInFilter() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists($x) && exists($y) && exists($z))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ConjunctionPredicate((Predicate)new ConjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("x")), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("y"))), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("z"))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists($x) || exists($y) || exists($z))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new DisjunctionPredicate((Predicate)new DisjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("x")), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("y"))), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("z"))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists($x) || (exists($y) || exists($z)))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new DisjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("x")), (Predicate)new DisjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("y")), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("z")))))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists($x) || exists($y) && exists($z))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new DisjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("x")), (Predicate)new ConjunctionPredicate((Predicate)new ExistsPredicate((PathNode)new NamedVariable("y")), (Predicate)new ExistsPredicate((PathNode)new NamedVariable("z")))))));
    }

    @Test
    public void testPredicateCurrentItemVariable() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $ ? (exists(@))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new Filter((PathNode)new ContextVariable(), (Predicate)new ExistsPredicate((PathNode)new PredicateCurrentItemVariable()))));
    }

    @Test
    public void testCaseSensitiveKeywords() {
        Assertions.assertThatThrownBy(() -> PATH_PARSER.parseJsonPath("LAX $")).hasMessage("line 1:1: mismatched input 'LAX' expecting {'lax', 'strict'}");
        Assertions.assertThatThrownBy(() -> PATH_PARSER.parseJsonPath("lax $[1 To 2]")).hasMessage("line 1:9: mismatched input 'To' expecting {',', ']'}");
    }

    @Test
    public void testNonReservedKeywords() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.lax"))).isEqualTo((Object)new JsonPath(true, (PathNode)new MemberAccessor((PathNode)new ContextVariable(), Optional.of("lax"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $.ceiling"))).isEqualTo((Object)new JsonPath(true, (PathNode)new MemberAccessor((PathNode)new ContextVariable(), Optional.of("ceiling"))));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $lax"))).isEqualTo((Object)new JsonPath(true, (PathNode)new NamedVariable("lax")));
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $[$lax]"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArrayAccessor((PathNode)new ContextVariable(), (List)ImmutableList.of((Object)new ArrayAccessor.Subscript((PathNode)new NamedVariable("lax"))))));
    }

    @Test
    public void testNestedStructure() {
        ((RecursiveComparisonAssert)Assertions.assertThat(TestPathParser.path("lax $multiplier[0].floor().abs() * ($.array.size() + $component ? (exists(@)))"))).isEqualTo((Object)new JsonPath(true, (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.MULTIPLY, (PathNode)new AbsMethod((PathNode)new FloorMethod((PathNode)new ArrayAccessor((PathNode)new NamedVariable("multiplier"), (List)ImmutableList.of((Object)new ArrayAccessor.Subscript((PathNode)new SqlValueLiteral((Literal)new LongLiteral("0"))))))), (PathNode)new ArithmeticBinary(ArithmeticBinary.Operator.ADD, (PathNode)new SizeMethod((PathNode)new MemberAccessor((PathNode)new ContextVariable(), Optional.of("array"))), (PathNode)new Filter((PathNode)new NamedVariable("component"), (Predicate)new ExistsPredicate((PathNode)new PredicateCurrentItemVariable()))))));
    }

    private static AssertProvider<? extends RecursiveComparisonAssert<?>> path(String path) {
        return () -> new RecursiveComparisonAssert((Object)PATH_PARSER.parseJsonPath(path), COMPARISON_CONFIGURATION);
    }
}

