/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableMap;
import io.trino.type.TypeCalculation;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTypeCalculation {
    @Test
    public void testBasicUsage() {
        Assertions.assertEquals((Long)42L, (Long)TypeCalculation.calculateLiteralValue((String)"42", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)0L, (Long)TypeCalculation.calculateLiteralValue((String)"NULL", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)0L, (Long)TypeCalculation.calculateLiteralValue((String)"null", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)42L, (Long)TypeCalculation.calculateLiteralValue((String)"x", (Map)ImmutableMap.of((Object)"x", (Object)42L)));
        Assertions.assertEquals((Long)42L, (Long)TypeCalculation.calculateLiteralValue((String)"(42)", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)0L, (Long)TypeCalculation.calculateLiteralValue((String)"(NULL)", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)42L, (Long)TypeCalculation.calculateLiteralValue((String)"(x)", (Map)ImmutableMap.of((Object)"x", (Object)42L)));
        Assertions.assertEquals((Long)97L, (Long)TypeCalculation.calculateLiteralValue((String)"42 + 55", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)-13L, (Long)TypeCalculation.calculateLiteralValue((String)"42 - 55", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)2310L, (Long)TypeCalculation.calculateLiteralValue((String)"42 * 55", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)7L, (Long)TypeCalculation.calculateLiteralValue((String)"42 / 6", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)372L, (Long)TypeCalculation.calculateLiteralValue((String)"42 + 55 * 6", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)582L, (Long)TypeCalculation.calculateLiteralValue((String)"(42 + 55) * 6", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)2L, (Long)TypeCalculation.calculateLiteralValue((String)"min(10,2)", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)10L, (Long)TypeCalculation.calculateLiteralValue((String)"min(10,2*10)", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)20L, (Long)TypeCalculation.calculateLiteralValue((String)"max(10,2*10)", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)10L, (Long)TypeCalculation.calculateLiteralValue((String)"max(10,2)", (Map)ImmutableMap.of()));
        Assertions.assertEquals((Long)97L, (Long)TypeCalculation.calculateLiteralValue((String)"x + y", (Map)ImmutableMap.of((Object)"x", (Object)42L, (Object)"y", (Object)55L)));
    }
}

