/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.ParameterDeclaration;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropFunction
extends Statement {
    private final QualifiedName name;
    private final List<ParameterDeclaration> parameters;
    private final boolean exists;

    public DropFunction(QualifiedName name, List<ParameterDeclaration> parameters, boolean exists) {
        this(Optional.empty(), name, parameters, exists);
    }

    public DropFunction(NodeLocation location, QualifiedName name, List<ParameterDeclaration> parameters, boolean exists) {
        this(Optional.of(location), name, parameters, exists);
    }

    private DropFunction(Optional<NodeLocation> location, QualifiedName name, List<ParameterDeclaration> parameters, boolean exists) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.exists = exists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<ParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropFunction o = (DropFunction)obj;
        return Objects.equals(this.name, o.name) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("exists", this.exists).toString();
    }
}

