/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class LoopStatement
extends ControlStatement {
    private final Optional<Identifier> label;
    private final List<ControlStatement> statements;

    public LoopStatement(NodeLocation location, Optional<Identifier> label, List<ControlStatement> statements) {
        super(location);
        this.label = Objects.requireNonNull(label, "label is null");
        this.statements = Objects.requireNonNull(statements, "statements is null");
    }

    public Optional<Identifier> getLabel() {
        return this.label;
    }

    public List<ControlStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLoopStatement(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.statements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LoopStatement)) return false;
        LoopStatement other = (LoopStatement)obj;
        if (!Objects.equals(this.label, other.label)) return false;
        if (!Objects.equals(this.statements, other.statements)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.label, this.statements);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("label", this.label).add("statements", this.statements).toString();
    }
}

