/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.collect.ImmutableList;
import io.trino.sql.QueryUtil;
import io.trino.sql.parser.ParserAssert;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.AssignmentStatement;
import io.trino.sql.tree.CommentCharacteristic;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CompoundStatement;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.CreateFunction;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DeterministicCharacteristic;
import io.trino.sql.tree.ElseIfClause;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfStatement;
import io.trino.sql.tree.LanguageCharacteristic;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NullInputCharacteristic;
import io.trino.sql.tree.ParameterDeclaration;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.ReturnStatement;
import io.trino.sql.tree.ReturnsClause;
import io.trino.sql.tree.SecurityCharacteristic;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.VariableDeclaration;
import io.trino.sql.tree.WhileStatement;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSqlParserRoutines {
    TestSqlParserRoutines() {
    }

    @Test
    public void testStandaloneFunction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.functionSpecification("FUNCTION foo() RETURNS bigint RETURN 42")))).ignoringLocation().isEqualTo(new FunctionSpecification(QualifiedName.of((String)"foo"), (List)ImmutableList.of(), TestSqlParserRoutines.returns(TestSqlParserRoutines.type("bigint")), (List)ImmutableList.of(), (ControlStatement)new ReturnStatement(TestSqlParserRoutines.location(), (Expression)TestSqlParserRoutines.literal(42L))));
    }

    @Test
    void testInlineFunction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("WITH\n  FUNCTION answer()\n  RETURNS BIGINT\n  RETURN 42\nSELECT answer()\n")))).ignoringLocation().isEqualTo(TestSqlParserRoutines.query(new FunctionSpecification(QualifiedName.of((String)"answer"), (List)ImmutableList.of(), TestSqlParserRoutines.returns(TestSqlParserRoutines.type("BIGINT")), (List)ImmutableList.of(), (ControlStatement)new ReturnStatement(TestSqlParserRoutines.location(), (Expression)TestSqlParserRoutines.literal(42L))), QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"answer"), (List)ImmutableList.of())})));
    }

    @Test
    void testSimpleFunction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE FUNCTION hello(s VARCHAR)\nRETURNS varchar\nLANGUAGE SQL\nDETERMINISTIC\nCALLED ON NULL INPUT\nSECURITY INVOKER\nCOMMENT 'hello world function'\nRETURN CONCAT('Hello, ', s, '!')\n")))).ignoringLocation().isEqualTo(new CreateFunction(TestSqlParserRoutines.location(), new FunctionSpecification(QualifiedName.of((String)"hello"), (List)ImmutableList.of((Object)TestSqlParserRoutines.parameter("s", TestSqlParserRoutines.type("VARCHAR"))), TestSqlParserRoutines.returns(TestSqlParserRoutines.type("varchar")), (List)ImmutableList.of((Object)new LanguageCharacteristic(TestSqlParserRoutines.location(), QueryUtil.identifier((String)"SQL")), (Object)new DeterministicCharacteristic(TestSqlParserRoutines.location(), true), (Object)NullInputCharacteristic.calledOnNullInput(), (Object)new SecurityCharacteristic(SecurityCharacteristic.Security.INVOKER), (Object)new CommentCharacteristic(new NodeLocation(1, 1), "hello world function")), (ControlStatement)new ReturnStatement(TestSqlParserRoutines.location(), QueryUtil.functionCall((String)"CONCAT", (Expression[])new Expression[]{TestSqlParserRoutines.literal("Hello, "), QueryUtil.identifier((String)"s"), TestSqlParserRoutines.literal("!")}))), false));
    }

    @Test
    void testEmptyFunction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE FUNCTION answer()\nRETURNS bigint\nRETURN 42\n")))).ignoringLocation().isEqualTo(new CreateFunction(TestSqlParserRoutines.location(), new FunctionSpecification(QualifiedName.of((String)"answer"), (List)ImmutableList.of(), TestSqlParserRoutines.returns(TestSqlParserRoutines.type("bigint")), (List)ImmutableList.of(), (ControlStatement)new ReturnStatement(TestSqlParserRoutines.location(), (Expression)TestSqlParserRoutines.literal(42L))), true));
    }

    @Test
    void testFibFunction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE FUNCTION fib(n bigint)\nRETURNS bigint\nBEGIN\n  DECLARE a bigint DEFAULT 1;\n  DECLARE b bigint DEFAULT 1;\n  DECLARE c bigint;\n  IF n <= 2 THEN\n    RETURN 1;\n  END IF;\n  WHILE n > 2 DO\n    SET n = n - 1;\n    SET c = a + b;\n    SET a = b;\n    SET b = c;\n  END WHILE;\n  RETURN c;\nEND\n")))).ignoringLocation().isEqualTo(new CreateFunction(TestSqlParserRoutines.location(), new FunctionSpecification(QualifiedName.of((String)"fib"), (List)ImmutableList.of((Object)TestSqlParserRoutines.parameter("n", TestSqlParserRoutines.type("bigint"))), TestSqlParserRoutines.returns(TestSqlParserRoutines.type("bigint")), (List)ImmutableList.of(), (ControlStatement)TestSqlParserRoutines.beginEnd((List<VariableDeclaration>)ImmutableList.of((Object)TestSqlParserRoutines.declare("a", TestSqlParserRoutines.type("bigint"), (Expression)TestSqlParserRoutines.literal(1L)), (Object)TestSqlParserRoutines.declare("b", TestSqlParserRoutines.type("bigint"), (Expression)TestSqlParserRoutines.literal(1L)), (Object)TestSqlParserRoutines.declare("c", TestSqlParserRoutines.type("bigint"))), new ControlStatement[]{new IfStatement(TestSqlParserRoutines.location(), (Expression)TestSqlParserRoutines.lte("n", (Expression)TestSqlParserRoutines.literal(2L)), (List)ImmutableList.of((Object)new ReturnStatement(TestSqlParserRoutines.location(), (Expression)TestSqlParserRoutines.literal(1L))), (List)ImmutableList.of(), Optional.empty()), new WhileStatement(TestSqlParserRoutines.location(), Optional.empty(), (Expression)TestSqlParserRoutines.gt("n", (Expression)TestSqlParserRoutines.literal(2L)), (List)ImmutableList.of((Object)TestSqlParserRoutines.assign("n", (Expression)TestSqlParserRoutines.minus((Expression)QueryUtil.identifier((String)"n"), (Expression)TestSqlParserRoutines.literal(1L))), (Object)TestSqlParserRoutines.assign("c", (Expression)TestSqlParserRoutines.plus((Expression)QueryUtil.identifier((String)"a"), (Expression)QueryUtil.identifier((String)"b"))), (Object)TestSqlParserRoutines.assign("a", (Expression)QueryUtil.identifier((String)"b")), (Object)TestSqlParserRoutines.assign("b", (Expression)QueryUtil.identifier((String)"c")))), new ReturnStatement(TestSqlParserRoutines.location(), (Expression)QueryUtil.identifier((String)"c"))})), false));
    }

    @Test
    void testFunctionWithIfElseIf() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE FUNCTION CustomerLevel(p_creditLimit DOUBLE)\nRETURNS varchar\nRETURNS NULL ON NULL INPUT\nSECURITY DEFINER\nBEGIN\n  DECLARE lvl VarChar;\n  IF p_creditLimit > 50000 THEN\n    SET lvl = 'PLATINUM';\n  ELSEIF (p_creditLimit <= 50000 AND p_creditLimit >= 10000) THEN\n    SET lvl = 'GOLD';\n  ELSEIF p_creditLimit < 10000 THEN\n    SET lvl = 'SILVER';\n  END IF;\n  RETURN (lvl);\nEND\n")))).ignoringLocation().isEqualTo(new CreateFunction(TestSqlParserRoutines.location(), new FunctionSpecification(QualifiedName.of((String)"CustomerLevel"), (List)ImmutableList.of((Object)TestSqlParserRoutines.parameter("p_creditLimit", TestSqlParserRoutines.type("DOUBLE"))), TestSqlParserRoutines.returns(TestSqlParserRoutines.type("varchar")), (List)ImmutableList.of((Object)NullInputCharacteristic.returnsNullOnNullInput(), (Object)new SecurityCharacteristic(SecurityCharacteristic.Security.DEFINER)), (ControlStatement)TestSqlParserRoutines.beginEnd((List<VariableDeclaration>)ImmutableList.of((Object)TestSqlParserRoutines.declare("lvl", TestSqlParserRoutines.type("VarChar"))), new ControlStatement[]{new IfStatement(TestSqlParserRoutines.location(), (Expression)TestSqlParserRoutines.gt("p_creditLimit", (Expression)TestSqlParserRoutines.literal(50000L)), (List)ImmutableList.of((Object)TestSqlParserRoutines.assign("lvl", (Expression)TestSqlParserRoutines.literal("PLATINUM"))), (List)ImmutableList.of((Object)TestSqlParserRoutines.elseIf((Expression)LogicalExpression.and((Expression)TestSqlParserRoutines.lte("p_creditLimit", (Expression)TestSqlParserRoutines.literal(50000L)), (Expression)TestSqlParserRoutines.gte("p_creditLimit", (Expression)TestSqlParserRoutines.literal(10000L))), new ControlStatement[]{TestSqlParserRoutines.assign("lvl", (Expression)TestSqlParserRoutines.literal("GOLD"))}), (Object)TestSqlParserRoutines.elseIf((Expression)TestSqlParserRoutines.lt("p_creditLimit", (Expression)TestSqlParserRoutines.literal(10000L)), new ControlStatement[]{TestSqlParserRoutines.assign("lvl", (Expression)TestSqlParserRoutines.literal("SILVER"))})), Optional.empty()), new ReturnStatement(TestSqlParserRoutines.location(), (Expression)QueryUtil.identifier((String)"lvl"))})), false));
    }

    private static DataType type(String identifier) {
        return new GenericDataType(Optional.empty(), new Identifier(identifier, false), (List)ImmutableList.of());
    }

    private static ReturnsClause returns(DataType type) {
        return new ReturnsClause(TestSqlParserRoutines.location(), type);
    }

    private static VariableDeclaration declare(String name, DataType type) {
        return new VariableDeclaration(TestSqlParserRoutines.location(), (List)ImmutableList.of((Object)new Identifier(name)), type, Optional.empty());
    }

    private static VariableDeclaration declare(String name, DataType type, Expression defaultValue) {
        return new VariableDeclaration(TestSqlParserRoutines.location(), (List)ImmutableList.of((Object)new Identifier(name)), type, Optional.of(defaultValue));
    }

    private static ParameterDeclaration parameter(String name, DataType type) {
        return new ParameterDeclaration(Optional.of(new Identifier(name)), type);
    }

    private static AssignmentStatement assign(String name, Expression value) {
        return new AssignmentStatement(TestSqlParserRoutines.location(), new Identifier(name), value);
    }

    private static ArithmeticBinaryExpression plus(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, left, right);
    }

    private static ArithmeticBinaryExpression minus(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, left, right);
    }

    private static ComparisonExpression lt(String name, Expression expression) {
        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)QueryUtil.identifier((String)name), expression);
    }

    private static ComparisonExpression lte(String name, Expression expression) {
        return new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)QueryUtil.identifier((String)name), expression);
    }

    private static ComparisonExpression gt(String name, Expression expression) {
        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)QueryUtil.identifier((String)name), expression);
    }

    private static ComparisonExpression gte(String name, Expression expression) {
        return new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)QueryUtil.identifier((String)name), expression);
    }

    private static StringLiteral literal(String literal) {
        return new StringLiteral(literal);
    }

    private static LongLiteral literal(long literal) {
        return new LongLiteral(String.valueOf(literal));
    }

    private static CompoundStatement beginEnd(List<VariableDeclaration> variableDeclarations, ControlStatement ... statements) {
        return new CompoundStatement(TestSqlParserRoutines.location(), variableDeclarations, (List)ImmutableList.copyOf((Object[])statements));
    }

    private static ElseIfClause elseIf(Expression expression, ControlStatement ... statements) {
        return new ElseIfClause(expression, (List)ImmutableList.copyOf((Object[])statements));
    }

    private static Query query(FunctionSpecification function, Select select) {
        return new Query((List)ImmutableList.of((Object)function), Optional.empty(), (QueryBody)new QuerySpecification(select, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static NodeLocation location() {
        return new NodeLocation(1, 1);
    }
}

