/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class LocalTime
extends Expression {
    private final Optional<Integer> precision;

    public LocalTime(NodeLocation location, int precision) {
        this(location, Optional.of(precision));
    }

    public LocalTime(NodeLocation location) {
        this(location, Optional.empty());
    }

    private LocalTime(NodeLocation location, Optional<Integer> precision) {
        super(Optional.of(location));
        Objects.requireNonNull(precision, "precision is null");
        this.precision = precision;
    }

    public Optional<Integer> getPrecision() {
        return this.precision;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLocalTime(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTime that = (LocalTime)o;
        return Objects.equals(this.precision, that.precision);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.precision);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!LocalTime.sameClass(this, other)) {
            return false;
        }
        LocalTime otherNode = (LocalTime)other;
        return Objects.equals(this.precision, otherNode.precision);
    }
}

