/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.GrantObject;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Revoke
extends Statement {
    private final boolean grantOptionFor;
    private final Optional<List<String>> privileges;
    private final GrantObject grantObject;
    private final PrincipalSpecification grantee;

    public Revoke(NodeLocation location, boolean grantOptionFor, Optional<List<String>> privileges, GrantObject grantObject, PrincipalSpecification grantee) {
        super(Optional.of(location));
        this.grantOptionFor = grantOptionFor;
        Objects.requireNonNull(privileges, "privileges is null");
        this.privileges = privileges.map(ImmutableList::copyOf);
        this.grantObject = Objects.requireNonNull(grantObject, "grantScope is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    public boolean isGrantOptionFor() {
        return this.grantOptionFor;
    }

    public Optional<List<String>> getPrivileges() {
        return this.privileges;
    }

    public GrantObject getGrantObject() {
        return this.grantObject;
    }

    public PrincipalSpecification getGrantee() {
        return this.grantee;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRevoke(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.grantOptionFor, this.privileges, this.grantObject, this.grantee);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Revoke o = (Revoke)obj;
        return this.grantOptionFor == o.grantOptionFor && Objects.equals(this.privileges, o.privileges) && Objects.equals(this.grantObject, o.grantObject) && Objects.equals(this.grantee, o.grantee);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grantOptionFor", this.grantOptionFor).add("privileges", this.privileges).add("grantScope", (Object)this.grantObject).add("grantee", (Object)this.grantee).toString();
    }
}

