/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.UpdateAssignment;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Update
extends Statement {
    private final Table table;
    private final List<UpdateAssignment> assignments;
    private final Optional<Expression> where;

    public Update(NodeLocation location, Table table, List<UpdateAssignment> assignments, Optional<Expression> where) {
        super(Optional.of(location));
        this.table = Objects.requireNonNull(table, "table is null");
        this.assignments = Objects.requireNonNull(assignments, "assignments is null");
        this.where = Objects.requireNonNull(where, "where is null");
    }

    public Table getTable() {
        return this.table;
    }

    public List<UpdateAssignment> getAssignments() {
        return this.assignments;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.assignments);
        this.where.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUpdate(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Update update = (Update)o;
        return this.table.equals(update.table) && this.assignments.equals(update.assignments) && this.where.equals(update.where);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.assignments, this.where);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("assignments", this.assignments).add("where", this.where.orElse(null)).omitNullValues().toString();
    }
}

