/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class Node {
    private final Optional<NodeLocation> location;

    @Deprecated
    protected Node(Optional<NodeLocation> location) {
        this.location = Objects.requireNonNull(location, "location is null");
    }

    protected Node(NodeLocation location) {
        this.location = Optional.ofNullable(location);
    }

    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNode(this, context);
    }

    public Optional<NodeLocation> getLocation() {
        return this.location;
    }

    public abstract List<? extends Node> getChildren();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public boolean shallowEquals(Node other) {
        throw new UnsupportedOperationException("not yet implemented: " + this.getClass().getName());
    }

    static boolean sameClass(Node left, Node right) {
        if (left == right) {
            return true;
        }
        return left.getClass() == right.getClass();
    }
}

