/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowColumns
extends Statement {
    private final QualifiedName table;
    private final Optional<String> likePattern;
    private final Optional<String> escape;

    public ShowColumns(NodeLocation location, QualifiedName table, Optional<String> likePattern, Optional<String> escape) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.likePattern = Objects.requireNonNull(likePattern, "likePattern is null");
        this.escape = Objects.requireNonNull(escape, "escape is null");
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    public Optional<String> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowColumns(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.likePattern, this.escape);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowColumns o = (ShowColumns)obj;
        return Objects.equals(this.table, o.table) && Objects.equals(this.likePattern, o.likePattern) && Objects.equals(this.escape, o.escape);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("likePattern", this.likePattern).add("escape", this.escape).toString();
    }
}

