/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AtTimeZone
extends Expression {
    private final Expression value;
    private final Expression timeZone;

    @Deprecated
    public AtTimeZone(Expression value, Expression timeZone) {
        this(Optional.empty(), value, timeZone);
    }

    public AtTimeZone(NodeLocation location, Expression value, Expression timeZone) {
        this(Optional.of(location), value, timeZone);
    }

    private AtTimeZone(Optional<NodeLocation> location, Expression value, Expression timeZone) {
        super(location);
        Preconditions.checkArgument((timeZone instanceof IntervalLiteral || timeZone instanceof StringLiteral ? 1 : 0) != 0, (Object)"timeZone must be IntervalLiteral or StringLiteral");
        this.value = Objects.requireNonNull(value, "value is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getTimeZone() {
        return this.timeZone;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAtTimeZone(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AtTimeZone atTimeZone = (AtTimeZone)obj;
        return Objects.equals(this.value, atTimeZone.value) && Objects.equals(this.timeZone, atTimeZone.timeZone);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return AtTimeZone.sameClass(this, other);
    }
}

