/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;

public class OrdinalityColumn
extends JsonTableColumnDefinition {
    private final Identifier name;

    public OrdinalityColumn(NodeLocation location, Identifier name) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitOrdinalityColumn(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrdinalityColumn that = (OrdinalityColumn)o;
        return Objects.equals(this.name, that.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!OrdinalityColumn.sameClass(this, other)) {
            return false;
        }
        return Objects.equals(this.name, ((OrdinalityColumn)other).name);
    }
}

