/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.SelectItem;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SingleColumn
extends SelectItem {
    private final Optional<Identifier> alias;
    private final Expression expression;

    @Deprecated
    public SingleColumn(Expression expression) {
        super(Optional.empty());
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.alias = Optional.empty();
    }

    @Deprecated
    public SingleColumn(Expression expression, Identifier alias) {
        super(Optional.empty());
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.alias = Optional.of(alias);
    }

    public SingleColumn(NodeLocation location, Expression expression, Optional<Identifier> alias) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.alias = Objects.requireNonNull(alias, "alias is null");
    }

    public Optional<Identifier> getAlias() {
        return this.alias;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SingleColumn other = (SingleColumn)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.expression, other.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alias, this.expression);
    }

    @Override
    public String toString() {
        if (this.alias.isPresent()) {
            return this.expression.toString() + " " + String.valueOf(this.alias.get());
        }
        return this.expression.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSingleColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SingleColumn.sameClass(this, other)) {
            return false;
        }
        return this.alias.equals(((SingleColumn)other).alias);
    }
}

