/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class JsonValue
extends Expression {
    private final JsonPathInvocation jsonPathInvocation;
    private final Optional<DataType> returnedType;
    private final EmptyOrErrorBehavior emptyBehavior;
    private final Optional<Expression> emptyDefault;
    private final EmptyOrErrorBehavior errorBehavior;
    private final Optional<Expression> errorDefault;

    public JsonValue(NodeLocation location, JsonPathInvocation jsonPathInvocation, Optional<DataType> returnedType, EmptyOrErrorBehavior emptyBehavior, Optional<Expression> emptyDefault, EmptyOrErrorBehavior errorBehavior, Optional<Expression> errorDefault) {
        super(location);
        Objects.requireNonNull(jsonPathInvocation, "jsonPathInvocation is null");
        Objects.requireNonNull(returnedType, "returnedType is null");
        Objects.requireNonNull(emptyBehavior, "emptyBehavior is null");
        Objects.requireNonNull(emptyDefault, "emptyDefault is null");
        Preconditions.checkArgument((emptyBehavior == EmptyOrErrorBehavior.DEFAULT || !emptyDefault.isPresent() ? 1 : 0) != 0, (Object)"default value can be specified only for DEFAULT ... ON EMPTY option");
        Preconditions.checkArgument((emptyBehavior != EmptyOrErrorBehavior.DEFAULT || emptyDefault.isPresent() ? 1 : 0) != 0, (Object)"DEFAULT ... ON EMPTY option requires default value");
        Objects.requireNonNull(errorBehavior, "errorBehavior is null");
        Objects.requireNonNull(errorDefault, "errorDefault is null");
        Preconditions.checkArgument((errorBehavior == EmptyOrErrorBehavior.DEFAULT || !errorDefault.isPresent() ? 1 : 0) != 0, (Object)"default value can be specified only for DEFAULT ... ON ERROR option");
        Preconditions.checkArgument((errorBehavior != EmptyOrErrorBehavior.DEFAULT || errorDefault.isPresent() ? 1 : 0) != 0, (Object)"DEFAULT ... ON ERROR option requires default value");
        this.jsonPathInvocation = jsonPathInvocation;
        this.returnedType = returnedType;
        this.emptyBehavior = emptyBehavior;
        this.emptyDefault = emptyDefault;
        this.errorBehavior = errorBehavior;
        this.errorDefault = errorDefault;
    }

    public JsonPathInvocation getJsonPathInvocation() {
        return this.jsonPathInvocation;
    }

    public Optional<DataType> getReturnedType() {
        return this.returnedType;
    }

    public EmptyOrErrorBehavior getEmptyBehavior() {
        return this.emptyBehavior;
    }

    public Optional<Expression> getEmptyDefault() {
        return this.emptyDefault;
    }

    public EmptyOrErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    public Optional<Expression> getErrorDefault() {
        return this.errorDefault;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonValue(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object)this.jsonPathInvocation);
        this.emptyDefault.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        this.errorDefault.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonValue that = (JsonValue)o;
        return Objects.equals(this.jsonPathInvocation, that.jsonPathInvocation) && Objects.equals(this.returnedType, that.returnedType) && this.emptyBehavior == that.emptyBehavior && Objects.equals(this.emptyDefault, that.emptyDefault) && this.errorBehavior == that.errorBehavior && Objects.equals(this.errorDefault, that.errorDefault);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.jsonPathInvocation, this.returnedType, this.emptyBehavior, this.emptyDefault, this.errorBehavior, this.errorDefault});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonValue.sameClass(this, other)) {
            return false;
        }
        JsonValue otherJsonValue = (JsonValue)other;
        return this.returnedType.equals(otherJsonValue.returnedType) && this.emptyBehavior == otherJsonValue.emptyBehavior && this.errorBehavior == otherJsonValue.errorBehavior;
    }

    public static enum EmptyOrErrorBehavior {
        NULL,
        ERROR,
        DEFAULT;

    }
}

