/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RowPattern;
import java.util.List;
import java.util.Objects;

public class PatternPermutation
extends RowPattern {
    private final List<RowPattern> patterns;

    public PatternPermutation(NodeLocation location, List<RowPattern> patterns) {
        super(location);
        this.patterns = Objects.requireNonNull(patterns, "patterns is null");
        Preconditions.checkArgument((!patterns.isEmpty() ? 1 : 0) != 0, (Object)"patterns list is empty");
    }

    public List<RowPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPatternPermutation(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.copyOf(this.patterns);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PatternPermutation o = (PatternPermutation)obj;
        return Objects.equals(this.patterns, o.patterns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.patterns);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("patterns", this.patterns).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return PatternPermutation.sameClass(this, other);
    }
}

