/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.CaseStatementWhenClause;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.ElseClause;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CaseStatement
extends ControlStatement {
    private final Optional<Expression> expression;
    private final List<CaseStatementWhenClause> whenClauses;
    private final Optional<ElseClause> elseClause;

    public CaseStatement(NodeLocation location, Optional<Expression> expression, List<CaseStatementWhenClause> whenClauses, Optional<ElseClause> elseClause) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.whenClauses = Objects.requireNonNull(whenClauses, "whenClauses is null");
        this.elseClause = Objects.requireNonNull(elseClause, "elseClause is null");
    }

    public Optional<Expression> getExpression() {
        return this.expression;
    }

    public List<CaseStatementWhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    public Optional<ElseClause> getElseClause() {
        return this.elseClause;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCaseStatement(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        this.expression.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        children.addAll(this.whenClauses);
        this.elseClause.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CaseStatement)) return false;
        CaseStatement other = (CaseStatement)obj;
        if (!Objects.equals(this.expression, other.expression)) return false;
        if (!Objects.equals(this.whenClauses, other.whenClauses)) return false;
        if (!Objects.equals(this.elseClause, other.elseClause)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.whenClauses, this.elseClause);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", this.expression).add("whenClauses", this.whenClauses).add("elseClause", this.elseClause).toString();
    }
}

