/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import io.trino.sql.parser.ParsingException;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class LongLiteral
extends Literal {
    private final String value;
    private final long parsedValue;

    @Deprecated
    public LongLiteral(String value) {
        this(Optional.empty(), value);
    }

    public LongLiteral(NodeLocation location, String value) {
        this(Optional.of(location), value);
    }

    private LongLiteral(Optional<NodeLocation> location, String value) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        try {
            this.value = value;
            this.parsedValue = LongLiteral.parse(value);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid numeric literal: " + value, location.orElse(new NodeLocation(1, 1)));
        }
    }

    public String getValue() {
        return this.value;
    }

    public long getParsedValue() {
        return this.parsedValue;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLongLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.parsedValue == that.parsedValue;
    }

    @Override
    public int hashCode() {
        return (int)(this.parsedValue ^ this.parsedValue >>> 32);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!LongLiteral.sameClass(this, other)) {
            return false;
        }
        return this.parsedValue == ((LongLiteral)other).parsedValue;
    }

    private static long parse(String value) {
        if ((value = value.replace("_", "")).startsWith("0x") || value.startsWith("0X")) {
            return Long.parseLong(value.substring(2), 16);
        }
        if (value.startsWith("-0x") || value.startsWith("-0X")) {
            return Long.parseLong("-" + value.substring(3), 16);
        }
        if (value.startsWith("0b") || value.startsWith("0B")) {
            return Long.parseLong(value.substring(2), 2);
        }
        if (value.startsWith("-0b") || value.startsWith("-0B")) {
            return Long.parseLong("-" + value.substring(3), 2);
        }
        if (value.startsWith("0o") || value.startsWith("0O")) {
            return Long.parseLong(value.substring(2), 8);
        }
        if (value.startsWith("-0o") || value.startsWith("-0O")) {
            return Long.parseLong("-" + value.substring(3), 8);
        }
        return Long.parseLong(value);
    }
}

