/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;

public class TryExpression
extends Expression {
    private final Expression innerExpression;

    public TryExpression(NodeLocation location, Expression innerExpression) {
        super(location);
        this.innerExpression = Objects.requireNonNull(innerExpression, "innerExpression is null");
    }

    public Expression getInnerExpression() {
        return this.innerExpression;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTryExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.innerExpression);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TryExpression o = (TryExpression)obj;
        return Objects.equals(this.innerExpression, o.innerExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.innerExpression);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return TryExpression.sameClass(this, other);
    }
}

