/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import io.trino.sql.QueryUtil;
import io.trino.sql.SqlFormatter;
import io.trino.sql.parser.ParserAssert;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.parser.TreeNodes;
import io.trino.sql.testing.TreeAssertions;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.AllRows;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.AnchorPattern;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.AutoGroupBy;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.CallArgument;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.ColumnPosition;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Corresponding;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.CurrentTimestamp;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.Descriptor;
import io.trino.sql.tree.DescriptorField;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropNotNullConstraint;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.EmptyPattern;
import io.trino.sql.tree.EmptyTableTreatment;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.ExecuteImmediate;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainFormat;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantObject;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.GrantorSpecification;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonTable;
import io.trino.sql.tree.JsonTablePlan;
import io.trino.sql.tree.JsonTableSpecificPlan;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.NestedColumns;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OneOrMoreQuantifier;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.OrdinalityColumn;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.PathElement;
import io.trino.sql.tree.PathSpecification;
import io.trino.sql.tree.PatternAlternation;
import io.trino.sql.tree.PatternConcatenation;
import io.trino.sql.tree.PatternQuantifier;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.PatternVariable;
import io.trino.sql.tree.PlanLeaf;
import io.trino.sql.tree.PlanParentChild;
import io.trino.sql.tree.PlanSiblings;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.ProcessingMode;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.QuantifiedPattern;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.QueryColumn;
import io.trino.sql.tree.QueryPeriod;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.ResetSessionAuthorization;
import io.trino.sql.tree.ReturnStatement;
import io.trino.sql.tree.ReturnsClause;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SessionProperty;
import io.trino.sql.tree.SetAuthorizationStatement;
import io.trino.sql.tree.SetColumnType;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetSessionAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.TableFunctionArgument;
import io.trino.sql.tree.TableFunctionDescriptorArgument;
import io.trino.sql.tree.TableFunctionInvocation;
import io.trino.sql.tree.TableFunctionTableArgument;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.ValueColumn;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowDefinition;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import io.trino.sql.tree.With;
import io.trino.sql.tree.WithQuery;
import io.trino.sql.tree.ZeroOrMoreQuantifier;
import io.trino.sql.tree.ZeroOrOneQuantifier;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSqlParser {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void testPosition() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("position('a' in 'b')")))).isEqualTo(new FunctionCall(TreeNodes.location(1, 1), QualifiedName.of((String)"strpos"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 17), "b"), (Object)new StringLiteral(TreeNodes.location(1, 10), "a"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("position('a' in ('b'))")))).isEqualTo(new FunctionCall(TreeNodes.location(1, 1), QualifiedName.of((String)"strpos"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 18), "b"), (Object)new StringLiteral(TreeNodes.location(1, 10), "a"))));
    }

    @Test
    public void testPossibleExponentialBacktracking() {
        TestSqlParser.createExpression("(((((((((((((((((((((((((((true)))))))))))))))))))))))))))");
    }

    @Test
    @Timeout(value=2L, unit=TimeUnit.SECONDS)
    public void testPotentialUnboundedLookahead() {
        TestSqlParser.createExpression("(\n      1 * -1 +\n      1 * -2 +\n      1 * -3 +\n      1 * -4 +\n      1 * -5 +\n      1 * -6 +\n      1 * -7 +\n      1 * -8 +\n      1 * -9 +\n      1 * -10 +\n      1 * -11 +\n      1 * -12\n)\n");
    }

    @Test
    public void testQualifiedName() {
        Assertions.assertThat((String)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).toString()).isEqualTo("a.b.c.d");
        Assertions.assertThat((String)QualifiedName.of((String)"A", (String[])new String[]{"b", "C", "d"}).toString()).isEqualTo("a.b.c.d");
        Assertions.assertThat((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"b", (String[])new String[]{"c", "d"}))).isTrue();
        Assertions.assertThat((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}))).isTrue();
        Assertions.assertThat((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"a", (String[])new String[]{"c", "d"}))).isFalse();
        Assertions.assertThat((boolean)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}).hasSuffix(QualifiedName.of((String)"z", (String[])new String[]{"a", "b", "c", "d"}))).isFalse();
        Assertions.assertThat((Object)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"})).isEqualTo((Object)QualifiedName.of((String)"a", (String[])new String[]{"b", "c", "d"}));
    }

    @Test
    public void testGenericLiteral() {
        TestSqlParser.assertGenericLiteral("VARCHAR");
        TestSqlParser.assertGenericLiteral("BIGINT");
        TestSqlParser.assertGenericLiteral("DOUBLE");
        TestSqlParser.assertGenericLiteral("BOOLEAN");
        TestSqlParser.assertGenericLiteral("DATE");
        TestSqlParser.assertGenericLiteral("foo");
    }

    private static void assertGenericLiteral(String type) {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(type + " 'abc'")))).isEqualTo(new GenericLiteral(new NodeLocation(1, 1), type, "abc"));
    }

    @Test
    public void testBinaryLiteral() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("x' '")))).isEqualTo(new BinaryLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("x''")))).isEqualTo(new BinaryLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("X'abcdef1234567890ABCDEF'")))).isEqualTo(new BinaryLiteral(location, "abcdef1234567890ABCDEF"));
        TestSqlParser.assertInvalidExpression("X 'a b'", "Spaces are not allowed.*");
        TestSqlParser.assertInvalidExpression("X'a b c'", "Binary literal must contain an even number of digits.*");
        TestSqlParser.assertInvalidExpression("X'a z'", "Binary literal can only contain hexadecimal digits.*");
    }

    @Test
    public void testLiterals() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("TIME 'abc'")))).isEqualTo(new GenericLiteral(location, "TIME", "abc"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("TIMESTAMP 'abc'")))).isEqualTo(new GenericLiteral(location, "TIMESTAMP", "abc"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '33' day")))).isEqualTo(new IntervalLiteral(location, "33", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '33' day to second")))).isEqualTo(new IntervalLiteral(location, "33", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.of(IntervalLiteral.IntervalField.SECOND)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("CHAR 'abc'")))).isEqualTo(new GenericLiteral(location, "CHAR", "abc"));
    }

    @Test
    public void testNumbers() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("9223372036854775807")))).isEqualTo(new LongLiteral(location, "9223372036854775807"));
        TestSqlParser.assertInvalidExpression("9223372036854775808", "Invalid numeric literal: 9223372036854775808");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-9223372036854775808")))).isEqualTo(new LongLiteral(location, "-9223372036854775808"));
        TestSqlParser.assertInvalidExpression("-9223372036854775809", "Invalid numeric literal: -9223372036854775809");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1E5")))).isEqualTo(new DoubleLiteral(location, "1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1E-5")))).isEqualTo(new DoubleLiteral(location, "1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".1E5")))).isEqualTo(new DoubleLiteral(location, ".1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".1E-5")))).isEqualTo(new DoubleLiteral(location, ".1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1.1E5")))).isEqualTo(new DoubleLiteral(location, "1.1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1.1E-5")))).isEqualTo(new DoubleLiteral(location, "1.1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1E5")))).isEqualTo(new DoubleLiteral(location, "-1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1E-5")))).isEqualTo(new DoubleLiteral(location, "-1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-.1E5")))).isEqualTo(new DoubleLiteral(location, "-.1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-.1E-5")))).isEqualTo(new DoubleLiteral(location, "-.1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1.1E5")))).isEqualTo(new DoubleLiteral(location, "-1.1E5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1.1E-5")))).isEqualTo(new DoubleLiteral(location, "-1.1E-5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".1")))).isEqualTo(new DecimalLiteral(location, ".1"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1.2")))).isEqualTo(new DecimalLiteral(location, "1.2"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1.2")))).isEqualTo(new DecimalLiteral(location, "-1.2"));
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123_456_789")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "123_456_789"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(123456789L)});
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("123_456_789_")).isInstanceOf(ParsingException.class);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123_456.789_0123")))).isEqualTo(new DecimalLiteral(new NodeLocation(1, 1), "123_456.789_0123"));
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("123_456.789_0123_")).isInstanceOf(ParsingException.class);
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("_123_456.789_0123")).isInstanceOf(ParsingException.class);
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("123_456_.789_0123")).isInstanceOf(ParsingException.class);
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("123_456._789_0123")).isInstanceOf(ParsingException.class);
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("0x123_abc_def")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "0x123_abc_def"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(4893429231L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("0X123_ABC_DEF")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "0X123_ABC_DEF"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(4893429231L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-0x123_abc_def")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "-0x123_abc_def"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(-4893429231L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-0X123_ABC_DEF")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "-0X123_ABC_DEF"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(-4893429231L)});
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("0x123_ABC_DEF_")).isInstanceOf(ParsingException.class);
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("0O012_345")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "0O012_345"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(5349L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("0o012_345")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "0o012_345"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(5349L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-0O012_345")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "-0O012_345"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(-5349L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-0o012_345")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "-0o012_345"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(-5349L)});
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("0o012_345_")).isInstanceOf(ParsingException.class);
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("0B110_010")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "0B110_010"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(50L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("0b110_010")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "0b110_010"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(50L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-0B110_010")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "-0B110_010"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(-50L)});
        ((ParserAssert)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-0b110_010")))).isEqualTo(new LongLiteral(new NodeLocation(1, 1), "-0b110_010"))).satisfies(new ThrowingConsumer[]{value -> Assertions.assertThat((long)((LongLiteral)value).getParsedValue()).isEqualTo(-50L)});
        Assertions.assertThatThrownBy(() -> SQL_PARSER.createExpression("0b110_010_")).isInstanceOf(ParsingException.class);
    }

    @Test
    public void testIdentifier() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("_123_456")))).isEqualTo(new Identifier(new NodeLocation(1, 1), "_123_456", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("_0x123_ABC_DEF")))).isEqualTo(new Identifier(new NodeLocation(1, 1), "_0x123_ABC_DEF", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("_0o012_345")))).isEqualTo(new Identifier(new NodeLocation(1, 1), "_0o012_345", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("_0b110_010")))).isEqualTo(new Identifier(new NodeLocation(1, 1), "_0b110_010", false));
    }

    @Test
    public void testArray() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("ARRAY []")))).isEqualTo(new Array(TreeNodes.location(1, 1), (List)ImmutableList.of()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("ARRAY [1, 2]")))).isEqualTo(new Array(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 8), "1"), (Object)new LongLiteral(TreeNodes.location(1, 11), "2"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("ARRAY [1e0, 2.5e0]")))).isEqualTo(new Array(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new DoubleLiteral(TreeNodes.location(1, 8), "1.0"), (Object)new DoubleLiteral(TreeNodes.location(1, 13), "2.5"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("ARRAY ['hi']")))).isEqualTo(new Array(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 8), "hi"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("ARRAY ['hi', 'hello']")))).isEqualTo(new Array(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 8), "hi"), (Object)new StringLiteral(TreeNodes.location(1, 14), "hello"))));
    }

    @Test
    public void testArraySubscript() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("ARRAY [1, 2][1]")))).isEqualTo(new SubscriptExpression(TreeNodes.location(1, 1), (Expression)new Array(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 8), "1"), (Object)new LongLiteral(TreeNodes.location(1, 11), "2"))), (Expression)new LongLiteral(TreeNodes.location(1, 14), "1")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("CASE WHEN TRUE THEN ARRAY[1,2] END[1]")))).isEqualTo(new SubscriptExpression(TreeNodes.location(1, 1), (Expression)new SearchedCaseExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new WhenClause(TreeNodes.location(1, 6), (Expression)new BooleanLiteral(TreeNodes.location(1, 11), "true"), (Expression)new Array(TreeNodes.location(1, 21), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 27), "1"), (Object)new LongLiteral(TreeNodes.location(1, 29), "2"))))), Optional.empty()), (Expression)new LongLiteral(TreeNodes.location(1, 36), "1")));
    }

    @Test
    public void testRowSubscript() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("ROW (1, 'a', true)[1]")))).isEqualTo(new SubscriptExpression(TreeNodes.location(1, 1), (Expression)new Row(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 6), "1"), (Object)new StringLiteral(TreeNodes.location(1, 9), "a"), (Object)new BooleanLiteral(TreeNodes.location(1, 14), "true"))), (Expression)new LongLiteral(TreeNodes.location(1, 20), "1")));
    }

    @Test
    public void testAllColumns() {
        TestSqlParser.assertStatement("SELECT * FROM t", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.empty(), (List)ImmutableList.of()))), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT r.* FROM t", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.of(new Identifier("r")), (List)ImmutableList.of()))), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT ROW (1, 'a', true).*", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.of(new Row((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("a"), (Object)new BooleanLiteral("true")))), (List)ImmutableList.of())))));
        TestSqlParser.assertStatement("SELECT ROW (1, 'a', true).* AS (f1, f2, f3)", (Statement)QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns(Optional.empty(), Optional.of(new Row((List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("a"), (Object)new BooleanLiteral("true")))), (List)ImmutableList.of((Object)new Identifier("f1"), (Object)new Identifier("f2"), (Object)new Identifier("f3")))))));
    }

    @Test
    public void testDouble() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123E7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.E7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.0E7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123E+7")))).isEqualTo(new DoubleLiteral(location, "123E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123E-7")))).isEqualTo(new DoubleLiteral(location, "123E-7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.456E7")))).isEqualTo(new DoubleLiteral(location, "123.456E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.456E+7")))).isEqualTo(new DoubleLiteral(location, "123.456E7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.456E-7")))).isEqualTo(new DoubleLiteral(location, "123.456E-7"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".4E42")))).isEqualTo(new DoubleLiteral(location, ".4E42"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".4E+42")))).isEqualTo(new DoubleLiteral(location, ".4E42"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".4E-42")))).isEqualTo(new DoubleLiteral(location, ".4E-42"));
    }

    @Test
    public void testArithmeticUnary() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("9")))).isEqualTo(new LongLiteral(TreeNodes.location(1, 1), "9"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 2), "9")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+ 9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 3), "9")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("++9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 2), (Expression)new LongLiteral(TreeNodes.location(1, 3), "9"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+ +9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 4), "9"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+ + 9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 5), "9"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+++9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 2), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 4), "9")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+ + +9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 5), (Expression)new LongLiteral(TreeNodes.location(1, 6), "9")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+ + + 9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 5), (Expression)new LongLiteral(TreeNodes.location(1, 7), "9")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-9")))).isEqualTo(new LongLiteral(TreeNodes.location(1, 1), "-9"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("- 9")))).isEqualTo(new LongLiteral(TreeNodes.location(1, 1), "-9"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("- + 9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 5), "9"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-+9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 2), (Expression)new LongLiteral(TreeNodes.location(1, 3), "9"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+ - + 9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 3), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 5), (Expression)new LongLiteral(TreeNodes.location(1, 7), "9")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+-+9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 2), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 4), "9")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("- -9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 3), "-9")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("- - 9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 3), "-9")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("- + - + 9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 5), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 7), (Expression)new LongLiteral(TreeNodes.location(1, 9), "9"))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-+-+9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 2), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 3), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 4), (Expression)new LongLiteral(TreeNodes.location(1, 5), "9"))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+ - + - + 9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 3), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 5), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 7), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 9), (Expression)new LongLiteral(TreeNodes.location(1, 11), "9")))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("+-+-+9")))).isEqualTo(ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 2), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 3), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 4), (Expression)ArithmeticUnaryExpression.positive((NodeLocation)TreeNodes.location(1, 5), (Expression)new LongLiteral(TreeNodes.location(1, 6), "9")))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("- - -9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 5), "-9"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("- - - 9")))).isEqualTo(ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 1), (Expression)ArithmeticUnaryExpression.negative((NodeLocation)TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 5), "-9"))));
    }

    @Test
    public void testCoalesce() {
        TestSqlParser.assertInvalidExpression("coalesce()", "The 'coalesce' function must have at least two arguments");
        TestSqlParser.assertInvalidExpression("coalesce(5)", "The 'coalesce' function must have at least two arguments");
        TestSqlParser.assertInvalidExpression("coalesce(1, 2) filter (where true)", "FILTER not valid for 'coalesce' function");
        TestSqlParser.assertInvalidExpression("coalesce(1, 2) OVER ()", "OVER clause not valid for 'coalesce' function");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("coalesce(13, 42)")))).isEqualTo(new CoalesceExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 10), "13"), (Object)new LongLiteral(TreeNodes.location(1, 14), "42"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("coalesce(6, 7, 8)")))).isEqualTo(new CoalesceExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 10), "6"), (Object)new LongLiteral(TreeNodes.location(1, 13), "7"), (Object)new LongLiteral(TreeNodes.location(1, 16), "8"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("coalesce(13, null)")))).isEqualTo(new CoalesceExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 10), "13"), (Object)new NullLiteral(TreeNodes.location(1, 14)))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("coalesce(null, 13)")))).isEqualTo(new CoalesceExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new NullLiteral(TreeNodes.location(1, 10)), (Object)new LongLiteral(TreeNodes.location(1, 16), "13"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("coalesce(null, null)")))).isEqualTo(new CoalesceExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new NullLiteral(TreeNodes.location(1, 10)), (Object)new NullLiteral(TreeNodes.location(1, 16)))));
    }

    @Test
    public void testIf() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("if(true, 1, 0)")))).isEqualTo(new IfExpression(TreeNodes.location(1, 1), (Expression)new BooleanLiteral(TreeNodes.location(1, 4), "true"), (Expression)new LongLiteral(TreeNodes.location(1, 10), "1"), (Expression)new LongLiteral(TreeNodes.location(1, 13), "0")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("if(true, 3, null)")))).isEqualTo(new IfExpression(TreeNodes.location(1, 1), (Expression)new BooleanLiteral(TreeNodes.location(1, 4), "true"), (Expression)new LongLiteral(TreeNodes.location(1, 10), "3"), (Expression)new NullLiteral(TreeNodes.location(1, 13))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("if(false, null, 4)")))).isEqualTo(new IfExpression(TreeNodes.location(1, 1), (Expression)new BooleanLiteral(TreeNodes.location(1, 4), "false"), (Expression)new NullLiteral(TreeNodes.location(1, 11)), (Expression)new LongLiteral(TreeNodes.location(1, 17), "4")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("if(false, null, null)")))).isEqualTo(new IfExpression(TreeNodes.location(1, 1), (Expression)new BooleanLiteral(TreeNodes.location(1, 4), "false"), (Expression)new NullLiteral(TreeNodes.location(1, 11)), (Expression)new NullLiteral(TreeNodes.location(1, 17))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("if(true, 3)")))).isEqualTo(new IfExpression(TreeNodes.location(1, 1), (Expression)new BooleanLiteral(TreeNodes.location(1, 4), "true"), (Expression)new LongLiteral(TreeNodes.location(1, 10), "3"), null));
        TestSqlParser.assertInvalidExpression("IF(true)", "Invalid number of arguments for 'if' function");
        TestSqlParser.assertInvalidExpression("IF(true, 1, 0) FILTER (WHERE true)", "FILTER not valid for 'if' function");
        TestSqlParser.assertInvalidExpression("IF(true, 1, 0) OVER()", "OVER clause not valid for 'if' function");
    }

    @Test
    public void testNullIf() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nullif(42, 87)")))).isEqualTo(new NullIfExpression(TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 8), "42"), (Expression)new LongLiteral(TreeNodes.location(1, 12), "87")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nullif(42, null)")))).isEqualTo(new NullIfExpression(TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 8), "42"), (Expression)new NullLiteral(TreeNodes.location(1, 12))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nullif(null, null)")))).isEqualTo(new NullIfExpression(TreeNodes.location(1, 1), (Expression)new NullLiteral(TreeNodes.location(1, 8)), (Expression)new NullLiteral(TreeNodes.location(1, 14))));
        TestSqlParser.assertInvalidExpression("nullif(1)", "Invalid number of arguments for 'nullif' function");
        TestSqlParser.assertInvalidExpression("nullif(1, 2, 3)", "Invalid number of arguments for 'nullif' function");
        TestSqlParser.assertInvalidExpression("nullif(42, 87) filter (where true)", "FILTER not valid for 'nullif' function");
        TestSqlParser.assertInvalidExpression("nullif(42, 87) OVER ()", "OVER clause not valid for 'nullif' function");
    }

    @Test
    public void testDoubleInQuery() {
        TestSqlParser.assertStatement("SELECT 123.456E7 FROM DUAL", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new DoubleLiteral("123.456E7")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"DUAL"))));
    }

    @Test
    public void testIntersect() {
        TestSqlParser.assertStatement("SELECT 123 INTERSECT DISTINCT SELECT 123 INTERSECT ALL SELECT 123", (Statement)QueryUtil.query((QueryBody)new Intersect((List)ImmutableList.of((Object)new Intersect((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true, Optional.empty()), (Object)TestSqlParser.createSelect123()), false, Optional.empty())));
        TestSqlParser.assertStatement("SELECT 123 INTERSECT DISTINCT CORRESPONDING SELECT 123 INTERSECT ALL CORRESPONDING SELECT 123", (Statement)QueryUtil.query((QueryBody)new Intersect((List)ImmutableList.of((Object)new Intersect((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of()))), (Object)TestSqlParser.createSelect123()), false, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of())))));
        TestSqlParser.assertStatement("SELECT 123 INTERSECT DISTINCT CORRESPONDING BY (x) SELECT 123 INTERSECT ALL CORRESPONDING SELECT 123", (Statement)QueryUtil.query((QueryBody)new Intersect((List)ImmutableList.of((Object)new Intersect((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of(QueryUtil.identifier((String)"x"))))), (Object)TestSqlParser.createSelect123()), false, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of())))));
    }

    @Test
    public void testUnion() {
        TestSqlParser.assertStatement("SELECT 123 UNION DISTINCT SELECT 123 UNION ALL SELECT 123", (Statement)QueryUtil.query((QueryBody)new Union((List)ImmutableList.of((Object)new Union((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true, Optional.empty()), (Object)TestSqlParser.createSelect123()), false, Optional.empty())));
        TestSqlParser.assertStatement("SELECT 123 UNION DISTINCT CORRESPONDING SELECT 123 UNION ALL CORRESPONDING SELECT 123", (Statement)QueryUtil.query((QueryBody)new Union((List)ImmutableList.of((Object)new Union((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of()))), (Object)TestSqlParser.createSelect123()), false, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of())))));
        TestSqlParser.assertStatement("SELECT 123 UNION DISTINCT CORRESPONDING BY (x) SELECT 123 UNION ALL CORRESPONDING SELECT 123", (Statement)QueryUtil.query((QueryBody)new Union((List)ImmutableList.of((Object)new Union((List)ImmutableList.of((Object)TestSqlParser.createSelect123(), (Object)TestSqlParser.createSelect123()), true, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of(QueryUtil.identifier((String)"x"))))), (Object)TestSqlParser.createSelect123()), false, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of())))));
    }

    @Test
    public void testExcept() {
        TestSqlParser.assertStatement("SELECT 123 EXCEPT DISTINCT SELECT 123 EXCEPT ALL SELECT 123", (Statement)QueryUtil.query((QueryBody)new Except(TreeNodes.location(1, 1), (QueryBody)new Except(TreeNodes.location(1, 1), (QueryBody)TestSqlParser.createSelect123(), (QueryBody)TestSqlParser.createSelect123(), true, Optional.empty()), (QueryBody)TestSqlParser.createSelect123(), false, Optional.empty())));
        TestSqlParser.assertStatement("SELECT 123 EXCEPT DISTINCT CORRESPONDING SELECT 123 EXCEPT ALL CORRESPONDING SELECT 123", (Statement)QueryUtil.query((QueryBody)new Except(TreeNodes.location(1, 1), (QueryBody)new Except(TreeNodes.location(1, 1), (QueryBody)TestSqlParser.createSelect123(), (QueryBody)TestSqlParser.createSelect123(), true, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of()))), (QueryBody)TestSqlParser.createSelect123(), false, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of())))));
        TestSqlParser.assertStatement("SELECT 123 EXCEPT DISTINCT CORRESPONDING BY (x) SELECT 123 EXCEPT ALL CORRESPONDING SELECT 123", (Statement)QueryUtil.query((QueryBody)new Except(TreeNodes.location(1, 1), (QueryBody)new Except(TreeNodes.location(1, 1), (QueryBody)TestSqlParser.createSelect123(), (QueryBody)TestSqlParser.createSelect123(), true, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of(QueryUtil.identifier((String)"x"))))), (QueryBody)TestSqlParser.createSelect123(), false, Optional.of(new Corresponding(TreeNodes.location(1, 1), List.of())))));
    }

    private static QuerySpecification createSelect123() {
        return new QuerySpecification(QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("123")}), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Test
    public void testReservedWordIdentifier() {
        TestSqlParser.assertStatement("SELECT id FROM public.orders", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"id")}), (Relation)new Table(QualifiedName.of((String)"public", (String[])new String[]{"orders"}))));
        TestSqlParser.assertStatement("SELECT id FROM \"public\".\"order\"", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"id")}), (Relation)new Table(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("public", true), (Object)new Identifier("order", true))))));
        TestSqlParser.assertStatement("SELECT id FROM \"public\".\"order\"\"2\"", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"id")}), (Relation)new Table(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("public", true), (Object)new Identifier("order\"2", true))))));
    }

    @Test
    public void testBetween() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 BETWEEN 2 AND 3")))).isEqualTo(new BetweenPredicate(TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 1), "1"), (Expression)new LongLiteral(TreeNodes.location(1, 11), "2"), (Expression)new LongLiteral(TreeNodes.location(1, 17), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 NOT BETWEEN 2 AND 3")))).isEqualTo(new NotExpression(TreeNodes.location(1, 3), (Expression)new BetweenPredicate(TreeNodes.location(1, 3), (Expression)new LongLiteral(TreeNodes.location(1, 1), "1"), (Expression)new LongLiteral(TreeNodes.location(1, 15), "2"), (Expression)new LongLiteral(TreeNodes.location(1, 21), "3"))));
    }

    @Test
    public void testSelectWithLimit() {
        TestSqlParser.assertStatement("SELECT * FROM table1 LIMIT 2", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new LongLiteral("2")))));
        TestSqlParser.assertStatement("SELECT * FROM table1 LIMIT ALL", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new AllRows()))));
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new LongLiteral("1"), new StringLiteral("1")}), QueryUtil.row((Expression[])new Expression[]{new LongLiteral("2"), new StringLiteral("2")})}));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) LIMIT ALL", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new AllRows()))));
    }

    @Test
    public void testValues() {
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new StringLiteral("a"), new LongLiteral("1"), new DoubleLiteral("2.2")}), QueryUtil.row((Expression[])new Expression[]{new StringLiteral("b"), new LongLiteral("2"), new DoubleLiteral("3.3")})}));
        TestSqlParser.assertStatement("VALUES ('a', 1, 2.2e0), ('b', 2, 3.3e0)", (Statement)valuesQuery);
        TestSqlParser.assertStatement("SELECT * FROM (VALUES ('a', 1, 2.2e0), ('b', 2, 3.3e0))", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery)));
    }

    @Test
    public void testRowPattern() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("(A B)* | CC+? DD?? E | (F | G)")))).isEqualTo(new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternConcatenation(TreeNodes.location(1, 2), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 2), new Identifier(TreeNodes.location(1, 2), "A", false)), (Object)new PatternVariable(TreeNodes.location(1, 4), new Identifier(TreeNodes.location(1, 4), "B", false)))), (PatternQuantifier)new ZeroOrMoreQuantifier(TreeNodes.location(1, 6), true)), (Object)new PatternConcatenation(TreeNodes.location(1, 10), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(1, 10), (List)ImmutableList.of((Object)new QuantifiedPattern(TreeNodes.location(1, 10), (RowPattern)new PatternVariable(TreeNodes.location(1, 10), new Identifier(TreeNodes.location(1, 10), "CC", false)), (PatternQuantifier)new OneOrMoreQuantifier(TreeNodes.location(1, 12), false)), (Object)new QuantifiedPattern(TreeNodes.location(1, 15), (RowPattern)new PatternVariable(TreeNodes.location(1, 15), new Identifier(TreeNodes.location(1, 15), "DD", false)), (PatternQuantifier)new ZeroOrOneQuantifier(TreeNodes.location(1, 17), false)))), (Object)new PatternVariable(TreeNodes.location(1, 20), new Identifier(TreeNodes.location(1, 20), "E", false)))))), (Object)new PatternAlternation(TreeNodes.location(1, 25), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 25), new Identifier(TreeNodes.location(1, 25), "F", false)), (Object)new PatternVariable(TreeNodes.location(1, 29), new Identifier(TreeNodes.location(1, 29), "G", false)))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A | B | C D E F")))).isEqualTo(new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new PatternAlternation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (Object)new PatternVariable(TreeNodes.location(1, 5), new Identifier(TreeNodes.location(1, 5), "B", false)))), (Object)new PatternConcatenation(TreeNodes.location(1, 9), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(1, 9), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(1, 9), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(1, 9), new Identifier(TreeNodes.location(1, 9), "C", false)), (Object)new PatternVariable(TreeNodes.location(1, 11), new Identifier(TreeNodes.location(1, 11), "D", false)))), (Object)new PatternVariable(TreeNodes.location(1, 13), new Identifier(TreeNodes.location(1, 13), "E", false)))), (Object)new PatternVariable(TreeNodes.location(1, 15), new Identifier(TreeNodes.location(1, 15), "F", false)))))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createRowPattern("A!")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:2: mismatched input '!'.*");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createRowPattern("A**")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:3: mismatched input '*'.*");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A??")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new ZeroOrOneQuantifier(TreeNodes.location(1, 2), false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("^$")))).isEqualTo(new PatternConcatenation(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new AnchorPattern(TreeNodes.location(1, 1), AnchorPattern.Type.PARTITION_START), (Object)new AnchorPattern(TreeNodes.location(1, 2), AnchorPattern.Type.PARTITION_END))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("()")))).isEqualTo(new EmptyPattern(TreeNodes.location(1, 1)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{3}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")), Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{3,}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")), Optional.empty())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{,3}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.empty(), Optional.of(new LongLiteral(TreeNodes.location(1, 4), "3")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.rowPattern("A{3,4}")))).isEqualTo(new QuantifiedPattern(TreeNodes.location(1, 1), (RowPattern)new PatternVariable(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "A", false)), (PatternQuantifier)new RangeQuantifier(TreeNodes.location(1, 2), true, Optional.of(new LongLiteral(TreeNodes.location(1, 3), "3")), Optional.of(new LongLiteral(TreeNodes.location(1, 5), "4")))));
    }

    @Test
    public void testPrecedenceAndAssociativity() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 AND 2 AND 3 AND 4")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LongLiteral(TreeNodes.location(1, 7), "2"), (Object)new LongLiteral(TreeNodes.location(1, 13), "3"), (Object)new LongLiteral(TreeNodes.location(1, 19), "4"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 OR 2 OR 3 OR 4")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LongLiteral(TreeNodes.location(1, 6), "2"), (Object)new LongLiteral(TreeNodes.location(1, 11), "3"), (Object)new LongLiteral(TreeNodes.location(1, 16), "4"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 AND 2 AND 3 OR 4 AND 5 AND 6 OR 7 AND 8 AND 9")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LongLiteral(TreeNodes.location(1, 7), "2"), (Object)new LongLiteral(TreeNodes.location(1, 13), "3"))), (Object)new LogicalExpression(TreeNodes.location(1, 18), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 18), "4"), (Object)new LongLiteral(TreeNodes.location(1, 24), "5"), (Object)new LongLiteral(TreeNodes.location(1, 30), "6"))), (Object)new LogicalExpression(TreeNodes.location(1, 35), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 35), "7"), (Object)new LongLiteral(TreeNodes.location(1, 41), "8"), (Object)new LongLiteral(TreeNodes.location(1, 47), "9"))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 AND 2 OR 3")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LongLiteral(TreeNodes.location(1, 7), "2"))), (Object)new LongLiteral(TreeNodes.location(1, 12), "3"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 OR 2 AND 3")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 1), "1"), (Object)new LogicalExpression(TreeNodes.location(1, 6), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 6), "2"), (Object)new LongLiteral(TreeNodes.location(1, 12), "3"))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("NOT 1 AND 2")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression(TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 5), "1")), (Object)new LongLiteral(TreeNodes.location(1, 11), "2"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("NOT 1 OR 2")))).isEqualTo(new LogicalExpression(TreeNodes.location(1, 1), LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression(TreeNodes.location(1, 1), (Expression)new LongLiteral(TreeNodes.location(1, 5), "1")), (Object)new LongLiteral(TreeNodes.location(1, 10), "2"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("-1 + 2")))).isEqualTo(new ArithmeticBinaryExpression(TreeNodes.location(1, 4), ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral(TreeNodes.location(1, 1), "-1"), (Expression)new LongLiteral(TreeNodes.location(1, 6), "2")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 - 2 - 3")))).isEqualTo(new ArithmeticBinaryExpression(TreeNodes.location(1, 7), ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new ArithmeticBinaryExpression(TreeNodes.location(1, 3), ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new LongLiteral(TreeNodes.location(1, 1), "1"), (Expression)new LongLiteral(TreeNodes.location(1, 5), "2")), (Expression)new LongLiteral(TreeNodes.location(1, 9), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 / 2 / 3")))).isEqualTo(new ArithmeticBinaryExpression(TreeNodes.location(1, 7), ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new ArithmeticBinaryExpression(TreeNodes.location(1, 3), ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new LongLiteral(TreeNodes.location(1, 1), "1"), (Expression)new LongLiteral(TreeNodes.location(1, 5), "2")), (Expression)new LongLiteral(TreeNodes.location(1, 9), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("1 + 2 * 3")))).isEqualTo(new ArithmeticBinaryExpression(TreeNodes.location(1, 3), ArithmeticBinaryExpression.Operator.ADD, (Expression)new LongLiteral(TreeNodes.location(1, 1), "1"), (Expression)new ArithmeticBinaryExpression(TreeNodes.location(1, 7), ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new LongLiteral(TreeNodes.location(1, 5), "2"), (Expression)new LongLiteral(TreeNodes.location(1, 9), "3"))));
    }

    @Test
    public void testInterval() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' YEAR")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.YEAR, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123-3' YEAR TO MONTH")))).isEqualTo(new IntervalLiteral(location, "123-3", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.YEAR, Optional.of(IntervalLiteral.IntervalField.MONTH)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' MONTH")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.MONTH, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' DAY")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123 23:58:53.456' DAY TO SECOND")))).isEqualTo(new IntervalLiteral(location, "123 23:58:53.456", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.of(IntervalLiteral.IntervalField.SECOND)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' HOUR")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '23:59' HOUR TO MINUTE")))).isEqualTo(new IntervalLiteral(location, "23:59", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.MINUTE)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' MINUTE")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.MINUTE, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("INTERVAL '123' SECOND")))).isEqualTo(new IntervalLiteral(location, "123", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.SECOND, Optional.empty()));
    }

    @Test
    public void testDecimal() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '12.34'")))).isEqualTo(new DecimalLiteral(location, "12.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '12.'")))).isEqualTo(new DecimalLiteral(location, "12."));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '12'")))).isEqualTo(new DecimalLiteral(location, "12"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '.34'")))).isEqualTo(new DecimalLiteral(location, ".34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '+12.34'")))).isEqualTo(new DecimalLiteral(location, "+12.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '+12'")))).isEqualTo(new DecimalLiteral(location, "+12"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '-12.34'")))).isEqualTo(new DecimalLiteral(location, "-12.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '-12'")))).isEqualTo(new DecimalLiteral(location, "-12"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '+.34'")))).isEqualTo(new DecimalLiteral(location, "+.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("DECIMAL '-.34'")))).isEqualTo(new DecimalLiteral(location, "-.34"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.")))).isEqualTo(new DecimalLiteral(location, "123."));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.0")))).isEqualTo(new DecimalLiteral(location, "123.0"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression(".5")))).isEqualTo(new DecimalLiteral(location, ".5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("123.5")))).isEqualTo(new DecimalLiteral(location, "123.5"));
    }

    @Test
    public void testTime() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("TIME '03:04:05'")))).isEqualTo(new GenericLiteral(location, "TIME", "03:04:05"));
    }

    @Test
    public void testCurrentTimestamp() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("CURRENT_TIMESTAMP")))).isEqualTo(new CurrentTimestamp(location, Optional.empty()));
    }

    @Test
    public void testTrim() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(BOTH FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.BOTH, (Expression)new StringLiteral(TreeNodes.location(1, 16), " abc "), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(LEADING FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.LEADING, (Expression)new StringLiteral(TreeNodes.location(1, 19), " abc "), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(TRAILING FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.TRAILING, (Expression)new StringLiteral(TreeNodes.location(1, 20), " abc "), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(BOTH ' ' FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.BOTH, (Expression)new StringLiteral(TreeNodes.location(1, 20), " abc "), Optional.of(new StringLiteral(TreeNodes.location(1, 11), " "))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(LEADING ' ' FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.LEADING, (Expression)new StringLiteral(TreeNodes.location(1, 23), " abc "), Optional.of(new StringLiteral(TreeNodes.location(1, 14), " "))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("trim(TRAILING ' ' FROM ' abc ')")))).isEqualTo(new Trim(TreeNodes.location(1, 1), Trim.Specification.TRAILING, (Expression)new StringLiteral(TreeNodes.location(1, 24), " abc "), Optional.of(new StringLiteral(TreeNodes.location(1, 15), " "))));
        TestSqlParser.assertInvalidExpression("trim(FROM ' abc ')", "The 'trim' function must have specification, char or both arguments when it takes FROM");
    }

    @Test
    public void testFormat() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("format('%s', 'abc')")))).isEqualTo(new Format(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 8), "%s"), (Object)new StringLiteral(TreeNodes.location(1, 14), "abc"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("format('%d %s', 123, 'x')")))).isEqualTo(new Format(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 8), "%d %s"), (Object)new LongLiteral(TreeNodes.location(1, 17), "123"), (Object)new StringLiteral(TreeNodes.location(1, 22), "x"))));
        TestSqlParser.assertInvalidExpression("format()", "The 'format' function must have at least two arguments");
        TestSqlParser.assertInvalidExpression("format('%s')", "The 'format' function must have at least two arguments");
    }

    @Test
    public void testCase() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("CASE 1 IS NULL WHEN true THEN 2 ELSE 3 END")))).isEqualTo(new SimpleCaseExpression(TreeNodes.location(1, 1), (Expression)new IsNullPredicate(TreeNodes.location(1, 8), (Expression)new LongLiteral(TreeNodes.location(1, 6), "1")), (List)ImmutableList.of((Object)new WhenClause(TreeNodes.location(1, 16), (Expression)new BooleanLiteral(TreeNodes.location(1, 21), "true"), (Expression)new LongLiteral(TreeNodes.location(1, 31), "2"))), Optional.of(new LongLiteral(TreeNodes.location(1, 38), "3"))));
    }

    @Test
    public void testSearchedCase() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("CASE WHEN a > 3 THEN 23 WHEN b = a THEN 33 END")))).isEqualTo(new SearchedCaseExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new WhenClause(TreeNodes.location(1, 6), (Expression)new ComparisonExpression(TreeNodes.location(1, 13), ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier(TreeNodes.location(1, 11), "a", false), (Expression)new LongLiteral(TreeNodes.location(1, 15), "3")), (Expression)new LongLiteral(TreeNodes.location(1, 22), "23")), (Object)new WhenClause(TreeNodes.location(1, 25), (Expression)new ComparisonExpression(TreeNodes.location(1, 32), ComparisonExpression.Operator.EQUAL, (Expression)new Identifier(TreeNodes.location(1, 30), "b", false), (Expression)new Identifier(TreeNodes.location(1, 34), "a", false)), (Expression)new LongLiteral(TreeNodes.location(1, 41), "33"))), Optional.empty()));
    }

    @Test
    public void testSetSession() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION foo = 'bar'")))).isEqualTo(new SetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false))), (Expression)new StringLiteral(TreeNodes.location(1, 19), "bar")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION foo.bar = 'baz'")))).isEqualTo(new SetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false))), (Expression)new StringLiteral(TreeNodes.location(1, 23), "baz")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION foo.bar.boo = 'baz'")))).isEqualTo(new SetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false), (Object)new Identifier(TreeNodes.location(1, 21), "boo", false))), (Expression)new StringLiteral(TreeNodes.location(1, 27), "baz")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION foo.bar = 'ban' || 'ana'")))).isEqualTo(new SetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false))), (Expression)new FunctionCall(TreeNodes.location(1, 29), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 23), "ban"), (Object)new StringLiteral(TreeNodes.location(1, 32), "ana")))));
    }

    @Test
    public void testResetSession() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("RESET SESSION foo.bar")))).isEqualTo(new ResetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 15), "foo", false), (Object)new Identifier(TreeNodes.location(1, 19), "bar", false)))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("RESET SESSION foo")))).isEqualTo(new ResetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 15), "foo", false)))));
    }

    @Test
    public void testSessionIdentifiers() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION \"foo-bar\".baz = 'x'")))).isEqualTo(new SetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo-bar", true), (Object)new Identifier(TreeNodes.location(1, 23), "baz", false))), (Expression)new StringLiteral(TreeNodes.location(1, 29), "x")));
        ParserAssert.assertStatementIsInvalid("SET SESSION foo-bar.name = 'value'").withMessage("line 1:16: mismatched input '-'. Expecting: '.', '='");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("RESET SESSION \"foo-bar\".baz")))).isEqualTo(new ResetSession(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 15), "foo-bar", true), (Object)new Identifier(TreeNodes.location(1, 25), "baz", false)))));
        ParserAssert.assertStatementIsInvalid("RESET SESSION foo-bar.name").withMessage("line 1:18: mismatched input '-'. Expecting: '.', <EOF>");
    }

    @Test
    public void testShowSession() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW SESSION")))).isEqualTo(new ShowSession(TreeNodes.location(1, 1), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW SESSION LIKE '%'")))).isEqualTo(new ShowSession(TreeNodes.location(1, 1), Optional.of("%"), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW SESSION LIKE '%' ESCAPE '$'")))).isEqualTo(new ShowSession(TreeNodes.location(1, 1), Optional.of("%"), Optional.of("$")));
    }

    @Test
    public void testShowCatalogs() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW CATALOGS")))).isEqualTo(new ShowCatalogs(TreeNodes.location(1, 1), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW CATALOGS LIKE '%'")))).isEqualTo(new ShowCatalogs(TreeNodes.location(1, 1), Optional.of("%"), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW CATALOGS LIKE '%$_%' ESCAPE '$'")))).isEqualTo(new ShowCatalogs(TreeNodes.location(1, 1), Optional.of("%$_%"), Optional.of("$")));
    }

    @Test
    public void testShowSchemas() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW SCHEMAS")))).isEqualTo(new ShowSchemas(TreeNodes.location(1, 1), Optional.empty(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW SCHEMAS FROM foo")))).isEqualTo(new ShowSchemas(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 19), "foo", false)), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW SCHEMAS IN foo LIKE '%'")))).isEqualTo(new ShowSchemas(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 17), "foo", false)), Optional.of("%"), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW SCHEMAS IN foo LIKE '%$_%' ESCAPE '$'")))).isEqualTo(new ShowSchemas(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 17), "foo", false)), Optional.of("%$_%"), Optional.of("$")));
    }

    @Test
    public void testShowTables() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW TABLES")))).isEqualTo(new ShowTables(TreeNodes.location(1, 1), Optional.empty(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW TABLES FROM a")))).isEqualTo(new ShowTables(TreeNodes.location(1, 1), Optional.of(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "a", false)))), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW TABLES FROM \"awesome schema\"")))).isEqualTo(new ShowTables(TreeNodes.location(1, 1), Optional.of(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "awesome schema", true)))), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW TABLES IN a LIKE '%$_%' ESCAPE '$'")))).isEqualTo(new ShowTables(TreeNodes.location(1, 1), Optional.of(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 16), "a", false)))), Optional.of("%$_%"), Optional.of("$")));
    }

    @Test
    public void testShowColumns() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW COLUMNS FROM a")))).isEqualTo(new ShowColumns(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "a", false))), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW COLUMNS FROM a.b")))).isEqualTo(new ShowColumns(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "a", false), (Object)new Identifier(TreeNodes.location(1, 21), "b", false))), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW COLUMNS FROM \"awesome table\"")))).isEqualTo(new ShowColumns(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "awesome table", true))), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW COLUMNS FROM \"awesome schema\".\"awesome table\"")))).isEqualTo(new ShowColumns(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "awesome schema", true), (Object)new Identifier(TreeNodes.location(1, 36), "awesome table", true))), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW COLUMNS FROM a.b LIKE '%$_%' ESCAPE '$'")))).isEqualTo(new ShowColumns(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "a", false), (Object)new Identifier(TreeNodes.location(1, 21), "b", false))), Optional.of("%$_%"), Optional.of("$")));
        ParserAssert.assertStatementIsInvalid("SHOW COLUMNS FROM a.b LIKE null").withMessage("line 1:28: mismatched input 'null'. Expecting: <string>");
        ParserAssert.assertStatementIsInvalid("SHOW COLUMNS FROM a.b LIKE 'a' ESCAPE null'").withMessage("line 1:39: mismatched input 'null'. Expecting: <string>");
    }

    @Test
    public void testShowFunctions() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW FUNCTIONS")))).isEqualTo(new ShowFunctions(TreeNodes.location(1, 1), Optional.empty(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW FUNCTIONS FROM x")))).isEqualTo(new ShowFunctions(TreeNodes.location(1, 1), Optional.of(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 21), "x", false)))), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW FUNCTIONS LIKE '%'")))).isEqualTo(new ShowFunctions(TreeNodes.location(1, 1), Optional.empty(), Optional.of("%"), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW FUNCTIONS LIKE '%' ESCAPE '$'")))).isEqualTo(new ShowFunctions(TreeNodes.location(1, 1), Optional.empty(), Optional.of("%"), Optional.of("$")));
    }

    @Test
    public void testSubstringBuiltInFunction() {
        String givenString = "ABCDEF";
        TestSqlParser.assertStatement("SELECT substring('%s' FROM 2)".formatted(givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substr"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2")}))})));
        TestSqlParser.assertStatement("SELECT substring('%s' FROM 2 FOR 3)".formatted(givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substr"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2"), new LongLiteral("3")}))})));
    }

    @Test
    public void testSubstringRegisteredFunction() {
        String givenString = "ABCDEF";
        TestSqlParser.assertStatement("SELECT substring('%s', 2)".formatted(givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substring"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2")}))})));
        TestSqlParser.assertStatement("SELECT substring('%s', 2, 3)".formatted(givenString), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(QualifiedName.of((String)"substring"), (List)Lists.newArrayList((Object[])new Expression[]{new StringLiteral(givenString), new LongLiteral("2"), new LongLiteral("3")}))})));
    }

    @Test
    public void testSelectWithRowType() {
        TestSqlParser.assertStatement("SELECT col1.f1, col2, col3.f1.f2.f3 FROM table1", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new DereferenceExpression((Expression)new Identifier("col1"), QueryUtil.identifier((String)"f1")), new Identifier("col2"), new DereferenceExpression((Expression)new DereferenceExpression((Expression)new DereferenceExpression((Expression)new Identifier("col3"), QueryUtil.identifier((String)"f1")), QueryUtil.identifier((String)"f2")), QueryUtil.identifier((String)"f3"))}), (Relation)new Table(QualifiedName.of((String)"table1"))));
        TestSqlParser.assertStatement("SELECT col1.f1[0], col2, col3[2].f2.f3, col4[4] FROM table1", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new SubscriptExpression((Expression)new DereferenceExpression((Expression)new Identifier("col1"), QueryUtil.identifier((String)"f1")), (Expression)new LongLiteral("0")), new Identifier("col2"), new DereferenceExpression((Expression)new DereferenceExpression((Expression)new SubscriptExpression((Expression)new Identifier("col3"), (Expression)new LongLiteral("2")), QueryUtil.identifier((String)"f2")), QueryUtil.identifier((String)"f3")), new SubscriptExpression((Expression)new Identifier("col4"), (Expression)new LongLiteral("4"))}), (Relation)new Table(QualifiedName.of((String)"table1"))));
        TestSqlParser.assertStatement("SELECT CAST(ROW(11, 12) AS ROW(COL0 INTEGER, COL1 INTEGER)).col0", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new DereferenceExpression((Expression)new Cast((Expression)new Row((List)Lists.newArrayList((Object[])new Expression[]{new LongLiteral("11"), new LongLiteral("12")})), (DataType)TreeNodes.rowType(TreeNodes.location(1, 26), TreeNodes.field(TreeNodes.location(1, 30), "COL0", TreeNodes.simpleType(TreeNodes.location(1, 35), "INTEGER")), TreeNodes.field(TreeNodes.location(1, 44), "COL1", TreeNodes.simpleType(TreeNodes.location(1, 49), "INTEGER")))), QueryUtil.identifier((String)"col0"))})));
    }

    @Test
    public void testSelectWithOrderBy() {
        TestSqlParser.assertStatement("SELECT * FROM table1 ORDER BY a", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), (OrderBy)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"a")})));
    }

    @Test
    public void testSelectWithOffset() {
        TestSqlParser.assertStatement("SELECT * FROM table1 OFFSET 2 ROWS", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 OFFSET 2", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new LongLiteral("1"), new StringLiteral("1")}), QueryUtil.row((Expression[])new Expression[]{new LongLiteral("2"), new StringLiteral("2")})}));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) OFFSET 2 ROWS", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) OFFSET 2", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new LongLiteral("2"))), Optional.empty()));
    }

    @Test
    public void testSelectWithFetch() {
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH FIRST 2 ROWS ONLY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new LongLiteral("2")))));
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH NEXT ROW ONLY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty()))));
        Query valuesQuery = QueryUtil.query((QueryBody)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new LongLiteral("1"), new StringLiteral("1")}), QueryUtil.row((Expression[])new Expression[]{new LongLiteral("2"), new StringLiteral("2")})}));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) FETCH FIRST ROW ONLY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty()))));
        TestSqlParser.assertStatement("SELECT * FROM (VALUES (1, '1'), (2, '2')) FETCH FIRST ROW WITH TIES", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.subquery((Query)valuesQuery), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty(), true))));
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH FIRST 2 ROWS WITH TIES", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new LongLiteral("2"), true))));
        TestSqlParser.assertStatement("SELECT * FROM table1 FETCH NEXT ROW WITH TIES", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst(Optional.empty(), true))));
    }

    @Test
    public void testSelectWithGroupBy() {
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY a", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier("a")))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY a, b", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier("a"))), (Object)new SimpleGroupBy((List)ImmutableList.of((Object)new Identifier("b")))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY ()", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of())))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM table1 GROUP BY AUTO")))).isEqualTo(new Query(TreeNodes.location(1, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 15), TreeNodes.qualifiedName(TreeNodes.location(1, 15), "table1"))), Optional.empty(), Optional.of(new GroupBy(TreeNodes.location(1, 31), false, (List)ImmutableList.of((Object)new AutoGroupBy(TreeNodes.location(1, 31))))), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM table1 GROUP BY ALL AUTO")))).isEqualTo(new Query(TreeNodes.location(1, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 15), TreeNodes.qualifiedName(TreeNodes.location(1, 15), "table1"))), Optional.empty(), Optional.of(new GroupBy(TreeNodes.location(1, 31), false, (List)ImmutableList.of((Object)new AutoGroupBy(TreeNodes.location(1, 35))))), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM table1 GROUP BY DISTINCT AUTO")))).isEqualTo(new Query(TreeNodes.location(1, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 15), TreeNodes.qualifiedName(TreeNodes.location(1, 15), "table1"))), Optional.empty(), Optional.of(new GroupBy(TreeNodes.location(1, 31), true, (List)ImmutableList.of((Object)new AutoGroupBy(TreeNodes.location(1, 40))))), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY GROUPING SETS (a)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new GroupingSets(GroupingSets.Type.EXPLICIT, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a"))))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT a, b, GROUPING(a, b) FROM table1 GROUP BY GROUPING SETS ((a), (b))", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{DereferenceExpression.from((QualifiedName)QualifiedName.of((String)"a")), DereferenceExpression.from((QualifiedName)QualifiedName.of((String)"b")), new GroupingOperation(TreeNodes.location(1, 14), (List)ImmutableList.of((Object)QualifiedName.of((String)"a"), (Object)QualifiedName.of((String)"b")))}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new GroupingSets(GroupingSets.Type.EXPLICIT, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a")), (Object)ImmutableList.of((Object)new Identifier("b"))))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY ALL GROUPING SETS ((a, b), (a), ()), CUBE (c), ROLLUP (d)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns(TreeNodes.location(1, 8))}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(false, (List)ImmutableList.of((Object)new GroupingSets(GroupingSets.Type.EXPLICIT, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a"), (Object)new Identifier("b")), (Object)ImmutableList.of((Object)new Identifier("a")), (Object)ImmutableList.of())), (Object)new GroupingSets(GroupingSets.Type.CUBE, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("c")))), (Object)new GroupingSets(GroupingSets.Type.ROLLUP, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("d"))))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("SELECT * FROM table1 GROUP BY DISTINCT GROUPING SETS ((a, b), (a), ()), CUBE (c), ROLLUP (d)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(QualifiedName.of((String)"table1")), Optional.empty(), Optional.of(new GroupBy(true, (List)ImmutableList.of((Object)new GroupingSets(GroupingSets.Type.EXPLICIT, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("a"), (Object)new Identifier("b")), (Object)ImmutableList.of((Object)new Identifier("a")), (Object)ImmutableList.of())), (Object)new GroupingSets(GroupingSets.Type.CUBE, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("c")))), (Object)new GroupingSets(GroupingSets.Type.ROLLUP, (List)ImmutableList.of((Object)ImmutableList.of((Object)new Identifier("d"))))))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testCreateCatalog() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE CATALOG test USING conn")))).isEqualTo(new CreateCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 16), "test", false), false, new Identifier(TreeNodes.location(1, 27), "conn", false), (List)ImmutableList.of(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE CATALOG IF NOT EXISTS test USING conn")))).isEqualTo(new CreateCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 30), "test", false), true, new Identifier(TreeNodes.location(1, 41), "conn", false), (List)ImmutableList.of(), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE CATALOG test USING conn COMMENT 'awesome' AUTHORIZATION ROLE dragon WITH (\"a\" = 'apple', \"b\" = 123)")))).isEqualTo(new CreateCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 16), "test", false), false, new Identifier(TreeNodes.location(1, 27), "conn", false), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 82), new Identifier(TreeNodes.location(1, 82), "a", true), (Expression)new StringLiteral(TreeNodes.location(1, 88), "apple")), (Object)new Property(TreeNodes.location(1, 97), new Identifier(TreeNodes.location(1, 97), "b", true), (Expression)new LongLiteral(TreeNodes.location(1, 103), "123"))), Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 69), "dragon", false))), Optional.of("awesome")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE CATALOG \"some name that contains space\" USING \"conn-with-dash\"")))).isEqualTo(new CreateCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 16), "some name that contains space", true), false, new Identifier(TreeNodes.location(1, 54), "conn-with-dash", true), (List)ImmutableList.of(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testDropCatalog() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP CATALOG test")))).isEqualTo(new DropCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 14), "test", false), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP CATALOG test CASCADE")))).isEqualTo(new DropCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 14), "test", false), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP CATALOG IF EXISTS test")))).isEqualTo(new DropCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 24), "test", false), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP CATALOG IF EXISTS test RESTRICT")))).isEqualTo(new DropCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 24), "test", false), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP CATALOG \"some catalog that contains space\"")))).isEqualTo(new DropCatalog(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 14), "some catalog that contains space", true), false, false));
    }

    @Test
    public void testCreateSchema() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE SCHEMA test")))).isEqualTo(new CreateSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 15), "test", false))), false, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE SCHEMA IF NOT EXISTS test")))).isEqualTo(new CreateSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 29), "test", false))), true, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE SCHEMA test WITH (a = 'apple', b = 123)")))).isEqualTo(new CreateSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 15), "test", false))), false, (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 26), new Identifier(TreeNodes.location(1, 26), "a", false), (Expression)new StringLiteral(TreeNodes.location(1, 30), "apple")), (Object)new Property(TreeNodes.location(1, 39), new Identifier(TreeNodes.location(1, 39), "b", false), (Expression)new LongLiteral(TreeNodes.location(1, 43), "123"))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE SCHEMA \"some name that contains space\"")))).isEqualTo(new CreateSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 15), "some name that contains space", true))), false, (List)ImmutableList.of(), Optional.empty()));
    }

    @Test
    public void testDropSchema() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP SCHEMA test")))).isEqualTo(new DropSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 13), "test", false))), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP SCHEMA test CASCADE")))).isEqualTo(new DropSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 13), "test", false))), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP SCHEMA IF EXISTS test")))).isEqualTo(new DropSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 23), "test", false))), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP SCHEMA IF EXISTS test RESTRICT")))).isEqualTo(new DropSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 23), "test", false))), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP SCHEMA \"some schema that contains space\"")))).isEqualTo(new DropSchema(TreeNodes.location(1, 1), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 13), "some schema that contains space", true))), false, false));
    }

    @Test
    public void testRenameSchema() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER SCHEMA foo RENAME TO bar")))).isEqualTo(new RenameSchema(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 14), "foo", false))), new Identifier(TreeNodes.location(1, 28), "bar", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER SCHEMA foo.bar RENAME TO baz")))).isEqualTo(new RenameSchema(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 14), "foo", false), (Object)new Identifier(TreeNodes.location(1, 18), "bar", false))), new Identifier(TreeNodes.location(1, 32), "baz", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER SCHEMA \"awesome schema\".\"awesome table\" RENAME TO \"even more awesome table\"")))).isEqualTo(new RenameSchema(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 14), "awesome schema", true), (Object)new Identifier(TreeNodes.location(1, 31), "awesome table", true))), new Identifier(TreeNodes.location(1, 57), "even more awesome table", true)));
    }

    @Test
    public void testUnicodeString() {
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&''")))).isEqualTo(new StringLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'' UESCAPE ')'")))).isEqualTo(new StringLiteral(location, ""));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801'")))).isEqualTo(new StringLiteral(location, "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'\u6d4b\u8bd5ABC\\6d4B\\8Bd5'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\u6d4b\u8bd5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5ABC\\6d4B\\8Bd5'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\u6d4b\u8bd5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5ABC\\\\'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\\"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5ABC###8Bd5' UESCAPE '#'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC#\u8bd5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("u&'\u6d4b\u8bd5''A''B''C##''''#8Bd5' UESCAPE '#'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5'A'B'C#''\u8bd5"));
        TestSqlParser.assertInvalidExpression("U&  '\u6d4b\u8bd5ABC\\\\'", ".*mismatched input.*");
        TestSqlParser.assertInvalidExpression("u&'\u6d4b\u8bd5ABC\\'", "Incomplete escape sequence: ");
        TestSqlParser.assertInvalidExpression("u&'\u6d4b\u8bd5ABC\\+'", "Incomplete escape sequence: ");
        TestSqlParser.assertInvalidExpression("U&'hello\\6dB\\8Bd5'", "Incomplete escape sequence: 6dB.*");
        TestSqlParser.assertInvalidExpression("U&'hello\\6D4B\\8Bd'", "Incomplete escape sequence: 8Bd");
        TestSqlParser.assertInvalidExpression("U&'hello\\K6B\\8Bd5'", "Invalid hexadecimal digit: K");
        TestSqlParser.assertInvalidExpression("U&'hello\\+FFFFFD\\8Bd5'", "Invalid escaped character: FFFFFD");
        TestSqlParser.assertInvalidExpression("U&'hello\\DBFF'", "Invalid escaped character: DBFF\\. Escaped character is a surrogate\\. Use '\\\\\\+123456' instead\\.");
        TestSqlParser.assertInvalidExpression("U&'hello\\+00DBFF'", "Invalid escaped character: 00DBFF\\. Escaped character is a surrogate\\. Use '\\\\\\+123456' instead\\.");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '%%'", "Invalid Unicode escape character: %%");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '\udbff'", "Invalid Unicode escape character: \udbff");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '\n'", "Invalid Unicode escape character: \n");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE ''''", "Invalid Unicode escape character: '");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE ' '", "Invalid Unicode escape character:  ");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE ''", "Empty Unicode escape character");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '1'", "Invalid Unicode escape character: 1");
        TestSqlParser.assertInvalidExpression("U&'hello\\8Bd5' UESCAPE '+'", "Invalid Unicode escape character: \\+");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'hello!6d4B!8Bd5!+10FFFFworld!7F16!7801' UESCAPE '!'")))).isEqualTo(new StringLiteral(location, "hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'\u6d4b\u8bd5ABC!6d4B!8Bd5' UESCAPE '!'")))).isEqualTo(new StringLiteral(location, "\u6d4b\u8bd5ABC\u6d4b\u8bd5"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801' UESCAPE '!'")))).isEqualTo(new StringLiteral(TreeNodes.location(1, 1), "hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801"));
    }

    @Test
    public void testCreateTable() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo (a VARCHAR, b BIGINT COMMENT 'hello world', c IPADDRESS)")))).isEqualTo(new CreateTable(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), (List)ImmutableList.of((Object)TreeNodes.columnDefinition(TreeNodes.location(1, 19), "a", TreeNodes.simpleType(TreeNodes.location(1, 21), "VARCHAR")), (Object)TreeNodes.columnDefinition(TreeNodes.location(1, 30), "b", TreeNodes.simpleType(TreeNodes.location(1, 32), "BIGINT"), true, "hello world"), (Object)TreeNodes.columnDefinition(TreeNodes.location(1, 62), "c", TreeNodes.simpleType(TreeNodes.location(1, 64), "IPADDRESS"))), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c TIMESTAMP)")))).isEqualTo(new CreateTable(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 28), "bar"), (List)ImmutableList.of((Object)TreeNodes.columnDefinition(TreeNodes.location(1, 33), "c", (DataType)TreeNodes.dateTimeType(TreeNodes.location(1, 35), DateTimeDataType.Type.TIMESTAMP, false), true)), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR WITH (nullable = true, compression = 'LZ4'))")))).describedAs("CREATE TABLE with column properties", new Object[0]))).isEqualTo(new CreateTable(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 28), "bar"), (List)ImmutableList.of((Object)TreeNodes.columnDefinition(TreeNodes.location(1, 33), "c", TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, (List<Property>)ImmutableList.of((Object)TreeNodes.property(TreeNodes.location(1, 49), "nullable", (Expression)new BooleanLiteral(TreeNodes.location(1, 60), "true")), (Object)TreeNodes.property(TreeNodes.location(1, 66), "compression", (Expression)new StringLiteral(TreeNodes.location(1, 80), "LZ4"))))), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE IF NOT EXISTS bar (LIKE like_table)", (Statement)new CreateTable(new NodeLocation(1, 1), QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.empty())), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table)")))).ignoringLocation().isEqualTo(new CreateTable(new NodeLocation(1, 1), QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.empty())), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table, d BIGINT)")))).ignoringLocation().isEqualTo(new CreateTable(new NodeLocation(1, 1), QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.empty()), (Object)new ColumnDefinition(QualifiedName.of((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 63), "BIGINT"), true, Collections.emptyList(), Optional.empty())), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty()));
        TestSqlParser.assertStatement("CREATE TABLE IF NOT EXISTS bar (LIKE like_table INCLUDING PROPERTIES)", (Statement)new CreateTable(new NodeLocation(1, 1), QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.of(LikeClause.PropertiesOption.INCLUDING))), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table EXCLUDING PROPERTIES)")))).ignoringLocation().isEqualTo(new CreateTable(new NodeLocation(1, 1), QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.of(LikeClause.PropertiesOption.EXCLUDING))), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS bar (c VARCHAR, LIKE like_table EXCLUDING PROPERTIES) COMMENT 'test'")))).ignoringLocation().isEqualTo(new CreateTable(new NodeLocation(1, 1), QualifiedName.of((String)"bar"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 35), "VARCHAR"), true, Collections.emptyList(), Optional.empty()), (Object)new LikeClause(QualifiedName.of((String)"like_table"), Optional.of(LikeClause.PropertiesOption.EXCLUDING))), SaveMode.IGNORE, (List)ImmutableList.of(), Optional.of("test")));
    }

    @Test
    public void testCreateTableWithNotNull() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo (\na VARCHAR NOT NULL COMMENT 'column a',\nb BIGINT COMMENT 'hello world',\nc IPADDRESS,\nd INTEGER NOT NULL)\n")))).ignoringLocation().isEqualTo(new CreateTable(new NodeLocation(1, 1), QualifiedName.of((String)"foo"), (List)ImmutableList.of((Object)new ColumnDefinition(QualifiedName.of((String)"a"), TreeNodes.simpleType(TreeNodes.location(1, 20), "VARCHAR"), false, Collections.emptyList(), Optional.of("column a")), (Object)new ColumnDefinition(QualifiedName.of((String)"b"), TreeNodes.simpleType(TreeNodes.location(1, 59), "BIGINT"), true, Collections.emptyList(), Optional.of("hello world")), (Object)new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 91), "IPADDRESS"), true, Collections.emptyList(), Optional.empty()), (Object)new ColumnDefinition(QualifiedName.of((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 104), "INTEGER"), false, Collections.emptyList(), Optional.empty())), SaveMode.FAIL, (List)ImmutableList.of(), Optional.empty()));
    }

    @Test
    public void testCreateTableAsSelect() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo AS SELECT * FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(1, 21), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 21), new Select(TreeNodes.location(1, 21), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 28), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 35), TreeNodes.qualifiedName(TreeNodes.location(1, 35), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of(), true, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x) AS SELECT a FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(1, 24), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 24), new Select(TreeNodes.location(1, 24), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 31), (Expression)new Identifier(TreeNodes.location(1, 31), "a", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 38), TreeNodes.qualifiedName(TreeNodes.location(1, 38), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x,y) AS SELECT a,b FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(1, 26), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 26), new Select(TreeNodes.location(1, 26), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 33), (Expression)new Identifier(TreeNodes.location(1, 33), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(1, 35), (Expression)new Identifier(TreeNodes.location(1, 35), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 42), TreeNodes.qualifiedName(TreeNodes.location(1, 42), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false), (Object)new Identifier(TreeNodes.location(1, 20), "y", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE TABLE foo AS SELECT * FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 25), "foo"), new Query(TreeNodes.location(1, 32), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 32), new Select(TreeNodes.location(1, 32), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 39), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 46), TreeNodes.qualifiedName(TreeNodes.location(1, 46), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.REPLACE, (List)ImmutableList.of(), true, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE TABLE foo(x) AS SELECT a FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 25), "foo"), new Query(TreeNodes.location(1, 35), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 35), new Select(TreeNodes.location(1, 35), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 42), (Expression)new Identifier(TreeNodes.location(1, 42), "a", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 49), TreeNodes.qualifiedName(TreeNodes.location(1, 49), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.REPLACE, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 29), "x", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE TABLE foo(x,y) AS SELECT a,b FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 25), "foo"), new Query(TreeNodes.location(1, 37), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 37), new Select(TreeNodes.location(1, 37), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 44), (Expression)new Identifier(TreeNodes.location(1, 44), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(1, 46), (Expression)new Identifier(TreeNodes.location(1, 46), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 53), TreeNodes.qualifiedName(TreeNodes.location(1, 53), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.REPLACE, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 29), "x", false), (Object)new Identifier(TreeNodes.location(1, 31), "y", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS foo AS SELECT * FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 28), "foo"), new Query(TreeNodes.location(1, 35), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 35), new Select(TreeNodes.location(1, 35), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 42), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 49), TreeNodes.qualifiedName(TreeNodes.location(1, 49), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.IGNORE, (List)ImmutableList.of(), true, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS foo(x) AS SELECT a FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 28), "foo"), new Query(TreeNodes.location(1, 38), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 38), new Select(TreeNodes.location(1, 38), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 45), (Expression)new Identifier(TreeNodes.location(1, 45), "a", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 52), TreeNodes.qualifiedName(TreeNodes.location(1, 52), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.IGNORE, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 32), "x", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE IF NOT EXISTS foo(x,y) AS SELECT a,b FROM t")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 28), "foo"), new Query(TreeNodes.location(1, 40), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 40), new Select(TreeNodes.location(1, 40), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 47), (Expression)new Identifier(TreeNodes.location(1, 47), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(1, 49), (Expression)new Identifier(TreeNodes.location(1, 49), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 56), TreeNodes.qualifiedName(TreeNodes.location(1, 56), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.IGNORE, (List)ImmutableList.of(), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 32), "x", false), (Object)new Identifier(TreeNodes.location(1, 34), "y", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo AS SELECT * FROM t WITH NO DATA")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(1, 21), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 21), new Select(TreeNodes.location(1, 21), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 28), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 35), TreeNodes.qualifiedName(TreeNodes.location(1, 35), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x) AS SELECT a FROM t WITH NO DATA")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(1, 24), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 24), new Select(TreeNodes.location(1, 24), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 31), (Expression)new Identifier(TreeNodes.location(1, 31), "a", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 38), TreeNodes.qualifiedName(TreeNodes.location(1, 38), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x,y) AS SELECT a,b FROM t WITH NO DATA")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(1, 26), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 26), new Select(TreeNodes.location(1, 26), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 33), (Expression)new Identifier(TreeNodes.location(1, 33), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(1, 35), (Expression)new Identifier(TreeNodes.location(1, 35), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 42), TreeNodes.qualifiedName(TreeNodes.location(1, 42), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false), (Object)new Identifier(TreeNodes.location(1, 20), "y", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT * FROM t\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(4, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(4, 15), TreeNodes.qualifiedName(TreeNodes.location(4, 15), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), true, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x)\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT a FROM t\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new Identifier(TreeNodes.location(4, 8), "a", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(4, 15), TreeNodes.qualifiedName(TreeNodes.location(4, 15), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x,y)\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT a,b FROM t\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new Identifier(TreeNodes.location(4, 8), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(4, 10), (Expression)new Identifier(TreeNodes.location(4, 10), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(4, 17), TreeNodes.qualifiedName(TreeNodes.location(4, 17), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), true, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false), (Object)new Identifier(TreeNodes.location(1, 20), "y", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT * FROM t\nWITH NO DATA\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(4, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(4, 15), TreeNodes.qualifiedName(TreeNodes.location(4, 15), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x)\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT a FROM t\nWITH NO DATA\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new Identifier(TreeNodes.location(4, 8), "a", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(4, 15), TreeNodes.qualifiedName(TreeNodes.location(4, 15), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), false, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x,y)\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT a,b FROM t\nWITH NO DATA\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new Identifier(TreeNodes.location(4, 8), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(4, 10), (Expression)new Identifier(TreeNodes.location(4, 10), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(4, 17), TreeNodes.qualifiedName(TreeNodes.location(4, 17), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), false, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false), (Object)new Identifier(TreeNodes.location(1, 20), "y", false))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo COMMENT 'test'\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT * FROM t\nWITH NO DATA\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(4, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(4, 15), TreeNodes.qualifiedName(TreeNodes.location(4, 15), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), false, Optional.empty(), Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x) COMMENT 'test'\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT a FROM t\nWITH NO DATA\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new Identifier(TreeNodes.location(4, 8), "a", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(4, 15), TreeNodes.qualifiedName(TreeNodes.location(4, 15), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), false, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false))), Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x,y) COMMENT 'test'\nWITH ( string = 'bar', long = 42, computed = 'ban' || 'ana', a  = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT a,b FROM t\nWITH NO DATA\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new Identifier(TreeNodes.location(4, 8), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(4, 10), (Expression)new Identifier(TreeNodes.location(4, 10), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(4, 17), TreeNodes.qualifiedName(TreeNodes.location(4, 17), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", false), (Expression)new StringLiteral(TreeNodes.location(2, 17), "bar")), (Object)new Property(TreeNodes.location(2, 24), new Identifier(TreeNodes.location(2, 24), "long", false), (Expression)new LongLiteral(TreeNodes.location(2, 31), "42")), (Object)new Property(TreeNodes.location(2, 35), new Identifier(TreeNodes.location(2, 35), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 52), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 46), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 55), "ana")))), (Object)new Property(TreeNodes.location(2, 62), new Identifier(TreeNodes.location(2, 62), "a", false), (Expression)new Array(TreeNodes.location(2, 67), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 74), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 80), "v2"))))), false, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false), (Object)new Identifier(TreeNodes.location(1, 20), "y", false))), Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE TABLE foo(x,y) COMMENT 'test'\nWITH ( \"string\" = 'bar', \"long\" = 42, computed = 'ban' || 'ana', a = ARRAY[ 'v1', 'v2' ] )\nAS\nSELECT a,b FROM t\nWITH NO DATA\n")))).isEqualTo(new CreateTableAsSelect(TreeNodes.location(1, 1), TreeNodes.qualifiedName(TreeNodes.location(1, 14), "foo"), new Query(TreeNodes.location(4, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new Identifier(TreeNodes.location(4, 8), "a", false), Optional.empty()), (Object)new SingleColumn(TreeNodes.location(4, 10), (Expression)new Identifier(TreeNodes.location(4, 10), "b", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(4, 17), TreeNodes.qualifiedName(TreeNodes.location(4, 17), "t"))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), SaveMode.FAIL, (List)ImmutableList.of((Object)new Property(TreeNodes.location(2, 8), new Identifier(TreeNodes.location(2, 8), "string", true), (Expression)new StringLiteral(TreeNodes.location(2, 19), "bar")), (Object)new Property(TreeNodes.location(2, 26), new Identifier(TreeNodes.location(2, 26), "long", true), (Expression)new LongLiteral(TreeNodes.location(2, 35), "42")), (Object)new Property(TreeNodes.location(2, 39), new Identifier(TreeNodes.location(2, 39), "computed", false), (Expression)new FunctionCall(TreeNodes.location(2, 56), QualifiedName.of((String)"concat"), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 50), "ban"), (Object)new StringLiteral(TreeNodes.location(2, 59), "ana")))), (Object)new Property(TreeNodes.location(2, 66), new Identifier(TreeNodes.location(2, 66), "a", false), (Expression)new Array(TreeNodes.location(2, 70), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(2, 77), "v1"), (Object)new StringLiteral(TreeNodes.location(2, 83), "v2"))))), false, Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "x", false), (Object)new Identifier(TreeNodes.location(1, 20), "y", false))), Optional.of("test")));
    }

    @Test
    public void testCreateTableAsWith() {
        String queryParenthesizedWith = "CREATE TABLE foo\nAS\n( WITH t(x) AS (VALUES 1)\nTABLE t )\nWITH NO DATA\n";
        String queryUnparenthesizedWith = "CREATE TABLE foo\nAS\nWITH t(x) AS (VALUES 1)\nTABLE t\nWITH NO DATA\n";
        String queryParenthesizedWithHasAlias = "CREATE TABLE foo(a)\nAS\n( WITH t(x) AS (VALUES 1)\nTABLE t )\nWITH NO DATA\n";
        String queryUnparenthesizedWithHasAlias = "CREATE TABLE foo(a)\nAS\nWITH t(x) AS (VALUES 1)\nTABLE t\nWITH NO DATA\n";
        QualifiedName table = QualifiedName.of((String)"foo");
        Query query = new Query((List)ImmutableList.of(), (List)ImmutableList.of(), Optional.of(new With(false, (List)ImmutableList.of((Object)new WithQuery(QueryUtil.identifier((String)"t"), QueryUtil.query((QueryBody)new Values((List)ImmutableList.of((Object)new LongLiteral("1")))), Optional.of(ImmutableList.of((Object)QueryUtil.identifier((String)"x"))))))), (QueryBody)new Table(QualifiedName.of((String)"t")), Optional.empty(), Optional.empty(), Optional.empty());
        TestSqlParser.assertStatement(queryParenthesizedWith, (Statement)new CreateTableAsSelect(TreeNodes.location(1, 1), table, query, SaveMode.FAIL, (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement(queryUnparenthesizedWith, (Statement)new CreateTableAsSelect(TreeNodes.location(1, 1), table, query, SaveMode.FAIL, (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement(queryParenthesizedWithHasAlias, (Statement)new CreateTableAsSelect(TreeNodes.location(1, 1), table, query, SaveMode.FAIL, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier("a"))), Optional.empty()));
        TestSqlParser.assertStatement(queryUnparenthesizedWithHasAlias, (Statement)new CreateTableAsSelect(TreeNodes.location(1, 1), table, query, SaveMode.FAIL, (List)ImmutableList.of(), false, Optional.of(ImmutableList.of((Object)new Identifier("a"))), Optional.empty()));
    }

    @Test
    public void testDropTable() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE a")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "a", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE a.b")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "a", false), (Object)new Identifier(TreeNodes.location(1, 14), "b", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE a.b.c")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "a", false), (Object)new Identifier(TreeNodes.location(1, 14), "b", false), (Object)new Identifier(TreeNodes.location(1, 16), "c", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE a.\"b/y\".c")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "a", false), (Object)new Identifier(TreeNodes.location(1, 14), "b/y", true), (Object)new Identifier(TreeNodes.location(1, 20), "c", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE IF EXISTS a")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 22), "a", false))), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE IF EXISTS a.b")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 22), "a", false), (Object)new Identifier(TreeNodes.location(1, 24), "b", false))), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE IF EXISTS a.b.c")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 22), "a", false), (Object)new Identifier(TreeNodes.location(1, 24), "b", false), (Object)new Identifier(TreeNodes.location(1, 26), "c", false))), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP TABLE IF EXISTS a.\"b/y\".c")))).isEqualTo(new DropTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 22), "a", false), (Object)new Identifier(TreeNodes.location(1, 24), "b/y", true), (Object)new Identifier(TreeNodes.location(1, 30), "c", false))), true));
    }

    @Test
    public void testTruncateTable() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("TRUNCATE TABLE a")))).isEqualTo(new TruncateTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 16), "a", false)))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("TRUNCATE TABLE a.b")))).isEqualTo(new TruncateTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 16), "a", false), (Object)new Identifier(TreeNodes.location(1, 18), "b", false)))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("TRUNCATE TABLE a.b.c")))).isEqualTo(new TruncateTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 16), "a", false), (Object)new Identifier(TreeNodes.location(1, 18), "b", false), (Object)new Identifier(TreeNodes.location(1, 20), "c", false)))));
    }

    @Test
    public void testDropView() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP VIEW a")))).isEqualTo(new DropView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 11), "a", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP VIEW a.b")))).isEqualTo(new DropView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 11), "a", false), (Object)new Identifier(TreeNodes.location(1, 13), "b", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP VIEW a.b.c")))).isEqualTo(new DropView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 11), "a", false), (Object)new Identifier(TreeNodes.location(1, 13), "b", false), (Object)new Identifier(TreeNodes.location(1, 15), "c", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP VIEW IF EXISTS a")))).isEqualTo(new DropView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 21), "a", false))), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP VIEW IF EXISTS a.b")))).isEqualTo(new DropView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 21), "a", false), (Object)new Identifier(TreeNodes.location(1, 23), "b", false))), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP VIEW IF EXISTS a.b.c")))).isEqualTo(new DropView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 21), "a", false), (Object)new Identifier(TreeNodes.location(1, 23), "b", false), (Object)new Identifier(TreeNodes.location(1, 25), "c", false))), true));
    }

    @Test
    public void testInsertInto() {
        Table table = new Table(QualifiedName.of((String)"a", (String[])new String[]{"b/c", "d"}));
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
        TestSqlParser.assertStatement("INSERT INTO a.\"b/c\".d SELECT * FROM t", (Statement)new Insert(TreeNodes.location(1, 1), table, Optional.empty(), query));
        TestSqlParser.assertStatement("INSERT INTO a.\"b/c\".d (c1, c2) SELECT * FROM t", (Statement)new Insert(TreeNodes.location(1, 1), table, Optional.of(ImmutableList.of((Object)QueryUtil.identifier((String)"c1"), (Object)QueryUtil.identifier((String)"c2"))), query));
    }

    @Test
    public void testDelete() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DELETE FROM t")))).isEqualTo(new Delete(TreeNodes.location(1, 1), new Table(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "t", false)))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DELETE FROM \"awesome table\"")))).isEqualTo(new Delete(TreeNodes.location(1, 1), new Table(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "awesome table", true)))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DELETE FROM t WHERE a = b")))).isEqualTo(new Delete(TreeNodes.location(1, 1), new Table(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "t", false)))), Optional.of(new ComparisonExpression(TreeNodes.location(1, 23), ComparisonExpression.Operator.EQUAL, (Expression)new Identifier(TreeNodes.location(1, 21), "a", false), (Expression)new Identifier(TreeNodes.location(1, 25), "b", false)))));
    }

    @Test
    public void testMerge() {
        NodeLocation location = new NodeLocation(1, 1);
        TestSqlParser.assertStatement("MERGE INTO inventory AS i\n  USING changes AS c\n  ON i.part = c.part\nWHEN MATCHED AND c.action = 'mod'\n  THEN UPDATE SET\n    qty = qty + c.qty\n  , ts = CURRENT_TIMESTAMP\nWHEN MATCHED AND c.action = 'del'\n  THEN DELETE\nWHEN NOT MATCHED AND c.action = 'new'\n  THEN INSERT (part, qty) VALUES (c.part, c.qty)\n", (Statement)new Merge(location, (Relation)new AliasedRelation(location, (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"inventory")), new Identifier("i"), null), QueryUtil.aliased((Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"changes")), (String)"c"), QueryUtil.equal((Expression)QueryUtil.nameReference((String)"i", (String[])new String[]{"part"}), (Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"part"})), (List)ImmutableList.of((Object)new MergeUpdate(Optional.of(QueryUtil.equal((Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"action"}), (Expression)new StringLiteral("mod"))), (List)ImmutableList.of((Object)new MergeUpdate.Assignment(new Identifier("qty"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, QueryUtil.nameReference((String)"qty", (String[])new String[0]), QueryUtil.nameReference((String)"c", (String[])new String[]{"qty"}))), (Object)new MergeUpdate.Assignment(new Identifier("ts"), (Expression)new CurrentTimestamp(location, Optional.empty())))), (Object)new MergeDelete(Optional.of(QueryUtil.equal((Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"action"}), (Expression)new StringLiteral("del")))), (Object)new MergeInsert(Optional.of(QueryUtil.equal((Expression)QueryUtil.nameReference((String)"c", (String[])new String[]{"action"}), (Expression)new StringLiteral("new"))), (List)ImmutableList.of((Object)new Identifier("part"), (Object)new Identifier("qty")), (List)ImmutableList.of((Object)QueryUtil.nameReference((String)"c", (String[])new String[]{"part"}), (Object)QueryUtil.nameReference((String)"c", (String[])new String[]{"qty"}))))));
    }

    @Test
    public void testRenameTable() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE a RENAME TO b")))).isEqualTo(new RenameTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "a", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "b", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS a RENAME TO b")))).isEqualTo(new RenameTable(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "a", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 35), "b", false))), true));
    }

    @Test
    public void testSetTableProperties() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE a SET PROPERTIES foo='bar'")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.TABLE, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 30), new Identifier(TreeNodes.location(1, 30), "foo", false), (Expression)new StringLiteral(TreeNodes.location(1, 34), "bar")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE a SET PROPERTIES foo=true")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.TABLE, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 30), new Identifier(TreeNodes.location(1, 30), "foo", false), (Expression)new BooleanLiteral(TreeNodes.location(1, 34), "true")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE a SET PROPERTIES foo=123")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.TABLE, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 30), new Identifier(TreeNodes.location(1, 30), "foo", false), (Expression)new LongLiteral(TreeNodes.location(1, 34), "123")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE a SET PROPERTIES foo=123, bar=456")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.TABLE, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 30), new Identifier(TreeNodes.location(1, 30), "foo", false), (Expression)new LongLiteral(TreeNodes.location(1, 34), "123")), (Object)new Property(TreeNodes.location(1, 39), new Identifier(TreeNodes.location(1, 39), "bar", false), (Expression)new LongLiteral(TreeNodes.location(1, 43), "456")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE a SET PROPERTIES \" s p a c e \"='bar'")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.TABLE, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 30), new Identifier(TreeNodes.location(1, 30), " s p a c e ", true), (Expression)new StringLiteral(TreeNodes.location(1, 44), "bar")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE a SET PROPERTIES foo=123, bar=DEFAULT")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.TABLE, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 30), new Identifier(TreeNodes.location(1, 30), "foo", false), (Expression)new LongLiteral(TreeNodes.location(1, 34), "123")), (Object)new Property(TreeNodes.location(1, 39), new Identifier(TreeNodes.location(1, 39), "bar", false)))));
        ParserAssert.assertStatementIsInvalid("ALTER TABLE a SET PROPERTIES").withMessage("line 1:29: mismatched input '<EOF>'. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER TABLE a SET PROPERTIES ()").withMessage("line 1:30: mismatched input '('. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER TABLE a SET PROPERTIES (foo='bar')").withMessage("line 1:30: mismatched input '('. Expecting: <identifier>");
    }

    @Test
    public void testCommentTable() {
        QualifiedName table = QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "a", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON TABLE a IS 'test'")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.TABLE, table, Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON TABLE a IS ''")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.TABLE, table, Optional.of("")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON TABLE a IS NULL")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.TABLE, table, Optional.empty()));
    }

    @Test
    public void testCommentView() {
        QualifiedName view = QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 17), "a", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON VIEW a IS 'test'")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.VIEW, view, Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON VIEW a IS ''")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.VIEW, view, Optional.of("")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON VIEW a IS NULL")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.VIEW, view, Optional.empty()));
    }

    @Test
    public void testCommentColumn() {
        QualifiedName column = QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "a", false), (Object)new Identifier(TreeNodes.location(1, 21), "b", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON COLUMN a.b IS 'test'")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.COLUMN, column, Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON COLUMN a.b IS ''")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.COLUMN, column, Optional.of("")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON COLUMN a.b IS NULL")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.COLUMN, column, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON COLUMN a IS 'test'")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.COLUMN, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "a", false))), Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON COLUMN a.b.c IS 'test'")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.COLUMN, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "a", false), (Object)new Identifier(TreeNodes.location(1, 21), "b", false), (Object)new Identifier(TreeNodes.location(1, 23), "c", false))), Optional.of("test")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMENT ON COLUMN a.b.c.d IS 'test'")))).isEqualTo(new Comment(TreeNodes.location(1, 1), Comment.Type.COLUMN, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "a", false), (Object)new Identifier(TreeNodes.location(1, 21), "b", false), (Object)new Identifier(TreeNodes.location(1, 23), "c", false), (Object)new Identifier(TreeNodes.location(1, 25), "d", false))), Optional.of("test")));
    }

    @Test
    public void testRenameColumn() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t RENAME COLUMN a TO b")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 33), "a", false))), new Identifier(TreeNodes.location(1, 38), "b", false), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN a TO b")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 43), "a", false))), new Identifier(TreeNodes.location(1, 48), "b", false), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t RENAME COLUMN IF EXISTS a TO b")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 43), "a", false))), new Identifier(TreeNodes.location(1, 48), "b", false), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN IF EXISTS a TO b")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 53), "a", false))), new Identifier(TreeNodes.location(1, 58), "b", false), true, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t RENAME COLUMN c.d TO x")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 33), "c", false), (Object)new Identifier(TreeNodes.location(1, 35), "d", false))), new Identifier(TreeNodes.location(1, 40), "x", false), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t RENAME COLUMN IF EXISTS c.d TO x")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 43), "c", false), (Object)new Identifier(TreeNodes.location(1, 45), "d", false))), new Identifier(TreeNodes.location(1, 50), "x", false), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN c.d TO x")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 43), "c", false), (Object)new Identifier(TreeNodes.location(1, 45), "d", false))), new Identifier(TreeNodes.location(1, 50), "x", false), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN b.\"c.d\" TO x")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 43), "b", false), (Object)new Identifier(TreeNodes.location(1, 45), "c.d", true))), new Identifier(TreeNodes.location(1, 54), "x", false), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN \"b.c\".d TO x")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 43), "b.c", true), (Object)new Identifier(TreeNodes.location(1, 49), "d", false))), new Identifier(TreeNodes.location(1, 54), "x", false), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t RENAME COLUMN IF EXISTS c.d TO x")))).isEqualTo(new RenameColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 53), "c", false), (Object)new Identifier(TreeNodes.location(1, 55), "d", false))), new Identifier(TreeNodes.location(1, 60), "x", false), true, true));
    }

    @Test
    public void testRenameView() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER VIEW a RENAME TO b")))).isEqualTo(new RenameView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "a", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 24), "b", false)))));
    }

    @Test
    public void testAlterViewSetAuthorization() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER VIEW foo.bar.baz SET AUTHORIZATION qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "VIEW", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "foo", false), (Object)new Identifier(TreeNodes.location(1, 16), "bar", false), (Object)new Identifier(TreeNodes.location(1, 20), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 42), "qux", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER VIEW foo.bar.baz SET AUTHORIZATION USER qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "VIEW", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "foo", false), (Object)new Identifier(TreeNodes.location(1, 16), "bar", false), (Object)new Identifier(TreeNodes.location(1, 20), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 47), "qux", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER VIEW foo.bar.baz SET AUTHORIZATION ROLE qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "VIEW", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 12), "foo", false), (Object)new Identifier(TreeNodes.location(1, 16), "bar", false), (Object)new Identifier(TreeNodes.location(1, 20), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 47), "qux", false))));
    }

    @Test
    public void testTableExecute() {
        Table table = new Table(TreeNodes.location(1, 7), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false))));
        Identifier procedure = new Identifier(TreeNodes.location(1, 25), "bar", false);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo EXECUTE bar")))).isEqualTo(new TableExecute(TreeNodes.location(1, 1), table, procedure, (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo EXECUTE bar(bah => 1, wuh => 'clap') WHERE age > 17")))).isEqualTo(new TableExecute(TreeNodes.location(1, 1), table, procedure, (List)ImmutableList.of((Object)new CallArgument(TreeNodes.location(1, 29), Optional.of(new Identifier(TreeNodes.location(1, 29), "bah", false)), (Expression)new LongLiteral(TreeNodes.location(1, 36), "1")), (Object)new CallArgument(TreeNodes.location(1, 39), Optional.of(new Identifier(TreeNodes.location(1, 39), "wuh", false)), (Expression)new StringLiteral(TreeNodes.location(1, 46), "clap"))), Optional.of(new ComparisonExpression(TreeNodes.location(1, 64), ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier(TreeNodes.location(1, 60), "age", false), (Expression)new LongLiteral(TreeNodes.location(1, 66), "17")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo EXECUTE bar(1, 'clap') WHERE age > 17")))).isEqualTo(new TableExecute(TreeNodes.location(1, 1), table, procedure, (List)ImmutableList.of((Object)new CallArgument(TreeNodes.location(1, 29), Optional.empty(), (Expression)new LongLiteral(TreeNodes.location(1, 29), "1")), (Object)new CallArgument(TreeNodes.location(1, 32), Optional.empty(), (Expression)new StringLiteral(TreeNodes.location(1, 32), "clap"))), Optional.of(new ComparisonExpression(TreeNodes.location(1, 50), ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier(TreeNodes.location(1, 46), "age", false), (Expression)new LongLiteral(TreeNodes.location(1, 52), "17")))));
    }

    @Test
    public void testAnalyze() {
        QualifiedName table = QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "foo", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ANALYZE foo")))).isEqualTo(new Analyze(TreeNodes.location(1, 1), table, (List)ImmutableList.of()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ANALYZE foo WITH ( \"string\" = 'bar', \"long\" = 42, computed = concat('ban', 'ana'), a = ARRAY[ 'v1', 'v2' ] )")))).isEqualTo(new Analyze(TreeNodes.location(1, 1), table, (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 20), new Identifier(TreeNodes.location(1, 20), "string", true), (Expression)new StringLiteral(TreeNodes.location(1, 31), "bar")), (Object)new Property(TreeNodes.location(1, 38), new Identifier(TreeNodes.location(1, 38), "long", true), (Expression)new LongLiteral(TreeNodes.location(1, 47), "42")), (Object)new Property(TreeNodes.location(1, 51), new Identifier(TreeNodes.location(1, 51), "computed", false), (Expression)new FunctionCall(TreeNodes.location(1, 62), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 62), "concat", false))), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 69), "ban"), (Object)new StringLiteral(TreeNodes.location(1, 76), "ana")))), (Object)new Property(TreeNodes.location(1, 84), new Identifier(TreeNodes.location(1, 84), "a", false), (Expression)new Array(TreeNodes.location(1, 88), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 95), "v1"), (Object)new StringLiteral(TreeNodes.location(1, 101), "v2")))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("EXPLAIN ANALYZE foo")))).isEqualTo(new Explain(TreeNodes.location(1, 1), (Statement)new Analyze(TreeNodes.location(1, 9), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 17), "foo", false))), (List)ImmutableList.of()), (List)ImmutableList.of()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("EXPLAIN ANALYZE ANALYZE foo")))).isEqualTo(new ExplainAnalyze(TreeNodes.location(1, 1), (Statement)new Analyze(TreeNodes.location(1, 17), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "foo", false))), (List)ImmutableList.of()), false));
    }

    @Test
    public void testAddColumn() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN c bigint")))).ignoringLocation().isEqualTo(new AddColumn(new NodeLocation(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 31), "bigint"), true, Collections.emptyList(), Optional.empty()), Optional.empty(), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), Optional.empty(), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), Optional.empty(), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN IF NOT EXISTS d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), Optional.empty(), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN IF NOT EXISTS d double NOT NULL")))).ignoringLocation().isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"d"), TreeNodes.simpleType(TreeNodes.location(1, 31), "double"), false, Collections.emptyList(), Optional.empty()), Optional.empty(), true, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN c bigint FIRST")))).ignoringLocation().isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 31), "bigint"), true, Collections.emptyList(), Optional.empty()), Optional.of(new ColumnPosition.First()), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN c bigint LAST")))).ignoringLocation().isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 31), "bigint"), true, Collections.emptyList(), Optional.empty()), Optional.of(new ColumnPosition.Last()), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN c bigint AFTER b")))).ignoringLocation().isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((String)"foo", (String[])new String[]{"t"}), new ColumnDefinition(QualifiedName.of((String)"c"), TreeNodes.simpleType(TreeNodes.location(1, 31), "bigint"), true, Collections.emptyList(), Optional.empty()), Optional.of(new ColumnPosition.After(QueryUtil.identifier((String)"b"))), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN c.d double")))).isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), new ColumnDefinition(TreeNodes.location(1, 30), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 30), "c", false), (Object)new Identifier(TreeNodes.location(1, 32), "d", false))), TreeNodes.simpleType(TreeNodes.location(1, 34), "double"), true, (List)ImmutableList.of(), Optional.empty()), Optional.empty(), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ADD COLUMN IF NOT EXISTS c.d double")))).isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), new ColumnDefinition(TreeNodes.location(1, 44), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 44), "c", false), (Object)new Identifier(TreeNodes.location(1, 46), "d", false))), TreeNodes.simpleType(TreeNodes.location(1, 48), "double"), true, (List)ImmutableList.of(), Optional.empty()), Optional.empty(), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN c.d double")))).isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), new ColumnDefinition(TreeNodes.location(1, 40), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 40), "c", false), (Object)new Identifier(TreeNodes.location(1, 42), "d", false))), TreeNodes.simpleType(TreeNodes.location(1, 44), "double"), true, (List)ImmutableList.of(), Optional.empty()), Optional.empty(), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN b.\"c.d\" double")))).isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), new ColumnDefinition(TreeNodes.location(1, 40), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 40), "b", false), (Object)new Identifier(TreeNodes.location(1, 42), "c.d", true))), TreeNodes.simpleType(TreeNodes.location(1, 48), "double"), true, (List)ImmutableList.of(), Optional.empty()), Optional.empty(), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN \"b.c\".d double")))).isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), new ColumnDefinition(TreeNodes.location(1, 40), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 40), "b.c", true), (Object)new Identifier(TreeNodes.location(1, 46), "d", false))), TreeNodes.simpleType(TreeNodes.location(1, 48), "double"), true, (List)ImmutableList.of(), Optional.empty()), Optional.empty(), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ADD COLUMN IF NOT EXISTS c.d double")))).isEqualTo(new AddColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), new ColumnDefinition(TreeNodes.location(1, 54), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 54), "c", false), (Object)new Identifier(TreeNodes.location(1, 56), "d", false))), TreeNodes.simpleType(TreeNodes.location(1, 58), "double"), true, (List)ImmutableList.of(), Optional.empty()), Optional.empty(), true, true));
    }

    @Test
    public void testDropColumn() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t DROP COLUMN c")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "c", false))), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE \"t x\" DROP COLUMN \"c d\"")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "t x", true))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "c d", true))), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t DROP COLUMN c")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 41), "c", false))), true, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t DROP COLUMN IF EXISTS c")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 41), "c", false))), false, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t DROP COLUMN IF EXISTS c")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 51), "c", false))), true, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t DROP COLUMN \"c.d\"")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "c.d", true))), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t DROP COLUMN c.d")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "c", false), (Object)new Identifier(TreeNodes.location(1, 33), "d", false))), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t DROP COLUMN b.\"c.d\"")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "b", false), (Object)new Identifier(TreeNodes.location(1, 33), "c.d", true))), false, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t DROP COLUMN \"b.c\".d")))).isEqualTo(new DropColumn(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "b.c", true), (Object)new Identifier(TreeNodes.location(1, 37), "d", false))), false, false));
    }

    @Test
    public void testAlterColumnSetDataType() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ALTER COLUMN a SET DATA TYPE bigint")))).isEqualTo(new SetColumnType(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 32), "a", false))), TreeNodes.simpleType(TreeNodes.location(1, 48), "bigint"), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ALTER COLUMN b SET DATA TYPE double")))).isEqualTo(new SetColumnType(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 42), "b", false))), TreeNodes.simpleType(TreeNodes.location(1, 58), "double"), true));
    }

    @Test
    public void testAlterColumnDropNotNullConstraint() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.t ALTER COLUMN a DROP NOT NULL")))).isEqualTo(new DropNotNullConstraint(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "t", false))), new Identifier(TreeNodes.location(1, 32), "a", false), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE IF EXISTS foo.t ALTER COLUMN a DROP NOT NULL")))).isEqualTo(new DropNotNullConstraint(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "foo", false), (Object)new Identifier(TreeNodes.location(1, 27), "t", false))), new Identifier(TreeNodes.location(1, 42), "a", false), true));
    }

    @Test
    public void testAlterTableSetAuthorization() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.bar.baz SET AUTHORIZATION qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "TABLE", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false), (Object)new Identifier(TreeNodes.location(1, 21), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 43), "qux", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.bar.baz SET AUTHORIZATION USER qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "TABLE", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false), (Object)new Identifier(TreeNodes.location(1, 21), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 48), "qux", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER TABLE foo.bar.baz SET AUTHORIZATION ROLE qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "TABLE", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false), (Object)new Identifier(TreeNodes.location(1, 21), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 48), "qux", false))));
    }

    @Test
    public void testAlterNewEntityKindSetAuthorization() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER QUARK foo.bar.baz SET AUTHORIZATION qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "QUARK", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false), (Object)new Identifier(TreeNodes.location(1, 21), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 43), "qux", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER QUARK foo.bar.baz SET AUTHORIZATION USER qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "QUARK", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false), (Object)new Identifier(TreeNodes.location(1, 21), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 48), "qux", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER QUARK foo.bar.baz SET AUTHORIZATION ROLE qux")))).isEqualTo(new SetAuthorizationStatement(TreeNodes.location(1, 1), "QUARK", QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "foo", false), (Object)new Identifier(TreeNodes.location(1, 17), "bar", false), (Object)new Identifier(TreeNodes.location(1, 21), "baz", false))), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 48), "qux", false))));
    }

    @Test
    public void testCreateView() {
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t")));
        TestSqlParser.assertStatement("CREATE VIEW a AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE OR REPLACE VIEW a AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, true, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW a SECURITY DEFINER AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.empty(), Optional.of(CreateView.Security.DEFINER), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW a SECURITY INVOKER AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.empty(), Optional.of(CreateView.Security.INVOKER), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT 'comment' SECURITY DEFINER AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.of("comment"), Optional.of(CreateView.Security.DEFINER), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT '' SECURITY INVOKER AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.of(""), Optional.of(CreateView.Security.INVOKER), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT 'comment' AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.of("comment"), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW a COMMENT '' AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.of(""), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW a WITH (property_1 = 'value_1', property_2 = 2) AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"a"), query, false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Property(new Identifier("property_1"), (Expression)new StringLiteral("value_1")), (Object)new Property(new Identifier("property_2"), (Expression)new LongLiteral("2")))));
        TestSqlParser.assertStatement("CREATE VIEW bar.foo AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"bar", (String[])new String[]{"foo"}), query, false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW \"awesome view\" AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"awesome view"), query, false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("CREATE VIEW \"awesome schema\".\"awesome view\" AS SELECT * FROM t", (Statement)new CreateView(TreeNodes.location(1, 1), QualifiedName.of((String)"awesome schema", (String[])new String[]{"awesome view"}), query, false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
    }

    @Test
    public void testGrant() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT INSERT, DELETE ON t TO u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"INSERT", (Object)"DELETE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 30), "u", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT UPDATE ON t TO u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"UPDATE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 17), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 22), "u", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT EXECUTE ON t TO u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"EXECUTE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 23), "u", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT SELECT ON t TO ROLE PUBLIC WITH GRANT OPTION")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"SELECT")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 17), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 27), "PUBLIC", false)), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT ALL PRIVILEGES ON TABLE t TO USER u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.empty(), new GrantObject(TreeNodes.location(1, 1), Optional.of("TABLE"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 41), "u", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT DELETE ON \"t\" TO ROLE \"public\" WITH GRANT OPTION")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"DELETE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 17), "t", true)))), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 29), "public", true)), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT SELECT ON SCHEMA s TO USER u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"SELECT")), new GrantObject(TreeNodes.location(1, 1), Optional.of("SCHEMA"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 24), "s", false)))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 34), "u", false)), false));
    }

    @Test
    public void testDeny() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DENY INSERT, DELETE ON t TO u")))).isEqualTo(new Deny(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"INSERT", (Object)"DELETE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 24), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 29), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DENY UPDATE ON t TO u")))).isEqualTo(new Deny(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"UPDATE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 16), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 21), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DENY ALL PRIVILEGES ON TABLE t TO USER u")))).isEqualTo(new Deny(TreeNodes.location(1, 1), Optional.empty(), new GrantObject(TreeNodes.location(1, 1), Optional.of("TABLE"), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 30), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 40), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DENY SELECT ON SCHEMA s TO USER u")))).isEqualTo(new Deny(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"SELECT")), new GrantObject(TreeNodes.location(1, 1), Optional.of("SCHEMA"), QualifiedName.of(List.of(new Identifier(TreeNodes.location(1, 23), "s", false)))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 33), "u", false))));
    }

    @Test
    public void testRevoke() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE INSERT, DELETE ON t FROM u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.of(ImmutableList.of((Object)"INSERT", (Object)"DELETE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 26), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 33), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE UPDATE ON t FROM u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.of(ImmutableList.of((Object)"UPDATE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 18), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 25), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE EXECUTE ON t FROM u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.of(ImmutableList.of((Object)"EXECUTE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 26), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE GRANT OPTION FOR SELECT ON t FROM ROLE PUBLIC")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), true, Optional.of(ImmutableList.of((Object)"SELECT")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 35), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 47), "PUBLIC", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE ALL PRIVILEGES ON TABLE t FROM USER u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.empty(), new GrantObject(TreeNodes.location(1, 1), Optional.of("TABLE"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 32), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 44), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE DELETE ON TABLE \"t\" FROM \"u\"")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.of(ImmutableList.of((Object)"DELETE")), new GrantObject(TreeNodes.location(1, 1), Optional.of("TABLE"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 24), "t", true)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 33), "u", true))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE SELECT ON SCHEMA s FROM USER u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.of(ImmutableList.of((Object)"SELECT")), new GrantObject(TreeNodes.location(1, 1), Optional.of("SCHEMA"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "s", false)))), new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 37), "u", false))));
    }

    @Test
    public void testExoticPrivilegesAndEntityKinds() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT ALL PRIVILEGES ON FUNKY_ENTITY t TO u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.empty(), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 38), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 43), "u", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT ALL PRIVILEGES ON FUNKY_ENTITY t TO u WITH GRANT OPTION")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.empty(), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 38), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 43), "u", false)), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT AUTO_GYRATE ON FUNKY_ENTITY t TO u WITH GRANT OPTION")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 35), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 40), "u", false)), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT AUTO_GYRATE ON FUNKY_ENTITY t TO u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 35), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 40), "u", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT AUTO_GYRATE ON t TO u")))).isEqualTo(new Grant(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 22), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 27), "u", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE ALL PRIVILEGES ON FUNKY_ENTITY t FROM u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.empty(), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 39), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 46), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE AUTO_GYRATE ON FUNKY_ENTITY t FROM u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 36), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 43), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE GRANT OPTION FOR AUTO_GYRATE ON FUNKY_ENTITY t FROM u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), true, Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 53), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 60), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE AUTO_GYRATE ON t FROM u")))).isEqualTo(new Revoke(TreeNodes.location(1, 1), false, Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 23), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 30), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DENY ALL PRIVILEGES ON FUNKY_ENTITY t TO u")))).isEqualTo(new Deny(TreeNodes.location(1, 1), Optional.empty(), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 37), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 42), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DENY AUTO_GYRATE ON FUNKY_ENTITY t TO u")))).isEqualTo(new Deny(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.of("FUNKY_ENTITY"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 34), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 39), "u", false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DENY AUTO_GYRATE ON t TO u")))).isEqualTo(new Deny(TreeNodes.location(1, 1), Optional.of(ImmutableList.of((Object)"AUTO_GYRATE")), new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 21), "t", false)))), new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 26), "u", false))));
    }

    @Test
    public void testShowGrants() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW GRANTS ON TABLE t")))).isEqualTo(new ShowGrants(TreeNodes.location(1, 1), Optional.of(new GrantObject(TreeNodes.location(1, 1), Optional.of("TABLE"), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 22), "t", false)))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW GRANTS ON t")))).isEqualTo(new ShowGrants(TreeNodes.location(1, 1), Optional.of(new GrantObject(TreeNodes.location(1, 1), Optional.empty(), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 16), "t", false)))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW GRANTS")))).isEqualTo(new ShowGrants(TreeNodes.location(1, 1), Optional.empty()));
    }

    @Test
    public void testShowRoles() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW ROLES")))).isEqualTo(new ShowRoles(TreeNodes.location(1, 1), Optional.empty(), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW ROLES FROM foo")))).isEqualTo(new ShowRoles(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 17), "foo", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW ROLES IN foo")))).isEqualTo(new ShowRoles(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 15), "foo", false)), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW CURRENT ROLES")))).isEqualTo(new ShowRoles(TreeNodes.location(1, 1), Optional.empty(), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW CURRENT ROLES FROM foo")))).isEqualTo(new ShowRoles(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 25), "foo", false)), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW CURRENT ROLES IN foo")))).isEqualTo(new ShowRoles(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 23), "foo", false)), true));
    }

    @Test
    public void testShowRoleGrants() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW ROLE GRANTS")))).isEqualTo(new ShowRoleGrants(TreeNodes.location(1, 1), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW ROLE GRANTS FROM catalog")))).isEqualTo(new ShowRoleGrants(TreeNodes.location(1, 1), Optional.of(new Identifier(TreeNodes.location(1, 23), "catalog", false))));
    }

    @Test
    public void testSetPath() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET PATH iLikeToEat.apples, andBananas")))).isEqualTo(new SetPath(TreeNodes.location(1, 1), new PathSpecification(TreeNodes.location(1, 10), (List)ImmutableList.of((Object)new PathElement(TreeNodes.location(1, 10), Optional.of(new Identifier(TreeNodes.location(1, 10), "iLikeToEat", false)), new Identifier(TreeNodes.location(1, 21), "apples", false)), (Object)new PathElement(TreeNodes.location(1, 29), Optional.empty(), new Identifier(TreeNodes.location(1, 29), "andBananas", false))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET PATH \"schemas,with\".\"grammar.in\", \"their!names\"")))).isEqualTo(new SetPath(TreeNodes.location(1, 1), new PathSpecification(TreeNodes.location(1, 10), (List)ImmutableList.of((Object)new PathElement(TreeNodes.location(1, 10), Optional.of(new Identifier(TreeNodes.location(1, 10), "schemas,with", true)), new Identifier(TreeNodes.location(1, 25), "grammar.in", true)), (Object)new PathElement(TreeNodes.location(1, 39), Optional.empty(), new Identifier(TreeNodes.location(1, 39), "their!names", true))))));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSqlParser.assertStatement("SET PATH one.too.many, qualifiers", (Statement)new SetPath(TreeNodes.location(1, 1), new PathSpecification(new NodeLocation(1, 10), (List)ImmutableList.of((Object)new PathElement(TreeNodes.location(1, 1), Optional.empty(), new Identifier("dummyValue"))))))).isInstanceOf(ParsingException.class)).hasMessage("line 1:17: mismatched input '.'. Expecting: ',', <EOF>");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SET PATH ")).isInstanceOf(ParsingException.class)).hasMessage("line 1:10: mismatched input '<EOF>'. Expecting: <identifier>");
    }

    @Test
    public void testSetTimeZone() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE LOCAL")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE 'America/Los_Angeles'")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new StringLiteral(TreeNodes.location(1, 15), "America/Los_Angeles"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE concat_ws('/', 'America', 'Los_Angeles')")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new FunctionCall(TreeNodes.location(1, 15), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 15), "concat_ws", false))), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 25), "/"), (Object)new StringLiteral(TreeNodes.location(1, 30), "America"), (Object)new StringLiteral(TreeNodes.location(1, 41), "Los_Angeles"))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE '-08:00'")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new StringLiteral(TreeNodes.location(1, 15), "-08:00"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE INTERVAL '10' HOUR")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new IntervalLiteral(TreeNodes.location(1, 15), "10", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.HOUR, Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET TIME ZONE INTERVAL -'08:00' HOUR TO MINUTE")))).isEqualTo(new SetTimeZone(TreeNodes.location(1, 1), Optional.of(new IntervalLiteral(TreeNodes.location(1, 15), "08:00", IntervalLiteral.Sign.NEGATIVE, IntervalLiteral.IntervalField.HOUR, Optional.of(IntervalLiteral.IntervalField.MINUTE)))));
    }

    @Test
    public void testWith() {
        TestSqlParser.assertStatement("WITH a (t, u) AS (SELECT * FROM x), b AS (SELECT * FROM y) TABLE z", (Statement)new Query((List)ImmutableList.of(), (List)ImmutableList.of(), Optional.of(new With(false, (List)ImmutableList.of((Object)new WithQuery(QueryUtil.identifier((String)"a"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"x"))), Optional.of(ImmutableList.of((Object)QueryUtil.identifier((String)"t"), (Object)QueryUtil.identifier((String)"u")))), (Object)new WithQuery(QueryUtil.identifier((String)"b"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"y"))), Optional.empty())))), (QueryBody)new Table(QualifiedName.of((String)"z")), Optional.empty(), Optional.empty(), Optional.empty()));
        TestSqlParser.assertStatement("WITH RECURSIVE a AS (SELECT * FROM x) TABLE y", (Statement)new Query((List)ImmutableList.of(), (List)ImmutableList.of(), Optional.of(new With(true, (List)ImmutableList.of((Object)new WithQuery(QueryUtil.identifier((String)"a"), QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"x"))), Optional.empty())))), (QueryBody)new Table(QualifiedName.of((String)"y")), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testImplicitJoin() {
        TestSqlParser.assertStatement("SELECT * FROM a, b", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.IMPLICIT, (Relation)new Table(QualifiedName.of((String)"a")), (Relation)new Table(QualifiedName.of((String)"b")), Optional.empty())));
    }

    @Test
    public void testExplain() {
        TestSqlParser.assertStatement("EXPLAIN SELECT * FROM t", (Statement)new Explain(TreeNodes.location(1, 1), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), (List)ImmutableList.of()));
        TestSqlParser.assertStatement("EXPLAIN (TYPE LOGICAL) SELECT * FROM t", (Statement)new Explain(TreeNodes.location(1, 1), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), (List)ImmutableList.of((Object)new ExplainType(TreeNodes.location(1, 1), ExplainType.Type.LOGICAL))));
        TestSqlParser.assertStatement("EXPLAIN (TYPE LOGICAL, FORMAT TEXT) SELECT * FROM t", (Statement)new Explain(TreeNodes.location(1, 1), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), (List)ImmutableList.of((Object)new ExplainType(TreeNodes.location(1, 1), ExplainType.Type.LOGICAL), (Object)new ExplainFormat(TreeNodes.location(1, 1), ExplainFormat.Type.TEXT))));
        ParserAssert.assertStatementIsInvalid("EXPLAIN VERBOSE SELECT * FROM t").withMessageStartingWith("line 1:9: mismatched input 'VERBOSE'. Expecting: '(', 'ALTER', 'ANALYZE', 'CALL',");
        ParserAssert.assertStatementIsInvalid("EXPLAIN VERBOSE (type LOGICAL) SELECT * FROM t").withMessageStartingWith("line 1:9: mismatched input 'VERBOSE'. Expecting: '(', 'ALTER', 'ANALYZE', 'CALL',");
    }

    @Test
    public void testExplainAnalyze() {
        TestSqlParser.assertStatement("EXPLAIN ANALYZE SELECT * FROM t", (Statement)new ExplainAnalyze(TreeNodes.location(1, 1), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), false));
        TestSqlParser.assertStatement("EXPLAIN ANALYZE VERBOSE SELECT * FROM t", (Statement)new ExplainAnalyze(TreeNodes.location(1, 1), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))), true));
        ParserAssert.assertStatementIsInvalid("EXPLAIN ANALYZE (type DISTRIBUTED) SELECT * FROM t").withMessage("line 1:18: mismatched input 'type'. Expecting: '(', 'SELECT', 'TABLE', 'VALUES'");
        ParserAssert.assertStatementIsInvalid("EXPLAIN ANALYZE VERBOSE (type DISTRIBUTED) SELECT * FROM t").withMessage("line 1:26: mismatched input 'type'. Expecting: '(', 'SELECT', 'TABLE', 'VALUES'");
    }

    @Test
    public void testJoinPrecedence() {
        TestSqlParser.assertStatement("SELECT * FROM a CROSS JOIN b LEFT JOIN c ON true", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.LEFT, (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"a")), (Relation)new Table(QualifiedName.of((String)"b")), Optional.empty()), (Relation)new Table(QualifiedName.of((String)"c")), Optional.of(new JoinOn((Expression)BooleanLiteral.TRUE_LITERAL)))));
        TestSqlParser.assertStatement("SELECT * FROM a CROSS JOIN b NATURAL JOIN c CROSS JOIN d NATURAL JOIN e", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.INNER, (Relation)new Join(Join.Type.CROSS, (Relation)new Join(Join.Type.INNER, (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"a")), (Relation)new Table(QualifiedName.of((String)"b")), Optional.empty()), (Relation)new Table(QualifiedName.of((String)"c")), Optional.of(new NaturalJoin())), (Relation)new Table(QualifiedName.of((String)"d")), Optional.empty()), (Relation)new Table(QualifiedName.of((String)"e")), Optional.of(new NaturalJoin()))));
    }

    @Test
    public void testUnnest() {
        TestSqlParser.assertStatement("SELECT * FROM t CROSS JOIN UNNEST(a)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new Unnest((List)ImmutableList.of((Object)new Identifier("a")), false), Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t CROSS JOIN UNNEST(a, b) WITH ORDINALITY", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new Unnest((List)ImmutableList.of((Object)new Identifier("a"), (Object)new Identifier("b")), true), Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t FULL JOIN UNNEST(a) AS tmp (c) ON true", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.FULL, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new AliasedRelation((Relation)new Unnest((List)ImmutableList.of((Object)new Identifier("a")), false), new Identifier("tmp"), (List)ImmutableList.of((Object)new Identifier("c"))), Optional.of(new JoinOn((Expression)BooleanLiteral.TRUE_LITERAL)))));
    }

    @Test
    public void testLateral() {
        Lateral lateralRelation = new Lateral(TreeNodes.location(1, 18), QueryUtil.query((QueryBody)new Values((List)ImmutableList.of((Object)new LongLiteral("1")))));
        TestSqlParser.assertStatement("SELECT * FROM t, LATERAL (VALUES 1) a(x)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.IMPLICIT, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)new AliasedRelation((Relation)lateralRelation, QueryUtil.identifier((String)"a"), (List)ImmutableList.of((Object)QueryUtil.identifier((String)"x"))), Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t CROSS JOIN LATERAL (VALUES 1) ", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.CROSS, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)lateralRelation, Optional.empty())));
        TestSqlParser.assertStatement("SELECT * FROM t FULL JOIN LATERAL (VALUES 1) ON true", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Join(Join.Type.FULL, (Relation)new Table(QualifiedName.of((String)"t")), (Relation)lateralRelation, Optional.of(new JoinOn((Expression)BooleanLiteral.TRUE_LITERAL)))));
    }

    @Test
    public void testStartTransaction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION ISOLATION LEVEL READ UNCOMMITTED")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new Isolation(TreeNodes.location(1, 35), Isolation.Level.READ_UNCOMMITTED))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION ISOLATION LEVEL READ COMMITTED")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new Isolation(TreeNodes.location(1, 35), Isolation.Level.READ_COMMITTED))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION ISOLATION LEVEL REPEATABLE READ")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new Isolation(TreeNodes.location(1, 35), Isolation.Level.REPEATABLE_READ))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION ISOLATION LEVEL SERIALIZABLE")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new Isolation(TreeNodes.location(1, 35), Isolation.Level.SERIALIZABLE))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION READ ONLY")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new TransactionAccessMode(TreeNodes.location(1, 19), true))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION READ WRITE")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new TransactionAccessMode(TreeNodes.location(1, 19), false))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION ISOLATION LEVEL READ COMMITTED, READ ONLY")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new Isolation(TreeNodes.location(1, 35), Isolation.Level.READ_COMMITTED), (Object)new TransactionAccessMode(TreeNodes.location(1, 51), true))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION READ ONLY, ISOLATION LEVEL READ COMMITTED")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new TransactionAccessMode(TreeNodes.location(1, 19), true), (Object)new Isolation(TreeNodes.location(1, 46), Isolation.Level.READ_COMMITTED))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("START TRANSACTION READ WRITE, ISOLATION LEVEL SERIALIZABLE")))).isEqualTo(new StartTransaction(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new TransactionAccessMode(TreeNodes.location(1, 19), false), (Object)new Isolation(TreeNodes.location(1, 47), Isolation.Level.SERIALIZABLE))));
    }

    @Test
    public void testCommit() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMIT")))).isEqualTo(new Commit(TreeNodes.location(1, 1)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("COMMIT WORK")))).isEqualTo(new Commit(TreeNodes.location(1, 1)));
    }

    @Test
    public void testRollback() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ROLLBACK")))).isEqualTo(new Rollback(TreeNodes.location(1, 1)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ROLLBACK WORK")))).isEqualTo(new Rollback(TreeNodes.location(1, 1)));
    }

    @Test
    public void testAtTimeZone() {
        TestSqlParser.assertStatement("SELECT TIMESTAMP '2012-10-31 01:00 UTC' AT TIME ZONE 'America/Los_Angeles'", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new AtTimeZone((Expression)new GenericLiteral("TIMESTAMP", "2012-10-31 01:00 UTC"), (Expression)new StringLiteral("America/Los_Angeles"))})));
    }

    @Test
    public void testLambda() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("() -> x")))).isEqualTo(new LambdaExpression(TreeNodes.location(1, 1), (List)ImmutableList.of(), (Expression)new Identifier(TreeNodes.location(1, 7), "x", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("x -> sin(x)")))).isEqualTo(new LambdaExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LambdaArgumentDeclaration(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "x", false))), (Expression)new FunctionCall(TreeNodes.location(1, 6), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 6), "sin", false))), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 10), "x", false)))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("(x, y) -> mod(x, y)")))).isEqualTo(new LambdaExpression(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new LambdaArgumentDeclaration(TreeNodes.location(1, 2), new Identifier(TreeNodes.location(1, 2), "x", false)), (Object)new LambdaArgumentDeclaration(TreeNodes.location(1, 5), new Identifier(TreeNodes.location(1, 5), "y", false))), (Expression)new FunctionCall(TreeNodes.location(1, 11), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 11), "mod", false))), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 15), "x", false), (Object)new Identifier(TreeNodes.location(1, 18), "y", false)))));
    }

    @Test
    public void testNonReserved() {
        TestSqlParser.assertStatement("SELECT zone FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("zone")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT INCLUDING, EXCLUDING, PROPERTIES FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("INCLUDING"), new Identifier("EXCLUDING"), new Identifier("PROPERTIES")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        TestSqlParser.assertStatement("SELECT ALL, SOME, ANY FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Identifier("ALL"), new Identifier("SOME"), new Identifier("ANY")}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
        NodeLocation location = new NodeLocation(1, 1);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("stats")))).isEqualTo(new Identifier(location, "stats", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfd")))).isEqualTo(new Identifier(location, "nfd", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfc")))).isEqualTo(new Identifier(location, "nfc", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfkd")))).isEqualTo(new Identifier(location, "nfkd", false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("nfkc")))).isEqualTo(new Identifier(location, "nfkc", false));
    }

    @Test
    public void testBinaryLiteralToHex() {
        Assertions.assertThat((String)new BinaryLiteral(TreeNodes.location(1, 1), "ab 01").toHexString()).isEqualTo("AB01");
    }

    @Test
    public void testCall() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CALL foo()")))).isEqualTo(new Call(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 6), "foo", false))), (List)ImmutableList.of()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CALL foo(123, a => 1, b => 'go', 456)")))).isEqualTo(new Call(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 6), "foo", false))), (List)ImmutableList.of((Object)new CallArgument(TreeNodes.location(1, 10), Optional.empty(), (Expression)new LongLiteral(TreeNodes.location(1, 10), "123")), (Object)new CallArgument(TreeNodes.location(1, 15), Optional.of(new Identifier(TreeNodes.location(1, 15), "a", false)), (Expression)new LongLiteral(TreeNodes.location(1, 20), "1")), (Object)new CallArgument(TreeNodes.location(1, 23), Optional.of(new Identifier(TreeNodes.location(1, 23), "b", false)), (Expression)new StringLiteral(TreeNodes.location(1, 28), "go")), (Object)new CallArgument(TreeNodes.location(1, 34), Optional.empty(), (Expression)new LongLiteral(TreeNodes.location(1, 34), "456")))));
    }

    @Test
    public void testPrepare() {
        TestSqlParser.assertStatement("PREPARE myquery FROM select * from foo", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")))));
    }

    @Test
    public void testPrepareDropView() {
        TestSqlParser.assertStatement("PREPARE statement1 FROM DROP VIEW IF EXISTS \"catalog-test\".\"test\".\"foo\"", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"statement1"), (Statement)new DropView(TreeNodes.location(1, 25), QualifiedName.of((String)"catalog-test", (String[])new String[]{"test", "foo"}), true)));
        ParserAssert.assertStatementIsInvalid("PREPARE statement1 FROM DROP VIEW IF EXISTS catalog-test.test.foo").withMessage("line 1:52: mismatched input '-'. Expecting: '.', <EOF>");
    }

    @Test
    public void testPrepareWithParameters() {
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT * FROM foo LIMIT ?", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new Parameter(0))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo LIMIT ?", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Limit((Expression)new Parameter(2))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ? FROM foo FETCH FIRST ? ROWS ONLY", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new Parameter(1))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo FETCH NEXT ? ROWS WITH TIES", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new FetchFirst((Expression)new Parameter(2), true)))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ?, ? FROM foo OFFSET ? ROWS", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0), new Parameter(1)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new Parameter(2))), Optional.empty())));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ? FROM foo OFFSET ? ROWS LIMIT ?", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new Parameter(1))), Optional.of(new Limit((Expression)new Parameter(2))))));
        TestSqlParser.assertStatement("PREPARE myquery FROM SELECT ? FROM foo OFFSET ? ROWS FETCH FIRST ? ROWS WITH TIES", (Statement)new Prepare(TreeNodes.location(1, 1), QueryUtil.identifier((String)"myquery"), (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new Parameter(0)}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new Offset((Expression)new Parameter(1))), Optional.of(new FetchFirst((Expression)new Parameter(2), true)))));
    }

    @Test
    public void testDeallocatePrepare() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DEALLOCATE PREPARE myquery")))).isEqualTo(new Deallocate(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 20), "myquery", false)));
    }

    @Test
    public void testExecute() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("EXECUTE myquery")))).isEqualTo(new Execute(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 9), "myquery", false), Collections.emptyList()));
    }

    @Test
    public void testExecuteWithUsing() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("EXECUTE myquery USING 1, 'abc', ARRAY ['hello']")))).isEqualTo(new Execute(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 9), "myquery", false), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 23), "1"), (Object)new StringLiteral(TreeNodes.location(1, 26), "abc"), (Object)new Array(TreeNodes.location(1, 33), (List)ImmutableList.of((Object)new StringLiteral(TreeNodes.location(1, 40), "hello"))))));
    }

    @Test
    public void testExecuteImmediate() {
        TestSqlParser.assertStatement("EXECUTE IMMEDIATE 'SELECT * FROM foo'", (Statement)new ExecuteImmediate(new NodeLocation(1, 1), new StringLiteral(new NodeLocation(1, 19), "SELECT * FROM foo"), Collections.emptyList()));
    }

    @Test
    public void testExecuteImmediateWithUsing() {
        TestSqlParser.assertStatement("EXECUTE IMMEDIATE 'SELECT ?, ? FROM foo' USING 1, 'abc', ARRAY ['hello']", (Statement)new ExecuteImmediate(new NodeLocation(1, 1), new StringLiteral(new NodeLocation(1, 19), "SELECT ?, ? FROM foo"), (List)ImmutableList.of((Object)new LongLiteral("1"), (Object)new StringLiteral("abc"), (Object)new Array((List)ImmutableList.of((Object)new StringLiteral("hello"))))));
    }

    @Test
    public void testExists() {
        TestSqlParser.assertStatement("SELECT EXISTS(SELECT 1)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")})))})));
        TestSqlParser.assertStatement("SELECT EXISTS(SELECT 1) = EXISTS(SELECT 2)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")}))), (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("2")}))))})));
        TestSqlParser.assertStatement("SELECT NOT EXISTS(SELECT 1) = EXISTS(SELECT 2)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")}))), (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("2")})))))})));
        TestSqlParser.assertStatement("SELECT (NOT EXISTS(SELECT 1)) = EXISTS(SELECT 2)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new NotExpression((Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("1")})))), (Expression)TestSqlParser.exists(QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new LongLiteral("2")}))))})));
    }

    private static ExistsPredicate exists(Query query) {
        return new ExistsPredicate((Expression)new SubqueryExpression(query));
    }

    @Test
    public void testShowStats() {
        String[] tableNames;
        for (String fullName : tableNames = new String[]{"t", "s.t", "c.s.t"}) {
            QualifiedName qualifiedName = TestSqlParser.makeQualifiedName(fullName);
            TestSqlParser.assertStatement("SHOW STATS FOR %s".formatted(qualifiedName), (Statement)new ShowStats(TreeNodes.location(1, 1), (Relation)new Table(qualifiedName)));
        }
    }

    @Test
    public void testShowStatsForQuery() {
        String[] tableNames;
        for (String fullName : tableNames = new String[]{"t", "s.t", "c.s.t"}) {
            QualifiedName qualifiedName = TestSqlParser.makeQualifiedName(fullName);
            TestSqlParser.assertStatement("SHOW STATS FOR (SELECT * FROM %s)".formatted(qualifiedName), (Statement)TestSqlParser.createShowStats(qualifiedName, (List<SelectItem>)ImmutableList.of((Object)new AllColumns()), Optional.empty()));
            TestSqlParser.assertStatement("SHOW STATS FOR (SELECT * FROM %s WHERE field > 0)".formatted(qualifiedName), (Statement)TestSqlParser.createShowStats(qualifiedName, (List<SelectItem>)ImmutableList.of((Object)new AllColumns()), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("field"), (Expression)new LongLiteral("0")))));
            TestSqlParser.assertStatement("SHOW STATS FOR (SELECT * FROM %s WHERE field > 0 or field < 0)".formatted(qualifiedName), (Statement)TestSqlParser.createShowStats(qualifiedName, (List<SelectItem>)ImmutableList.of((Object)new AllColumns()), Optional.of(LogicalExpression.or((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("field"), (Expression)new LongLiteral("0")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new Identifier("field"), (Expression)new LongLiteral("0"))))));
        }
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW STATS FOR (SELECT * FROM t LIMIT 10)")))).isEqualTo(new ShowStats(TreeNodes.location(1, 1), (Relation)new TableSubquery(new Query(TreeNodes.location(1, 17), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 17), new Select(TreeNodes.location(1, 17), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 24), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 31), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.of(new Limit(TreeNodes.location(1, 33), (Expression)new LongLiteral(TreeNodes.location(1, 39), "10")))), Optional.empty(), Optional.empty(), Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW STATS FOR (SELECT * FROM t ORDER BY field LIMIT 10)")))).isEqualTo(new ShowStats(TreeNodes.location(1, 1), (Relation)new TableSubquery(new Query(TreeNodes.location(1, 17), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 17), new Select(TreeNodes.location(1, 17), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 24), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(1, 31), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 31), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.of(new OrderBy(TreeNodes.location(1, 33), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 42), (Expression)new Identifier(TreeNodes.location(1, 42), "field", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.empty(), Optional.of(new Limit(TreeNodes.location(1, 48), (Expression)new LongLiteral(TreeNodes.location(1, 54), "10")))), Optional.empty(), Optional.empty(), Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SHOW STATS FOR (\n   WITH t AS (SELECT 1 )\n   SELECT * FROM t)\n")))).isEqualTo(new ShowStats(TreeNodes.location(1, 1), (Relation)new TableSubquery(new Query(TreeNodes.location(2, 4), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.of(new With(TreeNodes.location(2, 4), false, (List)ImmutableList.of((Object)new WithQuery(TreeNodes.location(2, 9), new Identifier(TreeNodes.location(2, 9), "t", false), new Query(TreeNodes.location(2, 15), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(2, 15), new Select(TreeNodes.location(2, 15), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(2, 22), (Expression)new LongLiteral(TreeNodes.location(2, 22), "1"), Optional.empty()))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty())))), (QueryBody)new QuerySpecification(TreeNodes.location(3, 4), new Select(TreeNodes.location(3, 4), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(3, 11), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(TreeNodes.location(3, 18), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(3, 18), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()))));
    }

    private static ShowStats createShowStats(QualifiedName name, List<SelectItem> selects, Optional<Expression> where) {
        return new ShowStats(TreeNodes.location(1, 1), (Relation)new TableSubquery(QueryUtil.simpleQuery((Select)new Select(false, selects), (Relation)new Table(name), where, Optional.empty())));
    }

    @Test
    public void testDescribeOutput() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DESCRIBE OUTPUT myquery")))).isEqualTo(new DescribeOutput(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 17), "myquery", false)));
    }

    @Test
    public void testDescribeInput() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DESCRIBE INPUT myquery")))).isEqualTo(new DescribeInput(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 16), "myquery", false)));
    }

    @Test
    public void testAggregationFilter() {
        TestSqlParser.assertStatement("SELECT SUM(x) FILTER (WHERE x > 4)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(Optional.empty(), QualifiedName.of((String)"SUM"), Optional.empty(), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new Identifier("x"), (Expression)new LongLiteral("4"))), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier("x")))})));
    }

    @Test
    public void testQuantifiedComparison() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("col1 < ANY (SELECT col2 FROM table1)")))).isEqualTo(new QuantifiedComparisonExpression(TreeNodes.location(1, 6), ComparisonExpression.Operator.LESS_THAN, QuantifiedComparisonExpression.Quantifier.ANY, (Expression)new Identifier(TreeNodes.location(1, 1), "col1", false), (Expression)new SubqueryExpression(TreeNodes.location(1, 13), new Query(TreeNodes.location(1, 13), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 13), new Select(TreeNodes.location(1, 13), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 20), (Expression)new Identifier(TreeNodes.location(1, 20), "col2", false), Optional.empty()))), Optional.of(new Table(TreeNodes.location(1, 30), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 30), "table1", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("col1 = ALL (VALUES ROW(1), ROW(2))")))).isEqualTo(new QuantifiedComparisonExpression(TreeNodes.location(1, 6), ComparisonExpression.Operator.EQUAL, QuantifiedComparisonExpression.Quantifier.ALL, (Expression)new Identifier(TreeNodes.location(1, 1), "col1", false), (Expression)new SubqueryExpression(TreeNodes.location(1, 13), new Query(TreeNodes.location(1, 13), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new Values(TreeNodes.location(1, 13), (List)ImmutableList.of((Object)new Row(TreeNodes.location(1, 20), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 24), "1"))), (Object)new Row(TreeNodes.location(1, 28), (List)ImmutableList.of((Object)new LongLiteral(TreeNodes.location(1, 32), "2"))))), Optional.empty(), Optional.empty(), Optional.empty()))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("col1 >= SOME (SELECT 10)")))).isEqualTo(new QuantifiedComparisonExpression(TreeNodes.location(1, 6), ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, QuantifiedComparisonExpression.Quantifier.SOME, (Expression)new Identifier(TreeNodes.location(1, 1), "col1", false), (Expression)new SubqueryExpression(TreeNodes.location(1, 15), new Query(TreeNodes.location(1, 15), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 15), new Select(TreeNodes.location(1, 15), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(1, 22), (Expression)new LongLiteral(TreeNodes.location(1, 22), "10"), Optional.empty()))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()))));
    }

    @Test
    public void testAggregationWithOrderBy() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("array_agg(x ORDER BY x DESC)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "array_agg", false))), Optional.empty(), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 13), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 22), (Expression)new Identifier(TreeNodes.location(1, 22), "x", false), SortItem.Ordering.DESCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 11), "x", false))));
        TestSqlParser.assertStatement("SELECT array_agg(x ORDER BY t.y) FROM t", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{new FunctionCall(Optional.empty(), QualifiedName.of((String)"array_agg"), Optional.empty(), Optional.empty(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new DereferenceExpression((Expression)new Identifier("t"), QueryUtil.identifier((String)"y")), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier("x")))}), (Relation)QueryUtil.table((QualifiedName)QualifiedName.of((String)"t"))));
    }

    @Test
    public void testCreateRole() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE role")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role", false), Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE role1 WITH ADMIN admin")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role1", false), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 30), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE \"role\" WITH ADMIN \"admin\"")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role", true), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 31), "admin", true))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE \"ro le\" WITH ADMIN \"ad min\"")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "ro le", true), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 32), "ad min", true))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE \"!@#$%^&*'\" WITH ADMIN \"\u0430\u0434\"\"\u043c\u0456\u043d\"")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "!@#$%^&*'", true), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 36), "\u0430\u0434\"\u043c\u0456\u043d", true))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE role2 WITH ADMIN USER admin1")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role2", false), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 35), "admin1", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE role2 WITH ADMIN ROLE role1")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role2", false), Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 35), "role1", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE role2 WITH ADMIN CURRENT_USER")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role2", false), Optional.of(new GrantorSpecification(GrantorSpecification.Type.CURRENT_USER, Optional.empty())), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE role2 WITH ADMIN CURRENT_ROLE")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role2", false), Optional.of(new GrantorSpecification(GrantorSpecification.Type.CURRENT_ROLE, Optional.empty())), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE ROLE role IN my_catalog")))).isEqualTo(new CreateRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 13), "role", false), Optional.empty(), Optional.of(new Identifier(TreeNodes.location(1, 21), "my_catalog", false))));
    }

    @Test
    public void testDropRole() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP ROLE role")))).isEqualTo(new DropRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 11), "role", false), Optional.empty(), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP ROLE IF EXISTS role")))).isEqualTo(new DropRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 21), "role", false), Optional.empty(), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP ROLE \"role\"")))).isEqualTo(new DropRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 11), "role", true), Optional.empty(), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP ROLE \"ro le\"")))).isEqualTo(new DropRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 11), "ro le", true), Optional.empty(), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP ROLE \"!@#$%^&*'\u0430\u0434\"\"\u043c\u0456\u043d\"")))).isEqualTo(new DropRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 11), "!@#$%^&*'\u0430\u0434\"\u043c\u0456\u043d", true), Optional.empty(), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP ROLE role IN my_catalog")))).isEqualTo(new DropRole(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 11), "role", false), Optional.of(new Identifier(TreeNodes.location(1, 19), "my_catalog", false)), false));
    }

    @Test
    public void testGrantRoles() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT role1 TO user1")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 16), "user1", false))), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT role1, role2, role3 TO user1, USER user2, ROLE role4 WITH ADMIN OPTION")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", false), (Object)new Identifier(TreeNodes.location(1, 14), "role2", false), (Object)new Identifier(TreeNodes.location(1, 21), "role3", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 30), "user1", false)), (Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 42), "user2", false)), (Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 54), "role4", false))), true, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT role1 TO user1 WITH ADMIN OPTION GRANTED BY admin")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 16), "user1", false))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 51), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT role1 TO USER user1 WITH ADMIN OPTION GRANTED BY USER admin")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 21), "user1", false))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 61), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT role1 TO ROLE role2 WITH ADMIN OPTION GRANTED BY ROLE admin")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 21), "role2", false))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 61), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT role1 TO ROLE role2 GRANTED BY ROLE admin")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 21), "role2", false))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 43), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT \"role1\" TO ROLE \"role2\" GRANTED BY ROLE \"admin\"")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", true)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 23), "role2", true))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 47), "admin", true))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("GRANT role1 TO user1 IN my_catalog")))).isEqualTo(new GrantRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 7), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 16), "user1", false))), false, Optional.empty(), Optional.of(new Identifier(TreeNodes.location(1, 25), "my_catalog", false))));
    }

    @Test
    public void testRevokeRoles() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE role1 FROM user1")))).isEqualTo(new RevokeRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 8), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 19), "user1", false))), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE ADMIN OPTION FOR role1, role2, role3 FROM user1, USER user2, ROLE role4")))).isEqualTo(new RevokeRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 25), "role1", false), (Object)new Identifier(TreeNodes.location(1, 32), "role2", false), (Object)new Identifier(TreeNodes.location(1, 39), "role3", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 50), "user1", false)), (Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 62), "user2", false)), (Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 74), "role4", false))), true, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE ADMIN OPTION FOR role1 FROM user1 GRANTED BY admin")))).isEqualTo(new RevokeRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 25), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 36), "user1", false))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 53), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE ADMIN OPTION FOR role1 FROM USER user1 GRANTED BY USER admin")))).isEqualTo(new RevokeRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 25), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 41), "user1", false))), true, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.USER, new Identifier(TreeNodes.location(1, 63), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE role1 FROM ROLE role2 GRANTED BY ROLE admin")))).isEqualTo(new RevokeRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 8), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 24), "role2", false))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 46), "admin", false))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE \"role1\" FROM ROLE \"role2\" GRANTED BY ROLE \"admin\"")))).isEqualTo(new RevokeRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 8), "role1", true)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 26), "role2", true))), false, Optional.of(new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(new PrincipalSpecification(PrincipalSpecification.Type.ROLE, new Identifier(TreeNodes.location(1, 50), "admin", true))))), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REVOKE role1 FROM user1 IN my_catalog")))).isEqualTo(new RevokeRoles(TreeNodes.location(1, 1), (Set)ImmutableSet.of((Object)new Identifier(TreeNodes.location(1, 8), "role1", false)), (Set)ImmutableSet.of((Object)new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, new Identifier(TreeNodes.location(1, 19), "user1", false))), false, Optional.empty(), Optional.of(new Identifier(TreeNodes.location(1, 28), "my_catalog", false))));
    }

    @Test
    public void testSetRole() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET ROLE ALL")))).isEqualTo(new SetRole(TreeNodes.location(1, 1), SetRole.Type.ALL, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET ROLE NONE")))).isEqualTo(new SetRole(TreeNodes.location(1, 1), SetRole.Type.NONE, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET ROLE role")))).isEqualTo(new SetRole(TreeNodes.location(1, 1), SetRole.Type.ROLE, Optional.of(new Identifier(TreeNodes.location(1, 10), "role", false)), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET ROLE \"role\"")))).isEqualTo(new SetRole(TreeNodes.location(1, 1), SetRole.Type.ROLE, Optional.of(new Identifier(TreeNodes.location(1, 10), "role", true)), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET ROLE role IN my_catalog")))).isEqualTo(new SetRole(TreeNodes.location(1, 1), SetRole.Type.ROLE, Optional.of(new Identifier(TreeNodes.location(1, 10), "role", false)), Optional.of(new Identifier(TreeNodes.location(1, 18), "my_catalog", false))));
    }

    @Test
    public void testCreateMaterializedView() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE MATERIALIZED VIEW a AS SELECT * FROM t")))).isEqualTo(new CreateMaterializedView(new NodeLocation(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 26), "a", false))), new Query(new NodeLocation(1, 31), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 31), new Select(new NodeLocation(1, 31), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 38), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 45), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 45), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), false, false, Optional.empty(), (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE MATERIALIZED VIEW catalog.schema.matview COMMENT 'A simple materialized view' AS SELECT * FROM catalog2.schema2.tab")))).isEqualTo(new CreateMaterializedView(new NodeLocation(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 37), "catalog", false), (Object)new Identifier(new NodeLocation(1, 45), "schema", false), (Object)new Identifier(new NodeLocation(1, 52), "matview", false))), new Query(new NodeLocation(1, 100), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 100), new Select(new NodeLocation(1, 100), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 107), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 114), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 114), "catalog2", false), (Object)new Identifier(new NodeLocation(1, 123), "schema2", false), (Object)new Identifier(new NodeLocation(1, 131), "tab", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), true, false, Optional.empty(), (List)ImmutableList.of(), Optional.of("A simple materialized view")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE MATERIALIZED VIEW a GRACE PERIOD INTERVAL '2' DAY AS SELECT * FROM t")))).isEqualTo(new CreateMaterializedView(new NodeLocation(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 26), "a", false))), new Query(new NodeLocation(1, 61), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(1, 61), new Select(new NodeLocation(1, 61), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(1, 68), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(1, 75), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 75), "t", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), false, false, Optional.of(new IntervalLiteral(new NodeLocation(1, 41), "2", IntervalLiteral.Sign.POSITIVE, IntervalLiteral.IntervalField.DAY, Optional.empty())), (List)ImmutableList.of(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE MATERIALIZED VIEW catalog.schema.matview COMMENT 'A simple materialized view'\nWITH (partitioned_by = ARRAY ['dateint'])\n AS SELECT * FROM catalog2.schema2.tab\n")))).isEqualTo(new CreateMaterializedView(new NodeLocation(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 37), "catalog", false), (Object)new Identifier(new NodeLocation(1, 45), "schema", false), (Object)new Identifier(new NodeLocation(1, 52), "matview", false))), new Query(new NodeLocation(3, 5), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(3, 5), new Select(new NodeLocation(3, 5), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(3, 12), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(3, 19), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(3, 19), "catalog2", false), (Object)new Identifier(new NodeLocation(3, 28), "schema2", false), (Object)new Identifier(new NodeLocation(3, 36), "tab", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), true, false, Optional.empty(), (List)ImmutableList.of((Object)new Property(new NodeLocation(2, 7), new Identifier(new NodeLocation(2, 7), "partitioned_by", false), (Expression)new Array(new NodeLocation(2, 24), (List)ImmutableList.of((Object)new StringLiteral(new NodeLocation(2, 31), "dateint"))))), Optional.of("A simple materialized view")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE OR REPLACE MATERIALIZED VIEW catalog.schema.matview COMMENT 'A partitioned materialized view'\nWITH (partitioned_by = ARRAY ['dateint'])\n AS WITH a (t, u) AS (SELECT * FROM x), b AS (SELECT * FROM a) TABLE b\n")))).isEqualTo(new CreateMaterializedView(new NodeLocation(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(1, 37), "catalog", false), (Object)new Identifier(new NodeLocation(1, 45), "schema", false), (Object)new Identifier(new NodeLocation(1, 52), "matview", false))), new Query(new NodeLocation(3, 5), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.of(new With(new NodeLocation(3, 5), false, (List)ImmutableList.of((Object)new WithQuery(new NodeLocation(3, 10), new Identifier(new NodeLocation(3, 10), "a", false), new Query(new NodeLocation(3, 23), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(3, 23), new Select(new NodeLocation(3, 23), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(3, 30), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(3, 37), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(3, 37), "x", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), Optional.of(ImmutableList.of((Object)new Identifier(new NodeLocation(3, 13), "t", false), (Object)new Identifier(new NodeLocation(3, 16), "u", false)))), (Object)new WithQuery(new NodeLocation(3, 41), new Identifier(new NodeLocation(3, 41), "b", false), new Query(new NodeLocation(3, 47), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(new NodeLocation(3, 47), new Select(new NodeLocation(3, 47), false, (List)ImmutableList.of((Object)new AllColumns(new NodeLocation(3, 54), Optional.empty(), (List)ImmutableList.of()))), Optional.of(new Table(new NodeLocation(3, 61), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(3, 61), "a", false))))), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty())))), (QueryBody)new Table(new NodeLocation(3, 64), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(new NodeLocation(3, 70), "b", false)))), Optional.empty(), Optional.empty(), Optional.empty()), true, false, Optional.empty(), (List)ImmutableList.of((Object)new Property(new NodeLocation(2, 7), new Identifier(new NodeLocation(2, 7), "partitioned_by", false), (Expression)new Array(new NodeLocation(2, 24), (List)ImmutableList.of((Object)new StringLiteral(new NodeLocation(2, 31), "dateint"))))), Optional.of("A partitioned materialized view")));
    }

    @Test
    public void testRefreshMaterializedView() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REFRESH MATERIALIZED VIEW test")))).isEqualTo(new RefreshMaterializedView(new NodeLocation(1, 1), new Table(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 27), "test", false))))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("REFRESH MATERIALIZED VIEW \"some name that contains space\"")))).isEqualTo(new RefreshMaterializedView(new NodeLocation(1, 1), new Table(QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 27), "some name that contains space", true))))));
    }

    @Test
    public void testDropMaterializedView() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP MATERIALIZED VIEW a")))).isEqualTo(new DropMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 24), "a", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP MATERIALIZED VIEW a.b")))).isEqualTo(new DropMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 24), "a", false), (Object)new Identifier(TreeNodes.location(1, 26), "b", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP MATERIALIZED VIEW a.b.c")))).isEqualTo(new DropMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 24), "a", false), (Object)new Identifier(TreeNodes.location(1, 26), "b", false), (Object)new Identifier(TreeNodes.location(1, 28), "c", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP MATERIALIZED VIEW IF EXISTS a")))).isEqualTo(new DropMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 34), "a", false))), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP MATERIALIZED VIEW IF EXISTS a.b")))).isEqualTo(new DropMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 34), "a", false), (Object)new Identifier(TreeNodes.location(1, 36), "b", false))), true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("DROP MATERIALIZED VIEW IF EXISTS a.b.c")))).isEqualTo(new DropMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 34), "a", false), (Object)new Identifier(TreeNodes.location(1, 36), "b", false), (Object)new Identifier(TreeNodes.location(1, 38), "c", false))), true));
    }

    @Test
    public void testRenameMaterializedView() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW a RENAME TO b")))).isEqualTo(new RenameMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "a", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 37), "b", false))), false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW IF EXISTS a RENAME TO b")))).isEqualTo(new RenameMaterializedView(TreeNodes.location(1, 1), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 35), "a", false))), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 47), "b", false))), true));
    }

    @Test
    public void testSetMaterializedViewProperties() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo='bar'")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 42), new Identifier(TreeNodes.location(1, 42), "foo", false), (Expression)new StringLiteral(TreeNodes.location(1, 46), "bar")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=true")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 42), new Identifier(TreeNodes.location(1, 42), "foo", false), (Expression)new BooleanLiteral(TreeNodes.location(1, 46), "true")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=123")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 42), new Identifier(TreeNodes.location(1, 42), "foo", false), (Expression)new LongLiteral(TreeNodes.location(1, 46), "123")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=123, bar=456")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 42), new Identifier(TreeNodes.location(1, 42), "foo", false), (Expression)new LongLiteral(TreeNodes.location(1, 46), "123")), (Object)new Property(TreeNodes.location(1, 51), new Identifier(TreeNodes.location(1, 51), "bar", false), (Expression)new LongLiteral(TreeNodes.location(1, 55), "456")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW a SET PROPERTIES \" s p a c e \"='bar'")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 42), new Identifier(TreeNodes.location(1, 42), " s p a c e ", true), (Expression)new StringLiteral(TreeNodes.location(1, 56), "bar")))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("ALTER MATERIALIZED VIEW a SET PROPERTIES foo=123, bar=DEFAULT")))).isEqualTo(new SetProperties(TreeNodes.location(1, 1), SetProperties.Type.MATERIALIZED_VIEW, QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 25), "a", false))), (List)ImmutableList.of((Object)new Property(TreeNodes.location(1, 42), new Identifier(TreeNodes.location(1, 42), "foo", false), (Expression)new LongLiteral(TreeNodes.location(1, 46), "123")), (Object)new Property(TreeNodes.location(1, 51), new Identifier(TreeNodes.location(1, 51), "bar", false)))));
        ParserAssert.assertStatementIsInvalid("ALTER MATERIALIZED VIEW a SET PROPERTIES").withMessage("line 1:41: mismatched input '<EOF>'. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER MATERIALIZED VIEW a SET PROPERTIES ()").withMessage("line 1:42: mismatched input '('. Expecting: <identifier>");
        ParserAssert.assertStatementIsInvalid("ALTER MATERIALIZED VIEW a SET PROPERTIES (foo='bar')").withMessage("line 1:42: mismatched input '('. Expecting: <identifier>");
    }

    @Test
    public void testNullTreatment() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("lead(x, 1) ignore nulls over()")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "lead", false))), Optional.of(new WindowSpecification(TreeNodes.location(1, 30), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty())), Optional.empty(), Optional.empty(), false, Optional.of(FunctionCall.NullTreatment.IGNORE), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 6), "x", false), (Object)new LongLiteral(TreeNodes.location(1, 9), "1"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("lead(x, 1) respect nulls over()")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "lead", false))), Optional.of(new WindowSpecification(TreeNodes.location(1, 31), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty())), Optional.empty(), Optional.empty(), false, Optional.of(FunctionCall.NullTreatment.RESPECT), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 6), "x", false), (Object)new LongLiteral(TreeNodes.location(1, 9), "1"))));
    }

    @Test
    public void testProcessingMode() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("RUNNING LAST(x, 1)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "LAST", false))), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.of(new ProcessingMode(TreeNodes.location(1, 1), ProcessingMode.Mode.RUNNING)), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 14), "x", false), (Object)new LongLiteral(TreeNodes.location(1, 17), "1"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("FINAL FIRST(x, 1)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 7), "FIRST", false))), Optional.empty(), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.of(new ProcessingMode(TreeNodes.location(1, 1), ProcessingMode.Mode.FINAL)), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 13), "x", false), (Object)new LongLiteral(TreeNodes.location(1, 16), "1"))));
    }

    @Test
    public void testWindowSpecification() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("rank() OVER someWindow")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "rank", false))), Optional.of(new WindowReference(TreeNodes.location(1, 8), new Identifier(TreeNodes.location(1, 13), "someWindow", false))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("rank() OVER (someWindow PARTITION BY x ORDER BY y ROWS CURRENT ROW)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "rank", false))), Optional.of(new WindowSpecification(TreeNodes.location(1, 14), Optional.of(new Identifier(TreeNodes.location(1, 14), "someWindow", false)), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 38), "x", false)), Optional.of(new OrderBy(TreeNodes.location(1, 40), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 49), (Expression)new Identifier(TreeNodes.location(1, 49), "y", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.of(new WindowFrame(TreeNodes.location(1, 51), WindowFrame.Type.ROWS, new FrameBound(TreeNodes.location(1, 56), FrameBound.Type.CURRENT_ROW), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of())))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("rank() OVER (PARTITION BY x ORDER BY y ROWS CURRENT ROW)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "rank", false))), Optional.of(new WindowSpecification(TreeNodes.location(1, 14), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 27), "x", false)), Optional.of(new OrderBy(TreeNodes.location(1, 29), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 38), (Expression)new Identifier(TreeNodes.location(1, 38), "y", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.of(new WindowFrame(TreeNodes.location(1, 40), WindowFrame.Type.ROWS, new FrameBound(TreeNodes.location(1, 45), FrameBound.Type.CURRENT_ROW), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of())))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
    }

    @Test
    public void testWindowClause() {
        TestSqlParser.assertStatement("SELECT * FROM T WINDOW someWindow AS (PARTITION BY a), otherWindow AS (someWindow ORDER BY b)", (Statement)QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new Table(TestSqlParser.makeQualifiedName("T")), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new WindowDefinition(new Identifier("someWindow"), new WindowSpecification(Optional.empty(), (List)ImmutableList.of((Object)new Identifier("a")), Optional.empty(), Optional.empty())), (Object)new WindowDefinition(new Identifier("otherWindow"), new WindowSpecification(Optional.of(new Identifier("someWindow")), (List)ImmutableList.of(), Optional.of(new OrderBy((List)ImmutableList.of((Object)new SortItem((Expression)new Identifier("b"), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.empty()))), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testWindowFrameWithPatternRecognition() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("rank() OVER (\n   PARTITION BY x\n   ORDER BY y\n   MEASURES\n       MATCH_NUMBER() AS match_no,\n       LAST(A.z) AS last_z\n   ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING\n   AFTER MATCH SKIP TO NEXT ROW\n   SEEK\n   PATTERN (A B C)\n   SUBSET U = (A, B)\n   DEFINE\n       B AS false,\n       C AS CLASSIFIER(U) = 'B'\n )\n")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 1), "rank", false))), Optional.of(new WindowSpecification(TreeNodes.location(2, 4), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(2, 17), "x", false)), Optional.of(new OrderBy(TreeNodes.location(3, 4), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(3, 13), (Expression)new Identifier(TreeNodes.location(3, 13), "y", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), Optional.of(new WindowFrame(TreeNodes.location(4, 4), WindowFrame.Type.ROWS, new FrameBound(TreeNodes.location(7, 17), FrameBound.Type.CURRENT_ROW), Optional.of(new FrameBound(TreeNodes.location(7, 33), FrameBound.Type.FOLLOWING, (Expression)new LongLiteral(TreeNodes.location(7, 33), "5"))), (List)ImmutableList.of((Object)new MeasureDefinition(TreeNodes.location(5, 8), (Expression)new FunctionCall(TreeNodes.location(5, 8), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(5, 8), "MATCH_NUMBER", false))), (List)ImmutableList.of()), new Identifier(TreeNodes.location(5, 26), "match_no", false)), (Object)new MeasureDefinition(TreeNodes.location(6, 8), (Expression)new FunctionCall(TreeNodes.location(6, 8), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(6, 8), "LAST", false))), (List)ImmutableList.of((Object)new DereferenceExpression(TreeNodes.location(6, 13), (Expression)new Identifier(TreeNodes.location(6, 13), "A", false), new Identifier(TreeNodes.location(6, 15), "z", false)))), new Identifier(TreeNodes.location(6, 21), "last_z", false))), Optional.of(SkipTo.skipToNextRow((NodeLocation)TreeNodes.location(8, 16))), Optional.of(new PatternSearchMode(TreeNodes.location(9, 4), PatternSearchMode.Mode.SEEK)), Optional.of(new PatternConcatenation(TreeNodes.location(10, 13), (List)ImmutableList.of((Object)new PatternConcatenation(TreeNodes.location(10, 13), (List)ImmutableList.of((Object)new PatternVariable(TreeNodes.location(10, 13), new Identifier(TreeNodes.location(10, 13), "A", false)), (Object)new PatternVariable(TreeNodes.location(10, 15), new Identifier(TreeNodes.location(10, 15), "B", false)))), (Object)new PatternVariable(TreeNodes.location(10, 17), new Identifier(TreeNodes.location(10, 17), "C", false))))), (List)ImmutableList.of((Object)new SubsetDefinition(TreeNodes.location(11, 11), new Identifier(TreeNodes.location(11, 11), "U", false), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(11, 16), "A", false), (Object)new Identifier(TreeNodes.location(11, 19), "B", false)))), (List)ImmutableList.of((Object)new VariableDefinition(TreeNodes.location(13, 8), new Identifier(TreeNodes.location(13, 8), "B", false), (Expression)new BooleanLiteral(TreeNodes.location(13, 13), "false")), (Object)new VariableDefinition(TreeNodes.location(14, 8), new Identifier(TreeNodes.location(14, 8), "C", false), (Expression)new ComparisonExpression(TreeNodes.location(14, 27), ComparisonExpression.Operator.EQUAL, (Expression)new FunctionCall(TreeNodes.location(14, 13), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(14, 13), "CLASSIFIER", false))), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(14, 24), "U", false))), (Expression)new StringLiteral(TreeNodes.location(14, 29), "B")))))))), Optional.empty(), Optional.empty(), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of()));
    }

    @Test
    public void testMeasureOverWindow() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("last_z OVER (\n  MEASURES z AS last_z\n  ROWS CURRENT ROW\n  PATTERN (A)\n  DEFINE a AS true\n)\n")))).isEqualTo(new WindowOperation(TreeNodes.location(1, 1), new Identifier(TreeNodes.location(1, 1), "last_z", false), (Window)new WindowSpecification(TreeNodes.location(2, 3), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.of(new WindowFrame(TreeNodes.location(2, 3), WindowFrame.Type.ROWS, new FrameBound(TreeNodes.location(3, 8), FrameBound.Type.CURRENT_ROW), Optional.empty(), (List)ImmutableList.of((Object)new MeasureDefinition(TreeNodes.location(2, 12), (Expression)new Identifier(TreeNodes.location(2, 12), "z", false), new Identifier(TreeNodes.location(2, 17), "last_z", false))), Optional.empty(), Optional.empty(), Optional.of(new PatternVariable(TreeNodes.location(4, 12), new Identifier(TreeNodes.location(4, 12), "A", false))), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new VariableDefinition(TreeNodes.location(5, 10), new Identifier(TreeNodes.location(5, 10), "a", false), (Expression)new BooleanLiteral(TreeNodes.location(5, 15), "true"))))))));
    }

    @Test
    public void testAllRowsReference() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SELECT 1 + A.*")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 1:13: mismatched input '.'.*");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT A.*")))).ignoringLocation().isEqualTo(QueryUtil.simpleQuery((Select)new Select(false, (List)ImmutableList.of((Object)new AllColumns((Expression)new Identifier("A"), (List)ImmutableList.of())))));
    }

    @Test
    public void testUpdate() {
        TestSqlParser.assertStatement("UPDATE foo_table\n    SET bar = 23, baz = 3.1415E0, bletch = 'barf'\nWHERE (nothing = 'fun')\n", (Statement)new Update(new NodeLocation(1, 1), QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo_table")), (List)ImmutableList.of((Object)new UpdateAssignment(new Identifier("bar"), (Expression)new LongLiteral("23")), (Object)new UpdateAssignment(new Identifier("baz"), (Expression)new DoubleLiteral("3.1415")), (Object)new UpdateAssignment(new Identifier("bletch"), (Expression)new StringLiteral("barf"))), Optional.of(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Identifier("nothing"), (Expression)new StringLiteral("fun")))));
    }

    @Test
    public void testWherelessUpdate() {
        TestSqlParser.assertStatement("UPDATE foo_table\nSET bar = 23\n", (Statement)new Update(new NodeLocation(1, 1), QueryUtil.table((QualifiedName)QualifiedName.of((String)"foo_table")), (List)ImmutableList.of((Object)new UpdateAssignment(new Identifier("bar"), (Expression)new LongLiteral("23"))), Optional.empty()));
    }

    @Test
    public void testQueryPeriod() {
        GenericLiteral rangeValue = new GenericLiteral(TreeNodes.location(1, 37), "TIMESTAMP", "2021-03-01 00:00:01");
        QueryPeriod queryPeriod = new QueryPeriod(TreeNodes.location(1, 17), QueryPeriod.RangeType.TIMESTAMP, (Expression)rangeValue);
        Table table = new Table(TreeNodes.location(1, 15), TreeNodes.qualifiedName(TreeNodes.location(1, 15), "t"), queryPeriod);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM t FOR TIMESTAMP AS OF TIMESTAMP '2021-03-01 00:00:01'")))).isEqualTo(new Query(TreeNodes.location(1, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(table), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
        rangeValue = new StringLiteral(TreeNodes.location(1, 35), "version1");
        queryPeriod = new QueryPeriod(new NodeLocation(1, 17), QueryPeriod.RangeType.VERSION, (Expression)rangeValue);
        table = new Table(TreeNodes.location(1, 15), TreeNodes.qualifiedName(TreeNodes.location(1, 15), "t"), queryPeriod);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM t FOR VERSION AS OF 'version1'")))).isEqualTo(new Query(TreeNodes.location(1, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(table), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testListagg() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("LISTAGG(x) WITHIN GROUP (ORDER BY x)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("LISTAGG", false))), Optional.empty(), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 26), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 35), (Expression)new Identifier(TreeNodes.location(1, 35), "x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "x", false), (Object)new StringLiteral(TreeNodes.location(1, 1), ""), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "true"), (Object)new StringLiteral(TreeNodes.location(1, 1), "..."), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("LISTAGG( DISTINCT x) WITHIN GROUP (ORDER BY x)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("LISTAGG", false))), Optional.empty(), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 36), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 45), (Expression)new Identifier(TreeNodes.location(1, 45), "x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), true, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 19), "x", false), (Object)new StringLiteral(TreeNodes.location(1, 1), ""), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "true"), (Object)new StringLiteral(TreeNodes.location(1, 1), "..."), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("LISTAGG(x, ',') WITHIN GROUP (ORDER BY y)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("LISTAGG", false))), Optional.empty(), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 31), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 40), (Expression)new Identifier(TreeNodes.location(1, 40), "y", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "x", false), (Object)new StringLiteral(TreeNodes.location(1, 12), ","), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "true"), (Object)new StringLiteral(TreeNodes.location(1, 1), "..."), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("LISTAGG(x, ',' ON OVERFLOW ERROR) WITHIN GROUP (ORDER BY x)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("LISTAGG", false))), Optional.empty(), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 49), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 58), (Expression)new Identifier(TreeNodes.location(1, 58), "x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "x", false), (Object)new StringLiteral(TreeNodes.location(1, 12), ","), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "true"), (Object)new StringLiteral(TreeNodes.location(1, 1), "..."), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("LISTAGG(x, ',' ON OVERFLOW TRUNCATE WITH COUNT) WITHIN GROUP (ORDER BY x)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("LISTAGG", false))), Optional.empty(), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 63), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 72), (Expression)new Identifier(TreeNodes.location(1, 72), "x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "x", false), (Object)new StringLiteral(TreeNodes.location(1, 12), ","), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"), (Object)new StringLiteral(TreeNodes.location(1, 1), "..."), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "true"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("LISTAGG(x, ',' ON OVERFLOW TRUNCATE 'HIDDEN' WITHOUT COUNT) WITHIN GROUP (ORDER BY x)")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("LISTAGG", false))), Optional.empty(), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 75), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 84), (Expression)new Identifier(TreeNodes.location(1, 84), "x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "x", false), (Object)new StringLiteral(TreeNodes.location(1, 12), ","), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"), (Object)new StringLiteral(TreeNodes.location(1, 37), "HIDDEN"), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("LISTAGG(x) WITHIN GROUP (ORDER BY x) OVER someWindow")))).isEqualTo(new FunctionCall(Optional.of(TreeNodes.location(1, 1)), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier("LISTAGG", false))), Optional.of(new WindowReference(TreeNodes.location(1, 38), new Identifier(TreeNodes.location(1, 43), "someWindow", false))), Optional.empty(), Optional.of(new OrderBy(TreeNodes.location(1, 26), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(1, 35), (Expression)new Identifier(TreeNodes.location(1, 35), "x", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.UNDEFINED)))), false, Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 9), "x", false), (Object)new StringLiteral(TreeNodes.location(1, 1), ""), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "true"), (Object)new StringLiteral(TreeNodes.location(1, 1), "..."), (Object)new BooleanLiteral(TreeNodes.location(1, 1), "false"))));
    }

    @Test
    public void testTableFunctionInvocation() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => 1))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new LongLiteral(TreeNodes.location(1, 39), "1"))), (List)ImmutableList.of())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(\n    arg1 => TABLE(orders) AS ord(a, b, c)\n        PARTITION BY a\n        PRUNE WHEN EMPTY\n        ORDER BY b ASC NULLS LAST,\n    arg2 => CAST(NULL AS DESCRIPTOR),\n    arg3 => DESCRIPTOR(x integer, y varchar),\n    arg4 => 5,\n    'not-named argument'\n    COPARTITION (ord, nation)))\n")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(2, 5), Optional.of(new Identifier(TreeNodes.location(2, 5), "arg1", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(2, 13), (Relation)new AliasedRelation(TreeNodes.location(2, 13), (Relation)new Table(TreeNodes.location(2, 13), TreeNodes.qualifiedName(TreeNodes.location(2, 19), "orders")), new Identifier(TreeNodes.location(2, 30), "ord", false), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(2, 34), "a", false), (Object)new Identifier(TreeNodes.location(2, 37), "b", false), (Object)new Identifier(TreeNodes.location(2, 40), "c", false))), Optional.of(ImmutableList.of((Object)new Identifier(TreeNodes.location(3, 22), "a", false))), Optional.of(new OrderBy(TreeNodes.location(5, 9), (List)ImmutableList.of((Object)new SortItem(TreeNodes.location(5, 18), (Expression)new Identifier(TreeNodes.location(5, 18), "b", false), SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)))), Optional.of(new EmptyTableTreatment(TreeNodes.location(4, 9), EmptyTableTreatment.Treatment.PRUNE)))), (Object)new TableFunctionArgument(TreeNodes.location(6, 5), Optional.of(new Identifier(TreeNodes.location(6, 5), "arg2", false)), (Node)TableFunctionDescriptorArgument.nullDescriptorArgument((NodeLocation)TreeNodes.location(6, 13))), (Object)new TableFunctionArgument(TreeNodes.location(7, 5), Optional.of(new Identifier(TreeNodes.location(7, 5), "arg3", false)), (Node)TableFunctionDescriptorArgument.descriptorArgument((NodeLocation)TreeNodes.location(7, 13), (Descriptor)new Descriptor(TreeNodes.location(7, 13), (List)ImmutableList.of((Object)new DescriptorField(TreeNodes.location(7, 24), new Identifier(TreeNodes.location(7, 24), "x", false), Optional.of(new GenericDataType(TreeNodes.location(7, 26), new Identifier(TreeNodes.location(7, 26), "integer", false), (List)ImmutableList.of()))), (Object)new DescriptorField(TreeNodes.location(7, 35), new Identifier(TreeNodes.location(7, 35), "y", false), Optional.of(new GenericDataType(TreeNodes.location(7, 37), new Identifier(TreeNodes.location(7, 37), "varchar", false), (List)ImmutableList.of()))))))), (Object)new TableFunctionArgument(TreeNodes.location(8, 5), Optional.of(new Identifier(TreeNodes.location(8, 5), "arg4", false)), (Node)new LongLiteral(TreeNodes.location(8, 13), "5")), (Object)new TableFunctionArgument(TreeNodes.location(9, 5), Optional.empty(), (Node)new StringLiteral(TreeNodes.location(9, 5), "not-named argument"))), (List)ImmutableList.of((Object)ImmutableList.of((Object)TreeNodes.qualifiedName(TreeNodes.location(10, 18), "ord"), (Object)TreeNodes.qualifiedName(TreeNodes.location(10, 23), "nation"))))));
    }

    @Test
    public void testTableFunctionTableArgumentAliasing() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => TABLE(orders)))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(1, 39), (Relation)new Table(TreeNodes.location(1, 39), TreeNodes.qualifiedName(TreeNodes.location(1, 45), "orders")), Optional.empty(), Optional.empty(), Optional.empty()))), (List)ImmutableList.of())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => TABLE(orders) AS ord))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(1, 39), (Relation)new AliasedRelation(TreeNodes.location(1, 39), (Relation)new Table(TreeNodes.location(1, 39), TreeNodes.qualifiedName(TreeNodes.location(1, 45), "orders")), new Identifier(TreeNodes.location(1, 56), "ord", false), null), Optional.empty(), Optional.empty(), Optional.empty()))), (List)ImmutableList.of())));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM TABLE(some_ptf(input => TABLE(orders) AS ord(a, b, c)))")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new TableFunctionInvocation(TreeNodes.location(1, 21), TreeNodes.qualifiedName(TreeNodes.location(1, 21), "some_ptf"), (List)ImmutableList.of((Object)new TableFunctionArgument(TreeNodes.location(1, 30), Optional.of(new Identifier(TreeNodes.location(1, 30), "input", false)), (Node)new TableFunctionTableArgument(TreeNodes.location(1, 39), (Relation)new AliasedRelation(TreeNodes.location(1, 39), (Relation)new Table(TreeNodes.location(1, 39), TreeNodes.qualifiedName(TreeNodes.location(1, 45), "orders")), new Identifier(TreeNodes.location(1, 56), "ord", false), (List)ImmutableList.of((Object)new Identifier(TreeNodes.location(1, 60), "a", false), (Object)new Identifier(TreeNodes.location(1, 63), "b", false), (Object)new Identifier(TreeNodes.location(1, 66), "c", false))), Optional.empty(), Optional.empty(), Optional.empty()))), (List)ImmutableList.of())));
    }

    @Test
    public void testCopartitionInTableArgumentAlias() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SELECT *\nFROM TABLE(some_ptf(\ninput => TABLE(orders) copartition(a, b, c)))\n")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 3:24: The word \"COPARTITION\" is ambiguous in this context. To alias an argument, precede the alias with \"AS\". To specify co-partitioning, change the argument order so that the last argument cannot be aliased.");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT *\nFROM TABLE(some_ptf(\n   input => TABLE(SELECT * FROM orders copartition(a, b, c))))\n")))).isInstanceOf(Query.class);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT *\nFROM TABLE(some_ptf(\n    input => TABLE(orders) \"COPARTITION\"(a, b, c)))\n")))).isInstanceOf(Query.class);
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT *\nFROM TABLE(some_ptf(\n   input => TABLE(orders) AS copartition(a, b, c)))\n")))).isInstanceOf(Query.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SQL_PARSER.createStatement("SELECT *\nFROM TABLE(some_ptf(\n    input1 => TABLE(customers) PARTITION BY nationkey,\n    input2 => TABLE(nation) PARTITION BY nationkey,\n    input3 => TABLE(lineitem)\n    COPARTITION(customers, nation)))\n")).isInstanceOf(ParsingException.class)).hasMessageMatching("line 6:5: The word \"COPARTITION\" is ambiguous in this context. To alias an argument, precede the alias with \"AS\". To specify co-partitioning, change the argument order so that the last argument cannot be aliased.");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT *\nFROM TABLE(some_ptf(\n    input1 => TABLE(customers) PARTITION BY nationkey,\n    input3 => TABLE(lineitem),\n    input2 => TABLE(nation) PARTITION BY nationkey\n    COPARTITION(customers, nation)))\n")))).isInstanceOf(Query.class);
    }

    private static Query selectAllFrom(Relation relation) {
        return new Query(TreeNodes.location(1, 1), (List)ImmutableList.of(), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(1, 1), new Select(TreeNodes.location(1, 1), false, (List)ImmutableList.of((Object)new AllColumns(TreeNodes.location(1, 8), Optional.empty(), (List)ImmutableList.of()))), Optional.of(relation), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Test
    public void testJsonExists() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_EXISTS(json_column, 'lax $[5]')")))).isEqualTo(new JsonExists(TreeNodes.location(1, 1), new JsonPathInvocation(TreeNodes.location(1, 13), (Expression)new Identifier(TreeNodes.location(1, 13), "json_column", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 26), "lax $[5]"), Optional.empty(), (List)ImmutableList.of()), JsonExists.ErrorBehavior.FALSE));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_EXISTS(\n    json_column FORMAT JSON ENCODING UTF8,\n    'lax $[start_parameter TO end_parameter.ceiling()]'\n        PASSING\n                start_column AS start_parameter,\n                end_column FORMAT JSON ENCODING UTF16 AS end_parameter\n    UNKNOWN ON ERROR)\n")))).isEqualTo(new JsonExists(TreeNodes.location(1, 1), new JsonPathInvocation(TreeNodes.location(2, 5), (Expression)new Identifier(TreeNodes.location(2, 5), "json_column", false), JsonPathParameter.JsonFormat.UTF8, new StringLiteral(TreeNodes.location(3, 5), "lax $[start_parameter TO end_parameter.ceiling()]"), Optional.empty(), (List)ImmutableList.of((Object)new JsonPathParameter(TreeNodes.location(5, 17), new Identifier(TreeNodes.location(5, 33), "start_parameter", false), (Expression)new Identifier(TreeNodes.location(5, 17), "start_column", false), Optional.empty()), (Object)new JsonPathParameter(TreeNodes.location(6, 17), new Identifier(TreeNodes.location(6, 58), "end_parameter", false), (Expression)new Identifier(TreeNodes.location(6, 17), "end_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)))), JsonExists.ErrorBehavior.UNKNOWN));
    }

    @Test
    public void testJsonValue() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_VALUE(json_column, 'lax $[5]')")))).isEqualTo(new JsonValue(TreeNodes.location(1, 1), new JsonPathInvocation(TreeNodes.location(1, 12), (Expression)new Identifier(TreeNodes.location(1, 12), "json_column", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 25), "lax $[5]"), Optional.empty(), (List)ImmutableList.of()), Optional.empty(), JsonValue.EmptyOrErrorBehavior.NULL, Optional.empty(), JsonValue.EmptyOrErrorBehavior.NULL, Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_VALUE(\n    json_column FORMAT JSON ENCODING UTF8,\n    'lax $[start_parameter TO end_parameter.ceiling()]'\n        PASSING\n                start_column AS start_parameter,\n                end_column FORMAT JSON ENCODING UTF16 AS end_parameter\n    RETURNING double\n    DEFAULT 5e0 ON EMPTY\n    ERROR ON ERROR)\n")))).isEqualTo(new JsonValue(TreeNodes.location(1, 1), new JsonPathInvocation(TreeNodes.location(2, 5), (Expression)new Identifier(TreeNodes.location(2, 5), "json_column", false), JsonPathParameter.JsonFormat.UTF8, new StringLiteral(TreeNodes.location(3, 5), "lax $[start_parameter TO end_parameter.ceiling()]"), Optional.empty(), (List)ImmutableList.of((Object)new JsonPathParameter(TreeNodes.location(5, 17), new Identifier(TreeNodes.location(5, 33), "start_parameter", false), (Expression)new Identifier(TreeNodes.location(5, 17), "start_column", false), Optional.empty()), (Object)new JsonPathParameter(TreeNodes.location(6, 17), new Identifier(TreeNodes.location(6, 58), "end_parameter", false), (Expression)new Identifier(TreeNodes.location(6, 17), "end_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)))), Optional.of(new GenericDataType(TreeNodes.location(7, 15), new Identifier(TreeNodes.location(7, 15), "double", false), (List)ImmutableList.of())), JsonValue.EmptyOrErrorBehavior.DEFAULT, Optional.of(new DoubleLiteral(TreeNodes.location(8, 13), "5e0")), JsonValue.EmptyOrErrorBehavior.ERROR, Optional.empty()));
    }

    @Test
    public void testJsonQuery() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_QUERY(json_column, 'lax $[5]')")))).isEqualTo(new JsonQuery(TreeNodes.location(1, 1), new JsonPathInvocation(TreeNodes.location(1, 12), (Expression)new Identifier(TreeNodes.location(1, 12), "json_column", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 25), "lax $[5]"), Optional.empty(), (List)ImmutableList.of()), Optional.empty(), Optional.empty(), JsonQuery.ArrayWrapperBehavior.WITHOUT, Optional.empty(), JsonQuery.EmptyOrErrorBehavior.NULL, JsonQuery.EmptyOrErrorBehavior.NULL));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_QUERY(\n    json_column FORMAT JSON ENCODING UTF8,\n    'lax $[start_parameter TO end_parameter.ceiling()]'\n        PASSING\n                start_column AS start_parameter,\n                end_column FORMAT JSON ENCODING UTF16 AS end_parameter\n    RETURNING varchar FORMAT JSON ENCODING UTF32\n    WITH ARRAY WRAPPER\n    OMIT QUOTES\n    EMPTY ARRAY ON EMPTY\n    ERROR ON ERROR)\n")))).isEqualTo(new JsonQuery(TreeNodes.location(1, 1), new JsonPathInvocation(TreeNodes.location(2, 5), (Expression)new Identifier(TreeNodes.location(2, 5), "json_column", false), JsonPathParameter.JsonFormat.UTF8, new StringLiteral(TreeNodes.location(3, 5), "lax $[start_parameter TO end_parameter.ceiling()]"), Optional.empty(), (List)ImmutableList.of((Object)new JsonPathParameter(TreeNodes.location(5, 17), new Identifier(TreeNodes.location(5, 33), "start_parameter", false), (Expression)new Identifier(TreeNodes.location(5, 17), "start_column", false), Optional.empty()), (Object)new JsonPathParameter(TreeNodes.location(6, 17), new Identifier(TreeNodes.location(6, 58), "end_parameter", false), (Expression)new Identifier(TreeNodes.location(6, 17), "end_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)))), Optional.of(new GenericDataType(TreeNodes.location(7, 15), new Identifier(TreeNodes.location(7, 15), "varchar", false), (List)ImmutableList.of())), Optional.of(JsonPathParameter.JsonFormat.UTF32), JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL, Optional.of(JsonQuery.QuotesBehavior.OMIT), JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY, JsonQuery.EmptyOrErrorBehavior.ERROR));
    }

    @Test
    public void testSessionProperty() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("WITH SESSION\n   key = 'value',\n   catalog.key2 = DECIMAL '10.0'\nSELECT 1\n")))).isEqualTo(new Query(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new SessionProperty(TreeNodes.location(2, 4), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(2, 4), "key", false))), (Expression)new StringLiteral(TreeNodes.location(2, 10), "value")), (Object)new SessionProperty(TreeNodes.location(3, 4), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(3, 4), "catalog", false), (Object)new Identifier(TreeNodes.location(3, 12), "key2", false))), (Expression)new DecimalLiteral(TreeNodes.location(3, 19), "10.0"))), (List)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(4, 1), new Select(TreeNodes.location(4, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(4, 8), (Expression)new LongLiteral(TreeNodes.location(4, 8), "1"), Optional.empty()))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testInvalidQueryScoped() {
        ParserAssert.assertStatementIsInvalid("WITH WITH SESSION query_max_memory = '1GB' SELECT 1").withMessage("line 1:6: mismatched input 'WITH'. Expecting: 'FUNCTION', 'RECURSIVE', 'SESSION', <identifier>");
        ParserAssert.assertStatementIsInvalid("WITH FUNCTION abc() RETURNS int RETURN 42, SESSION query_max_memory = '1GB' SELECT 1").withMessage("line 1:44: mismatched input 'SESSION'. Expecting: 'FUNCTION'");
        ParserAssert.assertStatementIsInvalid("WITH SESSION query_max_memory = '1GB', FUNCTION abc() RETURNS int RETURN 42, SESSION query_max_total_memory = '1GB' SELECT 1").withMessage("line 1:49: mismatched input 'abc'. Expecting: '.', '='");
        ParserAssert.assertStatementIsInvalid("WITH SESSION query_max_memory = '1GB', WITH SESSION query_max_total_memory = '1GB' SELECT 1").withMessage("line 1:40: mismatched input 'WITH'. Expecting: <identifier>");
    }

    @Test
    public void testWithSessionAndFunction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("WITH SESSION\n   key = 'value'\nWITH\n   FUNCTION foo()\n   RETURNS bigint\n   RETURN 42\nSELECT 1")))).isEqualTo(new Query(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new SessionProperty(TreeNodes.location(2, 4), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(2, 4), "key", false))), (Expression)new StringLiteral(TreeNodes.location(2, 10), "value"))), (List)ImmutableList.of((Object)new FunctionSpecification(TreeNodes.location(4, 4), QualifiedName.of((Iterable)ImmutableList.of((Object)new Identifier(TreeNodes.location(4, 13), "foo", false))), (List)ImmutableList.of(), new ReturnsClause(TreeNodes.location(5, 4), TreeNodes.simpleType(TreeNodes.location(5, 12), "bigint")), (List)ImmutableList.of(), Optional.of(new ReturnStatement(TreeNodes.location(6, 4), (Expression)new LongLiteral(TreeNodes.location(6, 11), "42"))), Optional.empty())), Optional.empty(), (QueryBody)new QuerySpecification(TreeNodes.location(7, 1), new Select(TreeNodes.location(7, 1), false, (List)ImmutableList.of((Object)new SingleColumn(TreeNodes.location(7, 8), (Expression)new LongLiteral(TreeNodes.location(7, 8), "1"), Optional.empty()))), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty(), Optional.empty(), Optional.empty()));
    }

    @Test
    public void testJsonObject() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_OBJECT()")))).isEqualTo(new JsonObject(TreeNodes.location(1, 1), (List)ImmutableList.of(), true, false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_OBJECT(key_column : value_column)")))).isEqualTo(new JsonObject(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new JsonObjectMember(TreeNodes.location(1, 13), (Expression)new Identifier(TreeNodes.location(1, 13), "key_column", false), (Expression)new Identifier(TreeNodes.location(1, 26), "value_column", false), Optional.empty())), true, false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_OBJECT(\n     key_column_1 VALUE value_column FORMAT JSON ENCODING UTF16,\n     KEY 'key_literal' VALUE 5,\n     key_column_2 : null\n     ABSENT ON NULL\n     WITH UNIQUE KEYS\n     RETURNING varbinary FORMAT JSON ENCODING UTF32)\n")))).isEqualTo(new JsonObject(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new JsonObjectMember(TreeNodes.location(2, 6), (Expression)new Identifier(TreeNodes.location(2, 6), "key_column_1", false), (Expression)new Identifier(TreeNodes.location(2, 25), "value_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)), (Object)new JsonObjectMember(TreeNodes.location(3, 6), (Expression)new StringLiteral(TreeNodes.location(3, 10), "key_literal"), (Expression)new LongLiteral(TreeNodes.location(3, 30), "5"), Optional.empty()), (Object)new JsonObjectMember(TreeNodes.location(4, 6), (Expression)new Identifier(TreeNodes.location(4, 6), "key_column_2", false), (Expression)new NullLiteral(TreeNodes.location(4, 21)), Optional.empty())), false, true, Optional.of(new GenericDataType(TreeNodes.location(7, 16), new Identifier(TreeNodes.location(7, 16), "varbinary", false), (List)ImmutableList.of())), Optional.of(JsonPathParameter.JsonFormat.UTF32)));
    }

    @Test
    public void testJsonArray() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_ARRAY()")))).isEqualTo(new JsonArray(TreeNodes.location(1, 1), (List)ImmutableList.of(), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_ARRAY(value_column)")))).isEqualTo(new JsonArray(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new JsonArrayElement(TreeNodes.location(1, 12), (Expression)new Identifier(TreeNodes.location(1, 12), "value_column", false), Optional.empty())), false, Optional.empty(), Optional.empty()));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.expression("JSON_ARRAY(value_column FORMAT JSON ENCODING UTF16,\n    5,\n    null\n    NULL ON NULL\n    RETURNING varbinary FORMAT JSON ENCODING UTF32)\n")))).isEqualTo(new JsonArray(TreeNodes.location(1, 1), (List)ImmutableList.of((Object)new JsonArrayElement(TreeNodes.location(1, 12), (Expression)new Identifier(TreeNodes.location(1, 12), "value_column", false), Optional.of(JsonPathParameter.JsonFormat.UTF16)), (Object)new JsonArrayElement(TreeNodes.location(2, 5), (Expression)new LongLiteral(TreeNodes.location(2, 5), "5"), Optional.empty()), (Object)new JsonArrayElement(TreeNodes.location(3, 5), (Expression)new NullLiteral(TreeNodes.location(3, 5)), Optional.empty())), true, Optional.of(new GenericDataType(TreeNodes.location(5, 15), new Identifier(TreeNodes.location(5, 15), "varbinary", false), (List)ImmutableList.of())), Optional.of(JsonPathParameter.JsonFormat.UTF32)));
    }

    @Test
    public void testJsonTableScalarColumns() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM JSON_TABLE(col, 'lax $' COLUMNS(ordinal_number FOR ORDINALITY, customer_name varchar PATH 'lax $.cust_no' DEFAULT 'anonymous' ON EMPTY null ON ERROR, customer_countries varchar FORMAT JSON PATH 'lax.cust_ctr[*]' WITH WRAPPER KEEP QUOTES null ON EMPTY ERROR ON ERROR,customer_regions varchar FORMAT JSON ENCODING UTF16 PATH 'lax.cust_reg[*]' EMPTY ARRAY ON EMPTY EMPTY OBJECT ON ERROR) EMPTY ON ERROR)")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new JsonTable(TreeNodes.location(1, 15), new JsonPathInvocation(TreeNodes.location(1, 26), (Expression)new Identifier(TreeNodes.location(1, 26), "col", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 31), "lax $"), Optional.empty(), (List)ImmutableList.of()), (List)ImmutableList.of((Object)new OrdinalityColumn(TreeNodes.location(1, 47), new Identifier(TreeNodes.location(1, 47), "ordinal_number", false)), (Object)new ValueColumn(TreeNodes.location(1, 78), new Identifier(TreeNodes.location(1, 78), "customer_name", false), (DataType)new GenericDataType(TreeNodes.location(1, 92), new Identifier(TreeNodes.location(1, 92), "varchar", false), (List)ImmutableList.of()), Optional.of(new StringLiteral(TreeNodes.location(1, 105), "lax $.cust_no")), JsonValue.EmptyOrErrorBehavior.DEFAULT, Optional.of(new StringLiteral(TreeNodes.location(1, 129), "anonymous")), Optional.of(JsonValue.EmptyOrErrorBehavior.NULL), Optional.empty()), (Object)new QueryColumn(TreeNodes.location(1, 165), new Identifier(TreeNodes.location(1, 165), "customer_countries", false), (DataType)new GenericDataType(TreeNodes.location(1, 184), new Identifier(TreeNodes.location(1, 184), "varchar", false), (List)ImmutableList.of()), JsonPathParameter.JsonFormat.JSON, Optional.of(new StringLiteral(TreeNodes.location(1, 209), "lax.cust_ctr[*]")), JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL, Optional.of(JsonQuery.QuotesBehavior.KEEP), JsonQuery.EmptyOrErrorBehavior.NULL, Optional.of(JsonQuery.EmptyOrErrorBehavior.ERROR)), (Object)new QueryColumn(TreeNodes.location(1, 281), new Identifier(TreeNodes.location(1, 281), "customer_regions", false), (DataType)new GenericDataType(TreeNodes.location(1, 298), new Identifier(TreeNodes.location(1, 298), "varchar", false), (List)ImmutableList.of()), JsonPathParameter.JsonFormat.UTF16, Optional.of(new StringLiteral(TreeNodes.location(1, 338), "lax.cust_reg[*]")), JsonQuery.ArrayWrapperBehavior.WITHOUT, Optional.empty(), JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY, Optional.of(JsonQuery.EmptyOrErrorBehavior.EMPTY_OBJECT))), Optional.empty(), Optional.of(JsonTable.ErrorBehavior.EMPTY))));
    }

    @Test
    public void testJsonTableNestedColumns() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SELECT * FROM JSON_TABLE(col, 'lax $' AS customer COLUMNS(\n    NESTED PATH 'lax $.cust_status[*]' AS status COLUMNS(\n       status varchar PATH 'lax $.type',\n       fresh boolean PATH 'lax &.new'),\n    NESTED PATH 'lax &.cust_comm[*]' AS comment COLUMNS(\n       comment varchar PATH 'lax $.text'))\n    PLAN (customer OUTER (status CROSS comment))\n    ERROR ON ERROR)\n")))).isEqualTo(TestSqlParser.selectAllFrom((Relation)new JsonTable(TreeNodes.location(1, 15), new JsonPathInvocation(TreeNodes.location(1, 26), (Expression)new Identifier(TreeNodes.location(1, 26), "col", false), JsonPathParameter.JsonFormat.JSON, new StringLiteral(TreeNodes.location(1, 31), "lax $"), Optional.of(new Identifier(TreeNodes.location(1, 42), "customer", false)), (List)ImmutableList.of()), (List)ImmutableList.of((Object)new NestedColumns(TreeNodes.location(2, 5), new StringLiteral(TreeNodes.location(2, 17), "lax $.cust_status[*]"), Optional.of(new Identifier(TreeNodes.location(2, 43), "status", false)), (List)ImmutableList.of((Object)new ValueColumn(TreeNodes.location(3, 8), new Identifier(TreeNodes.location(3, 8), "status", false), (DataType)new GenericDataType(TreeNodes.location(3, 15), new Identifier(TreeNodes.location(3, 15), "varchar", false), (List)ImmutableList.of()), Optional.of(new StringLiteral(TreeNodes.location(3, 28), "lax $.type")), JsonValue.EmptyOrErrorBehavior.NULL, Optional.empty(), Optional.empty(), Optional.empty()), (Object)new ValueColumn(TreeNodes.location(4, 8), new Identifier(TreeNodes.location(4, 8), "fresh", false), (DataType)new GenericDataType(TreeNodes.location(4, 14), new Identifier(TreeNodes.location(4, 14), "boolean", false), (List)ImmutableList.of()), Optional.of(new StringLiteral(TreeNodes.location(4, 27), "lax &.new")), JsonValue.EmptyOrErrorBehavior.NULL, Optional.empty(), Optional.empty(), Optional.empty()))), (Object)new NestedColumns(TreeNodes.location(5, 5), new StringLiteral(TreeNodes.location(5, 17), "lax &.cust_comm[*]"), Optional.of(new Identifier(TreeNodes.location(5, 41), "comment", false)), (List)ImmutableList.of((Object)new ValueColumn(TreeNodes.location(6, 8), new Identifier(TreeNodes.location(6, 8), "comment", false), (DataType)new GenericDataType(TreeNodes.location(6, 16), new Identifier(TreeNodes.location(6, 16), "varchar", false), (List)ImmutableList.of()), Optional.of(new StringLiteral(TreeNodes.location(6, 29), "lax $.text")), JsonValue.EmptyOrErrorBehavior.NULL, Optional.empty(), Optional.empty(), Optional.empty())))), Optional.of(new PlanParentChild(TreeNodes.location(7, 11), JsonTablePlan.ParentChildPlanType.OUTER, new PlanLeaf(TreeNodes.location(7, 11), new Identifier(TreeNodes.location(7, 11), "customer", false)), (JsonTableSpecificPlan)new PlanSiblings(TreeNodes.location(7, 27), JsonTablePlan.SiblingsPlanType.CROSS, (List)ImmutableList.of((Object)new PlanLeaf(TreeNodes.location(7, 27), new Identifier(TreeNodes.location(7, 27), "status", false)), (Object)new PlanLeaf(TreeNodes.location(7, 40), new Identifier(TreeNodes.location(7, 40), "comment", false)))))), Optional.of(JsonTable.ErrorBehavior.ERROR))));
    }

    @Test
    public void testSetSessionAuthorization() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION AUTHORIZATION user")))).isEqualTo(new SetSessionAuthorization(TreeNodes.location(1, 1), (Expression)new Identifier(TreeNodes.location(1, 27), "user", false)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION AUTHORIZATION \"user\"")))).isEqualTo(new SetSessionAuthorization(TreeNodes.location(1, 1), (Expression)new Identifier(TreeNodes.location(1, 27), "user", true)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION AUTHORIZATION 'user'")))).isEqualTo(new SetSessionAuthorization(TreeNodes.location(1, 1), (Expression)new StringLiteral(TreeNodes.location(1, 27), "user")));
        ParserAssert.assertStatementIsInvalid("SET SESSION AUTHORIZATION user-a").withMessage("line 1:31: mismatched input '-'. Expecting: <EOF>");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION AUTHORIZATION \"user-a\"")))).isEqualTo(new SetSessionAuthorization(TreeNodes.location(1, 1), (Expression)new Identifier(TreeNodes.location(1, 27), "user-a", true)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION AUTHORIZATION 'user-a'")))).isEqualTo(new SetSessionAuthorization(TreeNodes.location(1, 1), (Expression)new StringLiteral(TreeNodes.location(1, 27), "user-a")));
        ParserAssert.assertStatementIsInvalid("SET SESSION AUTHORIZATION null").withMessage("line 1:27: mismatched input 'null'. Expecting: '.', '=', <identifier>, <string>");
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION AUTHORIZATION \"null\"")))).isEqualTo(new SetSessionAuthorization(TreeNodes.location(1, 1), (Expression)new Identifier(TreeNodes.location(1, 27), "null", true)));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("SET SESSION AUTHORIZATION 'null'")))).isEqualTo(new SetSessionAuthorization(TreeNodes.location(1, 1), (Expression)new StringLiteral(TreeNodes.location(1, 27), "null")));
    }

    @Test
    public void testResetSessionAuthorization() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("RESET SESSION AUTHORIZATION")))).isEqualTo(new ResetSessionAuthorization(TreeNodes.location(1, 1)));
    }

    private static QualifiedName makeQualifiedName(String tableName) {
        List parts = (List)Splitter.on((char)'.').splitToList((CharSequence)tableName).stream().map(Identifier::new).collect(ImmutableList.toImmutableList());
        return QualifiedName.of((Iterable)parts);
    }

    @Deprecated
    private static void assertStatement(@Language(value="SQL") String query, Statement expected) {
        TestSqlParser.assertParsed(query, (Node)expected, (Node)SQL_PARSER.createStatement(query));
        TreeAssertions.assertFormattedSql((SqlParser)SQL_PARSER, (Node)expected);
    }

    private static void assertParsed(String input, Node expected, Node parsed) {
        if (!parsed.equals((Object)expected)) {
            Assertions.fail((String)"expected\n\n%s\n\nto parse as\n\n%s\n\nbut was\n\n%s\n".formatted(TestSqlParser.indent(input), TestSqlParser.indent(SqlFormatter.formatSql((Node)expected)), TestSqlParser.indent(SqlFormatter.formatSql((Node)parsed))));
        }
    }

    private static void assertInvalidExpression(String expression, String expectedErrorMessageRegex) {
        ParserAssert.assertExpressionIsInvalid(expression).withMessageMatching("line \\d+:\\d+: " + expectedErrorMessageRegex);
    }

    private static String indent(String value) {
        String indent = "    ";
        return indent + value.trim().replaceAll("\n", "\n" + indent);
    }

    private static Expression createExpression(String expression) {
        return SQL_PARSER.createExpression(expression);
    }
}

