/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.collect.ImmutableList;
import io.trino.sql.parser.ParserAssert;
import io.trino.sql.parser.TreeNodes;
import io.trino.sql.tree.CreateFunction;
import io.trino.sql.tree.DeterministicCharacteristic;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.LanguageCharacteristic;
import io.trino.sql.tree.ParameterDeclaration;
import io.trino.sql.tree.PropertiesCharacteristic;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.ReturnsClause;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSqlParserFunctions {
    @Test
    public void testLanguageEngineFunction() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.statement("CREATE FUNCTION hello(s varchar)\nRETURNS varchar\nLANGUAGE PYTHON\nDETERMINISTIC\nWITH (handler = 'hello')\nAS $$\ndef hello(s):\n    return 'Hello, ' + s + '!'\n$$\n")))).isEqualTo(new CreateFunction(TreeNodes.location(1, 1), new FunctionSpecification(TreeNodes.location(1, 8), TreeNodes.qualifiedName(TreeNodes.location(1, 17), "hello"), (List)ImmutableList.of((Object)new ParameterDeclaration(TreeNodes.location(1, 23), Optional.of(TreeNodes.identifier(TreeNodes.location(1, 23), "s")), TreeNodes.simpleType(TreeNodes.location(1, 25), "varchar"))), new ReturnsClause(TreeNodes.location(2, 1), TreeNodes.simpleType(TreeNodes.location(2, 9), "varchar")), (List)ImmutableList.of((Object)new LanguageCharacteristic(TreeNodes.location(3, 1), TreeNodes.identifier(TreeNodes.location(3, 10), "PYTHON")), (Object)new DeterministicCharacteristic(TreeNodes.location(4, 1), true), (Object)new PropertiesCharacteristic(TreeNodes.location(5, 1), (List)ImmutableList.of((Object)new Property(TreeNodes.location(5, 7), TreeNodes.identifier(TreeNodes.location(5, 7), "handler"), (Expression)new StringLiteral(TreeNodes.location(5, 17), "hello"))))), Optional.empty(), Optional.of(new StringLiteral(TreeNodes.location(6, 4), "def hello(s):\n    return 'Hello, ' + s + '!'\n"))), false));
    }

    @Test
    public void testDefinitionWithoutNewline() {
        ParserAssert.assertStatementIsInvalid("CREATE FUNCTION hello(s varchar)\nRETURNS varchar\nLANGUAGE TEST\nDETERMINISTIC\nAS $$ what $$\n").withMessage("line 5:4: Function definition must start with a newline after opening quotes");
    }
}

