/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.io.Resources;
import io.trino.sql.SqlFormatter;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.testing.TreeAssertions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Statement;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatementBuilder {
    private static final SqlParser SQL_PARSER = new SqlParser();

    @Test
    public void testStatementBuilder() {
        TestStatementBuilder.printStatement("select * from foo");
        TestStatementBuilder.printStatement("explain select * from foo");
        TestStatementBuilder.printStatement("explain (type distributed, format graphviz) select * from foo");
        TestStatementBuilder.printStatement("select * from foo /* end */");
        TestStatementBuilder.printStatement("/* start */ select * from foo");
        TestStatementBuilder.printStatement("/* start */ select * /* middle */ from foo /* end */");
        TestStatementBuilder.printStatement("-- start\nselect * -- junk\n-- hi\nfrom foo -- done");
        TestStatementBuilder.printStatement("select * from foo a (x, y, z)");
        TestStatementBuilder.printStatement("select *, 123, * from foo");
        TestStatementBuilder.printStatement("select show from foo");
        TestStatementBuilder.printStatement("select extract(day from x), extract(dow from x) from y");
        TestStatementBuilder.printStatement("select 1 + 13 || '15' from foo");
        TestStatementBuilder.printStatement("select x is distinct from y from foo where a is not distinct from b");
        TestStatementBuilder.printStatement("select x[1] from my_table");
        TestStatementBuilder.printStatement("select x[1][2] from my_table");
        TestStatementBuilder.printStatement("select x[cast(10 * sin(x) as bigint)] from my_table");
        TestStatementBuilder.printStatement("select * from (select * from (select * from t) x) y");
        TestStatementBuilder.printStatement("select * from (select * from (table t) x) y");
        TestStatementBuilder.printStatement("select * from t x tablesample system (10)");
        TestStatementBuilder.printStatement("select * from (t x tablesample system (10)) y");
        TestStatementBuilder.printStatement("select * from (t tablesample system (10)) tablesample system (10)");
        TestStatementBuilder.printStatement("select * from (t x tablesample system (10)) y tablesample system (10)");
        TestStatementBuilder.printStatement("select * from (((select q)))");
        TestStatementBuilder.printStatement("select * from (select q) x");
        TestStatementBuilder.printStatement("select * from ((select q) x) y");
        TestStatementBuilder.printStatement("select * from (((select q) x) y) z");
        TestStatementBuilder.printStatement("select * from unnest(t.my_array)");
        TestStatementBuilder.printStatement("select * from unnest(array[1, 2, 3])");
        TestStatementBuilder.printStatement("select x from unnest(array[1, 2, 3]) t(x)");
        TestStatementBuilder.printStatement("select * from users cross join unnest(friends)");
        TestStatementBuilder.printStatement("select id, friend from users cross join unnest(friends) t(friend)");
        TestStatementBuilder.printStatement("select * from unnest(t.my_array) with ordinality");
        TestStatementBuilder.printStatement("select * from unnest(array[1, 2, 3]) with ordinality");
        TestStatementBuilder.printStatement("select x from unnest(array[1, 2, 3]) with ordinality t(x)");
        TestStatementBuilder.printStatement("select * from users cross join unnest(friends) with ordinality");
        TestStatementBuilder.printStatement("select id, friend from users cross join unnest(friends) with ordinality t(friend)");
        TestStatementBuilder.printStatement("select count(*) x from src group by k, v");
        TestStatementBuilder.printStatement("select count(*) x from src group by cube (k, v)");
        TestStatementBuilder.printStatement("select count(*) x from src group by rollup (k, v)");
        TestStatementBuilder.printStatement("select count(*) x from src group by grouping sets ((k, v))");
        TestStatementBuilder.printStatement("select count(*) x from src group by grouping sets ((k, v), (v))");
        TestStatementBuilder.printStatement("select count(*) x from src group by grouping sets (k, v, k)");
        TestStatementBuilder.printStatement("select count(*) filter (where x > 4) y from t");
        TestStatementBuilder.printStatement("select sum(x) filter (where x > 4) y from t");
        TestStatementBuilder.printStatement("select sum(x) filter (where x > 4) y, sum(x) filter (where x < 2) z from t");
        TestStatementBuilder.printStatement("select sum(distinct x) filter (where x > 4) y, sum(x) filter (where x < 2) z from t");
        TestStatementBuilder.printStatement("select sum(x) filter (where x > 4) over (partition by y) z from t");
        TestStatementBuilder.printStatement("select depname, empno, salary\n, count(*) over ()\n, avg(salary) over (partition by depname)\n, rank() over (partition by depname order by salary desc)\n, sum(salary) over (order by salary rows unbounded preceding)\n, sum(salary) over (partition by depname order by salary rows between current row and 3 following)\n, sum(salary) over (partition by depname order by salary rows between current row and empno following)\n, sum(salary) over (partition by depname range unbounded preceding)\n, sum(salary) over (rows between 2 preceding and unbounded following)\nfrom emp");
        TestStatementBuilder.printStatement("with a (id) as (with x as (select 123 from z) select * from x)    , b (id) as (select 999 from z) select * from a join b using (id)");
        TestStatementBuilder.printStatement("with recursive t as (select * from x) select * from t");
        TestStatementBuilder.printStatement("select * from information_schema.tables");
        TestStatementBuilder.printStatement("show catalogs");
        TestStatementBuilder.printStatement("show schemas");
        TestStatementBuilder.printStatement("show schemas from sys");
        TestStatementBuilder.printStatement("show tables");
        TestStatementBuilder.printStatement("show tables from information_schema");
        TestStatementBuilder.printStatement("show tables like '%'");
        TestStatementBuilder.printStatement("show tables from information_schema like '%'");
        TestStatementBuilder.printStatement("show functions");
        TestStatementBuilder.printStatement("select cast('123' as bigint), try_cast('foo' as bigint)");
        TestStatementBuilder.printStatement("select * from a.b.c");
        TestStatementBuilder.printStatement("select * from a.b.c.e.f.g");
        TestStatementBuilder.printStatement("select \"TOTALPRICE\" \"my price\" from \"$MY\"\"ORDERS\"");
        TestStatementBuilder.printStatement("select * from foo tablesample system (10+1)");
        TestStatementBuilder.printStatement("select * from foo tablesample system (10) join bar tablesample bernoulli (30) on a.id = b.id");
        TestStatementBuilder.printStatement("select * from foo tablesample system (10) join bar tablesample bernoulli (30) on not(a.id > b.id)");
        TestStatementBuilder.printStatement("create table foo as (select * from abc)");
        TestStatementBuilder.printStatement("create table if not exists foo as (select * from abc)");
        TestStatementBuilder.printStatement("create table foo with (a = 'apple', b = 'banana') as select * from abc");
        TestStatementBuilder.printStatement("create table foo comment 'test' with (a = 'apple') as select * from abc");
        TestStatementBuilder.printStatement("create table foo as select * from abc WITH NO DATA");
        TestStatementBuilder.printStatement("create table foo as (with t(x) as (values 1) select x from t)");
        TestStatementBuilder.printStatement("create table if not exists foo as (with t(x) as (values 1) select x from t)");
        TestStatementBuilder.printStatement("create table foo as (with t(x) as (values 1) select x from t) WITH DATA");
        TestStatementBuilder.printStatement("create table if not exists foo as (with t(x) as (values 1) select x from t) WITH DATA");
        TestStatementBuilder.printStatement("create table foo as (with t(x) as (values 1) select x from t) WITH NO DATA");
        TestStatementBuilder.printStatement("create table if not exists foo as (with t(x) as (values 1) select x from t) WITH NO DATA");
        TestStatementBuilder.printStatement("create table foo(a) as (with t(x) as (values 1) select x from t)");
        TestStatementBuilder.printStatement("create table if not exists foo(a) as (with t(x) as (values 1) select x from t)");
        TestStatementBuilder.printStatement("create table foo(a) as (with t(x) as (values 1) select x from t) WITH DATA");
        TestStatementBuilder.printStatement("create table if not exists foo(a) as (with t(x) as (values 1) select x from t) WITH DATA");
        TestStatementBuilder.printStatement("create table foo(a) as (with t(x) as (values 1) select x from t) WITH NO DATA");
        TestStatementBuilder.printStatement("create table if not exists foo(a) as (with t(x) as (values 1) select x from t) WITH NO DATA");
        TestStatementBuilder.printStatement("drop table foo");
        TestStatementBuilder.printStatement("insert into foo select * from abc");
        TestStatementBuilder.printStatement("delete from foo");
        TestStatementBuilder.printStatement("delete from foo where a = b");
        TestStatementBuilder.printStatement("truncate table foo");
        TestStatementBuilder.printStatement("values ('a', 1, 2.2), ('b', 2, 3.3)");
        TestStatementBuilder.printStatement("table foo");
        TestStatementBuilder.printStatement("table foo order by x limit 10");
        TestStatementBuilder.printStatement("(table foo)");
        TestStatementBuilder.printStatement("(table foo) limit 10");
        TestStatementBuilder.printStatement("(table foo limit 5) limit 10");
        TestStatementBuilder.printStatement("select * from a limit all");
        TestStatementBuilder.printStatement("select * from a order by x limit all");
        TestStatementBuilder.printStatement("select * from a union select * from b");
        TestStatementBuilder.printStatement("table a union all table b");
        TestStatementBuilder.printStatement("(table foo) union select * from foo union (table foo order by x)");
        TestStatementBuilder.printStatement("table a union table b intersect table c");
        TestStatementBuilder.printStatement("(table a union table b) intersect table c");
        TestStatementBuilder.printStatement("table a union table b except table c intersect table d");
        TestStatementBuilder.printStatement("(table a union table b except table c) intersect table d");
        TestStatementBuilder.printStatement("((table a union table b) except table c) intersect table d");
        TestStatementBuilder.printStatement("(table a union (table b except table c)) intersect table d");
        TestStatementBuilder.printStatement("table a intersect table b union table c");
        TestStatementBuilder.printStatement("table a intersect (table b union table c)");
        TestStatementBuilder.printStatement("alter table foo rename to bar");
        TestStatementBuilder.printStatement("alter table a.b.c rename to d.e.f");
        TestStatementBuilder.printStatement("alter table a.b.c rename column x to y");
        TestStatementBuilder.printStatement("alter table foo set properties a='1'");
        TestStatementBuilder.printStatement("alter table a.b.c set properties a=true, b=123, c='x'");
        TestStatementBuilder.printStatement("alter table a.b.c set properties a=DEFAULT, b=123");
        TestStatementBuilder.printStatement("alter table a.b.c add column x bigint first");
        TestStatementBuilder.printStatement("alter table a.b.c add column x bigint after y");
        TestStatementBuilder.printStatement("alter table a.b.c add column x bigint last");
        TestStatementBuilder.printStatement("alter table a.b.c add column x bigint");
        TestStatementBuilder.printStatement("alter table a.b.c add column x bigint comment 'large x'");
        TestStatementBuilder.printStatement("alter table a.b.c add column x bigint with (weight = 2)");
        TestStatementBuilder.printStatement("alter table a.b.c add column x bigint comment 'xtra' with (compression = 'LZ4', special = true)");
        TestStatementBuilder.printStatement("alter table a.b.c drop column x");
        TestStatementBuilder.printStatement("alter table foo alter column x set data type bigint");
        TestStatementBuilder.printStatement("alter table a.b.c alter column x set data type bigint");
        TestStatementBuilder.printStatement("alter table foo alter column x drop not null");
        TestStatementBuilder.printStatement("alter table a.b.c alter column x drop not null");
        TestStatementBuilder.printStatement("alter materialized view foo set properties a='1'");
        TestStatementBuilder.printStatement("alter materialized view a.b.c set properties a=true, b=123, c='x'");
        TestStatementBuilder.printStatement("alter materialized view a.b.c set properties a=default, b=123");
        TestStatementBuilder.printStatement("create schema test");
        TestStatementBuilder.printStatement("create schema test authorization alice");
        TestStatementBuilder.printStatement("create schema test authorization alice with ( location = 'xyz' )");
        TestStatementBuilder.printStatement("create schema test authorization user alice");
        TestStatementBuilder.printStatement("create schema test authorization user alice with ( location = 'xyz' )");
        TestStatementBuilder.printStatement("create schema test authorization role public");
        TestStatementBuilder.printStatement("create schema test authorization role public with ( location = 'xyz' )");
        TestStatementBuilder.printStatement("create schema if not exists test");
        TestStatementBuilder.printStatement("create schema test with (a = 'apple', b = 123)");
        TestStatementBuilder.printStatement("drop schema test");
        TestStatementBuilder.printStatement("drop schema test cascade");
        TestStatementBuilder.printStatement("drop schema if exists test");
        TestStatementBuilder.printStatement("drop schema if exists test restrict");
        TestStatementBuilder.printStatement("alter schema foo rename to bar");
        TestStatementBuilder.printStatement("alter schema foo.bar rename to baz");
        TestStatementBuilder.printStatement("alter schema foo set authorization alice");
        TestStatementBuilder.printStatement("alter schema foo.bar set authorization USER alice");
        TestStatementBuilder.printStatement("alter schema foo.bar set authorization ROLE public");
        TestStatementBuilder.printStatement("create table test (a boolean, b bigint, c double, d varchar, e timestamp)");
        TestStatementBuilder.printStatement("create table test (a boolean, b bigint comment 'test')");
        TestStatementBuilder.printStatement("create table if not exists baz (a timestamp, b varchar)");
        TestStatementBuilder.printStatement("create table test (a boolean, b bigint) with (a = 'apple', b = 'banana')");
        TestStatementBuilder.printStatement("create table test (a boolean, b bigint) comment 'test' with (a = 'apple')");
        TestStatementBuilder.printStatement("create table test (a boolean with (a = 'apple', b = 'banana'), b bigint comment 'bla' with (c = 'cherry')) comment 'test' with (a = 'apple')");
        TestStatementBuilder.printStatement("comment on table test is 'test'");
        TestStatementBuilder.printStatement("comment on view test is 'test'");
        TestStatementBuilder.printStatement("comment on column test.a is 'test'");
        TestStatementBuilder.printStatement("drop table test");
        TestStatementBuilder.printStatement("alter table foo set authorization alice");
        TestStatementBuilder.printStatement("alter table foo.bar set authorization USER alice");
        TestStatementBuilder.printStatement("alter table foo.bar.baz set authorization ROLE public");
        TestStatementBuilder.printStatement("create view foo as with a as (select 123) select * from a");
        TestStatementBuilder.printStatement("create or replace view foo as select 123 from t");
        TestStatementBuilder.printStatement("drop view foo");
        TestStatementBuilder.printStatement("alter view foo set authorization alice");
        TestStatementBuilder.printStatement("alter view foo.bar set authorization USER alice");
        TestStatementBuilder.printStatement("alter view foo.bar.baz set authorization ROLE public");
        TestStatementBuilder.printStatement("insert into t select * from t");
        TestStatementBuilder.printStatement("insert into t (c1, c2) select * from t");
        TestStatementBuilder.printStatement("start transaction");
        TestStatementBuilder.printStatement("start transaction isolation level read uncommitted");
        TestStatementBuilder.printStatement("start transaction isolation level read committed");
        TestStatementBuilder.printStatement("start transaction isolation level repeatable read");
        TestStatementBuilder.printStatement("start transaction isolation level serializable");
        TestStatementBuilder.printStatement("start transaction read only");
        TestStatementBuilder.printStatement("start transaction read write");
        TestStatementBuilder.printStatement("start transaction isolation level read committed, read only");
        TestStatementBuilder.printStatement("start transaction read only, isolation level read committed");
        TestStatementBuilder.printStatement("start transaction read write, isolation level serializable");
        TestStatementBuilder.printStatement("commit");
        TestStatementBuilder.printStatement("commit work");
        TestStatementBuilder.printStatement("rollback");
        TestStatementBuilder.printStatement("rollback work");
        TestStatementBuilder.printStatement("call foo()");
        TestStatementBuilder.printStatement("call foo(123, a => 1, b => 'go', 456)");
        TestStatementBuilder.printStatement("grant select on foo to alice with grant option");
        TestStatementBuilder.printStatement("grant all privileges on foo to alice");
        TestStatementBuilder.printStatement("grant delete, select on foo to role public");
        TestStatementBuilder.printStatement("deny select on foo to alice");
        TestStatementBuilder.printStatement("deny all privileges on foo to alice");
        TestStatementBuilder.printStatement("deny delete, select on foo to role public");
        TestStatementBuilder.printStatement("deny select on schema foo to alice");
        TestStatementBuilder.printStatement("deny all privileges on schema foo to alice");
        TestStatementBuilder.printStatement("deny delete, select on schema foo to role public");
        TestStatementBuilder.printStatement("revoke grant option for select on foo from alice");
        TestStatementBuilder.printStatement("revoke all privileges on foo from alice");
        TestStatementBuilder.printStatement("revoke insert, delete on foo from role public");
        TestStatementBuilder.printStatement("show grants on table t");
        TestStatementBuilder.printStatement("show grants on t");
        TestStatementBuilder.printStatement("show grants");
        TestStatementBuilder.printStatement("show roles");
        TestStatementBuilder.printStatement("show roles from foo");
        TestStatementBuilder.printStatement("show current roles");
        TestStatementBuilder.printStatement("show current roles from foo");
        TestStatementBuilder.printStatement("show role grants");
        TestStatementBuilder.printStatement("show role grants from foo");
        TestStatementBuilder.printStatement("show create schema abc");
        TestStatementBuilder.printStatement("show create table abc");
        TestStatementBuilder.printStatement("show create view abc");
        TestStatementBuilder.printStatement("show create materialized view abc");
        TestStatementBuilder.printStatement("show create function abc");
        TestStatementBuilder.printStatement("prepare p from select * from (select * from T) \"A B\"");
        TestStatementBuilder.printStatement("prepare p from grant select on table hive.test.\"case\" to role test");
        TestStatementBuilder.printStatement("prepare p from grant select on hive.test.\"case\" to role test");
        TestStatementBuilder.printStatement("prepare p from grant select on table hive.test.\"case\" to role \"case\"");
        TestStatementBuilder.printStatement("SELECT * FROM table1 WHERE a >= ALL (VALUES 2, 3, 4)");
        TestStatementBuilder.printStatement("SELECT * FROM table1 WHERE a <> ANY (SELECT 2, 3, 4)");
        TestStatementBuilder.printStatement("SELECT * FROM table1 WHERE a = SOME (SELECT id FROM table2)");
        TestStatementBuilder.printStatement("merge into inventory as i\nusing changes as c\non i.part = c.part\nwhen matched and c.action = 'mod' then\nupdate set qty = qty + c.qty\nwhen matched and c.action = 'del' then delete\nwhen not matched and c.action = 'new' then\ninsert (part, qty) values (c.part, c.qty)");
        TestStatementBuilder.printStatement("set session authorization user");
        TestStatementBuilder.printStatement("reset session authorization");
    }

    @Test
    public void testStringFormatter() {
        TestStatementBuilder.assertSqlFormatter("U&'hello\\6d4B\\8Bd5\\+10FFFFworld\\7F16\\7801'", "'hello\u6d4b\u8bd5\udbff\udfffworld\u7f16\u7801'");
        TestStatementBuilder.assertSqlFormatter("'hello world'", "'hello world'");
        TestStatementBuilder.assertSqlFormatter("U&'!+10FFFF!6d4B!8Bd5ABC!6d4B!8Bd5' UESCAPE '!'", "'\udbff\udfff\u6d4b\u8bd5ABC\u6d4b\u8bd5'");
        TestStatementBuilder.assertSqlFormatter("U&'\\+10FFFF\\6D4B\\8BD5\\0041\\0042\\0043\\6D4B\\8BD5'", "'\udbff\udfff\u6d4b\u8bd5ABC\u6d4b\u8bd5'");
        TestStatementBuilder.assertSqlFormatter("U&'\\\\abc\\6D4B'''", "'\\abc\u6d4b'''");
    }

    @Test
    public void testStatementBuilderTpch() {
        TestStatementBuilder.printTpchQuery(1, 3);
        TestStatementBuilder.printTpchQuery(2, 33, "part type like", "region name");
        TestStatementBuilder.printTpchQuery(3, "market segment", "2013-03-05");
        TestStatementBuilder.printTpchQuery(4, "2013-03-05");
        TestStatementBuilder.printTpchQuery(5, "region name", "2013-03-05");
        TestStatementBuilder.printTpchQuery(6, "2013-03-05", 33, 44);
        TestStatementBuilder.printTpchQuery(7, "nation name 1", "nation name 2");
        TestStatementBuilder.printTpchQuery(8, "nation name", "region name", "part type");
        TestStatementBuilder.printTpchQuery(9, "part name like");
        TestStatementBuilder.printTpchQuery(10, "2013-03-05");
        TestStatementBuilder.printTpchQuery(11, "nation name", 33);
        TestStatementBuilder.printTpchQuery(12, "ship mode 1", "ship mode 2", "2013-03-05");
        TestStatementBuilder.printTpchQuery(13, "comment like 1", "comment like 2");
        TestStatementBuilder.printTpchQuery(14, "2013-03-05");
        TestStatementBuilder.printTpchQuery(16, "part brand", "part type like", 3, 4, 5, 6, 7, 8, 9, 10);
        TestStatementBuilder.printTpchQuery(17, "part brand", "part container");
        TestStatementBuilder.printTpchQuery(18, 33);
        TestStatementBuilder.printTpchQuery(19, "part brand 1", "part brand 2", "part brand 3", 11, 22, 33);
        TestStatementBuilder.printTpchQuery(20, "part name like", "2013-03-05", "nation name");
        TestStatementBuilder.printTpchQuery(21, "nation name");
        TestStatementBuilder.printTpchQuery(22, "phone 1", "phone 2", "phone 3", "phone 4", "phone 5", "phone 6", "phone 7");
    }

    private static void printStatement(String sql) {
        TestStatementBuilder.println(sql.trim());
        TestStatementBuilder.println("");
        Statement statement = SQL_PARSER.createStatement(sql);
        TestStatementBuilder.println(statement.toString());
        TestStatementBuilder.println("");
        TestStatementBuilder.println(SqlFormatter.formatSql((Node)statement));
        TestStatementBuilder.println("");
        TreeAssertions.assertFormattedSql((SqlParser)SQL_PARSER, (Node)statement);
        TestStatementBuilder.println("=".repeat(60));
        TestStatementBuilder.println("");
    }

    private static void assertSqlFormatter(String expression, String formatted) {
        Expression originalExpression = SQL_PARSER.createExpression(expression);
        String real = SqlFormatter.formatSql((Node)originalExpression);
        Assertions.assertThat((String)real).isEqualTo(formatted);
    }

    private static void println(String s) {
        if (Boolean.parseBoolean(System.getProperty("printParse"))) {
            System.out.println(s);
        }
    }

    private static String getTpchQuery(int q) {
        return TestStatementBuilder.readResource("tpch/queries/" + q + ".sql");
    }

    private static void printTpchQuery(int query, Object ... values) {
        String sql = TestStatementBuilder.getTpchQuery(query);
        for (int i = values.length - 1; i >= 0; --i) {
            sql = sql.replaceAll(":%s".formatted(i + 1), String.valueOf(values[i]));
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)sql.matches("(?s).*:[0-9].*")).as("Not all bind parameters were replaced: " + sql, new Object[0])).isFalse();
        sql = TestStatementBuilder.fixTpchQuery(sql);
        TestStatementBuilder.printStatement(sql);
    }

    private static String readResource(String name) {
        try {
            return Resources.toString((URL)Resources.getResource((String)name), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String fixTpchQuery(String s) {
        s = s.replaceFirst("(?m);$", "");
        s = s.replaceAll("(?m)^:[xo]$", "");
        s = s.replaceAll("(?m)^:n -1$", "");
        s = s.replaceAll("(?m)^:n ([0-9]+)$", "LIMIT $1");
        s = s.replace("day (3)", "day");
        return s;
    }
}

