/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import io.trino.sql.parser.ParserAssert;
import io.trino.sql.parser.TreeNodes;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DataTypeParameter;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.IntervalDayTimeDataType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTypeParser {
    @Test
    public void testCaseVariants() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("varchar")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "varchar"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("VARCHAR")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "VARCHAR"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("Varchar")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "Varchar"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY(bigint)")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 7), "bigint"))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("Array(Bigint)")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "Array"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 7), "Bigint"))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("array(bigint)")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "array"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 7), "bigint"))}));
    }

    @Test
    public void testDoublePrecisionVariants() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("DOUBLE PRECISION")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "DOUBLE"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("DOUBLE     PRECISION")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "DOUBLE"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("double precision")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "double"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ROW(DOUBLE PRECISION)")))).isEqualTo(TreeNodes.rowType(TreeNodes.location(1, 1), TreeNodes.field(TreeNodes.location(1, 5), TreeNodes.simpleType(TreeNodes.location(1, 5), "DOUBLE"))));
    }

    @Test
    public void testSimpleTypes() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("VARCHAR")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "VARCHAR"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("BIGINT")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "BIGINT"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("DOUBLE")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "DOUBLE"));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("BOOLEAN")))).isEqualTo(TreeNodes.simpleType(TreeNodes.location(1, 1), "BOOLEAN"));
    }

    @Test
    public void testDayTimeTypes() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP WITHOUT TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP WITH TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP(3)")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.location(1, 11), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP(3) WITHOUT TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.location(1, 11), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP(3) WITH TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, true, (DataTypeParameter)TreeNodes.parameter(TreeNodes.location(1, 11), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP(p)")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 11), "p"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP(p) WITHOUT TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 11), "p"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIMESTAMP(p) WITH TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIMESTAMP, true, (DataTypeParameter)TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 11), "p"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME WITHOUT TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, false));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME WITH TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, true));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME(3)")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.location(1, 6), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME(3) WITHOUT TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.location(1, 6), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME(3) WITH TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, true, (DataTypeParameter)TreeNodes.parameter(TreeNodes.location(1, 6), "3")));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME(p)")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 6), "p"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME(p) WITHOUT TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, false, (DataTypeParameter)TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 6), "p"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("TIME(p) WITH TIME ZONE")))).isEqualTo(TreeNodes.dateTimeType(TreeNodes.location(1, 1), DateTimeDataType.Type.TIME, true, (DataTypeParameter)TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 6), "p"))));
    }

    @Test
    public void testIntervalTypes() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("INTERVAL YEAR TO DAY")))).isEqualTo(TreeNodes.intervalType(TreeNodes.location(1, 1), IntervalDayTimeDataType.Field.YEAR, IntervalDayTimeDataType.Field.DAY));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("INTERVAL YEAR TO MONTH")))).isEqualTo(TreeNodes.intervalType(TreeNodes.location(1, 1), IntervalDayTimeDataType.Field.YEAR, IntervalDayTimeDataType.Field.MONTH));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("INTERVAL SECOND")))).isEqualTo(TreeNodes.intervalType(TreeNodes.location(1, 1), IntervalDayTimeDataType.Field.SECOND, IntervalDayTimeDataType.Field.SECOND));
    }

    @Test
    public void testParametricTypes() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY(TINYINT)")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 7), "TINYINT"))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY ( TINYINT ) ")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 9), "TINYINT"))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("MAP(BIGINT, SMALLINT)")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), "MAP", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 5), "BIGINT")), TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 13), "SMALLINT"))}));
    }

    @Test
    public void testArray() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("foo(42, 55) ARRAY")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 13), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 1), "foo", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.location(1, 5), "42"), TreeNodes.parameter(TreeNodes.location(1, 9), "55")}))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("VARCHAR(7) ARRAY")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 12), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "VARCHAR"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.location(1, 9), "7")}))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("VARCHAR(7) ARRAY array")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 18), "array"), new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 12), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "VARCHAR"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.location(1, 9), "7")}))}))}));
    }

    @Test
    public void testRowType() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ROW(a BIGINT, b VARCHAR)")))).isEqualTo(TreeNodes.rowType(TreeNodes.location(1, 1), TreeNodes.field(TreeNodes.location(1, 5), "a", TreeNodes.simpleType(TreeNodes.location(1, 7), "BIGINT")), TreeNodes.field(TreeNodes.location(1, 15), "b", TreeNodes.simpleType(TreeNodes.location(1, 17), "VARCHAR"))));
        ((ParserAssert)((Object)((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ROW(a BIGINT,b VARCHAR)")))).describedAs("No space after comma", new Object[0]))).isEqualTo(TreeNodes.rowType(TreeNodes.location(1, 1), TreeNodes.field(TreeNodes.location(1, 5), "a", TreeNodes.simpleType(TreeNodes.location(1, 7), "BIGINT")), TreeNodes.field(TreeNodes.location(1, 14), "b", TreeNodes.simpleType(TreeNodes.location(1, 16), "VARCHAR"))));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ROW(\"a\" BIGINT, \"b\" VARCHAR)")))).isEqualTo(TreeNodes.rowType(TreeNodes.location(1, 1), TreeNodes.field(TreeNodes.location(1, 5), "a", true, TreeNodes.simpleType(TreeNodes.location(1, 9), "BIGINT")), TreeNodes.field(TreeNodes.location(1, 17), "b", true, TreeNodes.simpleType(TreeNodes.location(1, 21), "VARCHAR"))));
    }

    @Test
    public void testComplexTypes() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ROW(x BIGINT, y DOUBLE PRECISION, z ROW(m array<bigint>,n map<double,varchar>))")))).isEqualTo(TreeNodes.rowType(TreeNodes.location(1, 1), TreeNodes.field(TreeNodes.location(1, 5), "x", TreeNodes.simpleType(TreeNodes.location(1, 7), "BIGINT")), TreeNodes.field(TreeNodes.location(1, 15), "y", TreeNodes.simpleType(TreeNodes.location(1, 17), "DOUBLE")), TreeNodes.field(TreeNodes.location(1, 35), "z", (DataType)TreeNodes.rowType(TreeNodes.location(1, 37), TreeNodes.field(TreeNodes.location(1, 41), "m", (DataType)TreeNodes.parametricType(TreeNodes.location(1, 43), "array", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 49), "bigint"))})), TreeNodes.field(TreeNodes.location(1, 57), "n", (DataType)TreeNodes.parametricType(TreeNodes.location(1, 59), "map", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 63), "double")), TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 70), "varchar"))}))))));
    }

    @Test
    public void testLegacyTypes() {
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY<BIGINT>")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 7), "BIGINT"))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY < BIGINT > ")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 1), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 9), "BIGINT"))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY<ARRAY<BIGINT>>")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), "ARRAY", new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 7), "ARRAY", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 13), "BIGINT"))}))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY<array<varchar(42)>>")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), "ARRAY", new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 7), "array", new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 13), "varchar", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.location(1, 21), "42")}))}))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("ARRAY<varchar(42)>")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), "ARRAY", new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 7), "varchar", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.location(1, 15), "42")}))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("MAP<BIGINT, VARCHAR>")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), "MAP", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 5), "BIGINT")), TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 13), "VARCHAR"))}));
        ((ParserAssert)((Object)Assertions.assertThat(ParserAssert.type("MAP<BIGINT, VARCHAR> ARRAY")))).isEqualTo(TreeNodes.parametricType(TreeNodes.location(1, 1), TreeNodes.identifier(TreeNodes.location(1, 22), "ARRAY"), new DataTypeParameter[]{TreeNodes.parameter((DataType)TreeNodes.parametricType(TreeNodes.location(1, 1), "MAP", new DataTypeParameter[]{TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 5), "BIGINT")), TreeNodes.parameter(TreeNodes.simpleType(TreeNodes.location(1, 13), "VARCHAR"))}))}));
    }
}

