/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableMap;
import io.trino.type.TypeCalculation;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTypeCalculation {
    @Test
    public void testBasicUsage() {
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"42", (Map)ImmutableMap.of())).isEqualTo((Object)42L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"NULL", (Map)ImmutableMap.of())).isEqualTo((Object)0L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"null", (Map)ImmutableMap.of())).isEqualTo((Object)0L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"x", (Map)ImmutableMap.of((Object)"x", (Object)42L))).isEqualTo((Object)42L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"(42)", (Map)ImmutableMap.of())).isEqualTo((Object)42L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"(NULL)", (Map)ImmutableMap.of())).isEqualTo((Object)0L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"(x)", (Map)ImmutableMap.of((Object)"x", (Object)42L))).isEqualTo((Object)42L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"42 + 55", (Map)ImmutableMap.of())).isEqualTo((Object)97L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"42 - 55", (Map)ImmutableMap.of())).isEqualTo((Object)-13L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"42 * 55", (Map)ImmutableMap.of())).isEqualTo((Object)2310L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"42 / 6", (Map)ImmutableMap.of())).isEqualTo((Object)7L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"42 + 55 * 6", (Map)ImmutableMap.of())).isEqualTo((Object)372L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"(42 + 55) * 6", (Map)ImmutableMap.of())).isEqualTo((Object)582L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"min(10,2)", (Map)ImmutableMap.of())).isEqualTo((Object)2L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"min(10,2*10)", (Map)ImmutableMap.of())).isEqualTo((Object)10L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"max(10,2*10)", (Map)ImmutableMap.of())).isEqualTo((Object)20L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"max(10,2)", (Map)ImmutableMap.of())).isEqualTo((Object)10L);
        Assertions.assertThat((Long)TypeCalculation.calculateLiteralValue((String)"x + y", (Map)ImmutableMap.of((Object)"x", (Object)42L, (Object)"y", (Object)55L))).isEqualTo((Object)97L);
    }
}

