/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.ColumnPosition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AddColumn
extends Statement {
    private final QualifiedName name;
    private final ColumnDefinition column;
    private final Optional<ColumnPosition> position;
    private final boolean tableExists;
    private final boolean columnNotExists;

    public AddColumn(NodeLocation location, QualifiedName name, ColumnDefinition column, Optional<ColumnPosition> position, boolean tableExists, boolean columnNotExists) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.column = Objects.requireNonNull(column, "column is null");
        this.position = Objects.requireNonNull(position, "position is null");
        this.tableExists = tableExists;
        this.columnNotExists = columnNotExists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public ColumnDefinition getColumn() {
        return this.column;
    }

    public Optional<ColumnPosition> getPosition() {
        return this.position;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isColumnNotExists() {
        return this.columnNotExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddColumn(this, context);
    }

    public List<Node> getChildren() {
        ColumnPosition columnPosition;
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.column);
        if (this.position.isPresent() && (columnPosition = this.position.get()) instanceof ColumnPosition.After) {
            ColumnPosition.After after = (ColumnPosition.After)columnPosition;
            nodes.add((Object)after.column());
        }
        return nodes.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.column, this.position);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddColumn o = (AddColumn)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.column, o.column) && Objects.equals(this.position, o.position);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("column", (Object)this.column).add("position", this.position).toString();
    }
}

