/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.password.file;

import com.google.common.base.Splitter;
import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import io.trino.plugin.password.file.FileGroupConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.security.GroupProvider;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public class FileGroupProvider
implements GroupProvider {
    private static final Splitter LINE_SPLITTER = Splitter.on((String)":").limit(2).trimResults();
    private static final Splitter GROUP_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final Supplier<Function<String, Set<String>>> userGroupSupplier;

    @Inject
    public FileGroupProvider(FileGroupConfig config) {
        File file = config.getGroupFile();
        this.userGroupSupplier = Suppliers.memoizeWithExpiration(() -> FileGroupProvider.loadGroupFile(file), (long)config.getRefreshPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public Set<String> getGroups(String user) {
        Objects.requireNonNull(user, "user is null");
        return this.userGroupSupplier.get().apply(user);
    }

    private static Function<String, Set<String>> loadGroupFile(File file) {
        Map<String, Set<String>> groups = FileGroupProvider.loadGroupFile(FileGroupProvider.readGroupFile(file));
        return user -> (Set)groups.getOrDefault(user, (Set<String>)ImmutableSet.of());
    }

    private static Map<String, Set<String>> loadGroupFile(List<String> lines) {
        HashMultimap userGroups = HashMultimap.create();
        for (int lineNumber = 1; lineNumber <= lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber - 1).trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            List parts = LINE_SPLITTER.splitToList((CharSequence)line);
            if (parts.size() != 2) {
                throw FileGroupProvider.invalidFile(lineNumber, "Expected two parts for group and users", null);
            }
            String group = (String)parts.get(0);
            GROUP_SPLITTER.splitToStream((CharSequence)parts.get(1)).forEach(arg_0 -> FileGroupProvider.lambda$loadGroupFile$2((Multimap)userGroups, group, arg_0));
        }
        return (Map)userGroups.asMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableSet.copyOf((Collection)((Collection)entry.getValue()))));
    }

    private static RuntimeException invalidFile(int lineNumber, String message, Throwable cause) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, String.format("Error in group file line %s: %s", lineNumber, message), cause);
    }

    private static List<String> readGroupFile(File file) {
        try {
            return Files.readAllLines(file.toPath());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_UNAVAILABLE, "Failed to read group file: " + file, (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$loadGroupFile$2(Multimap userGroups, String group, String user) {
        userGroups.put((Object)user, (Object)group);
    }
}

