/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.aggregation.AggregateFunctionPatterns;
import io.trino.plugin.base.aggregation.AggregateFunctionRule;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Optional;

public class ImplementCorr
implements AggregateFunctionRule<JdbcExpression> {
    private static final Capture<List<Variable>> ARGUMENTS = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"corr")).with(AggregateFunctionPatterns.arguments().matching(AggregateFunctionPatterns.variables().matching(AggregateFunctionPatterns.expressionTypes((Type[])new Type[]{RealType.REAL, RealType.REAL}).or(AggregateFunctionPatterns.expressionTypes((Type[])new Type[]{DoubleType.DOUBLE, DoubleType.DOUBLE}))).capturedAs(ARGUMENTS)));
    }

    public Optional<JdbcExpression> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        List arguments = (List)captures.get(ARGUMENTS);
        Verify.verify((arguments.size() == 2 ? 1 : 0) != 0);
        JdbcColumnHandle columnHandle1 = (JdbcColumnHandle)context.getAssignment(((Variable)arguments.get(0)).getName());
        JdbcColumnHandle columnHandle2 = (JdbcColumnHandle)context.getAssignment(((Variable)arguments.get(1)).getName());
        Verify.verify((boolean)aggregateFunction.getOutputType().equals(columnHandle1.getColumnType()));
        return Optional.of(new JdbcExpression(String.format("corr(%s, %s)", context.getIdentifierQuote().apply(columnHandle1.getColumnName()), context.getIdentifierQuote().apply(columnHandle2.getColumnName())), columnHandle1.getJdbcTypeHandle()));
    }
}

