/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.VarcharType;
import java.util.Optional;

public class RewriteLike
implements ConnectorExpressionRule<Call, String> {
    private static final Capture<ConnectorExpression> LIKE_VALUE = Capture.newCapture();
    private static final Capture<ConnectorExpression> LIKE_PATTERN = Capture.newCapture();
    private static final Pattern<Call> PATTERN = ConnectorExpressionPatterns.call().with(ConnectorExpressionPatterns.functionName().equalTo((Object)StandardFunctions.LIKE_PATTERN_FUNCTION_NAME)).with(ConnectorExpressionPatterns.type().equalTo((Object)BooleanType.BOOLEAN)).with(ConnectorExpressionPatterns.argumentCount().equalTo((Object)2)).with(ConnectorExpressionPatterns.argument((int)0).matching(ConnectorExpressionPatterns.expression().capturedAs(LIKE_VALUE).with(ConnectorExpressionPatterns.type().matching(VarcharType.class::isInstance)))).with(ConnectorExpressionPatterns.argument((int)1).matching(ConnectorExpressionPatterns.expression().capturedAs(LIKE_PATTERN).with(ConnectorExpressionPatterns.type().matching(VarcharType.class::isInstance))));

    public Pattern<Call> getPattern() {
        return PATTERN;
    }

    public Optional<String> rewrite(Call call, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        Optional value = context.defaultRewrite((ConnectorExpression)captures.get(LIKE_VALUE));
        if (value.isEmpty()) {
            return Optional.empty();
        }
        Optional pattern = context.defaultRewrite((ConnectorExpression)captures.get(LIKE_PATTERN));
        if (pattern.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(String.format("%s LIKE %s", value.get(), pattern.get()));
    }
}

