/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import io.airlift.slice.Slice;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionPatterns;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.spi.expression.Constant;
import io.trino.spi.type.VarcharType;
import java.util.Optional;

public class RewriteVarcharConstant
implements ConnectorExpressionRule<Constant, String> {
    private static final Pattern<Constant> PATTERN = ConnectorExpressionPatterns.constant().with(ConnectorExpressionPatterns.type().matching(VarcharType.class::isInstance));

    public Pattern<Constant> getPattern() {
        return PATTERN;
    }

    public Optional<String> rewrite(Constant constant, Captures captures, ConnectorExpressionRule.RewriteContext<String> context) {
        Slice slice = (Slice)constant.getValue();
        return Optional.of("'" + slice.toStringUtf8().replace("'", "''") + "'");
    }
}

