/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.phoenix.PhoenixClientModule;
import io.trino.plugin.phoenix.PhoenixConnector;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class PhoenixConnectorFactory
implements ConnectorFactory {
    private final ClassLoader classLoader;

    public PhoenixConnectorFactory(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return "phoenix";
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new PhoenixClientModule(), binder -> {
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
                binder.bind(ClassLoader.class).toInstance((Object)PhoenixConnectorFactory.class.getClassLoader());
                binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager());
            }});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            Connector connector = (Connector)injector.getInstance(PhoenixConnector.class);
            return connector;
        }
    }
}

