/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.phoenix;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.TablePropertiesProvider;
import io.trino.spi.session.PropertyMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.util.StringUtils;

public final class PhoenixTableProperties
implements TablePropertiesProvider {
    public static final String ROWKEYS = "rowkeys";
    public static final String SALT_BUCKETS = "salt_buckets";
    public static final String SPLIT_ON = "split_on";
    public static final String DISABLE_WAL = "disable_wal";
    public static final String IMMUTABLE_ROWS = "immutable_rows";
    public static final String DEFAULT_COLUMN_FAMILY = "default_column_family";
    public static final String BLOOMFILTER = "bloomfilter";
    public static final String VERSIONS = "versions";
    public static final String MIN_VERSIONS = "min_versions";
    public static final String COMPRESSION = "compression";
    public static final String TTL = "ttl";
    public static final String DATA_BLOCK_ENCODING = "data_block_encoding";
    private final List<PropertyMetadata<?>> tableProperties = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"rowkeys", (String)"Comma-separated list of columns to be the primary key.", null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)"salt_buckets", (String)"Number of salt buckets.  This causes an extra byte to be transparently prepended to every row key to ensure an evenly distributed read and write load across all region servers.", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"split_on", (String)"Comma-separated list of keys to split on during table creation.", null, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"disable_wal", (String)"If true, causes HBase not to write data to the write-ahead-log, thus making updates faster at the expense of potentially losing data in the event of a region server failure.", null, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"immutable_rows", (String)"Set to true if the table has rows which are write-once, append-only.", null, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"default_column_family", (String)"The column family name to use by default.", null, (boolean)false), (Object)PropertyMetadata.enumProperty((String)"bloomfilter", (String)"NONE, ROW or ROWCOL to enable blooms per column family.", BloomType.class, null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)"versions", (String)"The maximum number of row versions to store, configured per column family via HColumnDescriptor.", null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)"min_versions", (String)"The minimum number of row versions to store, configured per column family via HColumnDescriptor.", null, (boolean)false), (Object)PropertyMetadata.enumProperty((String)"compression", (String)"Compression algorithm to use for HBase blocks. Options are: SNAPPY, GZIP, LZ, and others.", Compression.Algorithm.class, null, (boolean)false), (Object)PropertyMetadata.integerProperty((String)"ttl", (String)"Number of seconds for cell TTL.  HBase will automatically delete rows once the expiration time is reached.", null, (boolean)false), (Object)PropertyMetadata.enumProperty((String)"data_block_encoding", (String)"The block encoding algorithm to use for Cells in HBase blocks. Options are: NONE, PREFIX, DIFF, FAST_DIFF, ROW_INDEX_V1, and others.", DataBlockEncoding.class, null, (boolean)false), (Object[])new PropertyMetadata[0]);

    @Inject
    public PhoenixTableProperties() {
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public static Optional<Integer> getSaltBuckets(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Integer value = (Integer)tableProperties.get(SALT_BUCKETS);
        return Optional.ofNullable(value);
    }

    public static Optional<String> getSplitOn(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String value = (String)tableProperties.get(SPLIT_ON);
        return Optional.ofNullable(value);
    }

    public static Optional<List<String>> getRowkeys(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String rowkeysCsv = (String)tableProperties.get(ROWKEYS);
        if (rowkeysCsv == null) {
            return Optional.empty();
        }
        return Optional.of((List)Arrays.stream(StringUtils.split((String)rowkeysCsv, (char)',')).map(String::trim).collect(ImmutableList.toImmutableList()));
    }

    public static Optional<Boolean> getDisableWal(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Boolean value = (Boolean)tableProperties.get(DISABLE_WAL);
        return Optional.ofNullable(value);
    }

    public static Optional<Boolean> getImmutableRows(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Boolean value = (Boolean)tableProperties.get(IMMUTABLE_ROWS);
        return Optional.ofNullable(value);
    }

    public static Optional<String> getDefaultColumnFamily(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        String value = (String)tableProperties.get(DEFAULT_COLUMN_FAMILY);
        return Optional.ofNullable(value);
    }

    public static Optional<BloomType> getBloomfilter(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        BloomType value = (BloomType)tableProperties.get(BLOOMFILTER);
        return Optional.ofNullable(value);
    }

    public static Optional<Integer> getVersions(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Integer value = (Integer)tableProperties.get(VERSIONS);
        return Optional.ofNullable(value);
    }

    public static Optional<Integer> getMinVersions(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Integer value = (Integer)tableProperties.get(MIN_VERSIONS);
        return Optional.ofNullable(value);
    }

    public static Optional<Compression.Algorithm> getCompression(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Compression.Algorithm value = (Compression.Algorithm)tableProperties.get(COMPRESSION);
        return Optional.ofNullable(value);
    }

    public static Optional<DataBlockEncoding> getDataBlockEncoding(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        DataBlockEncoding value = (DataBlockEncoding)tableProperties.get(DATA_BLOCK_ENCODING);
        return Optional.ofNullable(value);
    }

    public static Optional<Integer> getTimeToLive(Map<String, Object> tableProperties) {
        Objects.requireNonNull(tableProperties);
        Integer value = (Integer)tableProperties.get(TTL);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }
}

