/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class ConnectorExpressions {
    private ConnectorExpressions() {
    }

    public static List<ConnectorExpression> extractConjuncts(ConnectorExpression expression) {
        return ImmutableList.of((Object)expression);
    }

    public static ConnectorExpression and(ConnectorExpression ... expressions) {
        return ConnectorExpressions.and(Arrays.asList(expressions));
    }

    public static ConnectorExpression and(Collection<ConnectorExpression> expressions) {
        if (expressions.size() > 1) {
            throw new RuntimeException("Only single expression is currently supported");
        }
        if (expressions.isEmpty()) {
            return Constant.TRUE;
        }
        return (ConnectorExpression)Iterables.getOnlyElement(expressions);
    }
}

