/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.jmx.CacheStatsMBean;
import io.airlift.units.Duration;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.IdentityCacheMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.StatsCollecting;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class CachingJdbcClient
implements JdbcClient {
    private static final Object NULL_MARKER = new Object();
    private final JdbcClient delegate;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final boolean cacheMissing;
    private final IdentityCacheMapping identityMapping;
    private final Cache<IdentityCacheMapping.IdentityCacheKey, Set<String>> schemaNamesCache;
    private final Cache<TableNamesCacheKey, List<SchemaTableName>> tableNamesCache;
    private final Cache<TableHandleCacheKey, Optional<JdbcTableHandle>> tableHandleCache;
    private final Cache<ColumnsCacheKey, List<JdbcColumnHandle>> columnsCache;
    private final Cache<TableStatisticsCacheKey, TableStatistics> statisticsCache;

    @Inject
    public CachingJdbcClient(@StatsCollecting JdbcClient delegate, Set<SessionPropertiesProvider> sessionPropertiesProviders, IdentityCacheMapping identityMapping, BaseJdbcConfig config) {
        this(delegate, sessionPropertiesProviders, identityMapping, config.getMetadataCacheTtl(), config.isCacheMissing(), config.getCacheMaximumSize());
    }

    public CachingJdbcClient(JdbcClient delegate, Set<SessionPropertiesProvider> sessionPropertiesProviders, IdentityCacheMapping identityMapping, Duration metadataCachingTtl, boolean cacheMissing, long cacheMaximumSize) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.sessionProperties = (List)Objects.requireNonNull(sessionPropertiesProviders, "sessionPropertiesProviders is null").stream().flatMap(provider -> provider.getSessionProperties().stream()).collect(ImmutableList.toImmutableList());
        this.cacheMissing = cacheMissing;
        this.identityMapping = Objects.requireNonNull(identityMapping, "identityMapping is null");
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(metadataCachingTtl.toMillis(), TimeUnit.MILLISECONDS).recordStats();
        if (metadataCachingTtl.equals((Object)BaseJdbcConfig.CACHING_DISABLED)) {
            cacheBuilder.maximumSize(0L);
        } else {
            cacheBuilder.maximumSize(cacheMaximumSize);
        }
        this.schemaNamesCache = cacheBuilder.build();
        this.tableNamesCache = cacheBuilder.build();
        this.tableHandleCache = cacheBuilder.build();
        this.columnsCache = cacheBuilder.build();
        this.statisticsCache = cacheBuilder.build();
    }

    @Override
    public boolean schemaExists(ConnectorSession session, String schema) {
        return this.getSchemaNames(session).contains(schema);
    }

    @Override
    public Set<String> getSchemaNames(ConnectorSession session) {
        IdentityCacheMapping.IdentityCacheKey key = this.getIdentityKey(session);
        return CachingJdbcClient.get(this.schemaNamesCache, key, () -> this.delegate.getSchemaNames(session));
    }

    @Override
    public List<SchemaTableName> getTableNames(ConnectorSession session, Optional<String> schema) {
        TableNamesCacheKey key = new TableNamesCacheKey(this.getIdentityKey(session), schema);
        return CachingJdbcClient.get(this.tableNamesCache, key, () -> this.delegate.getTableNames(session, schema));
    }

    @Override
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return tableHandle.getColumns().get();
        }
        ColumnsCacheKey key = new ColumnsCacheKey(this.getIdentityKey(session), this.getSessionProperties(session), tableHandle.getRequiredNamedRelation().getSchemaTableName());
        return CachingJdbcClient.get(this.columnsCache, key, () -> this.delegate.getColumns(session, tableHandle));
    }

    @Override
    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        return this.delegate.toColumnMapping(session, connection, typeHandle);
    }

    @Override
    public List<ColumnMapping> toColumnMappings(ConnectorSession session, List<JdbcTypeHandle> typeHandles) {
        return this.delegate.toColumnMappings(session, typeHandles);
    }

    @Override
    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        return this.delegate.toWriteMapping(session, type);
    }

    @Override
    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return this.delegate.supportsAggregationPushdown(session, table, aggregates, assignments, groupingSets);
    }

    @Override
    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.delegate.implementAggregation(session, aggregate, assignments);
    }

    @Override
    public ConnectorSplitSource getSplits(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate.getSplits(session, tableHandle);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcSplit split) throws SQLException {
        return this.delegate.getConnection(session, split);
    }

    @Override
    public void abortReadConnection(Connection connection, ResultSet resultSet) throws SQLException {
        this.delegate.abortReadConnection(connection, resultSet);
    }

    @Override
    public PreparedQuery prepareQuery(ConnectorSession session, JdbcTableHandle table, Optional<List<List<JdbcColumnHandle>>> groupingSets, List<JdbcColumnHandle> columns, Map<String, String> columnExpressions) {
        return this.delegate.prepareQuery(session, table, groupingSets, columns, columnExpressions);
    }

    @Override
    public PreparedStatement buildSql(ConnectorSession session, Connection connection, JdbcSplit split, JdbcTableHandle table, List<JdbcColumnHandle> columns) throws SQLException {
        return this.delegate.buildSql(session, connection, split, table, columns);
    }

    @Override
    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        return this.delegate.implementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    @Override
    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return this.delegate.supportsTopN(session, handle, sortOrder);
    }

    @Override
    public boolean isTopNGuaranteed(ConnectorSession session) {
        return this.delegate.isTopNGuaranteed(session);
    }

    @Override
    public boolean supportsLimit() {
        return this.delegate.supportsLimit();
    }

    @Override
    public boolean isLimitGuaranteed(ConnectorSession session) {
        return this.delegate.isLimitGuaranteed(session);
    }

    @Override
    public Optional<JdbcTableHandle> getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        TableHandleCacheKey key = new TableHandleCacheKey(this.getIdentityKey(session), schemaTableName);
        Optional cachedTableHandle = (Optional)this.tableHandleCache.getIfPresent((Object)key);
        if (cachedTableHandle != null) {
            return cachedTableHandle;
        }
        Optional<JdbcTableHandle> tableHandle = this.delegate.getTableHandle(session, schemaTableName);
        if (tableHandle.isPresent() || this.cacheMissing) {
            this.tableHandleCache.put((Object)key, tableHandle);
        }
        return tableHandle;
    }

    @Override
    public void commitCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.delegate.commitCreateTable(session, handle);
        this.invalidateTableCaches(new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public JdbcOutputTableHandle beginInsertTable(ConnectorSession session, JdbcTableHandle tableHandle, List<JdbcColumnHandle> columns) {
        return this.delegate.beginInsertTable(session, tableHandle, columns);
    }

    @Override
    public void finishInsertTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.delegate.finishInsertTable(session, handle);
        this.onDataChanged(new SchemaTableName(handle.getSchemaName(), handle.getTableName()));
    }

    @Override
    public void dropTable(ConnectorSession session, JdbcTableHandle jdbcTableHandle) {
        this.delegate.dropTable(session, jdbcTableHandle);
        this.invalidateTableCaches(jdbcTableHandle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void rollbackCreateTable(ConnectorSession session, JdbcOutputTableHandle handle) {
        this.delegate.rollbackCreateTable(session, handle);
    }

    @Override
    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        return this.delegate.buildInsertSql(handle, columnWriters);
    }

    @Override
    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.delegate.getConnection(session, handle);
    }

    @Override
    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.delegate.getPreparedStatement(connection, sql);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle, TupleDomain<ColumnHandle> tupleDomain) {
        TableStatisticsCacheKey key = new TableStatisticsCacheKey(handle, tupleDomain);
        TableStatistics cachedStatistics = (TableStatistics)this.statisticsCache.getIfPresent((Object)key);
        if (cachedStatistics != null) {
            return cachedStatistics;
        }
        TableStatistics statistics = this.delegate.getTableStatistics(session, handle, tupleDomain);
        if (!statistics.equals((Object)TableStatistics.empty()) || this.cacheMissing) {
            this.statisticsCache.put((Object)key, (Object)statistics);
        }
        return statistics;
    }

    @Override
    public void createSchema(ConnectorSession session, String schemaName) {
        this.delegate.createSchema(session, schemaName);
        this.invalidateSchemasCache();
    }

    @Override
    public void dropSchema(ConnectorSession session, String schemaName) {
        this.delegate.dropSchema(session, schemaName);
        this.invalidateSchemasCache();
    }

    @Override
    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        this.delegate.setColumnComment(session, handle, column, comment);
        this.invalidateColumnsCache(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void addColumn(ConnectorSession session, JdbcTableHandle handle, ColumnMetadata column) {
        this.delegate.addColumn(session, handle, column);
        this.invalidateColumnsCache(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void dropColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column) {
        this.delegate.dropColumn(session, handle, column);
        this.invalidateColumnsCache(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        this.delegate.renameColumn(session, handle, jdbcColumn, newColumnName);
        this.invalidateColumnsCache(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        this.delegate.renameTable(session, handle, newTableName);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
        this.invalidateTableCaches(newTableName);
    }

    @Override
    public void setTableProperties(ConnectorSession session, JdbcTableHandle handle, Map<String, Object> properties) {
        this.delegate.setTableProperties(session, handle, properties);
        this.invalidateTableCaches(handle.asPlainTable().getSchemaTableName());
    }

    @Override
    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.delegate.createTable(session, tableMetadata);
        this.invalidateTableCaches(tableMetadata.getTable());
    }

    @Override
    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        return this.delegate.beginCreateTable(session, tableMetadata);
    }

    @Override
    public Optional<SystemTable> getSystemTable(ConnectorSession session, SchemaTableName tableName) {
        return this.delegate.getSystemTable(session, tableName);
    }

    @Override
    public String quoted(String name) {
        return this.delegate.quoted(name);
    }

    @Override
    public String quoted(RemoteTableName remoteTableName) {
        return this.delegate.quoted(remoteTableName);
    }

    @Override
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate.getTableProperties(session, tableHandle);
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> getTableScanRedirection(ConnectorSession session, JdbcTableHandle tableHandle) {
        return this.delegate.getTableScanRedirection(session, tableHandle);
    }

    public void onDataChanged(SchemaTableName table) {
        CachingJdbcClient.invalidateCache(this.statisticsCache, key -> key.tableHandle.references(table));
    }

    @Deprecated
    public void onDataChanged(JdbcTableHandle handle) {
        CachingJdbcClient.invalidateCache(this.statisticsCache, key -> key.tableHandle.equals(handle));
    }

    @Override
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        OptionalLong deletedRowsCount = this.delegate.delete(session, handle);
        this.onDataChanged(handle.getRequiredNamedRelation().getSchemaTableName());
        return deletedRowsCount;
    }

    @Override
    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        this.delegate.truncateTable(session, handle);
        this.onDataChanged(handle.getRequiredNamedRelation().getSchemaTableName());
    }

    @Managed
    public void flushCache() {
        this.schemaNamesCache.invalidateAll();
        this.tableNamesCache.invalidateAll();
        this.tableHandleCache.invalidateAll();
        this.columnsCache.invalidateAll();
        this.statisticsCache.invalidateAll();
    }

    private IdentityCacheMapping.IdentityCacheKey getIdentityKey(ConnectorSession session) {
        return this.identityMapping.getRemoteUserCacheKey(session);
    }

    private Map<String, Object> getSessionProperties(ConnectorSession session) {
        return (Map)this.sessionProperties.stream().map(property -> Map.entry(property.getName(), CachingJdbcClient.getSessionProperty(session, property))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Object getSessionProperty(ConnectorSession session, PropertyMetadata<?> property) {
        return MoreObjects.firstNonNull((Object)session.getProperty(property.getName(), property.getJavaType()), (Object)NULL_MARKER);
    }

    private void invalidateSchemasCache() {
        this.schemaNamesCache.invalidateAll();
    }

    private void invalidateTableCaches(SchemaTableName schemaTableName) {
        this.invalidateColumnsCache(schemaTableName);
        CachingJdbcClient.invalidateCache(this.tableHandleCache, key -> key.tableName.equals((Object)schemaTableName));
        CachingJdbcClient.invalidateCache(this.tableNamesCache, key -> key.schemaName.equals(Optional.of(schemaTableName.getSchemaName())));
        CachingJdbcClient.invalidateCache(this.statisticsCache, key -> key.tableHandle.references(schemaTableName));
    }

    private void invalidateColumnsCache(SchemaTableName table) {
        CachingJdbcClient.invalidateCache(this.columnsCache, key -> key.table.equals((Object)table));
    }

    @VisibleForTesting
    CacheStats getTableNamesCacheStats() {
        return this.tableNamesCache.stats();
    }

    @VisibleForTesting
    CacheStats getColumnsCacheStats() {
        return this.columnsCache.stats();
    }

    @VisibleForTesting
    CacheStats getStatisticsCacheStats() {
        return this.statisticsCache.stats();
    }

    private static <T, V> void invalidateCache(Cache<T, V> cache, Predicate<T> filterFunction) {
        Set cacheKeys = (Set)cache.asMap().keySet().stream().filter(filterFunction).collect(ImmutableSet.toImmutableSet());
        cache.invalidateAll((Iterable)cacheKeys);
    }

    private static <K, V> V get(Cache<K, V> cache, K key, Callable<V> loader) {
        try {
            return (V)cache.get(key, loader);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw e;
        }
        catch (ExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    @Managed
    @Nested
    public CacheStatsMBean getSchemaNamesStats() {
        return new CacheStatsMBean(this.schemaNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableNamesCache() {
        return new CacheStatsMBean(this.tableNamesCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getTableHandleCache() {
        return new CacheStatsMBean(this.tableHandleCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getColumnsCache() {
        return new CacheStatsMBean(this.columnsCache);
    }

    @Managed
    @Nested
    public CacheStatsMBean getStatisticsCache() {
        return new CacheStatsMBean(this.statisticsCache);
    }

    private static final class TableStatisticsCacheKey {
        private final JdbcTableHandle tableHandle;
        private final TupleDomain<ColumnHandle> tupleDomain;

        private TableStatisticsCacheKey(JdbcTableHandle tableHandle, TupleDomain<ColumnHandle> tupleDomain) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
            this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableStatisticsCacheKey that = (TableStatisticsCacheKey)o;
            return this.tableHandle.equals(that.tableHandle) && this.tupleDomain.equals(that.tupleDomain);
        }

        public int hashCode() {
            return Objects.hash(this.tableHandle, this.tupleDomain);
        }
    }

    private static final class TableNamesCacheKey {
        private final IdentityCacheMapping.IdentityCacheKey identity;
        private final Optional<String> schemaName;

        private TableNamesCacheKey(IdentityCacheMapping.IdentityCacheKey identity, Optional<String> schemaName) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableNamesCacheKey that = (TableNamesCacheKey)o;
            return Objects.equals(this.identity, that.identity) && Objects.equals(this.schemaName, that.schemaName);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.schemaName);
        }
    }

    private static final class TableHandleCacheKey {
        private final IdentityCacheMapping.IdentityCacheKey identity;
        private final SchemaTableName tableName;

        private TableHandleCacheKey(IdentityCacheMapping.IdentityCacheKey identity, SchemaTableName tableName) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TableHandleCacheKey that = (TableHandleCacheKey)o;
            return Objects.equals(this.identity, that.identity) && Objects.equals(this.tableName, that.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.tableName);
        }
    }

    private static final class ColumnsCacheKey {
        private final IdentityCacheMapping.IdentityCacheKey identity;
        private final SchemaTableName table;
        private final Map<String, Object> sessionProperties;

        private ColumnsCacheKey(IdentityCacheMapping.IdentityCacheKey identity, Map<String, Object> sessionProperties, SchemaTableName table) {
            this.identity = Objects.requireNonNull(identity, "identity is null");
            this.sessionProperties = ImmutableMap.copyOf(Objects.requireNonNull(sessionProperties, "sessionProperties is null"));
            this.table = Objects.requireNonNull(table, "table is null");
        }

        public IdentityCacheMapping.IdentityCacheKey getIdentity() {
            return this.identity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColumnsCacheKey that = (ColumnsCacheKey)o;
            return Objects.equals(this.identity, that.identity) && Objects.equals(this.sessionProperties, that.sessionProperties) && Objects.equals(this.table, that.table);
        }

        public int hashCode() {
            return Objects.hash(this.identity, this.sessionProperties, this.table);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("identity", (Object)this.identity).add("sessionProperties", this.sessionProperties).add("table", (Object)this.table).toString();
        }
    }
}

