/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.trino.plugin.jdbc.JdbcConnector;
import io.trino.plugin.jdbc.JdbcHandleResolver;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.spi.NodeManager;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorHandleResolver;
import io.trino.spi.type.TypeManager;
import java.util.Map;
import java.util.Objects;

public class JdbcConnectorFactory
implements ConnectorFactory {
    private final String name;
    private final JdbcModuleProvider moduleProvider;

    public JdbcConnectorFactory(String name, Module module) {
        this(name, (String catalogName) -> module);
    }

    @Deprecated
    public JdbcConnectorFactory(String name, JdbcModuleProvider moduleProvider) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or empty");
        this.name = name;
        this.moduleProvider = Objects.requireNonNull(moduleProvider, "moduleProvider is null");
    }

    public String getName() {
        return this.name;
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new JdbcHandleResolver();
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Bootstrap app = new Bootstrap(new Module[]{binder -> binder.bind(TypeManager.class).toInstance((Object)context.getTypeManager()), binder -> binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager()), binder -> binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder()), new JdbcModule(catalogName), this.moduleProvider.getModule(catalogName)});
        Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
        return (Connector)injector.getInstance(JdbcConnector.class);
    }

    @Deprecated
    public static interface JdbcModuleProvider {
        public Module getModule(String var1);
    }
}

